/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.Builder;
import org.infinispan.configuration.ConfigurationUtils;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusterCacheLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoaderConfiguration;
import org.infinispan.configuration.cache.LoaderConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;

public class LoadersConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<LoadersConfiguration> {
    private boolean passivation = false;
    private boolean preload = false;
    private boolean shared = false;
    private List<LoaderConfigurationBuilder<?, ?>> cacheLoaders = new ArrayList(2);

    protected LoadersConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public LoadersConfigurationBuilder passivation(boolean b) {
        this.passivation = b;
        return this;
    }

    boolean passivation() {
        return this.passivation;
    }

    public LoadersConfigurationBuilder preload(boolean b) {
        this.preload = b;
        return this;
    }

    boolean preload() {
        return this.preload;
    }

    public LoadersConfigurationBuilder shared(boolean b) {
        this.shared = b;
        return this;
    }

    boolean shared() {
        return this.shared;
    }

    @Deprecated
    public LegacyStoreConfigurationBuilder addCacheLoader() {
        LegacyStoreConfigurationBuilder builder = new LegacyStoreConfigurationBuilder(this);
        this.cacheLoaders.add(builder);
        return builder;
    }

    public LegacyLoaderConfigurationBuilder addLoader() {
        LegacyLoaderConfigurationBuilder builder = new LegacyLoaderConfigurationBuilder(this);
        this.cacheLoaders.add(builder);
        return builder;
    }

    public <T extends LoaderConfigurationBuilder<?, ?>> T addLoader(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(LoadersConfigurationBuilder.class);
            LoaderConfigurationBuilder builder = (LoaderConfigurationBuilder)constructor.newInstance(this);
            this.cacheLoaders.add(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not instantiate loader configuration builder '" + klass.getName() + "'", e);
        }
    }

    public LoaderConfigurationBuilder<?, ?> addLoader(LoaderConfigurationBuilder<?, ?> builder) {
        this.cacheLoaders.add(builder);
        return builder;
    }

    public LegacyStoreConfigurationBuilder addStore() {
        LegacyStoreConfigurationBuilder builder = new LegacyStoreConfigurationBuilder(this);
        this.cacheLoaders.add(builder);
        return builder;
    }

    public <T extends StoreConfigurationBuilder<?, ?>> T addStore(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(LoadersConfigurationBuilder.class);
            StoreConfigurationBuilder builder = (StoreConfigurationBuilder)constructor.newInstance(this);
            this.cacheLoaders.add(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not instantiate store configuration builder '" + klass.getName() + "'", e);
        }
    }

    public LoaderConfigurationBuilder<?, ?> addStore(StoreConfigurationBuilder<?, ?> builder) {
        this.cacheLoaders.add(builder);
        return builder;
    }

    public ClusterCacheLoaderConfigurationBuilder addClusterCacheLoader() {
        ClusterCacheLoaderConfigurationBuilder builder = new ClusterCacheLoaderConfigurationBuilder(this);
        this.cacheLoaders.add(builder);
        return builder;
    }

    public FileCacheStoreConfigurationBuilder addFileCacheStore() {
        FileCacheStoreConfigurationBuilder builder = new FileCacheStoreConfigurationBuilder(this);
        this.cacheLoaders.add(builder);
        return builder;
    }

    public LoadersConfigurationBuilder clearCacheLoaders() {
        this.cacheLoaders.clear();
        return this;
    }

    List<LoaderConfigurationBuilder<?, ?>> cacheLoaders() {
        return this.cacheLoaders;
    }

    @Override
    public void validate() {
        for (LoaderConfigurationBuilder<?, ?> b : this.cacheLoaders) {
            b.validate();
        }
    }

    @Override
    public LoadersConfiguration create() {
        LinkedList<LoaderConfiguration> loaders = new LinkedList<LoaderConfiguration>();
        for (LoaderConfigurationBuilder<?, ?> loader : this.cacheLoaders) {
            loaders.add((LoaderConfiguration)loader.create());
        }
        return new LoadersConfiguration(this.passivation, this.preload, this.shared, loaders);
    }

    public LoadersConfigurationBuilder read(LoadersConfiguration template) {
        for (LoaderConfiguration c : template.cacheLoaders()) {
            Class<Builder<LoaderConfiguration>> builderClass = ConfigurationUtils.builderFor(c);
            Builder<LoaderConfiguration> builder = this.addLoader(builderClass);
            builder.read(c);
        }
        this.passivation = template.passivation();
        this.preload = template.preload();
        this.shared = template.shared();
        return this;
    }

    public String toString() {
        return "LoadersConfigurationBuilder{cacheLoaders=" + this.cacheLoaders + ", passivation=" + this.passivation + ", preload=" + this.preload + ", shared=" + this.shared + '}';
    }
}

