/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.AbstractLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyLoaderConfiguration;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheStore;
import org.infinispan.util.TypedProperties;

public class LegacyLoaderConfigurationBuilder
extends AbstractLoaderConfigurationBuilder<LegacyLoaderConfiguration, LegacyLoaderConfigurationBuilder> {
    private CacheLoader cacheLoader;
    private Properties properties = new Properties();

    public LegacyLoaderConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public LegacyLoaderConfigurationBuilder self() {
        return this;
    }

    public LegacyLoaderConfigurationBuilder cacheLoader(CacheLoader cacheLoader) {
        this.cacheLoader = cacheLoader;
        return this;
    }

    @Override
    public LegacyLoaderConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public LegacyLoaderConfigurationBuilder withProperties(Properties props) {
        this.properties = props;
        return this;
    }

    @Override
    public void validate() {
        if (this.cacheLoader instanceof CacheStore) {
            throw new CacheException("Attempt to use a CacheStore as a loader");
        }
    }

    @Override
    public LegacyLoaderConfiguration create() {
        return new LegacyLoaderConfiguration(TypedProperties.toTypedProperties(this.properties), this.cacheLoader);
    }

    public LegacyLoaderConfigurationBuilder read(LegacyLoaderConfiguration template) {
        this.cacheLoader = template.cacheLoader();
        this.properties = template.properties();
        return this;
    }

    public String toString() {
        return "LoaderConfigurationBuilder{cacheLoader=" + this.cacheLoader + '}';
    }
}

