/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.config.Configuration;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.transaction.AbstractEnlistmentAdapter;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.SerializableXid;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionXaAdapter
extends AbstractEnlistmentAdapter
implements XAResource {
    private static final Log log = LogFactory.getLog(TransactionXaAdapter.class);
    private static boolean trace = log.isTraceEnabled();
    private int txTimeout;
    private final XaTransactionTable txTable;
    private final TransactionCoordinator txCoordinator;
    private final LocalXaTransaction localTransaction;
    private final RecoveryManager recoveryManager;
    private volatile RecoveryManager.RecoveryIterator recoveryIterator;
    private boolean recoveryEnabled;

    public TransactionXaAdapter(LocalXaTransaction localTransaction, TransactionTable txTable, RecoveryManager rm, TransactionCoordinator txCoordinator, CommandsFactory commandsFactory, RpcManager rpcManager, ClusteringDependentLogic clusteringDependentLogic, Configuration config) {
        super(localTransaction, commandsFactory, rpcManager, txTable, clusteringDependentLogic, config);
        this.localTransaction = localTransaction;
        this.txTable = (XaTransactionTable)txTable;
        this.recoveryManager = rm;
        this.txCoordinator = txCoordinator;
        this.recoveryEnabled = config.isTransactionRecoveryEnabled();
    }

    public TransactionXaAdapter(TransactionTable txTable, RecoveryManager rm, TransactionCoordinator txCoordinator, CommandsFactory commandsFactory, RpcManager rpcManager, ClusteringDependentLogic clusteringDependentLogic, Configuration config) {
        super(commandsFactory, rpcManager, txTable, clusteringDependentLogic, config);
        this.localTransaction = null;
        this.txTable = (XaTransactionTable)txTable;
        this.recoveryManager = rm;
        this.txCoordinator = txCoordinator;
        this.recoveryEnabled = config.isTransactionRecoveryEnabled();
    }

    @Override
    public int prepare(Xid externalXid) throws XAException {
        Xid xid = this.convertXid(externalXid);
        LocalXaTransaction localTransaction = this.getLocalTransactionAndValidate(xid);
        return this.txCoordinator.prepare(localTransaction);
    }

    @Override
    public void commit(Xid externalXid, boolean isOnePhase) throws XAException {
        Xid xid = this.convertXid(externalXid);
        LocalXaTransaction localTransaction = this.getLocalTransactionAndValidate(xid);
        if (isOnePhase) {
            this.txCoordinator.prepare(localTransaction);
            this.txCoordinator.commit(localTransaction, false);
        } else {
            this.txCoordinator.commit(localTransaction, false);
        }
        this.forgetSuccessfullyCompletedTransaction(this.recoveryManager, xid, localTransaction);
    }

    @Override
    public void rollback(Xid externalXid) throws XAException {
        Xid xid = this.convertXid(externalXid);
        LocalXaTransaction localTransaction1 = TransactionXaAdapter.getLocalTransactionAndValidateImpl(xid, this.txTable);
        this.localTransaction.markForRollback(true);
        this.txCoordinator.rollback(localTransaction1);
        this.forgetSuccessfullyCompletedTransaction(this.recoveryManager, xid, localTransaction1);
    }

    @Override
    public void start(Xid externalXid, int i) throws XAException {
        Xid xid = this.convertXid(externalXid);
        this.localTransaction.setXid(xid);
        this.txTable.addLocalTransactionMapping(this.localTransaction);
        if (trace) {
            log.tracef("start called on tx %s", this.localTransaction.getGlobalTransaction());
        }
    }

    @Override
    public void end(Xid externalXid, int i) throws XAException {
        if (trace) {
            log.tracef("end called on tx %s(%s)", this.localTransaction.getGlobalTransaction(), this.config.getName());
        }
    }

    @Override
    public void forget(Xid externalXid) throws XAException {
        Xid xid = this.convertXid(externalXid);
        if (trace) {
            log.tracef("forget called for xid %s", xid);
        }
        try {
            this.recoveryManager.removeRecoveryInformationFromCluster(null, xid, true, null);
        }
        catch (Exception e) {
            log.warn("Exception removing recovery information: ", e);
            throw new XAException(-3);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (trace) {
            log.trace("start called");
        }
        return this.txTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (!(xaResource instanceof TransactionXaAdapter)) {
            return false;
        }
        TransactionXaAdapter other = (TransactionXaAdapter)xaResource;
        return this.txTable == other.txTable;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (!this.config.isTransactionRecoveryEnabled()) {
            log.recoveryIgnored();
            return RecoveryManager.RecoveryIterator.NOTHING;
        }
        if (trace) {
            log.trace("recover called: " + flag);
        }
        if (this.isFlag(flag, 0x1000000)) {
            this.recoveryIterator = this.recoveryManager.getPreparedTransactionsFromCluster();
            if (trace) {
                log.tracef("Fetched a new recovery iterator: %s", this.recoveryIterator);
            }
        }
        if (this.isFlag(flag, 0x800000)) {
            if (trace) {
                log.trace("Flushing the iterator");
            }
            return this.recoveryIterator.all();
        }
        if (!this.isFlag(flag, 0x1000000) && !this.isFlag(flag, 0)) {
            throw new IllegalArgumentException("TMNOFLAGS this flag must be used when no other flags are specified. Received " + flag);
        }
        return this.recoveryIterator.hasNext() ? (Xid[])this.recoveryIterator.next() : RecoveryManager.RecoveryIterator.NOTHING;
    }

    private boolean isFlag(int value, int flag) {
        return (value & flag) != 0;
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        this.txTimeout = i;
        return true;
    }

    public String toString() {
        return "TransactionXaAdapter{localTransaction=" + this.localTransaction + '}';
    }

    private void forgetSuccessfullyCompletedTransaction(RecoveryManager recoveryManager, Xid xid, LocalXaTransaction localTransaction) {
        GlobalTransaction gtx = localTransaction.getGlobalTransaction();
        if (this.config.isTransactionRecoveryEnabled()) {
            recoveryManager.removeRecoveryInformationFromCluster(localTransaction.getRemoteLocksAcquired(), xid, false, gtx);
            this.txTable.removeLocalTransaction(localTransaction);
        } else {
            this.releaseLocksForCompletedTransaction(localTransaction);
        }
    }

    private LocalXaTransaction getLocalTransactionAndValidate(Xid xid) throws XAException {
        return TransactionXaAdapter.getLocalTransactionAndValidateImpl(xid, this.txTable);
    }

    private static LocalXaTransaction getLocalTransactionAndValidateImpl(Xid xid, XaTransactionTable txTable) throws XAException {
        LocalXaTransaction localTransaction = txTable.getLocalTransaction(xid);
        if (localTransaction == null) {
            if (trace) {
                log.tracef("no tx found for %s", xid);
            }
            throw new XAException(-4);
        }
        return localTransaction;
    }

    public LocalXaTransaction getLocalTransaction() {
        return this.localTransaction;
    }

    private Xid convertXid(Xid externalXid) {
        if (this.recoveryEnabled && !(externalXid instanceof SerializableXid)) {
            return new SerializableXid(externalXid);
        }
        return externalXid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionXaAdapter that = (TransactionXaAdapter)o;
        if (this.localTransaction != null ? !this.localTransaction.equals(that.localTransaction) : that.localTransaction != null) {
            return false;
        }
        return this.config.getName() != null ? this.config.getName().equals(that.config.getName()) : that.config.getName() == null;
    }
}

