/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.DisplayType;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Parameter;

@MBean(objectName="Transactions", description="Component that manages the cache's participation in JTA transactions.")
public class TxInterceptor
extends CommandInterceptor {
    private TransactionTable txTable;
    private final AtomicLong prepares = new AtomicLong(0L);
    private final AtomicLong commits = new AtomicLong(0L);
    private final AtomicLong rollbacks = new AtomicLong(0L);
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", writable=true)
    private boolean statisticsEnabled;
    protected TransactionCoordinator txCoordinator;
    private static final Log log = LogFactory.getLog(TxInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(TransactionTable txTable, Configuration c, TransactionCoordinator txCoordinator) {
        this.configuration = c;
        this.txTable = txTable;
        this.txCoordinator = txCoordinator;
        this.setStatisticsEnabled(this.configuration.isExposeJmxStatistics());
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.prepares.incrementAndGet();
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        if (!ctx.isOriginLocal()) {
            if (command.isOnePhaseCommit()) {
                this.txTable.remoteTransactionCommitted(command.getGlobalTransaction());
            } else {
                this.txTable.remoteTransactionPrepared(command.getGlobalTransaction());
            }
        }
        return result;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.commits.incrementAndGet();
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        if (!ctx.isOriginLocal()) {
            this.txTable.remoteTransactionCommitted(ctx.getGlobalTransaction());
        }
        return result;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.rollbacks.incrementAndGet();
        }
        if (!ctx.isOriginLocal()) {
            this.txTable.remoteTransactionRollback(command.getGlobalTransaction());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        if (ctx.isOriginLocal()) {
            command.setGlobalTransaction(ctx.getGlobalTransaction());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand invalidateCommand) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, invalidateCommand);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    private Object enlistReadAndInvokeNext(InvocationContext ctx, VisitableCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        return this.invokeNextInterceptor(ctx, command);
    }

    private void enlistIfNeeded(InvocationContext ctx) throws SystemException {
        if (TxInterceptor.shouldEnlist(ctx)) {
            LocalTransaction localTransaction = this.enlist((TxInvocationContext)ctx);
            LocalTxInvocationContext localTxContext = (LocalTxInvocationContext)ctx;
            localTxContext.setLocalTransaction(localTransaction);
        }
    }

    private Object enlistWriteAndInvokeNext(InvocationContext ctx, WriteCommand command) throws Throwable {
        Object rv;
        LocalTransaction localTransaction = null;
        boolean shouldAddMod = false;
        if (TxInterceptor.shouldEnlist(ctx)) {
            localTransaction = this.enlist((TxInvocationContext)ctx);
            LocalTxInvocationContext localTxContext = (LocalTxInvocationContext)ctx;
            if (this.localModeNotForced(ctx)) {
                shouldAddMod = true;
            }
            localTxContext.setLocalTransaction(localTransaction);
        }
        try {
            rv = this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable throwable) {
            if (ctx.isOriginLocal() && ctx.isInTxScope() && !ctx.hasFlag(Flag.FAIL_SILENTLY)) {
                TxInvocationContext txCtx = (TxInvocationContext)ctx;
                txCtx.getTransaction().setRollbackOnly();
            }
            throw throwable;
        }
        if (command.isSuccessful() && shouldAddMod) {
            localTransaction.addModification(command);
        }
        return rv;
    }

    public LocalTransaction enlist(TxInvocationContext ctx) throws SystemException {
        Transaction transaction = ctx.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("This should only be called in an tx scope");
        }
        int status = transaction.getStatus();
        if (this.isNotValid(status)) {
            throw new IllegalStateException("Transaction " + transaction + " is not in a valid state to be invoking cache operations on.");
        }
        LocalTransaction localTransaction = this.txTable.getOrCreateLocalTransaction(transaction, ctx);
        this.txTable.enlist(transaction, localTransaction);
        return localTransaction;
    }

    private boolean isNotValid(int status) {
        return status != 0 && status != 7;
    }

    private static boolean shouldEnlist(InvocationContext ctx) {
        return ctx.isInTxScope() && ctx.isOriginLocal();
    }

    private boolean localModeNotForced(InvocationContext icx) {
        if (icx.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().debug("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return false;
        }
        return true;
    }

    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset Statistics")
    public void resetStatistics() {
        this.prepares.set(0L);
        this.commits.set(0L);
        this.rollbacks.set(0L);
    }

    @Operation(displayName="Enable/disable statistics")
    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @Metric(displayName="Statistics enabled", dataType=DataType.TRAIT)
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="Number of transaction prepares performed since last reset")
    @Metric(displayName="Prepares", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getPrepares() {
        return this.prepares.get();
    }

    @ManagedAttribute(description="Number of transaction commits performed since last reset")
    @Metric(displayName="Commits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getCommits() {
        return this.commits.get();
    }

    @ManagedAttribute(description="Number of transaction rollbacks performed since last reset")
    @Metric(displayName="Rollbacks", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRollbacks() {
        return this.rollbacks.get();
    }
}

