/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CallInterceptor
extends CommandInterceptor {
    private static final Log log = LogFactory.getLog(CallInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (trace) {
            log.trace("Suppressing invocation of method handlePrepareCommand.");
        }
        return null;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (trace) {
            log.trace("Suppressing invocation of method handleCommitCommand.");
        }
        return null;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (trace) {
            log.trace("Suppressing invocation of method handleRollbackCommand.");
        }
        return null;
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand c) throws Throwable {
        if (trace) {
            log.trace("Suppressing invocation of method handleLockControlCommand.");
        }
        return null;
    }

    @Override
    public final Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (trace) {
            log.trace("Executing command: " + command + ".");
        }
        return command.perform(ctx);
    }
}

