/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.infinispan.CacheException;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.config.AbstractFluentConfigurationBean;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationDoc;
import org.infinispan.config.ConfigurationDocRef;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.Dynamic;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.GroupsConfiguration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.config.OverrideConfigurationVisitor;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.container.DataContainer;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.TopologyAwareConsistentHash;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.ReplicationQueueImpl;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SurvivesRestarts
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={})
@XmlRootElement(name="namedCacheConfiguration")
@ConfigurationDoc(name="default")
@Deprecated
public class Configuration
extends AbstractNamedCacheConfigurationBean {
    private static final long serialVersionUID = 5553791890144997466L;
    private static final Log log = LogFactory.getLog(Configuration.class);
    @XmlTransient
    private GlobalConfiguration globalConfiguration;
    @XmlAttribute
    @ConfigurationDoc(desc="Only used with the namedCache element, this attribute specifies the name of the cache.  Can be any String, but must be unique in a given configuration.")
    protected String name;
    @XmlTransient
    FluentConfiguration fluentConfig = new FluentConfiguration(this);
    @XmlTransient
    private ClassLoader cl;
    @XmlElement
    LockingType locking = new LockingType().setConfiguration(this);
    @XmlElement
    CacheLoaderManagerConfig loaders = new CacheLoaderManagerConfig().setConfiguration(this);
    @XmlElement
    TransactionType transaction = new TransactionType(null).setConfiguration(this);
    @XmlElement
    CustomInterceptorsType customInterceptors = new CustomInterceptorsType().setConfiguration(this);
    @XmlElement
    DataContainerType dataContainer = new DataContainerType().setConfiguration(this);
    @XmlElement
    EvictionType eviction = new EvictionType().setConfiguration(this);
    @XmlElement
    ExpirationType expiration = new ExpirationType().setConfiguration(this);
    @XmlElement
    UnsafeType unsafe = new UnsafeType().setConfiguration(this);
    @XmlElement
    ClusteringType clustering = new ClusteringType(CacheMode.LOCAL).setConfiguration(this);
    @XmlElement
    JmxStatistics jmxStatistics = new JmxStatistics().setConfiguration(this);
    @XmlElement
    StoreAsBinary storeAsBinary = new StoreAsBinary().setConfiguration(this);
    @Deprecated
    @XmlElement
    LazyDeserialization lazyDeserialization = new LazyDeserialization().setConfiguration(this);
    @XmlTransient
    InvocationBatching invocationBatching = new InvocationBatching().setConfiguration(this);
    @XmlElement
    DeadlockDetectionType deadlockDetection = new DeadlockDetectionType().setConfiguration(this);
    @XmlElement
    QueryConfigurationBean indexing = new QueryConfigurationBean().setConfiguration(this);
    @XmlElement
    VersioningConfigurationBean versioning = new VersioningConfigurationBean().setConfiguration(this);

    @Start(priority=1)
    private void correctIsolationLevels() {
        switch (this.locking.isolationLevel) {
            case NONE: {
                if (!this.clustering.mode.isClustered()) break;
                this.locking.isolationLevel = IsolationLevel.READ_COMMITTED;
                break;
            }
            case READ_UNCOMMITTED: {
                this.locking.isolationLevel = IsolationLevel.READ_COMMITTED;
                break;
            }
            case SERIALIZABLE: {
                this.locking.isolationLevel = IsolationLevel.REPEATABLE_READ;
            }
        }
    }

    public void applyOverrides(Configuration overrides) {
        OverrideConfigurationVisitor v1 = new OverrideConfigurationVisitor();
        this.accept(v1);
        OverrideConfigurationVisitor v2 = new OverrideConfigurationVisitor();
        overrides.accept(v2);
        v1.override(v2);
    }

    @Override
    public void inject(ComponentRegistry cr) {
        this.accept(new AbstractNamedCacheConfigurationBean.InjectComponentRegistryVisitor(cr));
    }

    public FluentConfiguration fluent() {
        return this.fluentConfig;
    }

    private void setInvocationBatching(InvocationBatching invocationBatching) {
        this.invocationBatching = invocationBatching;
        this.invocationBatching.setConfiguration(this);
    }

    @XmlElement
    private InvocationBatching getInvocationBatching() {
        return this.invocationBatching;
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void setGlobalConfiguration(GlobalConfiguration gc) {
        this.globalConfiguration = gc;
    }

    public final String getName() {
        return this.name;
    }

    public ClassLoader getClassLoader() {
        if (this.cl != null) {
            return this.cl;
        }
        if (this.cl == null && this.globalConfiguration != null) {
            return this.globalConfiguration.getClassLoader();
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = cl;
    }

    public boolean isStateTransferEnabled() {
        return this.clustering.stateRetrieval.fetchInMemoryState != false || this.loaders != null && this.loaders.isFetchPersistentState() != false;
    }

    public long getDeadlockDetectionSpinDuration() {
        return this.deadlockDetection.spinDuration;
    }

    @Deprecated
    public void setDeadlockDetectionSpinDuration(long eagerDeadlockSpinDuration) {
        this.deadlockDetection.setSpinDuration(eagerDeadlockSpinDuration);
    }

    @Deprecated
    public boolean isEnableDeadlockDetection() {
        return this.deadlockDetection.enabled;
    }

    public boolean isDeadlockDetectionEnabled() {
        return this.deadlockDetection.enabled;
    }

    @Deprecated
    public void setEnableDeadlockDetection(boolean useEagerDeadlockDetection) {
        this.deadlockDetection.setEnabled(useEagerDeadlockDetection);
    }

    @Deprecated
    public void setUseLockStriping(boolean useLockStriping) {
        this.locking.setUseLockStriping(useLockStriping);
    }

    public boolean isUseLockStriping() {
        return this.locking.useLockStriping;
    }

    public boolean isUnsafeUnreliableReturnValues() {
        return this.unsafe.unreliableReturnValues;
    }

    @Deprecated
    public void setUnsafeUnreliableReturnValues(boolean unsafeUnreliableReturnValues) {
        this.unsafe.setUnreliableReturnValues(unsafeUnreliableReturnValues);
    }

    @Deprecated
    public void setRehashRpcTimeout(long rehashRpcTimeout) {
        this.clustering.hash.setRehashRpcTimeout(rehashRpcTimeout);
    }

    public long getRehashRpcTimeout() {
        return this.clustering.hash.rehashRpcTimeout;
    }

    public boolean isWriteSkewCheck() {
        return this.locking.writeSkewCheck;
    }

    @Deprecated
    public void setWriteSkewCheck(boolean writeSkewCheck) {
        this.locking.setWriteSkewCheck(writeSkewCheck);
    }

    public int getConcurrencyLevel() {
        return this.locking.concurrencyLevel;
    }

    @Deprecated
    public void setConcurrencyLevel(int concurrencyLevel) {
        this.locking.setConcurrencyLevel(concurrencyLevel);
    }

    @Deprecated
    public void setReplQueueMaxElements(int replQueueMaxElements) {
        this.clustering.async.setReplQueueMaxElements(replQueueMaxElements);
    }

    @Deprecated
    public void setReplQueueInterval(long replQueueInterval) {
        this.clustering.async.setReplQueueInterval(replQueueInterval);
    }

    @Deprecated
    public void setReplQueueInterval(long replQueueInterval, TimeUnit timeUnit) {
        this.setReplQueueInterval(timeUnit.toMillis(replQueueInterval));
    }

    @Deprecated
    public void setReplQueueClass(String classname) {
        this.clustering.async.setReplQueueClass(classname);
    }

    @Deprecated
    public void setExposeJmxStatistics(boolean useMbean) {
        this.jmxStatistics.setEnabled(useMbean);
    }

    @Deprecated
    public void setInvocationBatchingEnabled(boolean enabled) {
        this.invocationBatching.setEnabled(enabled);
    }

    @Deprecated
    public void setFetchInMemoryState(boolean fetchInMemoryState) {
        this.clustering.stateRetrieval.setFetchInMemoryState(fetchInMemoryState);
    }

    @Deprecated
    public void setAlwaysProvideInMemoryState(boolean alwaysProvideInMemoryState) {
        this.clustering.stateRetrieval.setAlwaysProvideInMemoryState(alwaysProvideInMemoryState);
    }

    @Deprecated
    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout) {
        this.locking.setLockAcquisitionTimeout(lockAcquisitionTimeout);
    }

    @Deprecated
    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout, TimeUnit timeUnit) {
        this.setLockAcquisitionTimeout(timeUnit.toMillis(lockAcquisitionTimeout));
    }

    @Deprecated
    public void setSyncReplTimeout(long syncReplTimeout) {
        this.clustering.sync.setReplTimeout(syncReplTimeout);
    }

    @Deprecated
    public void setSyncReplTimeout(long syncReplTimeout, TimeUnit timeUnit) {
        this.setSyncReplTimeout(timeUnit.toMillis(syncReplTimeout));
    }

    @Deprecated
    public void setCacheMode(CacheMode cacheModeInt) {
        this.clustering.setMode(cacheModeInt);
    }

    @Deprecated
    public void setCacheMode(String cacheMode) {
        if (cacheMode == null) {
            throw new ConfigurationException("Cache mode cannot be null", "CacheMode");
        }
        this.clustering.setMode(CacheMode.valueOf(this.uc(cacheMode)));
        if (this.clustering.mode == null) {
            log.warn("Unknown cache mode '" + cacheMode + "', using defaults.");
            this.clustering.setMode(CacheMode.LOCAL);
        }
    }

    public String getCacheModeString() {
        return this.clustering.mode == null ? "none" : this.clustering.mode.toString();
    }

    @Deprecated
    public void setCacheModeString(String cacheMode) {
        this.setCacheMode(cacheMode);
    }

    public String getDataContainerClass() {
        return this.dataContainer.dataContainerClass;
    }

    public DataContainer getDataContainer() {
        return this.dataContainer.dataContainer;
    }

    public TypedProperties getDataContainerProperties() {
        return this.dataContainer.properties;
    }

    @Deprecated
    public long getEvictionWakeUpInterval() {
        return this.getExpirationWakeUpInterval();
    }

    @Deprecated
    public void setEvictionWakeUpInterval(long evictionWakeUpInterval) {
        this.eviction.setWakeUpInterval(evictionWakeUpInterval);
    }

    public EvictionStrategy getEvictionStrategy() {
        return this.eviction.strategy;
    }

    @Deprecated
    public void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.eviction.setStrategy(evictionStrategy);
    }

    @Deprecated
    public void setEvictionStrategy(String eStrategy) {
        this.eviction.strategy = EvictionStrategy.valueOf(this.uc(eStrategy));
        if (this.eviction.strategy == null) {
            log.warn("Unknown evictionStrategy  '" + eStrategy + "'!  Using EvictionStrategy.NONE.");
            this.eviction.setStrategy(EvictionStrategy.NONE);
        }
    }

    public EvictionThreadPolicy getEvictionThreadPolicy() {
        return this.eviction.threadPolicy;
    }

    @Deprecated
    public void setEvictionThreadPolicy(EvictionThreadPolicy policy) {
        this.eviction.setThreadPolicy(policy);
    }

    @Deprecated
    public void setEvictionThreadPolicy(String policy) {
        this.eviction.threadPolicy = EvictionThreadPolicy.valueOf(this.uc(policy));
        if (this.eviction.threadPolicy == null) {
            log.warn("Unknown thread eviction policy  '" + policy + "'!  Using EvictionThreadPolicy.DEFAULT");
            this.eviction.setThreadPolicy(EvictionThreadPolicy.DEFAULT);
        }
    }

    public int getEvictionMaxEntries() {
        return this.eviction.maxEntries;
    }

    @Deprecated
    public void setEvictionMaxEntries(int evictionMaxEntries) {
        this.eviction.setMaxEntries(evictionMaxEntries);
    }

    @Deprecated
    public void setVersioningScheme(VersioningScheme versioningScheme) {
        this.versioning.setVersioningScheme(versioningScheme);
    }

    @Deprecated
    public void setEnableVersioning(boolean enabled) {
        this.versioning.setEnabled(enabled);
    }

    public long getExpirationLifespan() {
        return this.expiration.lifespan;
    }

    @Deprecated
    public VersioningScheme getVersioningScheme() {
        return this.versioning.versioningScheme;
    }

    @Deprecated
    public boolean isEnableVersioning() {
        return this.versioning.enabled;
    }

    @Deprecated
    public void setExpirationLifespan(long expirationLifespan) {
        this.expiration.setLifespan(expirationLifespan);
    }

    public long getExpirationMaxIdle() {
        return this.expiration.maxIdle;
    }

    @Deprecated
    public void setExpirationMaxIdle(long expirationMaxIdle) {
        this.expiration.setMaxIdle(expirationMaxIdle);
    }

    public long getExpirationWakeUpInterval() {
        return this.expiration.wakeUpInterval;
    }

    @Deprecated
    public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
        this.transaction.setTransactionManagerLookupClass(transactionManagerLookupClass);
    }

    @Deprecated
    public void setTransactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.transaction.transactionManagerLookup(transactionManagerLookup);
    }

    @Deprecated
    public void setCacheLoaderManagerConfig(CacheLoaderManagerConfig cacheLoaderManagerConfig) {
        this.loaders = cacheLoaderManagerConfig;
    }

    @Deprecated
    public void setSyncCommitPhase(boolean syncCommitPhase) {
        this.transaction.setSyncCommitPhase(syncCommitPhase);
    }

    @Deprecated
    public void setSyncRollbackPhase(boolean syncRollbackPhase) {
        this.transaction.setSyncRollbackPhase(syncRollbackPhase);
    }

    @Deprecated
    public void setUseEagerLocking(boolean useEagerLocking) {
        this.transaction.setUseEagerLocking(useEagerLocking);
    }

    @Deprecated
    public void setEagerLockSingleNode(boolean eagerLockSingleNode) {
        this.transaction.setEagerLockSingleNode(eagerLockSingleNode);
    }

    @Deprecated
    public Configuration setCacheStopTimeout(int cacheStopTimeout) {
        this.transaction.setCacheStopTimeout(cacheStopTimeout);
        return this;
    }

    @Deprecated
    public void setUseReplQueue(boolean useReplQueue) {
        this.clustering.async.setUseReplQueue(useReplQueue);
    }

    @Deprecated
    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.locking.setIsolationLevel(isolationLevel);
    }

    @Deprecated
    public void setStateRetrievalTimeout(long stateRetrievalTimeout) {
        this.clustering.stateRetrieval.setTimeout(stateRetrievalTimeout);
    }

    @Deprecated
    public void setStateRetrievalTimeout(long stateRetrievalTimeout, TimeUnit timeUnit) {
        this.setStateRetrievalTimeout(timeUnit.toMillis(stateRetrievalTimeout));
    }

    @Deprecated
    public void setStateRetrievalLogFlushTimeout(long logFlushTimeout) {
        this.clustering.stateRetrieval.setLogFlushTimeout(logFlushTimeout);
    }

    @Deprecated
    public void setStateRetrievalLogFlushTimeout(long logFlushTimeout, TimeUnit timeUnit) {
        this.clustering.stateRetrieval.setLogFlushTimeout(timeUnit.toMillis(logFlushTimeout));
    }

    @Deprecated
    public void setStateRetrievalMaxNonProgressingLogWrites(int maxNonProgressingLogWrites) {
        this.clustering.stateRetrieval.setMaxNonProgressingLogWrites(maxNonProgressingLogWrites);
    }

    @Deprecated
    public void setStateRetrievalChunkSize(int chunkSize) {
        this.clustering.stateRetrieval.setChunkSize(chunkSize);
    }

    @Deprecated
    public void setStateRetrievalInitialRetryWaitTime(long initialRetryWaitTime) {
        this.clustering.stateRetrieval.setInitialRetryWaitTime(initialRetryWaitTime);
    }

    @Deprecated
    public void setStateRetrievalInitialRetryWaitTime(long initialRetryWaitTime, TimeUnit timeUnit) {
        this.setStateRetrievalInitialRetryWaitTime(timeUnit.toMillis(initialRetryWaitTime));
    }

    @Deprecated
    public void setStateRetrievalRetryWaitTimeIncreaseFactor(int retryWaitTimeIncreaseFactor) {
        this.clustering.stateRetrieval.setRetryWaitTimeIncreaseFactor(retryWaitTimeIncreaseFactor);
    }

    @Deprecated
    public void setStateRetrievalNumRetries(int numRetries) {
        this.clustering.stateRetrieval.setNumRetries(numRetries);
    }

    @Deprecated
    public void setIsolationLevel(String isolationLevel) {
        if (isolationLevel == null) {
            throw new ConfigurationException("Isolation level cannot be null", "IsolationLevel");
        }
        this.locking.setIsolationLevel(IsolationLevel.valueOf(this.uc(isolationLevel)));
        if (this.locking.isolationLevel == null) {
            log.warn("Unknown isolation level '" + isolationLevel + "', using defaults.");
            this.locking.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        }
    }

    @Deprecated
    public void setUseLazyDeserialization(boolean useLazyDeserialization) {
        this.storeAsBinary.setEnabled(useLazyDeserialization);
    }

    @Deprecated
    public void setL1CacheEnabled(boolean l1CacheEnabled) {
        this.clustering.l1.setEnabled(l1CacheEnabled);
    }

    @Deprecated
    public void setL1Lifespan(long l1Lifespan) {
        this.clustering.l1.setLifespan(l1Lifespan);
    }

    @Deprecated
    public void setL1OnRehash(boolean l1OnRehash) {
        this.clustering.l1.setOnRehash(l1OnRehash);
    }

    @Deprecated
    public void setL1InvalidationThreshold(int threshold) {
        this.clustering.l1.setInvalidationThreshold(threshold);
    }

    public int getL1InvalidationThreshold() {
        return this.clustering.l1.invalidationThreshold;
    }

    @Deprecated
    public void setConsistentHashClass(String consistentHashClass) {
        this.clustering.hash.setConsistentHashClass(consistentHashClass);
    }

    @Deprecated
    public void setHashFunctionClass(String hashFunctionClass) {
        this.clustering.hash.hashFunctionClass = hashFunctionClass;
    }

    @Deprecated
    public void setNumOwners(int numOwners) {
        this.clustering.hash.setNumOwners(numOwners);
    }

    @Deprecated
    public void setRehashEnabled(boolean rehashEnabled) {
        this.clustering.hash.setRehashEnabled(rehashEnabled);
    }

    @Deprecated
    public void setRehashWaitTime(long rehashWaitTime) {
        this.clustering.hash.setRehashWait(rehashWaitTime);
    }

    @Deprecated
    public void setUseAsyncMarshalling(boolean useAsyncMarshalling) {
        this.clustering.async.setAsyncMarshalling(useAsyncMarshalling);
    }

    @Deprecated
    public void setIndexingEnabled(boolean enabled) {
        this.indexing.setEnabled(enabled);
    }

    @Deprecated
    public void setIndexLocalOnly(boolean indexLocalOnly) {
        this.indexing.setIndexLocalOnly(indexLocalOnly);
    }

    public boolean isUseAsyncMarshalling() {
        return this.clustering.async.asyncMarshalling;
    }

    public boolean isUseReplQueue() {
        return this.clustering.async.useReplQueue;
    }

    public int getReplQueueMaxElements() {
        return this.clustering.async.replQueueMaxElements;
    }

    public long getReplQueueInterval() {
        return this.clustering.async.replQueueInterval;
    }

    public String getReplQueueClass() {
        return this.clustering.async.replQueueClass;
    }

    public boolean isExposeJmxStatistics() {
        return this.jmxStatistics.enabled;
    }

    public boolean isInvocationBatchingEnabled() {
        return this.invocationBatching.enabled;
    }

    public boolean isIndexingEnabled() {
        return this.indexing.isEnabled();
    }

    public boolean isIndexLocalOnly() {
        return this.indexing.isIndexLocalOnly();
    }

    public TypedProperties getIndexingProperties() {
        return this.indexing.properties;
    }

    public boolean isFetchInMemoryState() {
        return this.clustering.stateRetrieval.fetchInMemoryState;
    }

    public boolean isAlwaysProvideInMemoryState() {
        return this.clustering.stateRetrieval.alwaysProvideInMemoryState;
    }

    @Deprecated
    public boolean isEagerLockingSingleNodeInUse() {
        return this.isUseEagerLocking() && this.isEagerLockSingleNode() && this.getCacheMode().isDistributed();
    }

    public long getLockAcquisitionTimeout() {
        return this.locking.lockAcquisitionTimeout;
    }

    public long getSyncReplTimeout() {
        return this.clustering.sync.replTimeout;
    }

    public CacheMode getCacheMode() {
        return this.clustering.mode;
    }

    public LockingMode getTransactionLockingMode() {
        return this.transaction.lockingMode;
    }

    public TransactionMode getTransactionMode() {
        return this.transaction.transactionMode;
    }

    public boolean isTransactionAutoCommit() {
        return this.transaction.autoCommit;
    }

    public boolean isUse1PcForAutoCommitTransactions() {
        return this.transaction.use1PcForAutoCommitTransactions;
    }

    public IsolationLevel getIsolationLevel() {
        return this.locking.isolationLevel;
    }

    public String getTransactionManagerLookupClass() {
        return this.transaction.transactionManagerLookupClass;
    }

    public TransactionManagerLookup getTransactionManagerLookup() {
        return this.transaction.transactionManagerLookup;
    }

    public TransactionSynchronizationRegistryLookup getTransactionSynchronizationRegistryLookup() {
        return this.transaction.transactionSynchronizationRegistryLookup;
    }

    @Deprecated
    public CacheLoaderManagerConfig getCacheLoaderManagerConfig() {
        return this.loaders;
    }

    public List<CacheLoaderConfig> getCacheLoaders() {
        return this.loaders.getCacheLoaderConfigs();
    }

    public boolean isCacheLoaderShared() {
        return this.loaders.isShared();
    }

    public boolean isFetchPersistentState() {
        return this.loaders.isFetchPersistentState();
    }

    public boolean isCacheLoaderPassivation() {
        return this.loaders.isPassivation();
    }

    public boolean isCacheLoaderPreload() {
        return this.loaders.isPreload();
    }

    public boolean isSyncCommitPhase() {
        return this.transaction.syncCommitPhase;
    }

    public boolean isSyncRollbackPhase() {
        return this.transaction.syncRollbackPhase;
    }

    public boolean isSecondPhaseAsync() {
        return !this.isSyncCommitPhase() || this.isUseReplQueue() || !this.getCacheMode().isSynchronous();
    }

    @Deprecated
    public boolean isUseEagerLocking() {
        return this.transaction.useEagerLocking;
    }

    @Deprecated
    public boolean isEagerLockSingleNode() {
        return this.transaction.eagerLockSingleNode;
    }

    public int getCacheStopTimeout() {
        return this.transaction.cacheStopTimeout;
    }

    public long getStateRetrievalTimeout() {
        return this.clustering.stateRetrieval.timeout;
    }

    public long getStateRetrievalInitialRetryWaitTime() {
        return this.clustering.stateRetrieval.initialRetryWaitTime;
    }

    public int getStateRetrievalRetryWaitTimeIncreaseFactor() {
        return this.clustering.stateRetrieval.retryWaitTimeIncreaseFactor;
    }

    public int getStateRetrievalNumRetries() {
        return this.clustering.stateRetrieval.numRetries;
    }

    public int getStateRetrievalMaxNonProgressingLogWrites() {
        return this.clustering.stateRetrieval.maxNonProgressingLogWrites;
    }

    public int getStateRetrievalChunkSize() {
        return this.clustering.stateRetrieval.chunkSize;
    }

    public long getStateRetrievalLogFlushTimeout() {
        return this.clustering.stateRetrieval.logFlushTimeout;
    }

    @Deprecated
    public boolean isUseLazyDeserialization() {
        return this.isStoreAsBinary();
    }

    public boolean isStoreAsBinary() {
        if (this.lazyDeserialization.enabled.booleanValue()) {
            this.storeAsBinary.enabled = true;
        }
        return this.storeAsBinary.enabled;
    }

    public boolean isL1CacheEnabled() {
        return this.clustering.l1.enabled;
    }

    public boolean isL1CacheActivated() {
        return this.clustering.l1.activated && this.isL1CacheEnabled();
    }

    public long getL1Lifespan() {
        return this.clustering.l1.lifespan;
    }

    public boolean isL1OnRehash() {
        return this.clustering.l1.onRehash;
    }

    public String getConsistentHashClass() {
        if (this.clustering.hash.consistentHashClass == null) {
            this.clustering.hash.consistentHashClass = this.globalConfiguration == null || this.globalConfiguration.hasTopologyInfo() ? TopologyAwareConsistentHash.class.getName() : DefaultConsistentHash.class.getName();
        }
        return this.clustering.hash.consistentHashClass;
    }

    public boolean hasConsistentHashClass() {
        return this.clustering.hash.consistentHashClass != null;
    }

    public boolean isCustomConsistentHashClass() {
        return this.clustering.hash.consistentHashClass != null && !this.clustering.hash.consistentHashClass.equals(DefaultConsistentHash.class.getName()) && !this.clustering.hash.consistentHashClass.equals(TopologyAwareConsistentHash.class.getName());
    }

    public boolean isCustomHashFunctionClass() {
        return this.clustering.hash.hashFunctionClass != null && !this.clustering.hash.hashFunctionClass.equals(MurmurHash3.class.getName());
    }

    public String getHashFunctionClass() {
        return this.clustering.hash.hashFunctionClass;
    }

    public int getNumOwners() {
        return this.clustering.hash.numOwners;
    }

    public int getNumVirtualNodes() {
        return this.clustering.hash.numVirtualNodes;
    }

    public boolean isGroupsEnabled() {
        this.clustering.hash.groups.setConfiguration(this);
        return this.clustering.hash.groups.enabled;
    }

    public List<Grouper<?>> getGroupers() {
        this.clustering.hash.groups.setConfiguration(this);
        return this.clustering.hash.groups.groupers;
    }

    public boolean isRehashEnabled() {
        return this.clustering.hash.rehashEnabled;
    }

    public long getRehashWaitTime() {
        return this.clustering.hash.rehashWait;
    }

    public boolean isTransactionRecoveryEnabled() {
        return this.transaction.recovery.isEnabled();
    }

    public String getTransactionRecoveryCacheName() {
        return this.transaction.recovery.getRecoveryInfoCacheName();
    }

    public boolean isUseSynchronizationForTransactions() {
        return this.transaction.isUseSynchronization();
    }

    public void accept(ConfigurationBeanVisitor v) {
        v.visitConfiguration(this);
        this.clustering.accept(v);
        this.customInterceptors.accept(v);
        this.dataContainer.accept(v);
        this.deadlockDetection.accept(v);
        this.eviction.accept(v);
        this.expiration.accept(v);
        this.invocationBatching.accept(v);
        this.jmxStatistics.accept(v);
        this.storeAsBinary.accept(v);
        this.lazyDeserialization.accept(v);
        this.loaders.accept(v);
        this.locking.accept(v);
        this.transaction.accept(v);
        this.unsafe.accept(v);
        this.indexing.accept(v);
        this.versioning.accept(v);
    }

    public boolean equals(Object o) {
        if (!this.equalsIgnoreName(o)) {
            return false;
        }
        Configuration that = (Configuration)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public boolean equalsIgnoreName(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)o;
        if (this.clustering != null ? !this.clustering.equals(that.clustering) : that.clustering != null) {
            return false;
        }
        if (this.customInterceptors != null ? !this.customInterceptors.equals(that.customInterceptors) : that.customInterceptors != null) {
            return false;
        }
        if (this.dataContainer != null ? !this.dataContainer.equals(that.dataContainer) : that.dataContainer != null) {
            return false;
        }
        if (this.deadlockDetection != null ? !this.deadlockDetection.equals(that.deadlockDetection) : that.deadlockDetection != null) {
            return false;
        }
        if (this.eviction != null ? !this.eviction.equals(that.eviction) : that.eviction != null) {
            return false;
        }
        if (this.expiration != null ? !this.expiration.equals(that.expiration) : that.expiration != null) {
            return false;
        }
        if (this.globalConfiguration != null ? !this.globalConfiguration.equals(that.globalConfiguration) : that.globalConfiguration != null) {
            return false;
        }
        if (this.invocationBatching != null ? !this.invocationBatching.equals(that.invocationBatching) : that.invocationBatching != null) {
            return false;
        }
        if (this.jmxStatistics != null ? !this.jmxStatistics.equals(that.jmxStatistics) : that.jmxStatistics != null) {
            return false;
        }
        if (this.storeAsBinary != null ? !this.storeAsBinary.equals(that.storeAsBinary) : that.storeAsBinary != null) {
            return false;
        }
        if (this.lazyDeserialization != null ? !this.lazyDeserialization.equals(that.lazyDeserialization) : that.lazyDeserialization != null) {
            return false;
        }
        if (this.loaders != null ? !this.loaders.equals(that.loaders) : that.loaders != null) {
            return false;
        }
        if (this.locking != null ? !this.locking.equals(that.locking) : that.locking != null) {
            return false;
        }
        if (this.transaction != null ? !this.transaction.equals(that.transaction) : that.transaction != null) {
            return false;
        }
        return !(this.unsafe != null ? !this.unsafe.equals(that.unsafe) : that.unsafe != null);
    }

    public int hashCode() {
        int result = this.globalConfiguration != null ? this.globalConfiguration.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.locking != null ? this.locking.hashCode() : 0);
        result = 31 * result + (this.loaders != null ? this.loaders.hashCode() : 0);
        result = 31 * result + (this.transaction != null ? this.transaction.hashCode() : 0);
        result = 31 * result + (this.customInterceptors != null ? this.customInterceptors.hashCode() : 0);
        result = 31 * result + (this.dataContainer != null ? this.dataContainer.hashCode() : 0);
        result = 31 * result + (this.eviction != null ? this.eviction.hashCode() : 0);
        result = 31 * result + (this.expiration != null ? this.expiration.hashCode() : 0);
        result = 31 * result + (this.unsafe != null ? this.unsafe.hashCode() : 0);
        result = 31 * result + (this.clustering != null ? this.clustering.hashCode() : 0);
        result = 31 * result + (this.jmxStatistics != null ? this.jmxStatistics.hashCode() : 0);
        result = 31 * result + (this.storeAsBinary != null ? this.storeAsBinary.hashCode() : 0);
        result = 31 * result + (this.lazyDeserialization != null ? this.lazyDeserialization.hashCode() : 0);
        result = 31 * result + (this.invocationBatching != null ? this.invocationBatching.hashCode() : 0);
        result = 31 * result + (this.deadlockDetection != null ? this.deadlockDetection.hashCode() : 0);
        return result;
    }

    @Override
    public Configuration clone() {
        try {
            Configuration dolly = (Configuration)super.clone();
            if (this.clustering != null) {
                dolly.clustering = this.clustering.clone();
                dolly.clustering.setConfiguration(dolly);
            }
            if (this.locking != null) {
                dolly.locking = (LockingType)this.locking.clone();
                dolly.locking.setConfiguration(dolly);
            }
            if (this.loaders != null) {
                dolly.loaders = this.loaders.clone();
                dolly.loaders.setConfiguration(dolly);
            }
            if (this.transaction != null) {
                dolly.transaction = this.transaction.clone();
                dolly.transaction.setConfiguration(dolly);
            }
            if (this.customInterceptors != null) {
                dolly.customInterceptors = this.customInterceptors.clone();
                dolly.customInterceptors.setConfiguration(dolly);
            }
            if (this.dataContainer != null) {
                dolly.dataContainer = (DataContainerType)this.dataContainer.clone();
                dolly.dataContainer.setConfiguration(dolly);
            }
            if (this.eviction != null) {
                dolly.eviction = (EvictionType)this.eviction.clone();
                dolly.eviction.setConfiguration(dolly);
            }
            if (this.expiration != null) {
                dolly.expiration = (ExpirationType)this.expiration.clone();
                dolly.expiration.setConfiguration(dolly);
            }
            if (this.unsafe != null) {
                dolly.unsafe = (UnsafeType)this.unsafe.clone();
                dolly.unsafe.setConfiguration(dolly);
            }
            if (this.clustering != null) {
                dolly.clustering = this.clustering.clone();
                dolly.clustering.setConfiguration(dolly);
            }
            if (this.jmxStatistics != null) {
                dolly.jmxStatistics = (JmxStatistics)this.jmxStatistics.clone();
                dolly.jmxStatistics.setConfiguration(dolly);
            }
            if (this.storeAsBinary != null) {
                dolly.storeAsBinary = this.storeAsBinary.clone();
                dolly.storeAsBinary.setConfiguration(dolly);
            }
            if (this.lazyDeserialization != null) {
                dolly.lazyDeserialization = (LazyDeserialization)this.lazyDeserialization.clone();
                dolly.lazyDeserialization.setConfiguration(dolly);
            }
            if (this.invocationBatching != null) {
                dolly.invocationBatching = (InvocationBatching)this.invocationBatching.clone();
                dolly.invocationBatching.setConfiguration(dolly);
            }
            if (this.deadlockDetection != null) {
                dolly.deadlockDetection = (DeadlockDetectionType)this.deadlockDetection.clone();
                dolly.deadlockDetection.setConfiguration(dolly);
            }
            if (this.transaction != null) {
                dolly.transaction = this.transaction.clone();
                dolly.transaction.setConfiguration(dolly);
            }
            if (this.indexing != null) {
                dolly.indexing = this.indexing.clone();
                dolly.indexing.setConfiguration(dolly);
            }
            dolly.fluentConfig = new FluentConfiguration(dolly);
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Unexpected!", e);
        }
    }

    public String toXmlString() {
        return InfinispanConfiguration.toXmlString(this);
    }

    public boolean isUsingCacheLoaders() {
        return this.getCacheLoaderManagerConfig() != null && !this.getCacheLoaderManagerConfig().getCacheLoaderConfigs().isEmpty();
    }

    public List<CustomInterceptorConfig> getCustomInterceptors() {
        return this.customInterceptors.customInterceptors == null ? Collections.emptyList() : this.customInterceptors.customInterceptors;
    }

    public boolean isStoreKeysAsBinary() {
        return this.storeAsBinary.isStoreKeysAsBinary();
    }

    public boolean isStoreValuesAsBinary() {
        return this.storeAsBinary.isStoreValuesAsBinary();
    }

    @Deprecated
    public void setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
        this.customInterceptors.setCustomInterceptors(customInterceptors);
    }

    public void assertValid() throws ConfigurationException {
        if (this.clustering.mode.isClustered() && this.globalConfiguration != null && (this.globalConfiguration.getTransportClass() == null || this.globalConfiguration.getTransportClass().length() == 0)) {
            throw new ConfigurationException("Cache cannot use a clustered mode (" + (Object)((Object)this.clustering.mode) + ") mode and not define a transport!");
        }
    }

    public boolean isOnePhaseCommit() {
        return !this.getCacheMode().isSynchronous() || this.getTransactionLockingMode() == LockingMode.PESSIMISTIC;
    }

    public boolean isTransactionalCache() {
        return this.transaction.transactionMode.equals((Object)TransactionMode.TRANSACTIONAL);
    }

    public boolean isExpirationReaperEnabled() {
        return this.expiration.reaperEnabled;
    }

    public boolean isHashActivated() {
        return this.clustering.hash.activated;
    }

    public long getL1InvalidationCleanupTaskFrequency() {
        return this.clustering.l1.getL1InvalidationCleanupTaskFrequency();
    }

    public void setL1InvalidationCleanupTaskFrequency(long frequencyMillis) {
        this.clustering.l1.setL1InvalidationCleanupTaskFrequency(frequencyMillis);
    }

    @Deprecated
    public static enum CacheMode {
        LOCAL,
        REPL_SYNC,
        REPL_ASYNC,
        INVALIDATION_SYNC,
        INVALIDATION_ASYNC,
        DIST_SYNC,
        DIST_ASYNC;


        public boolean isInvalidation() {
            return this == INVALIDATION_SYNC || this == INVALIDATION_ASYNC;
        }

        public boolean isSynchronous() {
            return this == REPL_SYNC || this == DIST_SYNC || this == INVALIDATION_SYNC || this == LOCAL;
        }

        public boolean isClustered() {
            return this != LOCAL;
        }

        public boolean isDistributed() {
            return this == DIST_SYNC || this == DIST_ASYNC;
        }

        public boolean isReplicated() {
            return this == REPL_SYNC || this == REPL_ASYNC;
        }

        public CacheMode toSync() {
            switch (this) {
                case REPL_ASYNC: {
                    return REPL_SYNC;
                }
                case INVALIDATION_ASYNC: {
                    return INVALIDATION_SYNC;
                }
                case DIST_ASYNC: {
                    return DIST_SYNC;
                }
            }
            return this;
        }

        public CacheMode toAsync() {
            switch (this) {
                case REPL_SYNC: {
                    return REPL_ASYNC;
                }
                case INVALIDATION_SYNC: {
                    return INVALIDATION_ASYNC;
                }
                case DIST_SYNC: {
                    return DIST_ASYNC;
                }
            }
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="indexing")
    @Deprecated
    public static class QueryConfigurationBean
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.IndexingConfig {
        private static final long serialVersionUID = 2891683014353342549L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setIndexingEnabled")
        protected Boolean enabled = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setIndexLocalOnly")
        protected Boolean indexLocalOnly = false;
        @XmlElement(name="properties")
        protected TypedProperties properties = new TypedProperties();

        public void accept(ConfigurationBeanVisitor v) {
            v.visitQueryConfigurationBean(this);
        }

        @XmlAttribute
        public Boolean isEnabled() {
            return this.enabled;
        }

        @Deprecated
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        @XmlAttribute
        public Boolean isIndexLocalOnly() {
            return this.indexLocalOnly;
        }

        @Deprecated
        public void setIndexLocalOnly(Boolean indexLocalOnly) {
            this.testImmutability("indexLocalOnly");
            this.indexLocalOnly = indexLocalOnly;
        }

        @Override
        public FluentConfiguration.IndexingConfig indexLocalOnly(Boolean indexLocalOnly) {
            this.setIndexLocalOnly(indexLocalOnly);
            return this;
        }

        @Override
        public FluentConfiguration.IndexingConfig withProperties(Properties properties) {
            this.testImmutability("properties");
            this.properties = QueryConfigurationBean.toTypedProperties(properties);
            return this;
        }

        @Override
        public FluentConfiguration.IndexingConfig addProperty(String key, String value) {
            if (this.properties == null) {
                this.properties = new TypedProperties();
            }
            this.properties.setProperty(key, value);
            return this;
        }

        @Override
        public FluentConfiguration.IndexingConfig disable() {
            this.setEnabled(false);
            return this;
        }

        @Override
        protected QueryConfigurationBean setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QueryConfigurationBean)) {
                return false;
            }
            QueryConfigurationBean that = (QueryConfigurationBean)o;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
                return false;
            }
            if (this.indexLocalOnly != null ? !this.indexLocalOnly.equals(that.indexLocalOnly) : that.indexLocalOnly != null) {
                return false;
            }
            return this.properties.equals(that.properties);
        }

        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.indexLocalOnly != null ? this.indexLocalOnly.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            return result;
        }

        @Override
        protected boolean hasComponentStarted() {
            return false;
        }

        @Override
        public QueryConfigurationBean clone() {
            try {
                QueryConfigurationBean dolly = (QueryConfigurationBean)super.clone();
                dolly.enabled = this.enabled;
                dolly.indexLocalOnly = this.indexLocalOnly;
                dolly.properties = this.properties;
                return dolly;
            }
            catch (CloneNotSupportedException shouldNotHappen) {
                throw new RuntimeException("Should not happen!", shouldNotHappen);
            }
        }

        public String toString() {
            return "Indexing[enabled=" + this.enabled + ",localOnly=" + this.indexLocalOnly + "]";
        }
    }

    @Deprecated
    public static class CustomInterceptorPositionType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.CustomInterceptorPosition {
        private final CommandInterceptor interceptor;
        private final CustomInterceptorsType type;

        public CustomInterceptorPositionType(CommandInterceptor interceptor, CustomInterceptorsType type) {
            this.interceptor = interceptor;
            this.type = type;
        }

        @Override
        public FluentConfiguration.CustomInterceptorsConfig first() {
            CustomInterceptorConfig cfg = new CustomInterceptorConfig(this.interceptor, true, false, -1, "", "");
            this.type.getCustomInterceptors().add(cfg);
            return this.type;
        }

        @Override
        public FluentConfiguration.CustomInterceptorsConfig last() {
            CustomInterceptorConfig cfg = new CustomInterceptorConfig(this.interceptor, false, true, -1, "", "");
            this.type.getCustomInterceptors().add(cfg);
            return this.type;
        }

        @Override
        public FluentConfiguration.CustomInterceptorsConfig atIndex(int index) {
            CustomInterceptorConfig cfg = new CustomInterceptorConfig(this.interceptor, false, false, index, "", "");
            this.type.getCustomInterceptors().add(cfg);
            return this.type;
        }

        @Override
        public FluentConfiguration.CustomInterceptorsConfig after(Class<? extends CommandInterceptor> interceptorClass) {
            CustomInterceptorConfig cfg = new CustomInterceptorConfig(this.interceptor, false, false, -1, interceptorClass.getName(), null);
            this.type.getCustomInterceptors().add(cfg);
            return this.type;
        }

        @Override
        public FluentConfiguration.CustomInterceptorsConfig before(Class<? extends CommandInterceptor> interceptorClass) {
            CustomInterceptorConfig cfg = new CustomInterceptorConfig(this.interceptor, false, false, -1, null, interceptorClass.getName());
            this.type.getCustomInterceptors().add(cfg);
            return this.type;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ConfigurationDoc(name="customInterceptors")
    @Deprecated
    public static class CustomInterceptorsType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.CustomInterceptorsConfig {
        private static final long serialVersionUID = 7187545782011884661L;
        @XmlElement(name="interceptor")
        private List<CustomInterceptorConfig> customInterceptors = new LinkedList<CustomInterceptorConfig>();

        public CustomInterceptorsType() {
            this.testImmutability("customInterceptors");
        }

        @Override
        public CustomInterceptorsType clone() throws CloneNotSupportedException {
            CustomInterceptorsType dolly = (CustomInterceptorsType)super.clone();
            if (this.customInterceptors != null) {
                dolly.customInterceptors = new LinkedList<CustomInterceptorConfig>();
                for (CustomInterceptorConfig config : this.customInterceptors) {
                    CustomInterceptorConfig clone = config.clone();
                    dolly.customInterceptors.add(clone);
                }
            }
            return dolly;
        }

        public void accept(ConfigurationBeanVisitor v) {
            for (CustomInterceptorConfig i : this.customInterceptors) {
                i.accept(v);
            }
            v.visitCustomInterceptorsType(this);
        }

        public List<CustomInterceptorConfig> getCustomInterceptors() {
            return this.customInterceptors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CustomInterceptorsType)) {
                return false;
            }
            CustomInterceptorsType that = (CustomInterceptorsType)o;
            return !(this.customInterceptors != null ? !((Object)this.customInterceptors).equals(that.customInterceptors) : that.customInterceptors != null);
        }

        public int hashCode() {
            return this.customInterceptors != null ? ((Object)this.customInterceptors).hashCode() : 0;
        }

        @Deprecated
        public void setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
            this.testImmutability("customInterceptors");
            this.customInterceptors = customInterceptors;
        }

        @Override
        public FluentConfiguration.CustomInterceptorPosition add(CommandInterceptor interceptor) {
            this.testImmutability("customInterceptors");
            return new CustomInterceptorPositionType(interceptor, this);
        }

        @Override
        protected CustomInterceptorsType setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="unsafe")
    @Deprecated
    public static class UnsafeType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.UnsafeConfig {
        private static final long serialVersionUID = -9200921443651234163L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setUnsafeUnreliableReturnValues")
        protected Boolean unreliableReturnValues = false;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitUnsafeType(this);
        }

        @XmlAttribute
        public Boolean isUnreliableReturnValues() {
            return this.unreliableReturnValues;
        }

        @Deprecated
        public void setUnreliableReturnValues(Boolean unreliableReturnValues) {
            this.testImmutability("unreliableReturnValues");
            this.unreliableReturnValues = unreliableReturnValues;
        }

        @Override
        public FluentConfiguration.UnsafeConfig unreliableReturnValues(Boolean unreliableReturnValues) {
            this.setUnreliableReturnValues(unreliableReturnValues);
            return this;
        }

        @Override
        protected UnsafeType setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnsafeType)) {
                return false;
            }
            UnsafeType that = (UnsafeType)o;
            return !(this.unreliableReturnValues != null ? !this.unreliableReturnValues.equals(that.unreliableReturnValues) : that.unreliableReturnValues != null);
        }

        public int hashCode() {
            return this.unreliableReturnValues != null ? this.unreliableReturnValues.hashCode() : 0;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="deadlockDetection")
    @Deprecated
    public static class DeadlockDetectionType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.DeadlockDetectionConfig {
        private static final long serialVersionUID = -7178286048602531152L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEnableDeadlockDetection")
        protected Boolean enabled = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setDeadlockDetectionSpinDuration")
        protected Long spinDuration = 100L;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitDeadlockDetectionType(this);
        }

        @XmlAttribute
        public Boolean isEnabled() {
            return this.enabled;
        }

        @Deprecated
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        @XmlAttribute
        public Long getSpinDuration() {
            return this.spinDuration;
        }

        @Deprecated
        public void setSpinDuration(Long spinDuration) {
            this.testImmutability("spinDuration");
            this.spinDuration = spinDuration;
        }

        @Override
        public FluentConfiguration.DeadlockDetectionConfig spinDuration(Long spinDuration) {
            this.setSpinDuration(spinDuration);
            return this;
        }

        @Override
        protected DeadlockDetectionType setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        @Override
        public FluentConfiguration.DeadlockDetectionConfig disable() {
            this.setEnabled(false);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeadlockDetectionType)) {
                return false;
            }
            DeadlockDetectionType that = (DeadlockDetectionType)o;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
                return false;
            }
            return !(this.spinDuration != null ? !this.spinDuration.equals(that.spinDuration) : that.spinDuration != null);
        }

        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.spinDuration != null ? this.spinDuration.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="versioning")
    @Deprecated
    public static class VersioningConfigurationBean
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.VersioningConfig {
        private static final long serialVersionUID = -123456789001234L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEnableVersioning")
        protected Boolean enabled = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setVersioningScheme")
        protected VersioningScheme versioningScheme = VersioningScheme.NONE;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitVersioningConfigurationBean(this);
        }

        @XmlAttribute
        public Boolean isEnabled() {
            return this.enabled;
        }

        @Deprecated
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        @XmlAttribute
        public VersioningScheme getVersioningScheme() {
            return this.versioningScheme;
        }

        @Deprecated
        public void setVersioningScheme(VersioningScheme versioningScheme) {
            this.testImmutability("versioningScheme");
            this.versioningScheme = versioningScheme;
        }

        @Override
        public VersioningConfigurationBean versioningScheme(VersioningScheme versioningScheme) {
            this.setVersioningScheme(versioningScheme);
            return this;
        }

        @Override
        protected VersioningConfigurationBean setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        @Override
        public VersioningConfigurationBean disable() {
            this.setEnabled(false);
            return this;
        }

        @Override
        public VersioningConfigurationBean enable() {
            this.setEnabled(true);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VersioningConfigurationBean)) {
                return false;
            }
            VersioningConfigurationBean that = (VersioningConfigurationBean)o;
            if (!Util.safeEquals(this.enabled, that.enabled)) {
                return false;
            }
            return Util.safeEquals((Object)this.versioningScheme, (Object)that.versioningScheme);
        }

        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.versioningScheme != null ? this.versioningScheme.hashCode() : 0);
            return result;
        }
    }

    @ConfigurationDoc(name="invocationBatching")
    @Deprecated
    public static class InvocationBatching
    extends BooleanAttributeType
    implements FluentConfiguration.InvocationBatchingConfig {
        private static final long serialVersionUID = 5854115656815587815L;

        public InvocationBatching() {
            super("invocationBatching");
        }

        @Override
        public InvocationBatching enabled(Boolean enabled) {
            super.enabled(enabled);
            return this;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            super.setEnabled(enabled);
            this.updateTransactionMode();
        }

        @Override
        protected InvocationBatching setConfiguration(Configuration config) {
            super.setConfiguration(config);
            this.updateTransactionMode();
            return this;
        }

        @Override
        public InvocationBatching disable() {
            super.disable();
            return this;
        }

        private void updateTransactionMode() {
            if (this.enabled.booleanValue() && this.config != null) {
                this.config.transaction.transactionMode(TransactionMode.TRANSACTIONAL);
            }
        }
    }

    @ConfigurationDoc(name="jmxStatistics")
    @Deprecated
    public static class JmxStatistics
    extends BooleanAttributeType
    implements FluentConfiguration.JmxStatisticsConfig {
        private static final long serialVersionUID = 8716456707015486673L;

        public JmxStatistics() {
            super("jmxStatistics");
        }

        @Override
        protected JmxStatistics setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        @Override
        public JmxStatistics enabled(Boolean enabled) {
            super.enabled(enabled);
            return this;
        }

        @Override
        public JmxStatistics disable() {
            super.disable();
            return this;
        }
    }

    @ConfigurationDoc(name="lazyDeserialization")
    @Deprecated
    public static class LazyDeserialization
    extends BooleanAttributeType {
        public LazyDeserialization() {
            super("lazyDeserialization");
        }

        @Override
        public LazyDeserialization enabled(Boolean enabled) {
            log.lazyDeserializationDeprecated();
            super.enabled(enabled);
            return this;
        }

        @Override
        public LazyDeserialization disable() {
            log.lazyDeserializationDeprecated();
            super.disable();
            return this;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            log.lazyDeserializationDeprecated();
            super.setEnabled(enabled);
        }

        @Override
        protected LazyDeserialization setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }
    }

    @ConfigurationDoc(name="storeAsBinary")
    @Deprecated
    public static class StoreAsBinary
    extends BooleanAttributeType
    implements FluentConfiguration.StoreAsBinaryConfig {
        @ConfigurationDoc(desc="If enabled, keys are stored as binary, in their serialized form.  If false, keys are stored as object references.")
        @XmlAttribute
        private Boolean storeKeysAsBinary = true;
        @ConfigurationDoc(desc="If enabled, values are stored as binary, in their serialized form.  If false, values are stored as object references.")
        @XmlAttribute
        private Boolean storeValuesAsBinary = true;
        private static final long serialVersionUID = 7404820498857564962L;

        public StoreAsBinary() {
            super("storeAsBinary");
        }

        @Override
        protected StoreAsBinary setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        @Override
        public StoreAsBinary enabled(Boolean enabled) {
            super.enabled(enabled);
            return this;
        }

        @Override
        public StoreAsBinary disable() {
            super.disable();
            return this;
        }

        @Override
        public FluentConfiguration.StoreAsBinaryConfig storeKeysAsBinary(Boolean storeKeysAsBinary) {
            this.testImmutability("storeKeysAsBinary");
            this.storeKeysAsBinary = storeKeysAsBinary;
            return this;
        }

        @Override
        public FluentConfiguration.StoreAsBinaryConfig storeValuesAsBinary(Boolean storeValuesAsBinary) {
            this.testImmutability("storeValuesAsBinary");
            this.storeValuesAsBinary = storeValuesAsBinary;
            return this;
        }

        public Boolean isStoreKeysAsBinary() {
            return this.storeKeysAsBinary;
        }

        public Boolean isStoreValuesAsBinary() {
            return this.storeValuesAsBinary;
        }

        @Override
        public void accept(ConfigurationBeanVisitor v) {
            v.visitStoreAsBinaryType(this);
        }

        @Override
        public StoreAsBinary clone() {
            try {
                StoreAsBinary dolly = (StoreAsBinary)super.clone();
                dolly.storeKeysAsBinary = this.storeKeysAsBinary;
                dolly.storeValuesAsBinary = this.storeValuesAsBinary;
                return dolly;
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException("Should never get here");
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @Deprecated
    public static class BooleanAttributeType
    extends AbstractFluentConfigurationBean {
        @XmlTransient
        protected final String fieldName;
        private static final long serialVersionUID = 2296863404153834686L;
        @ConfigurationDoc(desc="Toggle switch")
        protected Boolean enabled = false;

        public BooleanAttributeType() {
            this.fieldName = "undefined";
        }

        public BooleanAttributeType(String fieldName) {
            this.fieldName = fieldName;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitBooleanAttributeType(this);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        @XmlAttribute
        public Boolean isEnabled() {
            return this.enabled;
        }

        public BooleanAttributeType enabled(Boolean enabled) {
            this.setEnabled(enabled);
            return this;
        }

        public BooleanAttributeType disable() {
            this.setEnabled(false);
            return this;
        }

        @Deprecated
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BooleanAttributeType)) {
                return false;
            }
            BooleanAttributeType that = (BooleanAttributeType)o;
            return !(this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null);
        }

        public int hashCode() {
            return this.enabled != null ? this.enabled.hashCode() : 0;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="l1")
    @Deprecated
    public static class L1Type
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.L1Config {
        private static final long serialVersionUID = -4703587764861110638L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setL1CacheEnabled")
        protected Boolean enabled = true;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setL1Lifespan")
        protected Long lifespan = 600000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setL1OnRehash")
        protected Boolean onRehash = true;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setL1InvalidationThreshold")
        protected Integer invalidationThreshold = 0;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setL1InvalidationReaperThreadFrequency")
        protected Long frequency = 600000L;
        @XmlTransient
        public boolean activated = false;

        private void activate() {
            this.activated = true;
            this.overriddenConfigurationElements.add("activated");
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitL1Type(this);
        }

        @XmlAttribute
        public Boolean isEnabled() {
            return this.enabled;
        }

        @Deprecated
        public FluentConfiguration.L1Config setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.activate();
            this.enabled = enabled;
            return this;
        }

        @XmlAttribute
        public Long getLifespan() {
            return this.lifespan;
        }

        @Deprecated
        public FluentConfiguration.L1Config setLifespan(Long lifespan) {
            this.testImmutability("lifespan");
            this.activate();
            this.lifespan = lifespan;
            return this;
        }

        @Deprecated
        public FluentConfiguration.L1Config setL1InvalidationCleanupTaskFrequency(long frequencyMillis) {
            this.testImmutability("frequency");
            this.frequency = frequencyMillis;
            return this;
        }

        @Override
        public FluentConfiguration.L1Config cleanupTaskFrequency(Long frequencyMillis) {
            return this.setL1InvalidationCleanupTaskFrequency(frequencyMillis);
        }

        @XmlAttribute(name="cleanupTaskFrequency")
        public Long getL1InvalidationCleanupTaskFrequency() {
            return this.frequency;
        }

        @Override
        public FluentConfiguration.L1Config lifespan(Long lifespan) {
            this.setLifespan(lifespan);
            return this;
        }

        @XmlAttribute
        public Boolean isOnRehash() {
            return this.onRehash;
        }

        @Deprecated
        public FluentConfiguration.L1Config setOnRehash(Boolean onRehash) {
            this.testImmutability("onRehash");
            this.activate();
            this.onRehash = onRehash;
            return this;
        }

        @Override
        public FluentConfiguration.L1Config onRehash(Boolean onRehash) {
            this.setOnRehash(onRehash);
            return this;
        }

        @Override
        public FluentConfiguration.L1Config invalidationThreshold(Integer threshold) {
            this.setInvalidationThreshold(threshold);
            return this;
        }

        public void setInvalidationThreshold(Integer threshold) {
            this.testImmutability("invalidationThreshold");
            this.activate();
            this.invalidationThreshold = threshold;
        }

        @XmlAttribute
        public Integer getInvalidationThreshold() {
            return this.invalidationThreshold;
        }

        @Override
        public FluentConfiguration.L1Config disable() {
            return this.setEnabled(false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof L1Type)) {
                return false;
            }
            L1Type l1Type = (L1Type)o;
            if (this.enabled != null ? !this.enabled.equals(l1Type.enabled) : l1Type.enabled != null) {
                return false;
            }
            if (this.lifespan != null ? !this.lifespan.equals(l1Type.lifespan) : l1Type.lifespan != null) {
                return false;
            }
            if (this.onRehash != null ? !this.onRehash.equals(l1Type.onRehash) : l1Type.onRehash != null) {
                return false;
            }
            return !(this.invalidationThreshold != null ? !this.invalidationThreshold.equals(l1Type.invalidationThreshold) : l1Type.invalidationThreshold != null);
        }

        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.lifespan != null ? this.lifespan.hashCode() : 0);
            result = 31 * result + (this.onRehash != null ? this.onRehash.hashCode() : 0);
            result = 31 * result + (this.invalidationThreshold != null ? this.invalidationThreshold.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="hash")
    @Deprecated
    public static class HashType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.HashConfig {
        private static final long serialVersionUID = 752218766840948822L;
        @ConfigurationDocRef(name="class", bean=Configuration.class, targetElement="setConsistentHashClass")
        protected String consistentHashClass;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setHashFunctionClass")
        protected String hashFunctionClass = MurmurHash3.class.getName();
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setNumOwners")
        protected Integer numOwners = 2;
        @ConfigurationDoc(desc="Future flag. Currenly unused.")
        protected Long rehashWait = TimeUnit.MINUTES.toMillis(1L);
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setRehashRpcTimeout")
        protected Long rehashRpcTimeout = TimeUnit.MINUTES.toMillis(10L);
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setRehashEnabled")
        protected Boolean rehashEnabled = true;
        @ConfigurationDocRef(bean=FluentConfiguration.HashConfig.class, targetElement="numVirtualNodes")
        protected Integer numVirtualNodes = 1;
        @ConfigurationDocRef(bean=FluentConfiguration.HashConfig.class, targetElement="groups")
        protected GroupsConfiguration groups = new GroupsConfiguration();
        @XmlTransient
        public boolean activated = false;

        public void accept(ConfigurationBeanVisitor v) {
            this.groups.accept(v);
            v.visitHashType(this);
        }

        @XmlAttribute(name="class")
        public String getConsistentHashClass() {
            return this.consistentHashClass;
        }

        @Deprecated
        public void setConsistentHashClass(String consistentHashClass) {
            this.testImmutability("consistentHashClass");
            this.activate();
            this.consistentHashClass = consistentHashClass;
        }

        @Override
        public FluentConfiguration.HashConfig consistentHashClass(Class<? extends ConsistentHash> consistentHashClass) {
            this.setConsistentHashClass(consistentHashClass.getName());
            return this;
        }

        @XmlAttribute
        public String getHashFunctionClass() {
            return this.hashFunctionClass;
        }

        @Deprecated
        public void setHashFunctionClass(String hashFunctionClass) {
            this.testImmutability("hashFunctionClass");
            this.activate();
            this.hashFunctionClass = hashFunctionClass;
        }

        private void activate() {
            this.activated = true;
            this.overriddenConfigurationElements.add("activated");
        }

        @Override
        public FluentConfiguration.HashConfig hashFunctionClass(Class<? extends Hash> hashFunctionClass) {
            this.setHashFunctionClass(hashFunctionClass.getName());
            return this;
        }

        @XmlAttribute
        public Integer getNumOwners() {
            return this.numOwners;
        }

        @XmlAttribute
        public Integer getNumVirtualNodes() {
            return this.numVirtualNodes;
        }

        @Override
        public FluentConfiguration.HashConfig numVirtualNodes(Integer numVirtualNodes) {
            this.setNumVirtualNodes(numVirtualNodes);
            return this;
        }

        @Deprecated
        public void setNumVirtualNodes(Integer numVirtualNodes) {
            this.testImmutability("numVirtualNodes");
            this.activate();
            this.numVirtualNodes = numVirtualNodes;
        }

        @Deprecated
        public void setNumOwners(Integer numOwners) {
            this.testImmutability("numOwners");
            this.activate();
            this.numOwners = numOwners;
        }

        @Override
        public FluentConfiguration.HashConfig numOwners(Integer numOwners) {
            this.setNumOwners(numOwners);
            return this;
        }

        @XmlAttribute
        public Long getRehashWait() {
            return this.rehashWait;
        }

        @Deprecated
        public void setRehashWait(Long rehashWaitTime) {
            this.testImmutability("rehashWait");
            this.activate();
            this.rehashWait = rehashWaitTime;
        }

        @Override
        public FluentConfiguration.HashConfig rehashWait(Long rehashWaitTime) {
            this.setRehashWait(rehashWaitTime);
            return this;
        }

        @XmlAttribute
        public Long getRehashRpcTimeout() {
            return this.rehashRpcTimeout;
        }

        @Deprecated
        public void setRehashRpcTimeout(Long rehashRpcTimeout) {
            this.testImmutability("rehashRpcTimeout");
            this.activate();
            this.rehashRpcTimeout = rehashRpcTimeout;
        }

        @Override
        public FluentConfiguration.HashConfig rehashRpcTimeout(Long rehashRpcTimeout) {
            this.setRehashRpcTimeout(rehashRpcTimeout);
            return this;
        }

        @XmlAttribute
        public Boolean isRehashEnabled() {
            return this.rehashEnabled;
        }

        @Deprecated
        public void setRehashEnabled(Boolean rehashEnabled) {
            this.testImmutability("rehashEnabled");
            this.activate();
            this.rehashEnabled = rehashEnabled;
        }

        @Override
        public FluentConfiguration.HashConfig rehashEnabled(Boolean rehashEnabled) {
            this.setRehashEnabled(rehashEnabled);
            return this;
        }

        @Override
        public GroupsConfiguration groups() {
            this.groups.setConfiguration(this.config);
            this.activate();
            return this.groups;
        }

        @XmlElement
        public void setGroups(GroupsConfiguration groups) {
            this.testImmutability("groups");
            this.groups = groups;
        }

        public GroupsConfiguration getGroups() {
            return this.groups();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HashType)) {
                return false;
            }
            HashType hashType = (HashType)o;
            if (this.consistentHashClass != null ? !this.consistentHashClass.equals(hashType.consistentHashClass) : hashType.consistentHashClass != null) {
                return false;
            }
            if (this.hashFunctionClass != null ? !this.hashFunctionClass.equals(hashType.hashFunctionClass) : hashType.hashFunctionClass != null) {
                return false;
            }
            if (this.numOwners != null ? !this.numOwners.equals(hashType.numOwners) : hashType.numOwners != null) {
                return false;
            }
            if (this.numVirtualNodes != null ? !this.numVirtualNodes.equals(hashType.numVirtualNodes) : hashType.numVirtualNodes != null) {
                return false;
            }
            if (this.groups != null ? !this.groups.equals(hashType.groups) : hashType.groups != null) {
                return false;
            }
            if (this.rehashRpcTimeout != null ? !this.rehashRpcTimeout.equals(hashType.rehashRpcTimeout) : hashType.rehashRpcTimeout != null) {
                return false;
            }
            if (this.rehashWait != null ? !this.rehashWait.equals(hashType.rehashWait) : hashType.rehashWait != null) {
                return false;
            }
            return this.rehashEnabled == hashType.rehashEnabled;
        }

        public int hashCode() {
            int result = this.consistentHashClass != null ? this.consistentHashClass.hashCode() : 0;
            result = 31 * result + (this.hashFunctionClass != null ? this.hashFunctionClass.hashCode() : 0);
            result = 31 * result + (this.numOwners != null ? this.numOwners.hashCode() : 0);
            result = 31 * result + (this.numVirtualNodes != null ? this.numVirtualNodes.hashCode() : 0);
            result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
            result = 31 * result + (this.rehashWait != null ? this.rehashWait.hashCode() : 0);
            result = 31 * result + (this.rehashRpcTimeout != null ? this.rehashRpcTimeout.hashCode() : 0);
            result = 31 * result + (this.rehashEnabled != false ? 0 : 1);
            return result;
        }

        @Override
        public HashType clone() throws CloneNotSupportedException {
            HashType dolly = (HashType)super.clone();
            dolly.consistentHashClass = this.consistentHashClass;
            dolly.hashFunctionClass = this.hashFunctionClass;
            dolly.numOwners = this.numOwners;
            dolly.numVirtualNodes = this.numVirtualNodes;
            dolly.rehashEnabled = this.rehashEnabled;
            dolly.rehashRpcTimeout = this.rehashRpcTimeout;
            dolly.rehashWait = this.rehashWait;
            dolly.groups = this.groups.clone();
            return dolly;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="sync")
    @Deprecated
    public static class SyncType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.SyncConfig {
        private static final long serialVersionUID = 8419216253674289524L;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setSyncReplTimeout")
        protected Long replTimeout = 15000L;
        @XmlTransient
        private boolean unmarshalledFromXml = false;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitSyncType(this);
        }

        @XmlAttribute
        public Long getReplTimeout() {
            return this.replTimeout;
        }

        @Deprecated
        public void setReplTimeout(Long replTimeout) {
            this.testImmutability("replTimeout");
            this.replTimeout = replTimeout;
        }

        @Override
        public FluentConfiguration.SyncConfig replTimeout(Long replTimeout) {
            this.setReplTimeout(replTimeout);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SyncType)) {
                return false;
            }
            SyncType syncType = (SyncType)o;
            return !(this.replTimeout != null ? !this.replTimeout.equals(syncType.replTimeout) : syncType.replTimeout != null);
        }

        public int hashCode() {
            return this.replTimeout != null ? this.replTimeout.hashCode() : 0;
        }

        @Override
        public void willUnmarshall(Object parent) {
            ClusteringType clustering = (ClusteringType)parent;
            if (clustering.async.unmarshalledFromXml) {
                throw new ConfigurationException("Cannot have both <sync /> and <async /> tags in a <clustering /> tag!");
            }
            this.unmarshalledFromXml = true;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="stateRetrieval")
    @Deprecated
    public static class StateRetrievalType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.StateRetrievalConfig {
        private static final long serialVersionUID = 3709234918426217096L;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setFetchInMemoryState")
        protected Boolean fetchInMemoryState = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setAlwaysProvideInMemoryState")
        protected Boolean alwaysProvideInMemoryState = false;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalTimeout")
        protected Long timeout = 240000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalInitialRetryWaitTime")
        protected Long initialRetryWaitTime = 500L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalRetryWaitTimeIncreaseFactor")
        protected Integer retryWaitTimeIncreaseFactor = 2;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalNumRetries")
        protected Integer numRetries = 5;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalLogFlushTimeout")
        protected Long logFlushTimeout = 60000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalMaxNonProgressingLogWrites")
        protected Integer maxNonProgressingLogWrites = 100;
        protected Integer chunkSize = 10000;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitStateRetrievalType(this);
        }

        @XmlAttribute
        public Boolean isFetchInMemoryState() {
            return this.fetchInMemoryState;
        }

        @Deprecated
        public void setFetchInMemoryState(Boolean fetchInMemoryState) {
            this.testImmutability("fetchInMemoryState");
            this.fetchInMemoryState = fetchInMemoryState;
        }

        @Override
        public FluentConfiguration.StateRetrievalConfig fetchInMemoryState(Boolean fetchInMemoryState) {
            this.setFetchInMemoryState(fetchInMemoryState);
            return this;
        }

        @XmlAttribute
        public Boolean isAlwaysProvideInMemoryState() {
            return this.alwaysProvideInMemoryState;
        }

        @Deprecated
        public void setAlwaysProvideInMemoryState(Boolean alwaysProvideInMemoryState) {
            this.testImmutability("alwaysProvideInMemoryState");
            this.alwaysProvideInMemoryState = alwaysProvideInMemoryState;
        }

        @Override
        public FluentConfiguration.StateRetrievalConfig alwaysProvideInMemoryState(Boolean alwaysProvideInMemoryState) {
            this.setAlwaysProvideInMemoryState(alwaysProvideInMemoryState);
            return this;
        }

        @XmlAttribute
        public Long getInitialRetryWaitTime() {
            return this.initialRetryWaitTime;
        }

        @Deprecated
        public void setInitialRetryWaitTime(Long initialRetryWaitTime) {
            this.testImmutability("initialRetryWaitTime");
            this.initialRetryWaitTime = initialRetryWaitTime;
        }

        @Override
        public FluentConfiguration.StateRetrievalConfig initialRetryWaitTime(Long initialRetryWaitTime) {
            this.setInitialRetryWaitTime(initialRetryWaitTime);
            return this;
        }

        @XmlAttribute
        public Integer getRetryWaitTimeIncreaseFactor() {
            return this.retryWaitTimeIncreaseFactor;
        }

        @Deprecated
        public void setRetryWaitTimeIncreaseFactor(Integer retryWaitTimeIncreaseFactor) {
            this.testImmutability("retryWaitTimeIncreaseFactor");
            this.retryWaitTimeIncreaseFactor = retryWaitTimeIncreaseFactor;
        }

        @Override
        public FluentConfiguration.StateRetrievalConfig retryWaitTimeIncreaseFactor(Integer retryWaitTimeIncreaseFactor) {
            this.setRetryWaitTimeIncreaseFactor(retryWaitTimeIncreaseFactor);
            return this;
        }

        @XmlAttribute
        public Integer getNumRetries() {
            return this.numRetries;
        }

        @Deprecated
        public void setNumRetries(Integer numRetries) {
            this.testImmutability("numRetries");
            this.numRetries = numRetries;
        }

        @Override
        public FluentConfiguration.StateRetrievalConfig numRetries(Integer numRetries) {
            this.setNumRetries(numRetries);
            return this;
        }

        @XmlAttribute
        public Long getTimeout() {
            return this.timeout;
        }

        @Deprecated
        public void setTimeout(Long timeout) {
            this.testImmutability("timeout");
            this.timeout = timeout;
        }

        @Override
        public FluentConfiguration.StateRetrievalConfig timeout(Long timeout) {
            this.setTimeout(timeout);
            return this;
        }

        @XmlAttribute
        public Long getLogFlushTimeout() {
            return this.logFlushTimeout;
        }

        @Deprecated
        public void setLogFlushTimeout(Long logFlushTimeout) {
            this.testImmutability("logFlushTimeout");
            this.logFlushTimeout = logFlushTimeout;
        }

        @Override
        public FluentConfiguration.StateRetrievalConfig logFlushTimeout(Long logFlushTimeout) {
            this.setLogFlushTimeout(logFlushTimeout);
            return this;
        }

        @XmlAttribute
        public Integer getMaxNonProgressingLogWrites() {
            return this.maxNonProgressingLogWrites;
        }

        @Deprecated
        public void setMaxNonProgressingLogWrites(Integer maxNonProgressingLogWrites) {
            this.testImmutability("maxNonProgressingLogWrites");
            this.maxNonProgressingLogWrites = maxNonProgressingLogWrites;
        }

        @Override
        public FluentConfiguration.StateRetrievalConfig maxNonProgressingLogWrites(Integer maxNonProgressingLogWrites) {
            this.setMaxNonProgressingLogWrites(maxNonProgressingLogWrites);
            return this;
        }

        public Integer getChunkSize() {
            return this.chunkSize;
        }

        @Deprecated
        public void setChunkSize(Integer chunkSize) {
            this.testImmutability("chunkSize");
            this.chunkSize = chunkSize;
        }

        @Override
        public FluentConfiguration.StateRetrievalConfig chunkSize(Integer chunkSize) {
            this.setChunkSize(chunkSize);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateRetrievalType)) {
                return false;
            }
            StateRetrievalType that = (StateRetrievalType)o;
            if (this.fetchInMemoryState != null ? !this.fetchInMemoryState.equals(that.fetchInMemoryState) : that.fetchInMemoryState != null) {
                return false;
            }
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) {
                return false;
            }
            if (this.initialRetryWaitTime != null ? !this.initialRetryWaitTime.equals(that.initialRetryWaitTime) : that.initialRetryWaitTime != null) {
                return false;
            }
            if (this.retryWaitTimeIncreaseFactor != null ? !this.retryWaitTimeIncreaseFactor.equals(that.retryWaitTimeIncreaseFactor) : that.retryWaitTimeIncreaseFactor != null) {
                return false;
            }
            return !(this.numRetries != null ? !this.numRetries.equals(that.numRetries) : that.numRetries != null);
        }

        public int hashCode() {
            int result = this.fetchInMemoryState != null ? this.fetchInMemoryState.hashCode() : 0;
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.initialRetryWaitTime != null ? this.initialRetryWaitTime.hashCode() : 0);
            result = 31 * result + (this.retryWaitTimeIncreaseFactor != null ? this.retryWaitTimeIncreaseFactor.hashCode() : 0);
            result = 31 * result + (this.numRetries != null ? this.numRetries.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="dataContainer")
    @Deprecated
    public static class DataContainerType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.DataContainerConfig {
        private static final long serialVersionUID = -959027510815676570L;
        @ConfigurationDocRef(name="class", bean=Configuration.class, targetElement="getDataContainerClass")
        protected String dataContainerClass = DefaultDataContainer.class.getName();
        @XmlElement(name="properties")
        protected TypedProperties properties = new TypedProperties();
        protected DataContainer dataContainer;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitDataContainerType(this);
        }

        @XmlAttribute(name="class")
        public String getDataContainerClass() {
            return this.dataContainerClass;
        }

        private DataContainerType setDataContainerClass(String dataContainerClass) {
            this.testImmutability("dataContainerClass");
            this.dataContainerClass = dataContainerClass;
            return this;
        }

        @Override
        public FluentConfiguration.DataContainerConfig dataContainerClass(Class<? extends DataContainer> dataContainerClass) {
            return this.setDataContainerClass(dataContainerClass.getName());
        }

        @Override
        public FluentConfiguration.DataContainerConfig withProperties(Properties properties) {
            this.testImmutability("properties");
            this.properties = DataContainerType.toTypedProperties(properties);
            return this;
        }

        @Override
        public FluentConfiguration.DataContainerConfig addProperty(String key, String value) {
            if (this.properties == null) {
                this.properties = new TypedProperties();
            }
            this.properties.setProperty(key, value);
            return this;
        }

        @Override
        public FluentConfiguration.DataContainerConfig dataContainer(DataContainer dataContainer) {
            this.dataContainer = dataContainer;
            return this;
        }

        @Override
        protected DataContainerType setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataContainerType)) {
                return false;
            }
            DataContainerType that = (DataContainerType)o;
            if (this.dataContainerClass != null ? !this.dataContainerClass.equals(that.dataContainerClass) : that.dataContainerClass != null) {
                return false;
            }
            return !(this.dataContainer != null ? !this.dataContainer.equals(that.dataContainer) : that.dataContainer != null);
        }

        public int hashCode() {
            int result = this.dataContainerClass != null ? this.dataContainerClass.hashCode() : 0;
            result = 31 * result + (this.dataContainer != null ? this.dataContainer.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="eviction")
    @Deprecated
    public static class EvictionType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.EvictionConfig {
        private static final long serialVersionUID = -1248563712058858791L;
        @Deprecated
        @ConfigurationDocRef(bean=EvictionType.class, targetElement="setWakeUpInterval")
        protected Long wakeUpInterval = Long.MIN_VALUE;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEvictionStrategy")
        protected EvictionStrategy strategy = EvictionStrategy.NONE;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEvictionMaxEntries")
        protected Integer maxEntries = -1;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEvictionThreadPolicy")
        protected EvictionThreadPolicy threadPolicy = EvictionThreadPolicy.DEFAULT;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitEvictionType(this);
        }

        @XmlAttribute
        @Deprecated
        public Long getWakeUpInterval() {
            log.evictionWakeUpIntervalDeprecated();
            return this.wakeUpInterval;
        }

        @Deprecated
        public void setWakeUpInterval(Long wakeUpInterval) {
            log.evictionWakeUpIntervalDeprecated();
            this.testImmutability("wakeUpInterval");
            this.wakeUpInterval = wakeUpInterval;
        }

        @XmlAttribute
        public EvictionStrategy getStrategy() {
            return this.strategy;
        }

        @Deprecated
        public void setStrategy(EvictionStrategy strategy) {
            this.testImmutability("strategy");
            this.strategy = strategy;
        }

        @Override
        public FluentConfiguration.EvictionConfig strategy(EvictionStrategy strategy) {
            this.setStrategy(strategy);
            return this;
        }

        @XmlAttribute
        public EvictionThreadPolicy getThreadPolicy() {
            return this.threadPolicy;
        }

        @Deprecated
        public void setThreadPolicy(EvictionThreadPolicy threadPolicy) {
            this.testImmutability("threadPolicy");
            this.threadPolicy = threadPolicy;
        }

        @Override
        public FluentConfiguration.EvictionConfig threadPolicy(EvictionThreadPolicy threadPolicy) {
            this.setThreadPolicy(threadPolicy);
            return this;
        }

        @XmlAttribute
        public Integer getMaxEntries() {
            return this.maxEntries;
        }

        @Deprecated
        public void setMaxEntries(Integer maxEntries) {
            this.testImmutability("maxEntries");
            this.maxEntries = maxEntries;
        }

        @Override
        public FluentConfiguration.EvictionConfig maxEntries(Integer maxEntries) {
            this.setMaxEntries(maxEntries);
            return this;
        }

        @Override
        protected EvictionType setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EvictionType)) {
                return false;
            }
            EvictionType that = (EvictionType)o;
            if (this.maxEntries != null ? !this.maxEntries.equals(that.maxEntries) : that.maxEntries != null) {
                return false;
            }
            if (this.strategy != that.strategy) {
                return false;
            }
            return this.threadPolicy == that.threadPolicy;
        }

        public int hashCode() {
            int result = this.strategy != null ? this.strategy.hashCode() : 0;
            result = 31 * result + (this.threadPolicy != null ? this.threadPolicy.hashCode() : 0);
            result = 31 * result + (this.maxEntries != null ? this.maxEntries.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="expiration")
    @Deprecated
    public static class ExpirationType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.ExpirationConfig {
        private static final long serialVersionUID = 5757161438110848530L;
        @ConfigurationDocRef(bean=FluentConfiguration.ExpirationConfig.class, targetElement="lifespan")
        protected Long lifespan = -1L;
        @ConfigurationDocRef(bean=FluentConfiguration.ExpirationConfig.class, targetElement="maxIdle")
        protected Long maxIdle = -1L;
        @ConfigurationDocRef(bean=FluentConfiguration.ExpirationConfig.class, targetElement="wakeUpInterval")
        protected Long wakeUpInterval = TimeUnit.MINUTES.toMillis(1L);
        @ConfigurationDocRef(bean=FluentConfiguration.ExpirationConfig.class, targetElement="reaperEnabled")
        @XmlAttribute
        protected Boolean reaperEnabled = true;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitExpirationType(this);
        }

        @XmlAttribute
        public Long getLifespan() {
            return this.lifespan;
        }

        @Deprecated
        public void setLifespan(Long lifespan) {
            this.testImmutability("lifespan");
            this.lifespan = lifespan;
        }

        @Override
        public FluentConfiguration.ExpirationConfig lifespan(Long lifespan) {
            this.setLifespan(lifespan);
            return this;
        }

        @XmlAttribute
        public Long getMaxIdle() {
            return this.maxIdle;
        }

        @Deprecated
        public void setMaxIdle(Long maxIdle) {
            this.testImmutability("maxIdle");
            this.maxIdle = maxIdle;
        }

        @Override
        public FluentConfiguration.ExpirationConfig maxIdle(Long maxIdle) {
            this.setMaxIdle(maxIdle);
            return this;
        }

        @Override
        public FluentConfiguration.ExpirationConfig wakeUpInterval(Long wakeUpInterval) {
            this.setWakeUpInterval(wakeUpInterval);
            return this;
        }

        @XmlAttribute
        private void setWakeUpInterval(Long wakeUpInterval) {
            this.testImmutability("wakeUpInterval");
            this.wakeUpInterval = wakeUpInterval;
        }

        public Long getWakeUpInterval() {
            return this.wakeUpInterval;
        }

        @Override
        public FluentConfiguration.ExpirationConfig reaperEnabled(Boolean enabled) {
            this.testImmutability("reaperEnabled");
            this.reaperEnabled = enabled;
            return this;
        }

        @Override
        protected ExpirationType setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExpirationType)) {
                return false;
            }
            ExpirationType that = (ExpirationType)o;
            if (!Util.safeEquals(this.lifespan, that.lifespan)) {
                return false;
            }
            if (!Util.safeEquals(this.maxIdle, that.maxIdle)) {
                return false;
            }
            if (!Util.safeEquals(this.wakeUpInterval, that.wakeUpInterval)) {
                return false;
            }
            return Util.safeEquals(this.reaperEnabled, that.reaperEnabled);
        }

        public int hashCode() {
            int result = this.lifespan != null ? this.lifespan.hashCode() : 0;
            result = 31 * result + (this.maxIdle != null ? this.maxIdle.hashCode() : 0);
            result = 31 * result + (this.wakeUpInterval != null ? this.wakeUpInterval.hashCode() : 0);
            result = 31 * result + (this.reaperEnabled != null ? this.reaperEnabled.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="async", parentName="clustering")
    @Deprecated
    public static class AsyncType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.AsyncConfig {
        @XmlTransient
        private boolean readFromXml = false;
        private static final long serialVersionUID = -7726319188826197399L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setUseReplQueue")
        protected Boolean useReplQueue = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setReplQueueMaxElements")
        protected Integer replQueueMaxElements = 1000;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setReplQueueInterval")
        protected Long replQueueInterval = 5000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setUseAsyncMarshalling")
        protected Boolean asyncMarshalling = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setReplQueueClass")
        protected String replQueueClass = ReplicationQueueImpl.class.getName();
        @XmlTransient
        private boolean unmarshalledFromXml = false;

        private AsyncType(boolean readFromXml) {
            this.readFromXml = readFromXml;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitAsyncType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AsyncType)) {
                return false;
            }
            AsyncType asyncType = (AsyncType)o;
            if (this.readFromXml != asyncType.readFromXml) {
                return false;
            }
            if (this.asyncMarshalling != null ? !this.asyncMarshalling.equals(asyncType.asyncMarshalling) : asyncType.asyncMarshalling != null) {
                return false;
            }
            if (this.replQueueInterval != null ? !this.replQueueInterval.equals(asyncType.replQueueInterval) : asyncType.replQueueInterval != null) {
                return false;
            }
            if (this.replQueueMaxElements != null ? !this.replQueueMaxElements.equals(asyncType.replQueueMaxElements) : asyncType.replQueueMaxElements != null) {
                return false;
            }
            if (this.useReplQueue != null ? !this.useReplQueue.equals(asyncType.useReplQueue) : asyncType.useReplQueue != null) {
                return false;
            }
            return Util.safeEquals(this.replQueueClass, asyncType.replQueueClass);
        }

        public int hashCode() {
            int result = this.readFromXml ? 1 : 0;
            result = 31 * result + (this.useReplQueue != null ? this.useReplQueue.hashCode() : 0);
            result = 31 * result + (this.replQueueMaxElements != null ? this.replQueueMaxElements.hashCode() : 0);
            result = 31 * result + (this.replQueueInterval != null ? this.replQueueInterval.hashCode() : 0);
            result = 31 * result + (this.asyncMarshalling != null ? this.asyncMarshalling.hashCode() : 0);
            result = 31 * result + (this.replQueueClass != null ? this.replQueueClass.hashCode() : 0);
            return result;
        }

        private AsyncType() {
            this(true);
        }

        @XmlAttribute
        public Boolean isUseReplQueue() {
            return this.useReplQueue;
        }

        @Deprecated
        public void setUseReplQueue(Boolean useReplQueue) {
            this.testImmutability("useReplQueue");
            this.useReplQueue = useReplQueue;
        }

        @Override
        public FluentConfiguration.AsyncConfig useReplQueue(Boolean useReplQueue) {
            this.setUseReplQueue(useReplQueue);
            return this;
        }

        @XmlAttribute
        public Integer getReplQueueMaxElements() {
            return this.replQueueMaxElements;
        }

        @Deprecated
        public void setReplQueueMaxElements(Integer replQueueMaxElements) {
            this.testImmutability("replQueueMaxElements");
            this.replQueueMaxElements = replQueueMaxElements;
        }

        @Override
        public FluentConfiguration.AsyncConfig replQueueMaxElements(Integer replQueueMaxElements) {
            this.setReplQueueMaxElements(replQueueMaxElements);
            return this;
        }

        @XmlAttribute
        public Long getReplQueueInterval() {
            return this.replQueueInterval;
        }

        @Deprecated
        public void setReplQueueInterval(Long replQueueInterval) {
            this.testImmutability("replQueueInterval");
            this.replQueueInterval = replQueueInterval;
        }

        @Override
        public FluentConfiguration.AsyncConfig replQueueInterval(Long replQueueInterval) {
            this.setReplQueueInterval(replQueueInterval);
            return this;
        }

        @XmlAttribute
        public Boolean isAsyncMarshalling() {
            return this.asyncMarshalling;
        }

        @Deprecated
        public void setAsyncMarshalling(Boolean asyncMarshalling) {
            this.testImmutability("asyncMarshalling");
            this.asyncMarshalling = asyncMarshalling;
        }

        @Override
        public FluentConfiguration.AsyncConfig asyncMarshalling(Boolean asyncMarshalling) {
            this.setAsyncMarshalling(asyncMarshalling);
            return this;
        }

        @XmlAttribute
        public String getReplQueueClass() {
            return this.replQueueClass;
        }

        @Deprecated
        public void setReplQueueClass(String replQueueClass) {
            this.testImmutability("replQueueClass");
            this.replQueueClass = replQueueClass;
        }

        @Override
        public FluentConfiguration.AsyncConfig replQueueClass(Class<? extends ReplicationQueue> replQueueClass) {
            this.setReplQueueClass(replQueueClass.getName());
            return this;
        }

        @Override
        public void willUnmarshall(Object parent) {
            ClusteringType clustering = (ClusteringType)parent;
            if (clustering.sync.unmarshalledFromXml) {
                throw new ConfigurationException("Cannot have both <sync /> and <async /> tags in a <clustering /> tag!");
            }
            this.unmarshalledFromXml = true;
        }
    }

    @Deprecated
    public static class ClusteringTypeAdapter
    extends XmlAdapter<ClusteringType, ClusteringType> {
        public ClusteringType marshal(ClusteringType ct) throws Exception {
            return ct;
        }

        public ClusteringType unmarshal(ClusteringType ct) throws Exception {
            if (ct.stringMode != null) {
                String mode = ct.stringMode.toLowerCase();
                if (mode.startsWith("r")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.REPL_SYNC);
                    } else {
                        ct.setMode(CacheMode.REPL_ASYNC);
                    }
                } else if (mode.startsWith("i")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.INVALIDATION_SYNC);
                    } else {
                        ct.setMode(CacheMode.INVALIDATION_ASYNC);
                    }
                } else if (mode.startsWith("d")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.DIST_SYNC);
                    } else {
                        ct.setMode(CacheMode.DIST_ASYNC);
                    }
                } else if (mode.startsWith("l")) {
                    ct.setMode(CacheMode.LOCAL);
                } else {
                    throw new ConfigurationException("Invalid clustering mode " + ct.stringMode);
                }
            }
            return ct;
        }
    }

    @XmlJavaTypeAdapter(value=ClusteringTypeAdapter.class)
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlType(propOrder={})
    @ConfigurationDoc(name="clustering")
    @Deprecated
    public static class ClusteringType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.ClusteringConfig {
        private static final long serialVersionUID = 4048135465543498430L;
        @XmlAttribute(name="mode")
        protected String stringMode;
        @XmlTransient
        protected boolean configuredAsync = false;
        @XmlTransient
        protected boolean configuredSync = false;
        @XmlTransient
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setCacheMode")
        protected CacheMode mode;
        @XmlElement
        protected SyncType sync = new SyncType();
        @XmlElement
        protected StateRetrievalType stateRetrieval = new StateRetrievalType();
        @XmlElement
        protected L1Type l1 = new L1Type();
        @XmlElement
        protected AsyncType async = new AsyncType(false);
        @XmlElement
        protected HashType hash = new HashType();

        public ClusteringType(CacheMode mode) {
            this.mode = mode;
        }

        public ClusteringType() {
            this.mode = CacheMode.DIST_SYNC;
        }

        @Override
        public FluentConfiguration.AsyncConfig async() {
            if (this.configuredSync) {
                throw new ConfigurationException("Already configured as sync");
            }
            this.configuredAsync = true;
            this.async.setConfiguration(this.config);
            return this.async;
        }

        @Override
        public FluentConfiguration.SyncConfig sync() {
            if (this.configuredAsync) {
                throw new ConfigurationException("Already configured as async");
            }
            this.configuredSync = true;
            this.sync.setConfiguration(this.config);
            return this.sync;
        }

        @Override
        public FluentConfiguration.StateRetrievalConfig stateRetrieval() {
            this.stateRetrieval.setConfiguration(this.config);
            return this.stateRetrieval;
        }

        @Override
        public FluentConfiguration.L1Config l1() {
            this.l1.setEnabled(true);
            this.l1.activate();
            this.l1.setConfiguration(this.config);
            return this.l1;
        }

        @Override
        public FluentConfiguration.HashConfig hash() {
            this.hash.setConfiguration(this.config);
            this.hash.activate();
            return this.hash;
        }

        @Deprecated
        public void setMode(CacheMode mode) {
            this.testImmutability("mode");
            this.mode = mode;
        }

        @Override
        public FluentConfiguration.ClusteringConfig mode(CacheMode mode) {
            this.testImmutability("mode");
            this.mode = mode;
            return this;
        }

        public boolean isSynchronous() {
            return !this.async.readFromXml;
        }

        @Override
        protected ClusteringType setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        @Override
        public ClusteringType clone() throws CloneNotSupportedException {
            ClusteringType dolly = (ClusteringType)super.clone();
            dolly.sync = (SyncType)this.sync.clone();
            dolly.stateRetrieval = (StateRetrievalType)this.stateRetrieval.clone();
            dolly.l1 = (L1Type)this.l1.clone();
            dolly.async = (AsyncType)this.async.clone();
            dolly.hash = this.hash.clone();
            return dolly;
        }

        public void accept(ConfigurationBeanVisitor v) {
            this.async.accept(v);
            this.hash.accept(v);
            this.l1.accept(v);
            this.stateRetrieval.accept(v);
            this.sync.accept(v);
            v.visitClusteringType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClusteringType)) {
                return false;
            }
            ClusteringType that = (ClusteringType)o;
            if (this.async != null ? !this.async.equals(that.async) : that.async != null) {
                return false;
            }
            if (this.hash != null ? !this.hash.equals(that.hash) : that.hash != null) {
                return false;
            }
            if (this.l1 != null ? !this.l1.equals(that.l1) : that.l1 != null) {
                return false;
            }
            if (this.mode != that.mode) {
                return false;
            }
            if (this.stateRetrieval != null ? !this.stateRetrieval.equals(that.stateRetrieval) : that.stateRetrieval != null) {
                return false;
            }
            return !(this.sync != null ? !this.sync.equals(that.sync) : that.sync != null);
        }

        public int hashCode() {
            int result = this.stringMode != null ? this.stringMode.hashCode() : 0;
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.sync != null ? this.sync.hashCode() : 0);
            result = 31 * result + (this.stateRetrieval != null ? this.stateRetrieval.hashCode() : 0);
            result = 31 * result + (this.l1 != null ? this.l1.hashCode() : 0);
            result = 31 * result + (this.async != null ? this.async.hashCode() : 0);
            result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
            return result;
        }

        @Override
        public void willUnmarshall(Object parent) {
            this.setMode(CacheMode.DIST_SYNC);
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="recovery", parentName="transaction")
    @Deprecated
    public static class RecoveryType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.RecoveryConfig {
        private static final long serialVersionUID = 7727835976746044904L;
        public static final String DEFAULT_RECOVERY_INFO_CACHE = "__recoveryInfoCacheName__";
        @ConfigurationDocRef(bean=Configuration.class, targetElement="isTransactionRecoveryEnabled")
        private boolean enabled = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="getTransactionRecoveryCacheName")
        private String recoveryInfoCacheName = "__recoveryInfoCacheName__";

        @Override
        public FluentConfiguration.RecoveryConfig disable() {
            return this.setEnabled(false);
        }

        @XmlAttribute(required=false)
        public boolean isEnabled() {
            return this.enabled;
        }

        private RecoveryType setEnabled(boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
            return this;
        }

        @Override
        public FluentConfiguration.RecoveryConfig recoveryInfoCacheName(String cacheName) {
            return this.setRecoveryInfoCacheName(cacheName);
        }

        @XmlAttribute(required=false)
        public String getRecoveryInfoCacheName() {
            return this.recoveryInfoCacheName;
        }

        private RecoveryType setRecoveryInfoCacheName(String recoveryInfoCacheName) {
            this.testImmutability("recoveryInfoCacheName");
            this.recoveryInfoCacheName = recoveryInfoCacheName;
            return this;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitRecoveryType(this);
        }

        @Override
        public FluentConfiguration.TransactionConfig lockingMode(LockingMode lockingMode) {
            return this.transaction().lockingMode(lockingMode);
        }

        @Override
        public FluentConfiguration.TransactionConfig autoCommit(boolean enabled) {
            return this.transaction().autoCommit(enabled);
        }

        @Override
        public FluentConfiguration.TransactionConfig transactionMode(TransactionMode transactionMode) {
            return this.transaction().transactionMode(transactionMode);
        }

        @Override
        public TransactionType use1PcForAutoCommitTransactions(boolean b) {
            return this.transaction().use1PcForAutoCommitTransactions(b);
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="locking")
    @Deprecated
    public static class LockingType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.LockingConfig {
        private static final long serialVersionUID = 8142143187082119506L;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setLockAcquisitionTimeout")
        protected Long lockAcquisitionTimeout = 10000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setIsolationLevel")
        protected IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setWriteSkewCheck")
        protected Boolean writeSkewCheck = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setUseLockStriping")
        protected Boolean useLockStriping = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setConcurrencyLevel")
        protected Integer concurrencyLevel = 32;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitLockingType(this);
        }

        @XmlAttribute
        public Long getLockAcquisitionTimeout() {
            return this.lockAcquisitionTimeout;
        }

        @Deprecated
        public void setLockAcquisitionTimeout(Long lockAcquisitionTimeout) {
            this.testImmutability("lockAcquisitionTimeout");
            this.lockAcquisitionTimeout = lockAcquisitionTimeout;
        }

        @Override
        public FluentConfiguration.LockingConfig lockAcquisitionTimeout(Long lockAcquisitionTimeout) {
            this.setLockAcquisitionTimeout(lockAcquisitionTimeout);
            return this;
        }

        @XmlAttribute
        public IsolationLevel getIsolationLevel() {
            return this.isolationLevel;
        }

        @Deprecated
        public void setIsolationLevel(IsolationLevel isolationLevel) {
            this.testImmutability("isolationLevel");
            this.isolationLevel = isolationLevel;
        }

        @Override
        public FluentConfiguration.LockingConfig isolationLevel(IsolationLevel isolationLevel) {
            this.setIsolationLevel(isolationLevel);
            return this;
        }

        @XmlAttribute
        public Boolean isWriteSkewCheck() {
            return this.writeSkewCheck;
        }

        @Deprecated
        public void setWriteSkewCheck(Boolean writeSkewCheck) {
            this.testImmutability("writeSkewCheck");
            this.writeSkewCheck = writeSkewCheck;
        }

        @Override
        public FluentConfiguration.LockingConfig writeSkewCheck(Boolean writeSkewCheck) {
            this.setWriteSkewCheck(writeSkewCheck);
            return this;
        }

        @XmlAttribute
        public Boolean isUseLockStriping() {
            return this.useLockStriping;
        }

        @Deprecated
        public void setUseLockStriping(Boolean useLockStriping) {
            this.testImmutability("useLockStriping");
            this.useLockStriping = useLockStriping;
        }

        @Override
        public FluentConfiguration.LockingConfig useLockStriping(Boolean useLockStriping) {
            this.setUseLockStriping(useLockStriping);
            return this;
        }

        @XmlAttribute
        public Integer getConcurrencyLevel() {
            return this.concurrencyLevel;
        }

        @Deprecated
        public void setConcurrencyLevel(Integer concurrencyLevel) {
            this.testImmutability("concurrencyLevel");
            this.concurrencyLevel = concurrencyLevel;
        }

        @Override
        public FluentConfiguration.LockingConfig concurrencyLevel(Integer concurrencyLevel) {
            this.setConcurrencyLevel(concurrencyLevel);
            return this;
        }

        @Override
        protected LockingType setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LockingType)) {
                return false;
            }
            LockingType that = (LockingType)o;
            if (this.concurrencyLevel != null ? !this.concurrencyLevel.equals(that.concurrencyLevel) : that.concurrencyLevel != null) {
                return false;
            }
            if (this.isolationLevel != that.isolationLevel) {
                return false;
            }
            if (this.lockAcquisitionTimeout != null ? !this.lockAcquisitionTimeout.equals(that.lockAcquisitionTimeout) : that.lockAcquisitionTimeout != null) {
                return false;
            }
            if (this.useLockStriping != null ? !this.useLockStriping.equals(that.useLockStriping) : that.useLockStriping != null) {
                return false;
            }
            return !(this.writeSkewCheck != null ? !this.writeSkewCheck.equals(that.writeSkewCheck) : that.writeSkewCheck != null);
        }

        public int hashCode() {
            int result = this.lockAcquisitionTimeout != null ? this.lockAcquisitionTimeout.hashCode() : 0;
            result = 31 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
            result = 31 * result + (this.writeSkewCheck != null ? this.writeSkewCheck.hashCode() : 0);
            result = 31 * result + (this.useLockStriping != null ? this.useLockStriping.hashCode() : 0);
            result = 31 * result + (this.concurrencyLevel != null ? this.concurrencyLevel.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlType(propOrder={})
    @ConfigurationDoc(name="transaction")
    @Deprecated
    public static class TransactionType
    extends AbstractFluentConfigurationBean
    implements FluentConfiguration.TransactionConfig {
        private static final long serialVersionUID = -3867090839830874603L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setTransactionManagerLookupClass")
        protected String transactionManagerLookupClass;
        @XmlTransient
        protected TransactionManagerLookup transactionManagerLookup;
        @XmlTransient
        protected TransactionSynchronizationRegistryLookup transactionSynchronizationRegistryLookup;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setSyncCommitPhase")
        protected Boolean syncCommitPhase = true;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setSyncRollbackPhase")
        @Dynamic
        protected Boolean syncRollbackPhase = false;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setUseEagerLocking")
        protected Boolean useEagerLocking = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="isUseSynchronizationForTransactions")
        protected Boolean useSynchronization = false;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEagerLockSingleNode")
        protected Boolean eagerLockSingleNode = false;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setCacheStopTimeout")
        protected Integer cacheStopTimeout = 30000;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="getTransactionLockingMode")
        protected LockingMode lockingMode = LockingMode.OPTIMISTIC;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="getTransactionMode")
        protected TransactionMode transactionMode = TransactionMode.NON_TRANSACTIONAL;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="isTransactionAutoCommit")
        protected Boolean autoCommit = true;
        @XmlElement
        protected RecoveryType recovery = new RecoveryType();
        @ConfigurationDocRef(bean=Configuration.class, targetElement="isUse1PcForAutoCommitTransactions")
        private Boolean use1PcForAutoCommitTransactions = Boolean.FALSE;

        public TransactionType(String transactionManagerLookupClass) {
            this.transactionManagerLookupClass = transactionManagerLookupClass;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitTransactionType(this);
            this.recovery.accept(v);
        }

        public TransactionType() {
            this.transactionManagerLookupClass = GenericTransactionManagerLookup.class.getName();
        }

        @XmlAttribute
        public String getTransactionManagerLookupClass() {
            return this.transactionManagerLookupClass;
        }

        @Override
        public FluentConfiguration.TransactionConfig transactionMode(TransactionMode txMode) {
            this.testImmutability("transactionMode");
            this.transactionMode = txMode;
            return this;
        }

        @Deprecated
        public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
            this.testImmutability("transactionManagerLookupClass");
            if (transactionManagerLookupClass != null) {
                this.transactionMode(TransactionMode.TRANSACTIONAL);
            }
            this.transactionManagerLookupClass = transactionManagerLookupClass;
        }

        @Override
        public FluentConfiguration.TransactionConfig transactionManagerLookupClass(Class<? extends TransactionManagerLookup> transactionManagerLookupClass) {
            this.setTransactionManagerLookupClass(transactionManagerLookupClass == null ? null : transactionManagerLookupClass.getName());
            return this;
        }

        @XmlAttribute
        public Boolean isSyncCommitPhase() {
            return this.syncCommitPhase;
        }

        @XmlAttribute
        public Boolean getUse1PcForAutoCommitTransactions() {
            return this.use1PcForAutoCommitTransactions;
        }

        public void setUse1PcForAutoCommitTransactions(Boolean use1PcForAutoCommitTransactions) {
            this.use1PcForAutoCommitTransactions = use1PcForAutoCommitTransactions;
        }

        @Deprecated
        public void setSyncCommitPhase(Boolean syncCommitPhase) {
            this.testImmutability("syncCommitPhase");
            this.syncCommitPhase = syncCommitPhase;
        }

        @Override
        public FluentConfiguration.TransactionConfig syncCommitPhase(Boolean syncCommitPhase) {
            this.setSyncCommitPhase(syncCommitPhase);
            return this;
        }

        @Override
        public FluentConfiguration.TransactionConfig useSynchronization(Boolean useSynchronization) {
            return this.setUseSynchronization(useSynchronization);
        }

        @Override
        public FluentConfiguration.TransactionConfig lockingMode(LockingMode lockingMode) {
            this.testImmutability("lockingMode");
            this.lockingMode = lockingMode;
            return this;
        }

        @Override
        public FluentConfiguration.TransactionConfig autoCommit(boolean enabled) {
            this.testImmutability("autoCommit");
            this.autoCommit = enabled;
            return this;
        }

        @Override
        public TransactionType use1PcForAutoCommitTransactions(boolean b) {
            this.testImmutability("use1PcForAutoCommitTransactions");
            this.use1PcForAutoCommitTransactions = b;
            return this;
        }

        @XmlAttribute
        public Boolean isUseSynchronization() {
            return this.useSynchronization;
        }

        private FluentConfiguration.TransactionConfig setUseSynchronization(Boolean useSynchronization) {
            this.testImmutability("useSynchronization");
            this.useSynchronization = useSynchronization;
            return this;
        }

        @XmlAttribute
        public Boolean isSyncRollbackPhase() {
            return this.syncRollbackPhase;
        }

        @Deprecated
        public void setSyncRollbackPhase(Boolean syncRollbackPhase) {
            this.testImmutability("syncRollbackPhase");
            this.syncRollbackPhase = syncRollbackPhase;
        }

        @Override
        public FluentConfiguration.TransactionConfig syncRollbackPhase(Boolean syncRollbackPhase) {
            this.setSyncRollbackPhase(syncRollbackPhase);
            return this;
        }

        @XmlAttribute
        public Boolean isUseEagerLocking() {
            return this.useEagerLocking;
        }

        @Deprecated
        public void setUseEagerLocking(Boolean useEagerLocking) {
            this.testImmutability("useEagerLocking");
            this.useEagerLocking = useEagerLocking;
        }

        @Override
        public FluentConfiguration.TransactionConfig useEagerLocking(Boolean useEagerLocking) {
            this.setUseEagerLocking(useEagerLocking);
            return this;
        }

        @Override
        public FluentConfiguration.TransactionConfig transactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
            this.testImmutability("transactionManagerLookup");
            this.transactionManagerLookup = transactionManagerLookup;
            if (transactionManagerLookup != null) {
                this.transactionMode(TransactionMode.TRANSACTIONAL);
            }
            return this;
        }

        @Override
        public FluentConfiguration.TransactionConfig transactionSynchronizationRegistryLookup(TransactionSynchronizationRegistryLookup transactionSynchronizationRegistryLookup) {
            this.testImmutability("transactionSynchronizationRegistryLookup");
            this.transactionSynchronizationRegistryLookup = transactionSynchronizationRegistryLookup;
            if (transactionSynchronizationRegistryLookup != null) {
                this.transactionMode(TransactionMode.TRANSACTIONAL);
            }
            return this;
        }

        public TransactionSynchronizationRegistryLookup getTransactionSynchronizationRegistryLookup() {
            return this.transactionSynchronizationRegistryLookup;
        }

        @XmlAttribute
        public Boolean isEagerLockSingleNode() {
            return this.eagerLockSingleNode;
        }

        @Deprecated
        public FluentConfiguration.TransactionConfig setEagerLockSingleNode(Boolean eagerLockSingleNode) {
            this.testImmutability("eagerLockSingleNode");
            this.eagerLockSingleNode = eagerLockSingleNode;
            return this;
        }

        @Override
        public FluentConfiguration.TransactionConfig eagerLockSingleNode(Boolean eagerLockSingleNode) {
            this.setEagerLockSingleNode(eagerLockSingleNode);
            return this;
        }

        @XmlAttribute
        public Integer getCacheStopTimeout() {
            return this.cacheStopTimeout;
        }

        @Deprecated
        public void setCacheStopTimeout(Integer cacheStopTimeout) {
            this.testImmutability("cacheStopTimeout");
            this.cacheStopTimeout = cacheStopTimeout;
        }

        @Override
        public FluentConfiguration.TransactionConfig cacheStopTimeout(Integer cacheStopTimeout) {
            this.setCacheStopTimeout(cacheStopTimeout);
            return this;
        }

        @Override
        public FluentConfiguration.RecoveryConfig recovery() {
            this.recovery.setEnabled(true);
            this.recovery.setConfiguration(this.config);
            return this.recovery;
        }

        @Override
        protected TransactionType setConfiguration(Configuration config) {
            super.setConfiguration(config);
            return this;
        }

        public TransactionMode getTransactionMode() {
            return this.transactionMode;
        }

        @XmlAttribute
        public void setTransactionMode(TransactionMode transactionMode) {
            this.testImmutability("transactionMode");
            this.transactionMode = transactionMode;
        }

        public LockingMode getLockingMode() {
            return this.lockingMode;
        }

        @XmlAttribute
        public void setLockingMode(LockingMode lockingMode) {
            this.testImmutability("lockingMode");
            this.lockingMode = lockingMode;
        }

        @XmlAttribute
        private void setAutoCommit(Boolean autoCommit) {
            this.testImmutability("autoCommit");
            this.autoCommit = autoCommit;
        }

        public Boolean getAutoCommit() {
            return this.autoCommit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionType)) {
                return false;
            }
            TransactionType that = (TransactionType)o;
            if (this.syncCommitPhase != null ? !this.syncCommitPhase.equals(that.syncCommitPhase) : that.syncCommitPhase != null) {
                return false;
            }
            if (this.syncRollbackPhase != null ? !this.syncRollbackPhase.equals(that.syncRollbackPhase) : that.syncRollbackPhase != null) {
                return false;
            }
            if (this.transactionManagerLookup != null ? !this.transactionManagerLookup.equals(that.transactionManagerLookup) : that.transactionManagerLookup != null) {
                return false;
            }
            if (this.transactionManagerLookupClass != null ? !this.transactionManagerLookupClass.equals(that.transactionManagerLookupClass) : that.transactionManagerLookupClass != null) {
                return false;
            }
            if (this.useEagerLocking != null ? !this.useEagerLocking.equals(that.useEagerLocking) : that.useEagerLocking != null) {
                return false;
            }
            if (this.cacheStopTimeout != null ? !this.cacheStopTimeout.equals(that.cacheStopTimeout) : that.cacheStopTimeout != null) {
                return false;
            }
            if (this.transactionMode != null ? !this.transactionMode.equals((Object)that.transactionMode) : that.transactionMode != null) {
                return false;
            }
            return !(this.lockingMode != null ? !this.lockingMode.equals((Object)that.lockingMode) : that.lockingMode != null);
        }

        public int hashCode() {
            int result = this.transactionManagerLookupClass != null ? this.transactionManagerLookupClass.hashCode() : 0;
            result = 31 * result + (this.transactionManagerLookup != null ? this.transactionManagerLookup.hashCode() : 0);
            result = 31 * result + (this.syncCommitPhase != null ? this.syncCommitPhase.hashCode() : 0);
            result = 31 * result + (this.syncRollbackPhase != null ? this.syncRollbackPhase.hashCode() : 0);
            result = 31 * result + (this.useEagerLocking != null ? this.useEagerLocking.hashCode() : 0);
            result = 31 * result + (this.cacheStopTimeout != null ? this.cacheStopTimeout.hashCode() : 0);
            return result;
        }

        @Override
        public void willUnmarshall(Object parent) {
            this.setTransactionManagerLookupClass(GenericTransactionManagerLookup.class.getName());
        }

        @Override
        public TransactionType clone() throws CloneNotSupportedException {
            TransactionType dolly = (TransactionType)super.clone();
            if (this.recovery != null) {
                dolly.recovery = (RecoveryType)this.recovery.clone();
            }
            return dolly;
        }
    }
}

