/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.Xid;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.RemoveRecoveryInfoCommand;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.recovery.PreparedTxIterator;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryInfoKey;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.XidAware;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RecoveryManagerImpl
implements RecoveryManager {
    private static final Log log = LogFactory.getLog(RecoveryManagerImpl.class);
    private volatile RpcManager rpcManager;
    private volatile CommandsFactory commandFactory;
    private final ConcurrentMap<RecoveryInfoKey, RecoveryAwareRemoteTransaction> preparedTransactions;
    private final String cacheName;
    private volatile RecoveryAwareTransactionTable txTable;
    private volatile boolean broadcastForPreparedTx = true;

    public RecoveryManagerImpl(ConcurrentMap<RecoveryInfoKey, RecoveryAwareRemoteTransaction> recoveryHolder, String cacheName) {
        this.preparedTransactions = recoveryHolder;
        this.cacheName = cacheName;
    }

    @Inject
    public void init(RpcManager rpcManager, CommandsFactory commandsFactory, TransactionTable txTable) {
        this.rpcManager = rpcManager;
        this.commandFactory = commandsFactory;
        this.txTable = (RecoveryAwareTransactionTable)txTable;
    }

    @Override
    public RecoveryManager.RecoveryIterator getPreparedTransactionsFromCluster() {
        PreparedTxIterator iterator = new PreparedTxIterator();
        iterator.add(this.txTable.getLocalPreparedXids());
        if (this.notOnlyMeInTheCluster() && this.broadcastForPreparedTx) {
            boolean success = true;
            Map<Address, Response> responses = this.getAllPreparedTxFromCluster();
            for (Map.Entry<Address, Response> rEntry : responses.entrySet()) {
                Response thisResponse = rEntry.getValue();
                if (this.isSuccessful(thisResponse)) {
                    List responseValue = (List)((SuccessfulResponse)thisResponse).getResponseValue();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Received Xid lists %s from node %s", responseValue, rEntry.getKey());
                    }
                    iterator.add(responseValue);
                    continue;
                }
                log.warn((Object)"Missing the list of prepared transactions from node %s. Received response is %s", rEntry.getKey(), rEntry.getValue());
                success = false;
            }
            boolean bl = this.broadcastForPreparedTx = !success;
            if (!this.broadcastForPreparedTx) {
                log.info("Finished broadcasting for remote prepared transactions. Returning only local values from now on.");
            }
        }
        return iterator;
    }

    @Override
    public void removeRecoveryInformation(Collection<Address> lockOwners, Xid xid, boolean sync) {
        if (this.rpcManager != null) {
            RemoveRecoveryInfoCommand ftc = this.commandFactory.buildRemoveRecoveryInfoCommand(Collections.singletonList(xid));
            this.rpcManager.invokeRemotely(lockOwners, ftc, false);
        }
    }

    @Override
    public void removeLocalRecoveryInformation(List<Xid> xids) {
        for (Xid xid : xids) {
            RemoteTransaction remove = (RemoteTransaction)this.preparedTransactions.remove(new RecoveryInfoKey(xid, this.cacheName));
            if (remove == null || !log.isTraceEnabled()) continue;
            log.trace((Object)"removed xid: %s", xid);
        }
    }

    @Override
    public List<Xid> getLocalInDoubtTransactions() {
        ArrayList<Xid> result = new ArrayList<Xid>();
        for (Map.Entry entry : this.preparedTransactions.entrySet()) {
            RecoveryAwareRemoteTransaction rt = (RecoveryAwareRemoteTransaction)entry.getValue();
            RecoveryInfoKey cacheNamePair = (RecoveryInfoKey)entry.getKey();
            if (!cacheNamePair.sameCacheName(this.cacheName) || !rt.isInDoubt()) continue;
            XidAware globalTransaction = (XidAware)((Object)rt.getGlobalTransaction());
            if (log.isTraceEnabled()) {
                log.trace((Object)"Found in doubt transaction: %s", globalTransaction);
            }
            result.add(globalTransaction.getXid());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Returning %s ", result);
        }
        return result;
    }

    public void registerPreparedTransaction(RecoveryAwareRemoteTransaction remoteTransaction) {
        Xid xid = ((XidAware)((Object)remoteTransaction.getGlobalTransaction())).getXid();
        RemoteTransaction previous = this.preparedTransactions.put(new RecoveryInfoKey(xid, this.cacheName), remoteTransaction);
        if (previous != null) {
            log.error((Object)"There's already a prepared transaction with this xid: %s. New transaction is %s. Are there two different transactions having same Xid in the cluster?", previous, remoteTransaction);
            throw new IllegalStateException("Are there two different transactions having same Xid in the cluster?");
        }
    }

    public void nodesLeft(List<Address> leavers) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Handling leavers: %s. There are %s prepared transactions to check", leavers, this.preparedTransactions.values().size());
        }
        for (RecoveryAwareRemoteTransaction rt : this.preparedTransactions.values()) {
            rt.computeOrphan(leavers);
        }
    }

    public RemoteTransaction getPreparedTransaction(Xid xid) {
        return (RemoteTransaction)this.preparedTransactions.get(new RecoveryInfoKey(xid, this.cacheName));
    }

    private boolean isSuccessful(Response thisResponse) {
        return thisResponse != null && thisResponse.isValid() && thisResponse.isSuccessful();
    }

    private boolean notOnlyMeInTheCluster() {
        return this.rpcManager != null && this.rpcManager.getTransport().getMembers().size() > 1;
    }

    private Map<Address, Response> getAllPreparedTxFromCluster() {
        GetInDoubtTransactionsCommand command = this.commandFactory.buildGetInDoubtTransactionsCommand();
        Map<Address, Response> addressResponseMap = this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, true, false);
        if (log.isTraceEnabled()) {
            log.trace((Object)"getAllPreparedTxFromCluster received from cluster: %s", addressResponseMap);
        }
        return addressResponseMap;
    }

    public ConcurrentMap<RecoveryInfoKey, RecoveryAwareRemoteTransaction> getPreparedTransactions() {
        return this.preparedTransactions;
    }
}

