/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.infinispan.CacheException;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.MembershipArithmetic;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.synchronization.SynchronizationAdapter;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionTable {
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    private static boolean trace = log.isTraceEnabled();
    protected final ConcurrentMap<Transaction, LocalTransaction> localTransactions = new ConcurrentHashMap<Transaction, LocalTransaction>();
    protected final ConcurrentMap<GlobalTransaction, RemoteTransaction> remoteTransactions = new ConcurrentHashMap<GlobalTransaction, RemoteTransaction>();
    private final Object listener = new StaleTransactionCleanup();
    protected Configuration configuration;
    protected InvocationContextContainer icc;
    protected TransactionCoordinator txCoordinator;
    private InterceptorChain invoker;
    private CacheNotifier notifier;
    private RpcManager rpcManager;
    private TransactionFactory txFactory;
    private ExecutorService lockBreakingService;
    private EmbeddedCacheManager cm;

    @Inject
    public void initialize(RpcManager rpcManager, Configuration configuration, InvocationContextContainer icc, InterceptorChain invoker, CacheNotifier notifier, TransactionFactory gtf, EmbeddedCacheManager cm, TransactionCoordinator txCoordinator) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.icc = icc;
        this.invoker = invoker;
        this.notifier = notifier;
        this.txFactory = gtf;
        this.cm = cm;
        this.txCoordinator = txCoordinator;
    }

    @Start
    private void start() {
        this.lockBreakingService = Executors.newFixedThreadPool(1);
        this.cm.addListener(this.listener);
    }

    @Stop
    private void stop() {
        this.cm.removeListener(this.listener);
        this.lockBreakingService.shutdownNow();
        if (trace) {
            log.trace((Object)"Wait for on-going transactions to finish for %d seconds.", TimeUnit.MILLISECONDS.toSeconds(this.configuration.getCacheStopTimeout()));
        }
        long failTime = System.currentTimeMillis() + (long)this.configuration.getCacheStopTimeout();
        boolean txsOnGoing = this.areTxsOnGoing();
        while (txsOnGoing && System.currentTimeMillis() < failTime) {
            try {
                Thread.sleep(100L);
                txsOnGoing = this.areTxsOnGoing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (!trace) continue;
                log.trace((Object)"Interrupted waiting for on-going transactions to finish. localTransactions=%s, remoteTransactions%s", this.localTransactions, this.remoteTransactions);
            }
        }
        if (txsOnGoing) {
            log.warn((Object)"Stopping but there're transactions that did not finish in time: localTransactions=%s, remoteTransactions%s", this.localTransactions, this.remoteTransactions);
        } else if (trace) {
            log.trace("All transactions terminated");
        }
    }

    private boolean areTxsOnGoing() {
        return !this.localTransactions.isEmpty() || !this.remoteTransactions.isEmpty();
    }

    public Set<Object> getLockedKeysForRemoteTransaction(GlobalTransaction gtx) {
        RemoteTransaction transaction = (RemoteTransaction)this.remoteTransactions.get(gtx);
        if (transaction == null) {
            return Collections.emptySet();
        }
        return transaction.getLockedKeys();
    }

    public void remoteTransactionPrepared(GlobalTransaction gtx) {
    }

    public void localTransactionPrepared(LocalTransaction localTransaction) {
    }

    public void enlist(Transaction transaction, LocalTransaction localTransaction) {
        if (!localTransaction.isEnlisted()) {
            SynchronizationAdapter sync = new SynchronizationAdapter(localTransaction, this.txCoordinator);
            try {
                transaction.registerSynchronization((Synchronization)sync);
            }
            catch (Exception e) {
                log.warn((Object)"Failed synchronization registration", e);
                throw new CacheException(e);
            }
            ((SyncLocalTransaction)localTransaction).setEnlisted(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStateOnNodesLeaving(List<Address> leavers) {
        HashSet<GlobalTransaction> toKill = new HashSet<GlobalTransaction>();
        for (GlobalTransaction gt : this.remoteTransactions.keySet()) {
            if (!leavers.contains(gt.getAddress())) continue;
            toKill.add(gt);
        }
        if (trace) {
            if (toKill.isEmpty()) {
                log.trace((Object)"No global transactions pertain to originator(s) %s who have left the cluster.", leavers);
            } else {
                log.trace((Object)"%s global transactions pertain to leavers list %s and need to be killed", toKill.size(), leavers);
            }
        }
        for (GlobalTransaction gtx : toKill) {
            if (trace) {
                log.trace((Object)"Killing %s", gtx);
            }
            RollbackCommand rc = new RollbackCommand(gtx);
            rc.init(this.invoker, this.icc, this);
            try {
                rc.perform(null);
                if (!trace) continue;
                log.trace((Object)"Rollback of %s complete.", gtx);
            }
            catch (Throwable e) {
                log.warn((Object)("Unable to roll back gtx " + gtx), e);
            }
            finally {
                this.removeRemoteTransaction(gtx);
            }
        }
        if (trace) {
            log.trace("Completed cleaning stale locks.");
        }
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return (RemoteTransaction)this.remoteTransactions.get(txId);
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications) {
        RemoteTransaction remoteTransaction = this.txFactory.newRemoteTransaction(modifications, globalTx);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx) {
        RemoteTransaction remoteTransaction = this.txFactory.newRemoteTransaction(globalTx);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    private void registerRemoteTransaction(GlobalTransaction gtx, RemoteTransaction rtx) {
        RemoteTransaction transaction = this.remoteTransactions.put(gtx, rtx);
        if (transaction != null) {
            String message = "A remote transaction with the given id was already registered!!!";
            log.error(message);
            throw new IllegalStateException(message);
        }
        if (trace) {
            log.trace("Created and registered remote transaction " + rtx);
        }
    }

    public LocalTransaction getOrCreateLocalTransaction(Transaction transaction, InvocationContext ctx) {
        LocalTransaction current = (LocalTransaction)this.localTransactions.get(transaction);
        if (current == null) {
            Address localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
            GlobalTransaction tx = this.txFactory.newGlobalTransaction(localAddress, false);
            if (trace) {
                log.trace((Object)"Created a new GlobalTransaction %s", tx);
            }
            current = this.txFactory.newLocalTransaction(transaction, tx);
            this.localTransactions.put(transaction, current);
            this.notifier.notifyTransactionRegistered(tx, ctx);
        }
        return current;
    }

    public boolean removeLocalTransaction(LocalTransaction localTransaction) {
        return this.localTransactions.remove(localTransaction.getTransaction()) != null;
    }

    public void remoteTransactionCompleted(GlobalTransaction gtx) {
        this.remoteTransactions.remove(gtx);
    }

    private boolean removeRemoteTransaction(GlobalTransaction txId) {
        boolean existed;
        boolean bl = existed = this.remoteTransactions.remove(txId) != null;
        if (trace) {
            log.trace("Removed " + txId + " from transaction table. Transaction existed? " + existed);
        }
        return existed;
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public LocalTransaction getLocalTransaction(Transaction tx) {
        return (LocalTransaction)this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }

    @Listener
    public class StaleTransactionCleanup {
        @ViewChanged
        public void onViewChange(ViewChangedEvent vce) {
            List<Address> leavers = MembershipArithmetic.getMembersLeft(vce.getOldMembers(), vce.getNewMembers());
            if (!leavers.isEmpty()) {
                if (trace) {
                    log.trace((Object)"Saw %s leavers - kicking off a lock breaking task", leavers.size());
                }
                this.cleanTxForWhichTheOwnerLeft(leavers);
                if (TransactionTable.this.configuration.isUseEagerLocking() && TransactionTable.this.configuration.isEagerLockSingleNode() && TransactionTable.this.configuration.getCacheMode().isDistributed()) {
                    for (LocalTransaction localTx : TransactionTable.this.localTransactions.values()) {
                        if (!localTx.hasRemoteLocksAcquired(leavers)) continue;
                        localTx.markForRollback();
                    }
                }
            }
        }

        private void cleanTxForWhichTheOwnerLeft(final List<Address> leavers) {
            try {
                TransactionTable.this.lockBreakingService.submit(new Runnable(){

                    @Override
                    public void run() {
                        TransactionTable.this.updateStateOnNodesLeaving(leavers);
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                log.debug((Object)"Unable to submit task to executor", ree);
            }
        }
    }
}

