/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import javax.transaction.xa.XAException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionCoordinator {
    private static final Log log = LogFactory.getLog(TransactionCoordinator.class);
    private CommandsFactory commandsFactory;
    private InvocationContextContainer icc;
    private InterceptorChain invoker;
    private TransactionTable txTable;
    Configuration configuration;
    boolean trace;

    @Inject
    public void init(CommandsFactory commandsFactory, InvocationContextContainer icc, InterceptorChain invoker, TransactionTable txTable, Configuration configuration) {
        this.commandsFactory = commandsFactory;
        this.icc = icc;
        this.invoker = invoker;
        this.txTable = txTable;
        this.configuration = configuration;
        this.trace = log.isTraceEnabled();
    }

    public int prepare(LocalTransaction localTransaction) throws XAException {
        this.validateNotMarkedForRollback(localTransaction);
        if (this.configuration.isOnePhaseCommit()) {
            if (this.trace) {
                log.trace((Object)"Received prepare for tx: %s. Skipping call as 1PC will be used.", localTransaction);
            }
            return 0;
        }
        PrepareCommand prepareCommand = this.commandsFactory.buildPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), this.configuration.isOnePhaseCommit());
        if (this.trace) {
            log.trace("Sending prepare command through the chain: " + prepareCommand);
        }
        LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
        ctx.setLocalTransaction(localTransaction);
        try {
            this.invoker.invoke(ctx, prepareCommand);
            if (localTransaction.isReadOnly()) {
                if (this.trace) {
                    log.trace("Readonly transaction: " + localTransaction.getGlobalTransaction());
                }
                this.commit(localTransaction, false);
                return 3;
            }
            this.txTable.localTransactionPrepared(localTransaction);
            return 0;
        }
        catch (Throwable e) {
            log.error((Object)"Error while processing PrepareCommand", e);
            throw new XAException(-3);
        }
    }

    private void validateNotMarkedForRollback(LocalTransaction localTransaction) throws XAException {
        if (localTransaction.isMarkedForRollback()) {
            if (this.trace) {
                log.trace((Object)"Transaction already marked for rollback: %s", localTransaction);
            }
            throw new XAException(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(LocalTransaction localTransaction, boolean isOnePhase) throws XAException {
        block10: {
            if (this.trace) {
                log.trace((Object)"Committing transaction %s", localTransaction.getGlobalTransaction());
            }
            try {
                LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
                ctx.setLocalTransaction(localTransaction);
                if (this.configuration.isOnePhaseCommit() || isOnePhase) {
                    this.validateNotMarkedForRollback(localTransaction);
                    if (this.trace) {
                        log.trace("Doing an 1PC prepare call on the interceptor chain");
                    }
                    PrepareCommand command = this.commandsFactory.buildPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), true);
                    try {
                        this.invoker.invoke(ctx, command);
                        break block10;
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error while processing 1PC PrepareCommand", e);
                        throw new XAException(-3);
                    }
                }
                CommitCommand commitCommand = this.commandsFactory.buildCommitCommand(localTransaction.getGlobalTransaction());
                try {
                    this.invoker.invoke(ctx, commitCommand);
                }
                catch (Throwable e) {
                    log.error((Object)"Error while processing 1PC PrepareCommand", e);
                    throw new XAException(-3);
                }
            }
            finally {
                TransactionCoordinator.cleanupImpl(localTransaction, this.txTable, this.icc);
            }
        }
    }

    public void rollback(LocalTransaction localTransaction) throws XAException {
        if (this.trace) {
            log.trace((Object)"rollback transaction %s ", localTransaction.getGlobalTransaction());
        }
        RollbackCommand rollbackCommand = this.commandsFactory.buildRollbackCommand(localTransaction.getGlobalTransaction());
        LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
        ctx.setLocalTransaction(localTransaction);
        try {
            this.invoker.invoke(ctx, rollbackCommand);
        }
        catch (Throwable e) {
            log.error((Object)"Exception while rollback", e);
            throw new XAException(8);
        }
        finally {
            TransactionCoordinator.cleanupImpl(localTransaction, this.txTable, this.icc);
        }
    }

    private static void cleanupImpl(LocalTransaction localTransaction, TransactionTable txTable, InvocationContextContainer icc) {
        txTable.removeLocalTransaction(localTransaction);
        icc.suspend();
    }
}

