/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.transaction.Transaction;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class LocalTransaction
extends AbstractCacheTransaction {
    private static final Log log = LogFactory.getLog(LocalTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    private Set<Address> remoteLockedNodes;
    private volatile boolean isMarkedForRollback;
    private final Transaction transaction;

    public LocalTransaction(Transaction transaction, GlobalTransaction tx) {
        this.tx = tx;
        this.transaction = transaction;
    }

    public void addModification(WriteCommand mod) {
        if (trace) {
            log.trace((Object)"Adding modification %s. Mod list is %s", mod, this.modifications);
        }
        if (this.modifications == null) {
            this.modifications = new LinkedList();
        }
        this.modifications.add(mod);
    }

    public boolean hasRemoteLocksAcquired(List<Address> leavers) {
        if (log.isTraceEnabled()) {
            log.trace("My remote locks: " + this.remoteLockedNodes + ", leavers are:" + leavers);
        }
        return this.remoteLockedNodes != null && !Collections.disjoint(this.remoteLockedNodes, leavers);
    }

    public void locksAcquired(Collection<Address> nodes) {
        if (this.remoteLockedNodes == null) {
            this.remoteLockedNodes = new HashSet<Address>();
        }
        this.remoteLockedNodes.addAll(nodes);
    }

    public Collection<Address> getRemoteLocksAcquired() {
        if (this.remoteLockedNodes == null) {
            return Collections.emptySet();
        }
        return this.remoteLockedNodes;
    }

    public void markForRollback() {
        this.isMarkedForRollback = true;
    }

    public boolean isMarkedForRollback() {
        return this.isMarkedForRollback;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries == null ? InfinispanCollections.emptyBidirectionalMap() : this.lookedUpEntries;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = new BidirectionalLinkedHashMap(4);
        }
        this.lookedUpEntries.put(key, e);
    }

    public boolean isReadOnly() {
        return !(this.modifications != null && !this.modifications.isEmpty() || this.lookedUpEntries != null && !this.lookedUpEntries.isEmpty());
    }

    public abstract boolean isEnlisted();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalTransaction that = (LocalTransaction)o;
        if (this.isMarkedForRollback != that.isMarkedForRollback) {
            return false;
        }
        if (this.remoteLockedNodes != null ? !((Object)this.remoteLockedNodes).equals(that.remoteLockedNodes) : that.remoteLockedNodes != null) {
            return false;
        }
        return !(this.transaction != null ? !this.transaction.equals(that.transaction) : that.transaction != null);
    }

    public int hashCode() {
        int result = this.remoteLockedNodes != null ? ((Object)this.remoteLockedNodes).hashCode() : 0;
        result = 31 * result + (this.isMarkedForRollback ? 1 : 0);
        result = 31 * result + (this.transaction != null ? this.transaction.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LocalTransaction{remoteLockedNodes=" + this.remoteLockedNodes + ", isMarkedForRollback=" + this.isMarkedForRollback + ", transaction=" + this.transaction + "} " + super.toString();
    }
}

