/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Set;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.Util;

public class MarshalledValue {
    protected volatile Object instance;
    protected volatile byte[] raw;
    private volatile int cachedHashCode = 0;
    private volatile transient boolean equalityPreferenceForInstance = true;
    private final StreamingMarshaller marshaller;

    public MarshalledValue(Object instance, boolean equalityPreferenceForInstance, StreamingMarshaller marshaller) throws NotSerializableException {
        if (instance == null) {
            throw new NullPointerException("Null values cannot be wrapped as MarshalledValues!");
        }
        this.instance = instance;
        this.equalityPreferenceForInstance = equalityPreferenceForInstance;
        this.marshaller = marshaller;
    }

    public MarshalledValue(byte[] raw, int cachedHashCode, StreamingMarshaller marshaller) {
        this.init(raw, cachedHashCode);
        this.marshaller = marshaller;
    }

    public void init(byte[] raw, int cachedHashCode) {
        this.raw = raw;
        this.cachedHashCode = cachedHashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void serialize() {
        if (this.raw == null) {
            try {
                ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(128);
                ObjectOutput out = this.marshaller.startObjectOutput(baos, true);
                try {
                    this.marshaller.objectToObjectStream(this.instance, out);
                }
                finally {
                    this.marshaller.finishObjectOutput(out);
                }
                byte[] buf = baos.getRawBuffer();
                int length = baos.size();
                this.raw = new byte[length];
                System.arraycopy(buf, 0, this.raw, 0, length);
            }
            catch (Exception e) {
                throw new CacheException("Unable to marshall value " + this.instance, e);
            }
        }
    }

    public synchronized void deserialize() {
        if (this.instance == null) {
            try {
                this.instance = this.marshaller.objectFromByteBuffer(this.raw);
            }
            catch (Exception e) {
                throw new CacheException("Unable to unmarshall value", e);
            }
        }
    }

    public void compact(boolean preferSerializedRepresentation, boolean force) {
        this.equalityPreferenceForInstance = true;
        if (force) {
            if (preferSerializedRepresentation && this.raw == null) {
                this.serialize();
            } else if (!preferSerializedRepresentation && this.instance == null) {
                this.deserialize();
            }
        }
        if (this.instance != null && this.raw != null) {
            if (preferSerializedRepresentation) {
                this.nullifyInstance();
            } else {
                this.raw = null;
            }
        }
    }

    private synchronized void nullifyInstance() {
        this.instance = null;
    }

    public byte[] getRaw() {
        if (this.raw == null) {
            this.serialize();
        }
        return this.raw;
    }

    public synchronized Object get() {
        if (this.instance == null) {
            this.deserialize();
        }
        return this.instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshalledValue that = (MarshalledValue)o;
        if (this.raw != null && that.raw != null) {
            return Arrays.equals(this.raw, that.raw);
        }
        if (this.instance != null && that.instance != null) {
            return this.instance.equals(that.instance);
        }
        if (this.equalityPreferenceForInstance && that.equalityPreferenceForInstance) {
            if (this.instance == null) {
                this.deserialize();
            }
            if (that.instance == null) {
                that.deserialize();
            }
            return this.instance.equals(that.instance);
        }
        if (this.raw == null) {
            this.serialize();
        }
        if (that.raw == null) {
            that.serialize();
        }
        return Arrays.equals(this.raw, that.raw);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            if (this.instance == null) {
                this.deserialize();
            }
            this.cachedHashCode = this.instance.hashCode();
            if (this.cachedHashCode == 0) {
                this.cachedHashCode = 65261;
            }
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("MarshalledValue{").append("instance=").append(this.instance != null ? this.instance.toString() : "<serialized>").append(", serialized=").append(this.raw != null ? Util.printArray(this.raw, false) : "false").append(", cachedHashCode=").append(this.cachedHashCode).append("}@").append(Util.hexIdHashCode(this));
        return sb.toString();
    }

    public MarshalledValue setEqualityPreferenceForInstance(boolean equalityPreferenceForInstance) {
        this.equalityPreferenceForInstance = equalityPreferenceForInstance;
        return this;
    }

    public static boolean isTypeExcluded(Class type) {
        return type.equals(String.class) || type.isPrimitive() || type.equals(Void.class) || type.equals(Boolean.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Float.class) || type.equals(Double.class) || type.isArray() && MarshalledValue.isTypeExcluded(type.getComponentType()) || type.equals(GlobalTransaction.class) || Address.class.isAssignableFrom(type) || ReplicableCommand.class.isAssignableFrom(type) || type.equals(MarshalledValue.class);
    }

    public static class Externalizer
    extends AbstractExternalizer<MarshalledValue> {
        private StreamingMarshaller marshaller;

        public void inject(StreamingMarshaller marshaller) {
            this.marshaller = marshaller;
        }

        @Override
        public void writeObject(ObjectOutput output, MarshalledValue mv) throws IOException {
            byte[] raw = mv.getRaw();
            UnsignedNumeric.writeUnsignedInt(output, raw.length);
            output.write(raw);
            output.writeInt(mv.hashCode());
        }

        @Override
        public MarshalledValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int length = UnsignedNumeric.readUnsignedInt(input);
            byte[] raw = new byte[length];
            input.readFully(raw);
            int hc = input.readInt();
            return new MarshalledValue(raw, hc, this.marshaller);
        }

        @Override
        public Integer getId() {
            return 40;
        }

        @Override
        public Set<Class<? extends MarshalledValue>> getTypeClasses() {
            return Util.asSet(MarshalledValue.class);
        }
    }
}

