/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.infinispan.CacheException;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationDocRef;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.util.TypedProperties;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class AbstractCacheLoaderConfig
extends AbstractNamedCacheConfigurationBean
implements CacheLoaderConfig {
    private static final long serialVersionUID = -4303705423800914433L;
    @XmlAttribute(name="class")
    @ConfigurationDocRef(name="class", bean=AbstractCacheLoaderConfig.class, targetElement="setCacheLoaderClassName")
    protected String cacheLoaderClassName;
    @XmlTransient
    protected TypedProperties properties = EMPTY_PROPERTIES;

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.testImmutability("properties");
        this.properties = this.toTypedProperties(properties);
    }

    public void setProperties(String properties) throws IOException {
        if (properties == null) {
            return;
        }
        this.testImmutability("properties");
        properties = XmlConfigHelper.escapeBackslashes(properties);
        ByteArrayInputStream is = new ByteArrayInputStream(properties.trim().getBytes("ISO8859_1"));
        this.properties = new TypedProperties();
        this.properties.load(is);
        is.close();
    }

    @Override
    public String getCacheLoaderClassName() {
        return this.cacheLoaderClassName;
    }

    @Override
    public void setCacheLoaderClassName(String className) {
        if (className == null || className.length() == 0) {
            return;
        }
        this.testImmutability("cacheLoaderClassName");
        this.cacheLoaderClassName = className;
    }

    @Override
    public AbstractCacheLoaderConfig clone() {
        try {
            return (AbstractCacheLoaderConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void accept(ConfigurationBeanVisitor v) {
    }
}

