/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.CacheException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.config.ConfigurationException;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class InterceptorChain {
    private static final Log log = LogFactory.getLog(InterceptorChain.class);
    private volatile CommandInterceptor firstInChain;

    public InterceptorChain(CommandInterceptor first) {
        this.firstInChain = first;
    }

    @Start
    private void printChainInfo() {
        if (log.isDebugEnabled()) {
            log.debug("Interceptor chain size: " + this.size());
            log.debug("Interceptor chain is: " + this.toString());
        }
    }

    private void assertNotAdded(Class<? extends CommandInterceptor> clazz) {
        for (CommandInterceptor next = this.firstInChain; next != null; next = next.getNext()) {
            if (!next.getClass().equals(clazz)) continue;
            throw new ConfigurationException("Detected interceptor of type [" + clazz.getName() + "] being added to the interceptor chain more than once!");
        }
    }

    public synchronized void addInterceptor(CommandInterceptor interceptor, int position) {
        this.assertNotAdded(interceptor.getClass());
        if (position == 0) {
            interceptor.setNext(this.firstInChain);
            this.firstInChain = interceptor;
            return;
        }
        if (this.firstInChain == null) {
            return;
        }
        int index = 0;
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (++index != position) continue;
            interceptor.setNext(it.getNext());
            it.setNext(interceptor);
            return;
        }
        throw new IllegalArgumentException("Invalid index: " + index + " !");
    }

    public void removeInterceptor(int position) {
        if (this.firstInChain == null) {
            return;
        }
        if (position == 0) {
            this.firstInChain = this.firstInChain.getNext();
            return;
        }
        int index = 0;
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (++index != position) continue;
            if (it.getNext() == null) {
                return;
            }
            it.setNext(it.getNext().getNext());
            return;
        }
        throw new IllegalArgumentException("Invalid position: " + position + " !");
    }

    public int size() {
        int size = 0;
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            ++size;
        }
        return size;
    }

    public List<CommandInterceptor> asList() {
        if (this.firstInChain == null) {
            return Collections.emptyList();
        }
        LinkedList<CommandInterceptor> retval = new LinkedList<CommandInterceptor>();
        CommandInterceptor tmp = this.firstInChain;
        do {
            retval.add(tmp);
        } while ((tmp = tmp.getNext()) != null);
        return Collections.unmodifiableList(retval);
    }

    public void removeInterceptor(Class<? extends CommandInterceptor> clazz) {
        if (this.firstInChain.getClass() == clazz) {
            this.firstInChain = this.firstInChain.getNext();
        }
        CommandInterceptor prevIt = this.firstInChain;
        for (CommandInterceptor it = this.firstInChain.getNext(); it != null; it = it.getNext()) {
            if (it.getClass() == clazz) {
                prevIt.setNext(it.getNext());
            }
            prevIt = it;
        }
    }

    public boolean addInterceptorAfter(CommandInterceptor toAdd, Class<? extends CommandInterceptor> afterInterceptor) {
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (!it.getClass().equals(afterInterceptor)) continue;
            toAdd.setNext(it.getNext());
            it.setNext(toAdd);
            return true;
        }
        return false;
    }

    public boolean addInterceptorBefore(CommandInterceptor toAdd, Class<? extends CommandInterceptor> beforeInterceptor) {
        if (this.firstInChain.getClass().equals(beforeInterceptor)) {
            toAdd.setNext(this.firstInChain);
            this.firstInChain = toAdd;
            return true;
        }
        CommandInterceptor it = this.firstInChain;
        while (it.getNext() != null) {
            if (it.getNext().getClass().equals(beforeInterceptor)) {
                toAdd.setNext(it.getNext());
                it.setNext(toAdd);
                return true;
            }
            it = it.getNext();
        }
        return false;
    }

    public boolean replaceInterceptor(CommandInterceptor replacingInterceptor, Class<? extends CommandInterceptor> toBeReplacedInterceptorType) {
        if (this.firstInChain.getClass().equals(toBeReplacedInterceptorType)) {
            replacingInterceptor.setNext(this.firstInChain.getNext());
            this.firstInChain = replacingInterceptor;
            return true;
        }
        CommandInterceptor it = this.firstInChain;
        CommandInterceptor previous = this.firstInChain;
        while (it.getNext() != null) {
            CommandInterceptor current = it.getNext();
            if (current.getClass().equals(toBeReplacedInterceptorType)) {
                replacingInterceptor.setNext(current.getNext());
                previous.setNext(replacingInterceptor);
                return true;
            }
            previous = current;
            it = current;
        }
        return false;
    }

    public synchronized void appendInterceptor(CommandInterceptor ci) {
        CommandInterceptor it = this.firstInChain;
        while (it.hasNext()) {
            it = it.getNext();
        }
        it.setNext(ci);
        ci.setNext(null);
    }

    public Object invoke(InvocationContext ctx, VisitableCommand command) {
        try {
            return command.acceptVisitor(ctx, this.firstInChain);
        }
        catch (CacheException e) {
            if (e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public CommandInterceptor getFirstInChain() {
        return this.firstInChain;
    }

    public void setFirstInChain(CommandInterceptor interceptor) {
        this.firstInChain = interceptor;
    }

    public List<CommandInterceptor> getInterceptorsWhichExtend(Class<? extends CommandInterceptor> interceptorClass) {
        ArrayList<CommandInterceptor> result = new ArrayList<CommandInterceptor>();
        for (CommandInterceptor interceptor : this.asList()) {
            boolean isSubclass = interceptorClass.isAssignableFrom(interceptor.getClass());
            if (!isSubclass) continue;
            result.add(interceptor);
        }
        return result;
    }

    public List<CommandInterceptor> getInterceptorsWithClassName(String name) {
        ArrayList<CommandInterceptor> result = new ArrayList<CommandInterceptor>(2);
        for (CommandInterceptor iterator = this.firstInChain; iterator != null; iterator = iterator.getNext()) {
            if (!iterator.getClass().getName().equals(name)) continue;
            result.add(iterator);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CommandInterceptor i = this.firstInChain; i != null; i = i.getNext()) {
            sb.append("\n\t>> ");
            sb.append(i.getClass().getName());
        }
        return sb.toString();
    }

    public boolean containsInstance(CommandInterceptor interceptor) {
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (it != interceptor) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean containsInterceptorType(Class<? extends CommandInterceptor> interceptorType) {
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (!it.getClass().equals(interceptorType)) continue;
            return true;
        }
        return false;
    }
}

