/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.L1Manager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;

public class DistributionInterceptor
extends BaseRpcInterceptor {
    DistributionManager dm;
    CommandsFactory cf;
    DataContainer dataContainer;
    boolean isL1CacheEnabled;
    boolean needReliableReturnValues;
    EntryFactory entryFactory;
    L1Manager l1Manager;
    static final RecipientGenerator CLEAR_COMMAND_GENERATOR = new RecipientGenerator(){

        @Override
        public List<Address> generateRecipients() {
            return null;
        }

        @Override
        public Collection<Object> getKeys() {
            return Collections.emptySet();
        }
    };

    @Inject
    public void injectDependencies(DistributionManager distributionManager, CommandsFactory cf, DataContainer dataContainer, EntryFactory entryFactory, L1Manager l1Manager) {
        this.dm = distributionManager;
        this.cf = cf;
        this.dataContainer = dataContainer;
        this.entryFactory = entryFactory;
        this.l1Manager = l1Manager;
    }

    @Start
    public void start() {
        this.isL1CacheEnabled = this.configuration.isL1CacheEnabled();
        this.needReliableReturnValues = !this.configuration.isUnsafeUnreliableReturnValues();
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        boolean isRehashInProgress = !this.dm.isJoinComplete() || this.dm.isRehashInProgress();
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.isL1CacheEnabled && !ctx.isOriginLocal() && returnValue != null) {
            this.l1Manager.addRequestor(command.getKey(), ctx.getOrigin());
        }
        if (this.needsRemoteGet(ctx, command.getKey(), returnValue == null)) {
            returnValue = this.remoteGetAndStoreInL1(ctx, command.getKey(), isRehashInProgress, false);
        }
        return returnValue;
    }

    private boolean needsRemoteGet(InvocationContext ctx, Object key, boolean retvalCheck) {
        CacheEntry entry;
        return retvalCheck && !ctx.hasFlag(Flag.SKIP_REMOTE_LOOKUP) && ((entry = ctx.lookupEntry(key)) == null || entry.isNull() || entry.isLockPlaceholder());
    }

    private Object remoteGetAndStoreInL1(InvocationContext ctx, Object key, boolean dmWasRehashingDuringLocalLookup, boolean isWrite) throws Throwable {
        DataLocality locality = this.dm.getLocality(key);
        boolean isMappedToLocalNode = locality.isLocal();
        if (ctx.isOriginLocal() && !isMappedToLocalNode && this.isNotInL1(key)) {
            return this.realRemoteGet(ctx, key, true, isWrite);
        }
        if (isMappedToLocalNode && dmWasRehashingDuringLocalLookup) {
            if (this.trace) {
                this.log.trace((Object)"Key %s is mapped to local node %s, but a rehash is in progress so may need to look elsewhere", key, this.rpcManager.getAddress());
            }
            return this.realRemoteGet(ctx, key, false, isWrite);
        }
        if (this.trace) {
            this.log.trace((Object)"Not doing a remote get for key %s since entry is mapped to current node (%s), or is in L1.  Owners are %s", key, this.rpcManager.getAddress(), this.dm.locate(key));
        }
        return null;
    }

    private Object realRemoteGet(InvocationContext ctx, Object key, boolean storeInL1, boolean isWrite) throws Throwable {
        InternalCacheEntry ice;
        if (this.trace) {
            this.log.trace((Object)"Doing a remote get for key %s", key);
        }
        if ((ice = this.dm.retrieveFromRemoteSource(key, ctx)) != null) {
            if (storeInL1) {
                if (this.isL1CacheEnabled) {
                    if (this.trace) {
                        this.log.trace((Object)"Caching remotely retrieved entry for key %s in L1", key);
                    }
                    long lifespan = ice.getLifespan() < 0L ? this.configuration.getL1Lifespan() : Math.min(ice.getLifespan(), this.configuration.getL1Lifespan());
                    PutKeyValueCommand put = this.cf.buildPutKeyValueCommand(ice.getKey(), ice.getValue(), lifespan, -1L, ctx.getFlags());
                    this.entryFactory.wrapEntryForWriting(ctx, key, true, false, ctx.hasLockedKey(key), false, false);
                    this.invokeNextInterceptor(ctx, put);
                } else {
                    CacheEntry ce = ctx.lookupEntry(key);
                    if (ce == null || ce.isNull() || ce.isLockPlaceholder()) {
                        if (ce != null && ce.isChanged()) {
                            ce.setValue(ice.getValue());
                        } else if (isWrite) {
                            this.entryFactory.wrapEntryForWriting(ctx, ice, true, false, ctx.hasLockedKey(key), false, false);
                        } else {
                            ctx.putLookedUpEntry(key, ice);
                        }
                    }
                }
            } else if (this.trace) {
                this.log.trace((Object)"Not caching remotely retrieved entry for key %s in L1", key);
            }
            return ice.getValue();
        }
        return null;
    }

    private boolean isNotInL1(Object key) {
        return !this.isL1CacheEnabled || !this.dataContainer.containsKey(key);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false, false);
        if (this.isL1CacheEnabled && !ctx.isOriginLocal()) {
            this.l1Manager.addRequestor(command.getKey(), ctx.getOrigin());
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new MultipleKeysRecipientGenerator(command.getMap().keySet()), true, false);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false, false);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, CLEAR_COMMAND_GENERATOR, false, true);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false, false);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            if (this.configuration.isEagerLockSingleNode()) {
                LinkedList<Address> where;
                Map<Object, List<Address>> toMulticast = this.dm.locateAll(command.getKeys(), 1);
                if (toMulticast.size() == 1) {
                    where = toMulticast.values().iterator().next();
                } else {
                    where = new LinkedList();
                    for (List<Address> values : toMulticast.values()) {
                        where.addAll(values);
                    }
                }
                this.rpcManager.invokeRemotely(where, (ReplicableCommand)command, true, true);
                ((LocalTxInvocationContext)ctx).remoteLocksAcquired(where);
            } else {
                this.rpcManager.invokeRemotely(this.dm.getAffectedNodes(command.getKeys()), (ReplicableCommand)command, true, true);
            }
            ctx.addAffectedKeys(command.getKeys());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private boolean needToResendPrepare(Response r) {
        return r instanceof SuccessfulResponse && Byte.valueOf((byte)1).equals(((SuccessfulResponse)r).getResponseValue());
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        block9: {
            if (this.shouldInvokeRemoteTxCommand(ctx)) {
                Map<Address, Response> responses;
                Collection<Address> preparedOn = ((LocalTxInvocationContext)ctx).getRemoteLocksAcquired();
                List<Address> recipients = this.dm.getAffectedNodes(ctx.getAffectedKeys());
                boolean syncCommitPhase = this.configuration.isSyncCommitPhase();
                for (Address a : preparedOn) {
                    if (recipients.contains(a)) continue;
                    recipients.add(a);
                    syncCommitPhase = true;
                }
                NotifyingNotifiableFuture<Object> f = null;
                if (this.isL1CacheEnabled) {
                    f = this.l1Manager.flushCache(ctx.getLockedKeys(), null, null);
                }
                if (!(responses = this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, syncCommitPhase, true)).isEmpty()) {
                    LinkedList<Address> resendTo = new LinkedList<Address>();
                    for (Map.Entry<Address, Response> r : responses.entrySet()) {
                        if (!this.needToResendPrepare(r.getValue())) continue;
                        resendTo.add(r.getKey());
                    }
                    if (!resendTo.isEmpty()) {
                        this.log.debug((Object)"Need to resend prepares for %s to %s", command.getGlobalTransaction(), resendTo);
                        PrepareCommand pc = this.cf.buildPrepareCommand(command.getGlobalTransaction(), ctx.getModifications(), true);
                        this.rpcManager.invokeRemotely(resendTo, (ReplicableCommand)pc, true, true);
                    }
                }
                if (f != null && this.configuration.isSyncCommitPhase()) {
                    try {
                        f.get();
                    }
                    catch (Exception e) {
                        if (!this.log.isInfoEnabled()) break block9;
                        this.log.info((Object)"Failed invalidating remote cache: ", e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        boolean sync = this.isSynchronous(ctx);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            List<Address> recipients = this.dm.getAffectedNodes(ctx.getAffectedKeys());
            NotifyingNotifiableFuture<Object> f = null;
            if (this.isL1CacheEnabled && command.isOnePhaseCommit()) {
                f = this.l1Manager.flushCache(ctx.getLockedKeys(), null, null);
            }
            this.rpcManager.invokeRemotely(recipients, command, sync);
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(recipients);
            if (f != null) {
                f.get();
            }
        }
        return retVal;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.rpcManager.invokeRemotely(this.dm.getAffectedNodes(ctx.getAffectedKeys()), (ReplicableCommand)command, this.configuration.isSyncRollbackPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void remoteGetBeforeWrite(InvocationContext ctx, boolean isConditionalCommand, KeyGenerator keygen) throws Throwable {
        if (this.isNeedReliableReturnValues(ctx) || isConditionalCommand && ctx.isInTxScope()) {
            boolean isStillRehashingOnJoin = !this.dm.isJoinComplete();
            for (Object k : keygen.getKeys()) {
                this.remoteGetAndStoreInL1(ctx, k, isStillRehashingOnJoin, true);
            }
        }
    }

    private boolean isNeedReliableReturnValues(InvocationContext ctx) {
        return !ctx.hasFlag(Flag.SKIP_REMOTE_LOOKUP) && this.needReliableReturnValues;
    }

    private Object handleWriteCommand(InvocationContext ctx, WriteCommand command, RecipientGenerator recipientGenerator, boolean skipRemoteGet, boolean skipL1Invalidation) throws Throwable {
        if (ctx.isOriginLocal() && !skipRemoteGet) {
            this.remoteGetBeforeWrite(ctx, command.isConditional(), recipientGenerator);
        }
        boolean sync = this.isSynchronous(ctx);
        if (this.isLocalModeForced(ctx)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful()) {
            if (!ctx.isInTxScope()) {
                NotifyingNotifiableFuture<Object> future = null;
                if (ctx.isOriginLocal()) {
                    int numCallRecipients;
                    List<Address> rec = recipientGenerator.generateRecipients();
                    int n = numCallRecipients = rec == null ? 0 : rec.size();
                    if (this.trace) {
                        this.log.trace((Object)"Invoking command %s on hosts %s", command, rec);
                    }
                    boolean useFuture = ctx.isUseFutureReturnType();
                    if (this.isL1CacheEnabled && !skipL1Invalidation) {
                        if (this.rpcManager.getTransport().getMembers().size() > numCallRecipients) {
                            if (this.trace) {
                                this.log.trace((Object)"Put occuring on node, requesting L1 cache invalidation for keys %s. Other data owners are %s", command.getAffectedKeys(), this.dm.getAffectedNodes(command.getAffectedKeys()));
                            }
                            future = this.l1Manager.flushCache(recipientGenerator.getKeys(), returnValue, null);
                        } else if (this.trace) {
                            this.log.trace((Object)"Not performing invalidation! numCallRecipients=%s", numCallRecipients);
                        }
                    }
                    if (!this.isSingleOwnerAndLocal(recipientGenerator)) {
                        if (useFuture) {
                            if (future == null) {
                                future = new NotifyingFutureImpl(returnValue);
                            }
                            this.rpcManager.invokeRemotelyInFuture(rec, command, future);
                            return future;
                        }
                        this.rpcManager.invokeRemotely(rec, command, sync);
                    } else if (useFuture && future != null) {
                        return future;
                    }
                    if (future != null && sync) {
                        future.get();
                        if (this.trace) {
                            this.log.trace((Object)"Finished invalidating keys %s ", recipientGenerator.getKeys());
                        }
                    }
                } else if (this.isL1CacheEnabled && !skipL1Invalidation) {
                    if (this.trace) {
                        this.log.trace((Object)"Put occuring on node, requesting cache invalidation for keys %s. Origin of command is remote", command.getAffectedKeys());
                    }
                    future = this.l1Manager.flushCache(recipientGenerator.getKeys(), returnValue, ctx.getOrigin());
                    if (sync) {
                        future.get();
                        if (this.trace) {
                            this.log.trace((Object)"Finished invalidating keys %s ", recipientGenerator.getKeys());
                        }
                    }
                }
            } else {
                ((TxInvocationContext)ctx).addAffectedKeys(recipientGenerator.getKeys());
            }
        }
        return returnValue;
    }

    private boolean isSingleOwnerAndLocal(RecipientGenerator recipientGenerator) {
        List<Address> recipients;
        return this.configuration.getNumOwners() == 1 && (recipients = recipientGenerator.generateRecipients()) != null && recipients.size() == 1 && recipients.get(0).equals(this.rpcManager.getTransport().getAddress());
    }

    class MultipleKeysRecipientGenerator
    implements RecipientGenerator {
        final Collection<Object> keys;
        List<Address> recipients = null;

        MultipleKeysRecipientGenerator(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                HashSet<Address> addresses = new HashSet<Address>();
                Map<Object, List<Address>> recipientsMap = DistributionInterceptor.this.dm.locateAll(this.keys);
                for (List<Address> a : recipientsMap.values()) {
                    addresses.addAll(a);
                }
                this.recipients = Immutables.immutableListConvert(addresses);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    class SingleKeyRecipientGenerator
    implements RecipientGenerator {
        final Object key;
        final Set<Object> keys;
        List<Address> recipients = null;

        SingleKeyRecipientGenerator(Object key) {
            this.key = key;
            this.keys = Collections.singleton(key);
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                this.recipients = DistributionInterceptor.this.dm.locate(this.key);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    static interface RecipientGenerator
    extends KeyGenerator {
        public List<Address> generateRecipients();
    }

    static interface KeyGenerator {
        public Collection<Object> getKeys();
    }
}

