/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;

public class VirtualAddress
implements Address {
    private final Address realAddress;
    private final int id;

    public VirtualAddress(Address realAddress, int id) {
        if (realAddress == null) {
            throw new IllegalArgumentException(Util.formatString("readAddress must not be null", new Object[0]));
        }
        this.realAddress = realAddress;
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Address getRealAddress() {
        return this.realAddress;
    }

    public int hashCode() {
        int result = this.realAddress.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualAddress) {
            VirtualAddress that = (VirtualAddress)obj;
            return this.realAddress.equals(that.realAddress) && this.id == that.id;
        }
        return false;
    }

    public String toString() {
        return Util.formatString("Virtual node %s residing on real node %s", this.id, this.realAddress);
    }

    public static class Externalizer
    extends AbstractExternalizer<VirtualAddress> {
        @Override
        public void writeObject(ObjectOutput output, VirtualAddress address) throws IOException {
            output.writeObject(address.realAddress);
            output.writeInt(address.id);
        }

        @Override
        public VirtualAddress readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            Address realAddress = (Address)unmarshaller.readObject();
            int id = unmarshaller.readInt();
            VirtualAddress address = new VirtualAddress(realAddress, id);
            return address;
        }

        @Override
        public Integer getId() {
            return 69;
        }

        @Override
        public Set<Class<? extends VirtualAddress>> getTypeClasses() {
            return Util.asSet(VirtualAddress.class);
        }
    }
}

