/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.infinispan.distribution.ch.AbstractWheelConsistentHash;
import org.infinispan.distribution.ch.NodeTopologyInfo;
import org.infinispan.distribution.ch.TopologyInfo;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.hash.Hash;

public class TopologyAwareConsistentHash
extends AbstractWheelConsistentHash {
    private TopologyInfo topologyInfo;

    public TopologyAwareConsistentHash() {
    }

    public TopologyAwareConsistentHash(Hash hash) {
        this.setHashFunction(hash);
    }

    @Override
    public List<Address> locate(Object key, int replCount) {
        Address owner = this.getOwner(key);
        if (this.trace) {
            this.log.trace((Object)"Owner of key %s identified as %s", key, owner);
        }
        int ownerCount = Math.min(replCount, this.caches.size());
        List<Address> owners = this.getOwners(owner, ownerCount);
        return owners;
    }

    @Override
    public List<Address> getStateProvidersOnLeave(Address leaver, int replCount) {
        HashSet<Address> result = new HashSet<Address>();
        Address realLeaver = this.getRealAddress(leaver);
        for (Address address : this.caches) {
            if (address.equals(leaver) || !this.getOwners(address, replCount).contains(realLeaver)) continue;
            result.add(address);
        }
        List<Address> addressList = this.getOwners(realLeaver, replCount);
        if (addressList.size() > 1) {
            result.add(addressList.get(1));
        }
        return new ArrayList<Address>(result);
    }

    @Override
    public List<Address> getStateProvidersOnJoin(Address joiner, int replCount) {
        return this.getStateProvidersOnLeave(joiner, replCount);
    }

    private List<Address> getOwners(Address address, int numOwners) {
        Address realAddress = this.getRealAddress(address);
        int ownerHash = this.getNormalizedHash(address);
        Collection beforeOnWheel = this.positions.headMap(ownerHash).values();
        Collection afterOnWheel = this.positions.tailMap(ownerHash).values();
        ArrayList processSequence = new ArrayList(afterOnWheel);
        processSequence.addAll(beforeOnWheel);
        ArrayList<Address> result = new ArrayList<Address>();
        result.add(this.getRealAddress((Address)processSequence.remove(0)));
        int level = 0;
        while (result.size() < numOwners) {
            Iterator addrIt = processSequence.iterator();
            while (addrIt.hasNext()) {
                Address a = (Address)addrIt.next();
                Address ra = this.getRealAddress(a);
                switch (level) {
                    case 0: {
                        if (this.topologyInfo.isSameSite(realAddress, ra)) break;
                        if (this.trace) {
                            this.log.trace((Object)"Owner (different site) identified as %s", a);
                        }
                        result.add(ra);
                        addrIt.remove();
                        break;
                    }
                    case 1: {
                        if (this.topologyInfo.isSameRack(realAddress, ra)) break;
                        if (this.trace) {
                            this.log.trace((Object)"Owner (different rack) identified as %s", a);
                        }
                        result.add(ra);
                        addrIt.remove();
                        break;
                    }
                    case 2: {
                        if (this.topologyInfo.isSameMachine(realAddress, ra)) break;
                        if (this.trace) {
                            this.log.trace((Object)"Owner (different machine) identified as %s", a);
                        }
                        result.add(ra);
                        addrIt.remove();
                        break;
                    }
                    case 3: {
                        if (this.trace) {
                            this.log.trace((Object)"Owner (same machine) identified as %s", a);
                        }
                        result.add(ra);
                        addrIt.remove();
                    }
                }
                if (result.size() != numOwners) continue;
                break;
            }
            ++level;
        }
        if (result.size() != numOwners) {
            throw new AssertionError((Object)"This should not happen!");
        }
        return result;
    }

    private Address getOwner(Object key) {
        int hash = this.getNormalizedHash(key);
        SortedMap map = this.positions.tailMap(hash);
        if (map.size() == 0) {
            return (Address)this.positions.get(this.positions.firstKey());
        }
        Integer ownerHash = map.firstKey();
        return (Address)this.positions.get(ownerHash);
    }

    @Override
    public void setTopologyInfo(TopologyInfo topologyInfo) {
        this.topologyInfo = topologyInfo;
    }

    public TopologyInfo getTopologyInfo() {
        return this.topologyInfo;
    }

    @Override
    public String toString() {
        return "TopologyAwareConsistentHash {addresses=" + this.caches + ", positions=" + this.positions + ", topologyInfo=" + this.topologyInfo + ", addressToHashIds=" + this.addressToHashIds + "}";
    }

    @Override
    protected boolean isVirtualNodesEnabled() {
        return this.numVirtualNodes > 1;
    }

    public static class Externalizer
    extends AbstractWheelConsistentHash.Externalizer<TopologyAwareConsistentHash> {
        @Override
        protected TopologyAwareConsistentHash instance() {
            return new TopologyAwareConsistentHash();
        }

        @Override
        public void writeObject(ObjectOutput output, TopologyAwareConsistentHash topologyAwareConsistentHash) throws IOException {
            super.writeObject(output, topologyAwareConsistentHash);
            Collection<NodeTopologyInfo> infoCollection = topologyAwareConsistentHash.topologyInfo.getAllTopologyInfo();
            output.writeInt(infoCollection.size());
            for (NodeTopologyInfo nti : infoCollection) {
                output.writeObject(nti);
            }
        }

        @Override
        public TopologyAwareConsistentHash readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            TopologyAwareConsistentHash ch = (TopologyAwareConsistentHash)super.readObject(unmarshaller);
            ch.topologyInfo = new TopologyInfo();
            int ntiCount = unmarshaller.readInt();
            for (int i = 0; i < ntiCount; ++i) {
                NodeTopologyInfo nti = (NodeTopologyInfo)unmarshaller.readObject();
                ch.topologyInfo.addNodeTopologyInfo(nti.getAddress(), nti);
            }
            return ch;
        }

        @Override
        public Integer getId() {
            return 61;
        }

        @Override
        public Set<Class<? extends TopologyAwareConsistentHash>> getTypeClasses() {
            return Util.asSet(TopologyAwareConsistentHash.class);
        }
    }
}

