/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.distribution.ch.AbstractConsistentHash;
import org.infinispan.distribution.ch.VirtualAddress;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.hash.Hash;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractWheelConsistentHash
extends AbstractConsistentHash {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final boolean trace = this.log.isTraceEnabled();
    protected SortedMap<Integer, Address> positions;
    protected Map<Address, Integer> addressToHashIds;
    protected Hash hashFunction;
    protected int numVirtualNodes;
    static final int HASH_SPACE = 10240;

    protected AbstractWheelConsistentHash() {
    }

    public void setHashFunction(Hash h) {
        this.hashFunction = h;
    }

    public void setNumVirtualNodes(Integer numVirtualNodes) {
        this.numVirtualNodes = numVirtualNodes;
    }

    @Override
    public void setCaches(Set<Address> newCaches) {
        this.caches = new LinkedHashSet(newCaches.size());
        this.positions = new TreeMap<Integer, Address>();
        this.addressToHashIds = new HashMap<Address, Integer>();
        if (this.trace) {
            this.log.trace((Object)"Adding %s nodes to cluster", newCaches.size());
        }
        for (Address a : newCaches) {
            if (this.isVirtualNodesEnabled()) {
                if (this.trace) {
                    this.log.trace((Object)"Adding %s virtual nodes for real node %s", this.numVirtualNodes, a);
                }
                for (int i = 0; i < this.numVirtualNodes; ++i) {
                    VirtualAddress va = new VirtualAddress(a, i);
                    if (this.trace) {
                        this.log.trace((Object)"Adding virtual node %s", va);
                    }
                    this.addNode(va);
                }
                continue;
            }
            if (this.trace) {
                this.log.trace((Object)"Adding node %s", a);
            }
            this.addNode(a);
        }
        this.caches.addAll(this.positions.values());
    }

    @Override
    public Set<Address> getCaches() {
        return this.getRealAddresses(this.caches);
    }

    protected void addNode(Address a) {
        int positionIndex = Math.abs(this.hashFunction.hash(a)) % 10240;
        while (this.positions.containsKey(positionIndex)) {
            ++positionIndex;
        }
        this.positions.put(positionIndex, a);
        if (!this.addressToHashIds.containsKey(a)) {
            this.addressToHashIds.put(a, positionIndex);
        }
        if (this.trace) {
            this.log.trace((Object)"Added node %s", a);
        }
    }

    protected Address getRealAddress(Address a) {
        if (this.isVirtualNodesEnabled()) {
            return ((VirtualAddress)a).getRealAddress();
        }
        return a;
    }

    protected List<Address> getRealAddresses(List<Address> virtualAddresses) {
        if (virtualAddresses.isEmpty()) {
            return Collections.emptyList();
        }
        if (virtualAddresses.size() == 1) {
            if (this.isVirtualNodesEnabled()) {
                VirtualAddress a = (VirtualAddress)virtualAddresses.iterator().next();
                return Collections.singletonList(a.getRealAddress());
            }
            return virtualAddresses;
        }
        if (this.isVirtualNodesEnabled()) {
            ArrayList<Address> addresses = new ArrayList<Address>();
            for (Address a : virtualAddresses) {
                VirtualAddress va = (VirtualAddress)a;
                addresses.add(va.getRealAddress());
            }
            return addresses;
        }
        return virtualAddresses;
    }

    protected Set<Address> getRealAddresses(Set<Address> virtualAddresses) {
        if (virtualAddresses.isEmpty()) {
            return Collections.emptySet();
        }
        if (virtualAddresses.size() == 1) {
            if (this.isVirtualNodesEnabled()) {
                VirtualAddress a = (VirtualAddress)virtualAddresses.iterator().next();
                return Collections.singleton(a.getRealAddress());
            }
            return virtualAddresses;
        }
        if (this.isVirtualNodesEnabled()) {
            HashSet<Address> addresses = new HashSet<Address>();
            for (Address a : virtualAddresses) {
                VirtualAddress va = (VirtualAddress)a;
                addresses.add(va.getRealAddress());
            }
            return addresses;
        }
        return virtualAddresses;
    }

    @Override
    public List<Address> getBackupsForNode(Address node, int replCount) {
        return this.locate(node, replCount);
    }

    @Override
    public int getHashSpace() {
        return 10240;
    }

    @Override
    public int getHashId(Address a) {
        Integer hashId = this.addressToHashIds.get(a);
        if (hashId == null) {
            return -1;
        }
        return hashId;
    }

    public int getNormalizedHash(Object key) {
        int keyHashCode = this.hashFunction.hash(key);
        if (keyHashCode == Integer.MIN_VALUE) {
            ++keyHashCode;
        }
        return Math.abs(keyHashCode) % 10240;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {" + "addresses=" + this.caches + ", positions=" + this.positions + ", addressToHashIds=" + this.addressToHashIds + "}";
    }

    protected boolean isVirtualNodesEnabled() {
        return false;
    }

    public static abstract class Externalizer<T extends AbstractWheelConsistentHash>
    extends AbstractExternalizer<T> {
        protected abstract T instance();

        @Override
        public void writeObject(ObjectOutput output, T abstractWheelConsistentHash) throws IOException {
            output.writeObject(((AbstractWheelConsistentHash)abstractWheelConsistentHash).hashFunction.getClass().getName());
            output.writeObject(((AbstractWheelConsistentHash)abstractWheelConsistentHash).caches);
            output.writeObject(((AbstractWheelConsistentHash)abstractWheelConsistentHash).positions);
            output.writeObject(((AbstractWheelConsistentHash)abstractWheelConsistentHash).addressToHashIds);
            output.writeInt(((AbstractWheelConsistentHash)abstractWheelConsistentHash).numVirtualNodes);
        }

        @Override
        public T readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            T abstractWheelConsistentHash = this.instance();
            String hashFuctionName = (String)unmarshaller.readObject();
            ((AbstractWheelConsistentHash)abstractWheelConsistentHash).setHashFunction((Hash)Util.getInstance(hashFuctionName));
            ((AbstractWheelConsistentHash)abstractWheelConsistentHash).caches = (Set)unmarshaller.readObject();
            ((AbstractWheelConsistentHash)abstractWheelConsistentHash).positions = (SortedMap)unmarshaller.readObject();
            ((AbstractWheelConsistentHash)abstractWheelConsistentHash).addressToHashIds = (Map)unmarshaller.readObject();
            ((AbstractWheelConsistentHash)abstractWheelConsistentHash).numVirtualNodes = unmarshaller.readInt();
            return abstractWheelConsistentHash;
        }
    }
}

