/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.RemoteTransactionLogDetails;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.NodeTopologyInfo;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RehashControlCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 17;
    Type type;
    Address sender;
    Map<Object, InternalCacheValue> state;
    ConsistentHash oldCH;
    List<Address> nodesLeft;
    ConsistentHash newCH;
    DistributionManager distributionManager;
    Transport transport;
    Configuration configuration;
    DataContainer dataContainer;
    List<WriteCommand> txLogCommands;
    List<PrepareCommand> pendingPrepares;
    CommandsFactory commandsFactory;
    NodeTopologyInfo nodeTopologyInfo;
    private static final Log log = LogFactory.getLog(RehashControlCommand.class);

    public RehashControlCommand() {
    }

    public RehashControlCommand(String cacheName, Type type, Address sender, Map<Object, InternalCacheValue> state, ConsistentHash oldConsistentHash, ConsistentHash consistentHash, List<Address> leavers, CommandsFactory commandsFactory) {
        super(cacheName);
        this.type = type;
        this.sender = sender;
        this.state = state;
        this.oldCH = oldConsistentHash;
        this.newCH = consistentHash;
        this.nodesLeft = leavers;
        this.commandsFactory = commandsFactory;
    }

    public RehashControlCommand(String cacheName, Type type, Address sender, List<WriteCommand> txLogCommands, List<PrepareCommand> pendingPrepares, CommandsFactory commandsFactory) {
        super(cacheName);
        this.type = type;
        this.sender = sender;
        this.txLogCommands = txLogCommands;
        this.pendingPrepares = pendingPrepares;
        this.commandsFactory = commandsFactory;
    }

    public RehashControlCommand(Transport transport) {
        this.transport = transport;
    }

    public void init(DistributionManager distributionManager, Configuration configuration, DataContainer dataContainer, CommandsFactory commandsFactory) {
        this.distributionManager = distributionManager;
        this.configuration = configuration;
        this.dataContainer = dataContainer;
        this.commandsFactory = commandsFactory;
        for (List commandList : Arrays.asList(this.txLogCommands, this.pendingPrepares)) {
            if (commandList == null) continue;
            for (ReplicableCommand cmd : commandList) {
                commandsFactory.initializeReplicableCommand(cmd, false);
            }
        }
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        switch (this.type) {
            case JOIN_REQ: {
                return this.distributionManager.requestPermissionToJoin(this.sender);
            }
            case JOIN_REHASH_START: {
                return this.distributionManager.informRehashOnJoin(this.sender, true, this.nodeTopologyInfo);
            }
            case JOIN_REHASH_END: {
                this.distributionManager.informRehashOnJoin(this.sender, false, this.nodeTopologyInfo);
                return null;
            }
            case LEAVE_REHASH_END: {
                this.distributionManager.informRehashOnLeave(this.sender);
                return null;
            }
            case PULL_STATE_JOIN: {
                return this.pullStateForJoin();
            }
            case PULL_STATE_LEAVE: {
                return this.pullStateForLeave();
            }
            case LEAVE_DRAIN_TX: {
                this.distributionManager.applyRemoteTxLog(this.txLogCommands);
                return null;
            }
            case LEAVE_DRAIN_TX_PREPARES: {
                for (PrepareCommand pc : this.pendingPrepares) {
                    pc.perform(null);
                }
                return null;
            }
            case JOIN_TX_LOG_REQ: {
                return this.drainTxLog();
            }
            case JOIN_TX_FINAL_LOG_REQ: {
                return this.lockAndDrainTxLog();
            }
            case JOIN_TX_LOG_CLOSE: {
                this.unlockAndCloseTxLog();
                return null;
            }
            case JOIN_ABORT: {
                this.distributionManager.abortJoin(this.sender);
                return null;
            }
            case FETCH_TOPOLOGY_INFO: {
                return this.distributionManager.getTopologyInfo().getAllTopologyInfo();
            }
        }
        throw new CacheException("Unknown rehash control command type " + (Object)((Object)this.type));
    }

    private RemoteTransactionLogDetails drainTxLog() {
        TransactionLogger tl = this.distributionManager.getTransactionLogger();
        List<WriteCommand> mods = tl.drain();
        return new RemoteTransactionLogDetails(tl.shouldDrainWithoutLock(), mods, null);
    }

    private RemoteTransactionLogDetails lockAndDrainTxLog() {
        TransactionLogger tl = this.distributionManager.getTransactionLogger();
        return new RemoteTransactionLogDetails(false, tl.drainAndLock(this.sender), tl.getPendingPrepares());
    }

    private void unlockAndCloseTxLog() {
        TransactionLogger tl = this.distributionManager.getTransactionLogger();
        tl.unlockAndDisable(this.sender);
    }

    public Map<Object, InternalCacheValue> pullStateForJoin() throws CacheLoaderException {
        this.distributionManager.getTransactionLogger().enable();
        HashMap<Object, InternalCacheValue> state = new HashMap<Object, InternalCacheValue>();
        for (InternalCacheEntry ice : this.dataContainer) {
            Object k = ice.getKey();
            if (!this.shouldTransferOwnershipToJoinNode(k)) continue;
            state.put(k, ice.toInternalCacheValue());
        }
        CacheStore cacheStore = this.distributionManager.getCacheStoreForRehashing();
        if (cacheStore != null) {
            for (Object k : cacheStore.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer))) {
                InternalCacheValue v;
                if (state.containsKey(k) || !this.shouldTransferOwnershipToJoinNode(k) || (v = this.loadValue(cacheStore, k)) == null) continue;
                state.put(k, v);
            }
        }
        return state;
    }

    public Map<Object, InternalCacheValue> pullStateForLeave() throws CacheLoaderException {
        HashMap<Object, InternalCacheValue> state = new HashMap<Object, InternalCacheValue>();
        for (InternalCacheEntry ice : this.dataContainer) {
            Object k = ice.getKey();
            if (!this.shouldTransferOwnershipFromLeftNodes(k)) continue;
            state.put(k, ice.toInternalCacheValue());
        }
        CacheStore cacheStore = this.distributionManager.getCacheStoreForRehashing();
        if (cacheStore != null) {
            for (Object k : cacheStore.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer))) {
                InternalCacheValue v;
                if (state.containsKey(k) || !this.shouldTransferOwnershipFromLeftNodes(k) || (v = this.loadValue(cacheStore, k)) == null) continue;
                state.put(k, v);
            }
        }
        return state;
    }

    private boolean shouldTransferOwnershipFromLeftNodes(Object k) {
        Address self = this.transport.getAddress();
        int numCopies = this.configuration.getNumOwners();
        List<Address> oldList = this.oldCH.locate(k, numCopies);
        boolean localToThisNode = oldList.indexOf(self) >= 0;
        boolean senderIsNewOwner = this.newCH.isKeyLocalToAddress(this.sender, k, numCopies);
        for (Address leftNodeAddress : this.nodesLeft) {
            boolean localToLeftNode = oldList.indexOf(leftNodeAddress) >= 0;
            if (!localToLeftNode || !senderIsNewOwner || !localToThisNode) continue;
            return true;
        }
        return false;
    }

    private InternalCacheValue loadValue(CacheStore cs, Object k) {
        try {
            InternalCacheEntry ice = cs.load(k);
            return ice == null ? null : ice.toInternalCacheValue();
        }
        catch (CacheLoaderException cle) {
            log.warn((Object)("Unable to load " + k + " from cache loader"), cle);
            return null;
        }
    }

    final boolean shouldTransferOwnershipToJoinNode(Object k) {
        List<Address> newOwnerList;
        Address self = this.transport.getAddress();
        int numCopies = this.configuration.getNumOwners();
        List<Address> oldOwnerList = this.oldCH.locate(k, numCopies);
        return !oldOwnerList.isEmpty() && self.equals(oldOwnerList.get(0)) && (newOwnerList = this.newCH.locate(k, numCopies)).contains(this.sender);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public byte getCommandId() {
        return 17;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.cacheName, (byte)this.type.ordinal(), this.sender, this.state, this.oldCH, this.nodesLeft, this.newCH, this.txLogCommands, this.pendingPrepares, this.nodeTopologyInfo};
    }

    public void setNodeTopologyInfo(NodeTopologyInfo nodeTopologyInfo) {
        this.nodeTopologyInfo = nodeTopologyInfo;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.cacheName = (String)parameters[i++];
        this.type = Type.values()[(Byte)parameters[i++]];
        this.sender = (Address)parameters[i++];
        this.state = (Map)parameters[i++];
        this.oldCH = (ConsistentHash)parameters[i++];
        this.nodesLeft = (List)parameters[i++];
        this.newCH = (ConsistentHash)parameters[i++];
        this.txLogCommands = (List)parameters[i++];
        this.pendingPrepares = (List)parameters[i++];
        this.nodeTopologyInfo = (NodeTopologyInfo)parameters[i++];
    }

    @Override
    public String toString() {
        return "RehashControlCommand{type=" + (Object)((Object)this.type) + ", sender=" + this.sender + ", state=" + (this.state == null ? "N/A" : Integer.valueOf(this.state.size())) + ", oldConsistentHash=" + this.oldCH + ", nodesLeft=" + this.nodesLeft + ", consistentHash=" + this.newCH + ", txLogCommands=" + (this.txLogCommands == null ? "N/A" : Integer.valueOf(this.txLogCommands.size())) + ", pendingPrepares=" + (this.pendingPrepares == null ? "N/A" : Integer.valueOf(this.pendingPrepares.size())) + ", nodeTopologyInfo=" + this.nodeTopologyInfo + '}';
    }

    public static enum Type {
        JOIN_REQ,
        JOIN_REHASH_START,
        JOIN_REHASH_END,
        PULL_STATE_JOIN,
        PULL_STATE_LEAVE,
        LEAVE_REHASH_END,
        LEAVE_DRAIN_TX,
        LEAVE_DRAIN_TX_PREPARES,
        JOIN_TX_LOG_REQ,
        JOIN_TX_FINAL_LOG_REQ,
        JOIN_TX_LOG_CLOSE,
        FETCH_TOPOLOGY_INFO,
        JOIN_ABORT;

    }
}

