/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.config.ConfigurationException;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.util.Proxies;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ModuleProperties
extends Properties {
    private static final long serialVersionUID = 2558131508076199744L;
    private static final Log log = LogFactory.getLog(ModuleProperties.class);
    public static final String MODULE_PROPERTIES_FILENAME = "infinispan-module.properties";
    public static final String MODULE_NAME_KEY = "infinispan.module.name";
    public static final String MODULE_CONFIGURATION_CLASS = "infinispan.module.configurationClassName";
    public static final String MODULE_LIFECYCLE = "infinispan.module.lifecycle";
    public static final String MODULE_COMMAND_INITIALIZER = "infinispan.module.command.initializer";
    public static final String MODULE_COMMAND_FACTORY = "infinispan.module.command.factory";
    private static Map<String, ModuleProperties> moduleProperties;
    private static Map<Byte, ModuleCommandFactory> commandFactories;
    private static Map<Byte, Class<? extends ModuleCommandInitializer>> commandInitializers;
    private static Collection<Class<? extends ReplicableCommand>> moduleCommands;

    protected static Enumeration<URL> getResources(String filename) throws IOException {
        Enumeration<URL> result;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enumeration = result = cl == null ? null : cl.getResources(filename);
        if (result == null) {
            result = ModuleProperties.class.getClassLoader().getResources(filename);
        }
        return result;
    }

    public static ModuleProperties loadModuleProperties(String moduleName) throws IOException {
        Enumeration<URL> resources = ModuleProperties.getResources(MODULE_PROPERTIES_FILENAME);
        if (resources == null) {
            throw new IOException("Could not find infinispan-module.properties files on classpath for module " + moduleName);
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            ModuleProperties props = new ModuleProperties();
            props.load(url.openStream());
            props.verify();
            if (!props.getName().equalsIgnoreCase(moduleName)) continue;
            return props;
        }
        return null;
    }

    private static Map<String, ModuleProperties> loadModuleProperties() throws IOException {
        HashMap<String, ModuleProperties> map = new HashMap<String, ModuleProperties>();
        Enumeration<URL> resources = ModuleProperties.getResources(MODULE_PROPERTIES_FILENAME);
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = null;
                try {
                    url = resources.nextElement();
                    ModuleProperties props = new ModuleProperties();
                    props.load(url.openStream());
                    props.verify();
                    map.put(props.getName(), props);
                }
                catch (Exception e) {
                    log.warn((Object)("Could not load module at URL " + url), e);
                }
            }
        }
        return map;
    }

    private static Map<String, ModuleProperties> getModuleProperties() throws IOException {
        if (moduleProperties == null) {
            moduleProperties = ModuleProperties.loadModuleProperties();
        }
        return moduleProperties;
    }

    public static List<ModuleLifecycle> resolveModuleLifecycles() {
        try {
            ArrayList<ModuleLifecycle> lifecycles = new ArrayList<ModuleLifecycle>();
            Map<String, ModuleProperties> p = ModuleProperties.getModuleProperties();
            for (Map.Entry<String, ModuleProperties> m : p.entrySet()) {
                try {
                    String lifecycleClassName = m.getValue().getLifecycleClassName();
                    if (lifecycleClassName == null || lifecycleClassName.isEmpty()) continue;
                    Class loadClass = Util.loadClassStrict(lifecycleClassName);
                    Object proxy = Proxies.newCatchThrowableProxy(loadClass.newInstance());
                    ModuleLifecycle ml = (ModuleLifecycle)proxy;
                    lifecycles.add(ml);
                }
                catch (Exception e) {
                    log.warn((Object)("Module " + m.getKey() + " loaded, but could not be initialized "), e);
                }
            }
            return lifecycles;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public String getName() {
        return super.getProperty(MODULE_NAME_KEY);
    }

    public String getConfigurationClassName() {
        return super.getProperty(MODULE_CONFIGURATION_CLASS);
    }

    public String getLifecycleClassName() {
        return super.getProperty(MODULE_LIFECYCLE);
    }

    public String getCommandInitializerClassName() {
        return super.getProperty(MODULE_COMMAND_INITIALIZER);
    }

    public String getCommandFactoryClassName() {
        return super.getProperty(MODULE_COMMAND_FACTORY);
    }

    protected void verify() {
        if (this.getName() == null) {
            throw new ConfigurationException("Module properties does not specify module name. Module name should be specified using key infinispan.module.name");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadModuleCommandHandlers() {
        try {
            commandFactories = new HashMap<Byte, ModuleCommandFactory>(1);
            commandInitializers = new HashMap<Byte, Class<? extends ModuleCommandInitializer>>(1);
            moduleCommands = new HashSet<Class<? extends ReplicableCommand>>(1);
            Map<String, ModuleProperties> p = ModuleProperties.getModuleProperties();
            for (Map.Entry<String, ModuleProperties> module : p.entrySet()) {
                String factClass = module.getValue().getCommandFactoryClassName();
                String initClass = module.getValue().getCommandInitializerClassName();
                if (factClass == null || initClass == null) continue;
                try {
                    ModuleCommandFactory fact = (ModuleCommandFactory)Util.getInstance(factClass);
                    Class initClazz = Util.loadClass(initClass);
                    for (Map.Entry<Byte, Class<? extends ReplicableCommand>> entry : fact.getModuleCommands().entrySet()) {
                        byte id = entry.getKey();
                        if (commandFactories.containsKey(id)) {
                            throw new IllegalArgumentException("Module " + module.getKey() + " cannot use id " + id + " for commands, as it is already in use by " + commandFactories.get(id).getClass().getName());
                        }
                        commandFactories.put(id, fact);
                        commandInitializers.put(id, initClazz);
                        moduleCommands.add(entry.getValue());
                    }
                }
                catch (Exception e) {
                    throw new CacheException("Unable to load factory class " + factClass + " for module " + module.getKey());
                    return;
                }
            }
        }
        catch (IOException ioe) {
            commandInitializers = Collections.emptyMap();
            commandFactories = Collections.emptyMap();
            throw new CacheException("IO Exception reading module properties file!", ioe);
        }
    }

    public static Collection<Class<? extends ReplicableCommand>> moduleCommands() {
        if (moduleCommands == null) {
            ModuleProperties.loadModuleCommandHandlers();
        }
        return moduleCommands;
    }

    public static Map<Byte, ModuleCommandFactory> moduleCommandFactories() {
        if (commandFactories == null) {
            ModuleProperties.loadModuleCommandHandlers();
        }
        return commandFactories;
    }

    public static Map<Byte, ModuleCommandInitializer> moduleCommandInitializers() {
        if (commandInitializers == null) {
            ModuleProperties.loadModuleCommandHandlers();
        }
        if (commandInitializers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Byte, ModuleCommandInitializer> initializers = new HashMap<Byte, ModuleCommandInitializer>(commandInitializers.size());
        for (Map.Entry<Byte, Class<? extends ModuleCommandInitializer>> e : commandInitializers.entrySet()) {
            initializers.put(e.getKey(), Util.getInstance(e.getValue()));
        }
        return initializers;
    }
}

