/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryAwareLocalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.infinispan.transaction.xa.recovery.XidAware;

public class RecoveryAwareTransactionTable
extends XaTransactionTable {
    private RecoveryManagerImpl recoveryManager;

    @Inject
    public void initialize(RecoveryManager recoveryManager) {
        this.recoveryManager = (RecoveryManagerImpl)recoveryManager;
    }

    @Override
    public void remoteTransactionPrepared(GlobalTransaction gtx) {
        RecoveryAwareRemoteTransaction remoteTransaction = (RecoveryAwareRemoteTransaction)this.remoteTransactions.get(gtx);
        remoteTransaction.setPrepared(true);
        RemoteTransaction preparedTx = (RemoteTransaction)this.remoteTransactions.remove(remoteTransaction.getGlobalTransaction());
        if (preparedTx == null) {
            throw new IllegalStateException("This tx has just been prepared, cannot be missing from here!");
        }
        this.recoveryManager.registerPreparedTransaction(remoteTransaction);
    }

    @Override
    public void localTransactionPrepared(LocalTransaction localTransaction) {
        ((RecoveryAwareLocalTransaction)localTransaction).setPrepared(true);
    }

    @Override
    protected void updateStateOnNodesLeaving(List<Address> leavers) {
        this.recoveryManager.nodesLeft(leavers);
        super.updateStateOnNodesLeaving(leavers);
    }

    @Override
    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        RemoteTransaction remoteTransaction = (RemoteTransaction)this.remoteTransactions.get(txId);
        if (remoteTransaction != null) {
            return remoteTransaction;
        }
        return this.recoveryManager.getPreparedTransaction(((XidAware)((Object)txId)).getXid());
    }

    @Override
    public void remoteTransactionCompleted(GlobalTransaction gtx) {
        this.recoveryManager.remoteTransactionCompleted(gtx);
    }

    public List<Xid> getLocalPreparedXids() {
        LinkedList<Xid> result = new LinkedList<Xid>();
        for (Map.Entry e : this.xid2LocalTx.entrySet()) {
            RecoveryAwareLocalTransaction value = (RecoveryAwareLocalTransaction)e.getValue();
            if (!value.isPrepared()) continue;
            result.add((Xid)e.getKey());
        }
        return result;
    }
}

