/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.util.List;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RecoveryAwareRemoteTransaction
extends RemoteTransaction
implements RecoveryAwareTransaction {
    private static Log log = LogFactory.getLog(RecoveryAwareRemoteTransaction.class);
    private boolean prepared;
    private boolean isOrphan;

    public RecoveryAwareRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
        super(modifications, tx);
    }

    public RecoveryAwareRemoteTransaction(GlobalTransaction tx) {
        super(tx);
    }

    public boolean isInDoubt() {
        return this.isPrepared() && this.isOrphan();
    }

    public boolean isOrphan() {
        return this.isOrphan;
    }

    public void computeOrphan(List<Address> leavers) {
        if (leavers.contains(this.getGlobalTransaction().getAddress())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"This transaction's originator has left the cluster: %s", this.getGlobalTransaction());
            }
            this.isOrphan = true;
        }
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    @Override
    public String toString() {
        return "RecoveryAwareRemoteTransaction{prepared=" + this.prepared + ", isOrphan=" + this.isOrphan + ", modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", tx=" + this.tx + "} ";
    }
}

