/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.Random;
import javax.transaction.Transaction;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareDldGlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareGlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareLocalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionFactory {
    private static Log log = LogFactory.getLog(TransactionFactory.class);
    private TxFactoryEnum txFactoryEnum;

    public GlobalTransaction newGlobalTransaction() {
        return this.txFactoryEnum.newGlobalTransaction();
    }

    public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
        return this.txFactoryEnum.newGlobalTransaction(addr, remote);
    }

    public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
        return this.txFactoryEnum.newLocalTransaction(tx, gtx);
    }

    public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
        return this.txFactoryEnum.newRemoteTransaction(modifications, tx);
    }

    public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
        return this.txFactoryEnum.newRemoteTransaction(tx);
    }

    public TransactionFactory() {
        this.init(false, false, true);
    }

    public TransactionFactory(boolean dldEnabled) {
        this.init(dldEnabled, false, true);
    }

    public TransactionFactory(boolean dldEnabled, boolean recoveryEnabled) {
        this.init(dldEnabled, recoveryEnabled, true);
    }

    @Inject
    public void init(Configuration configuration) {
        boolean dldEnabled = configuration.isEnableDeadlockDetection();
        boolean recoveryEnabled = configuration.isTransactionRecoveryEnabled();
        boolean xa = !configuration.isUseSynchronizationForTransactions();
        this.init(dldEnabled, recoveryEnabled, xa);
    }

    private void init(boolean dldEnabled, boolean recoveryEnabled, boolean xa) {
        if (dldEnabled && recoveryEnabled && xa) {
            this.txFactoryEnum = TxFactoryEnum.DLD_RECOVERY_XA;
        }
        if (dldEnabled && !recoveryEnabled && xa) {
            this.txFactoryEnum = TxFactoryEnum.DLD_NORECOVERY_XA;
        }
        if (dldEnabled && !recoveryEnabled && !xa) {
            this.txFactoryEnum = TxFactoryEnum.DLD_NORECOVERY_NOXA;
        }
        if (!dldEnabled && recoveryEnabled && xa) {
            this.txFactoryEnum = TxFactoryEnum.NODLD_RECOVERY_XA;
        }
        if (!dldEnabled && !recoveryEnabled && xa) {
            this.txFactoryEnum = TxFactoryEnum.NODLD_NORECOVERY_XA;
        }
        if (!(dldEnabled || recoveryEnabled || xa)) {
            this.txFactoryEnum = TxFactoryEnum.NODLD_NORECOVERY_NOXA;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Setting factory enum to %s", new Object[]{this.txFactoryEnum});
        }
        if (this.txFactoryEnum == null) {
            log.error((Object)"Unsupported combination (dldEnabled, recoveryEnabled, xa) = (%s, %s, %s)", dldEnabled, recoveryEnabled, xa);
            throw new IllegalStateException("Unsupported combination (dldEnabled, recoveryEnabled, xa) = (" + dldEnabled + ", " + recoveryEnabled + ", " + xa + ")");
        }
    }

    private static enum TxFactoryEnum {
        DLD_RECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new RecoveryAwareLocalTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
                return this.addToinCoss(new RecoveryAwareDldGlobalTransaction(addr, remote));
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new RecoveryAwareDldGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RecoveryAwareRemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RecoveryAwareRemoteTransaction(tx);
            }
        }
        ,
        DLD_NORECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new LocalXaTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
                return this.addToinCoss(new DldGlobalTransaction(addr, remote));
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new DldGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RemoteTransaction(tx);
            }
        }
        ,
        DLD_NORECOVERY_NOXA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new SyncLocalTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
                return this.addToinCoss(new DldGlobalTransaction(addr, remote));
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new DldGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RemoteTransaction(tx);
            }
        }
        ,
        NODLD_RECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new RecoveryAwareLocalTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
                return new RecoveryAwareGlobalTransaction(addr, remote);
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new RecoveryAwareGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RecoveryAwareRemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RecoveryAwareRemoteTransaction(tx);
            }
        }
        ,
        NODLD_NORECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new LocalXaTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
                return new GlobalTransaction(addr, remote);
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new GlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RemoteTransaction(tx);
            }
        }
        ,
        NODLD_NORECOVERY_NOXA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new SyncLocalTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
                return new GlobalTransaction(addr, remote);
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new GlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RemoteTransaction(tx);
            }
        };

        private final Random rnd = new Random();

        public abstract LocalTransaction newLocalTransaction(Transaction var1, GlobalTransaction var2);

        public abstract GlobalTransaction newGlobalTransaction(Address var1, boolean var2);

        public abstract GlobalTransaction newGlobalTransaction();

        protected long generateRandomId() {
            return this.rnd.nextLong();
        }

        protected GlobalTransaction addToinCoss(DldGlobalTransaction dldGlobalTransaction) {
            dldGlobalTransaction.setCoinToss(this.generateRandomId());
            return dldGlobalTransaction;
        }

        public abstract RemoteTransaction newRemoteTransaction(WriteCommand[] var1, GlobalTransaction var2);

        public abstract RemoteTransaction newRemoteTransaction(GlobalTransaction var1);
    }
}

