/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.NamedCacheNotFoundException;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.ExtendedResponse;
import org.infinispan.remoting.responses.RequestIgnoredResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.DistributedSync;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateTransferException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class InboundInvocationHandlerImpl
implements InboundInvocationHandler {
    GlobalComponentRegistry gcr;
    private static final Log log = LogFactory.getLog(InboundInvocationHandlerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private StreamingMarshaller marshaller;
    private EmbeddedCacheManager embeddedCacheManager;
    private GlobalConfiguration globalConfiguration;
    private Transport transport;
    private DistributedSync distributedSync;
    private long distributedSyncTimeout;
    private static final long timeBeforeWeEnqueueCallForRetry = 10000L;
    private final Map<String, RetryQueue> retryThreadMap = Collections.synchronizedMap(new HashMap());

    @Inject
    public void inject(GlobalComponentRegistry gcr, StreamingMarshaller marshaller, EmbeddedCacheManager embeddedCacheManager, Transport transport, GlobalConfiguration globalConfiguration) {
        this.gcr = gcr;
        this.marshaller = marshaller;
        this.embeddedCacheManager = embeddedCacheManager;
        this.transport = transport;
        this.globalConfiguration = globalConfiguration;
    }

    @Start
    public void start() {
        this.distributedSync = this.transport.getDistributedSync();
        this.distributedSyncTimeout = this.globalConfiguration.getDistributedSyncTimeout();
    }

    private boolean isDefined(String cacheName) {
        return "___defaultcache".equals(cacheName) || this.embeddedCacheManager.getCacheNames().contains(cacheName);
    }

    public void waitForStart(CacheRpcCommand cmd) {
        if (cmd.getConfiguration().getCacheMode().isDistributed()) {
            cmd.getComponentRegistry().getComponent(DistributionManager.class).waitForFinalJoin();
        }
    }

    @Override
    public Response handle(CacheRpcCommand cmd, Address origin) throws Throwable {
        cmd.setOrigin(origin);
        String cacheName = cmd.getCacheName();
        ComponentRegistry cr = this.gcr.getNamedComponentRegistry(cacheName);
        if (cr == null) {
            if (this.embeddedCacheManager.getGlobalConfiguration().isStrictPeerToPeer() && this.isDefined(cacheName)) {
                log.info("Will try and wait for the cache to start");
                long giveupTime = System.currentTimeMillis() + 30000L;
                while (cr == null && System.currentTimeMillis() < giveupTime) {
                    Thread.sleep(100L);
                    cr = this.gcr.getNamedComponentRegistry(cacheName);
                }
            }
            if (cr == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Cache named %s does not exist on this cache manager!", cacheName);
                }
                return new ExceptionResponse(new NamedCacheNotFoundException(cacheName));
            }
        }
        Configuration localConfig = cr.getComponent(Configuration.class);
        cmd.injectComponents(localConfig, cr);
        return this.handleWithRetry(cmd);
    }

    private Response handleInternal(CacheRpcCommand cmd) throws Throwable {
        ComponentRegistry cr = cmd.getComponentRegistry();
        CommandsFactory commandsFactory = cr.getLocalComponent(CommandsFactory.class);
        commandsFactory.initializeReplicableCommand(cmd, true);
        try {
            log.trace((Object)"Calling perform() on %s", cmd);
            ResponseGenerator respGen = cr.getComponent(ResponseGenerator.class);
            Object retval = cmd.perform(null);
            return respGen.getResponse(cmd, retval);
        }
        catch (Exception e) {
            return new ExceptionResponse(e);
        }
    }

    private Response handleWithWaitForBlocks(CacheRpcCommand cmd, long distSyncTimeout) throws Throwable {
        DistributedSync.SyncResponse sr = this.distributedSync.blockUntilReleased(distSyncTimeout, TimeUnit.MILLISECONDS);
        boolean replayIgnored = sr == DistributedSync.SyncResponse.STATE_ACHIEVED;
        Response resp = this.handleInternal(cmd);
        if (resp == null || resp.isValid()) {
            if (replayIgnored) {
                resp = new ExtendedResponse(resp, true);
            }
        } else if (trace) {
            log.trace("Unable to execute command, got invalid response");
        }
        return resp;
    }

    public JoinHandle howToHandle(CacheRpcCommand cmd) {
        Configuration localConfig = cmd.getConfiguration();
        ComponentRegistry cr = cmd.getComponentRegistry();
        if (localConfig.getCacheMode().isDistributed()) {
            DistributionManager dm = cr.getComponent(DistributionManager.class);
            if (dm.isJoinComplete()) {
                return JoinHandle.OK;
            }
            if (dm.isInFinalJoinPhase() && !(cmd instanceof ClusteredGetCommand)) {
                return JoinHandle.QUEUE;
            }
            return JoinHandle.IGNORE;
        }
        long giveupTime = System.currentTimeMillis() + localConfig.getStateRetrievalTimeout();
        while (cr.getStatus().startingUp() && System.currentTimeMillis() < giveupTime) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
        }
        if (!cr.getStatus().allowInvocations()) {
            log.info((Object)"Cache named [%s] exists but isn't in a state to handle invocations.  Its state is %s.", new Object[]{cmd.getCacheName(), cr.getStatus()});
            return JoinHandle.IGNORE;
        }
        return JoinHandle.OK;
    }

    @Override
    public void applyState(String cacheName, InputStream i) throws StateTransferException {
        this.getStateTransferManager(cacheName).applyState(i);
    }

    @Override
    public void generateState(String cacheName, OutputStream o) throws StateTransferException {
        StateTransferManager manager = this.getStateTransferManager(cacheName);
        if (manager == null) {
            ObjectOutput oo = null;
            try {
                oo = this.marshaller.startObjectOutput(o, false);
                this.marshaller.objectToObjectStream(false, oo);
            }
            catch (Exception e) {
                throw new StateTransferException(e);
            }
            finally {
                this.marshaller.finishObjectOutput(oo);
            }
        } else {
            manager.generateState(o);
        }
    }

    private StateTransferManager getStateTransferManager(String cacheName) throws StateTransferException {
        ComponentRegistry cr = this.gcr.getNamedComponentRegistry(cacheName);
        if (cr == null) {
            return null;
        }
        return cr.getComponent(StateTransferManager.class);
    }

    @Override
    public void blockTillNoLongerRetrying(String cacheName) {
        RetryQueue rq = this.getRetryQueue(cacheName);
        rq.blockUntilNoLongerRetrying();
    }

    /*
     * Exception decompiling
     */
    private Response handleWithRetry(CacheRpcCommand cmd) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RetryQueue getRetryQueue(String cacheName) {
        Map<String, RetryQueue> map = this.retryThreadMap;
        synchronized (map) {
            if (this.retryThreadMap.containsKey(cacheName)) {
                return this.retryThreadMap.get(cacheName);
            }
            RetryQueue rq = new RetryQueue(cacheName, this.transport.getAddress().toString());
            this.retryThreadMap.put(cacheName, rq);
            return rq;
        }
    }

    private boolean enqueueing(String cacheName) {
        return this.getRetryQueue((String)cacheName).enqueueing;
    }

    private Response enqueueCommand(CacheRpcCommand command) throws Throwable {
        return this.getRetryQueue(command.getCacheName()).enqueue(command);
    }

    private class RetryQueue
    extends Thread {
        boolean enqueueing;
        final BlockingQueue<CacheRpcCommand> queue;
        final ReentrantLock retryQueueLock;
        final ReclosableLatch enqueuedBlocker;

        private RetryQueue(String cacheName, String cacheAddress) {
            super("RetryQueueProcessor-" + (cacheName.equals("___defaultcache") ? "DEFAULT" : cacheName) + "@" + cacheAddress);
            this.enqueueing = false;
            this.queue = new LinkedBlockingQueue<CacheRpcCommand>();
            this.retryQueueLock = new ReentrantLock();
            this.enqueuedBlocker = new ReclosableLatch(true);
            this.setDaemon(true);
            this.setPriority(10);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response enqueue(CacheRpcCommand command) throws Throwable {
            this.retryQueueLock.lock();
            boolean unlock = false;
            try {
                if (this.enqueueing) {
                    log.trace((Object)"Enqueueing command %s since we are enqueueing.", command);
                    this.queue.add(command);
                    RequestIgnoredResponse requestIgnoredResponse = RequestIgnoredResponse.INSTANCE;
                    return requestIgnoredResponse;
                }
                if (InboundInvocationHandlerImpl.this.howToHandle(command) == JoinHandle.QUEUE) {
                    this.enqueueing = true;
                    this.enqueuedBlocker.close();
                    Response response = this.enqueue(command);
                    return response;
                }
                InboundInvocationHandlerImpl.this.distributedSync.acquireProcessingLock(false, 10000L, TimeUnit.MILLISECONDS);
                unlock = true;
                Response response = InboundInvocationHandlerImpl.this.handleWithWaitForBlocks(command, InboundInvocationHandlerImpl.this.distributedSyncTimeout);
                return response;
            }
            finally {
                if (unlock) {
                    InboundInvocationHandlerImpl.this.distributedSync.releaseProcessingLock(false);
                }
                this.retryQueueLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean running = true;
            while (running) {
                CacheRpcCommand c = null;
                boolean unlock = false;
                try {
                    c = this.queue.take();
                    InboundInvocationHandlerImpl.this.waitForStart(c);
                    InboundInvocationHandlerImpl.this.distributedSync.acquireProcessingLock(false, InboundInvocationHandlerImpl.this.distributedSyncTimeout, TimeUnit.MILLISECONDS);
                    unlock = true;
                    InboundInvocationHandlerImpl.this.handleInternal(c);
                    this.retryQueueLock.lock();
                    if (this.queue.isEmpty()) {
                        this.enqueueing = false;
                        this.enqueuedBlocker.open();
                    }
                    this.retryQueueLock.unlock();
                }
                catch (InterruptedException e) {
                    this.enqueueing = false;
                    this.enqueuedBlocker.open();
                    running = false;
                }
                catch (Throwable throwable) {
                    log.warn((Object)"Caught exception when handling command %s", throwable, c);
                }
                finally {
                    if (!unlock) continue;
                    InboundInvocationHandlerImpl.this.distributedSync.releaseProcessingLock(false);
                }
            }
        }

        public void blockUntilNoLongerRetrying() {
            try {
                this.enqueuedBlocker.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static enum JoinHandle {
        QUEUE,
        OK,
        IGNORE;

    }
}

