/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.Properties;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.util.Util;

class CacheLoaderConfigAdapter
extends XmlAdapter<AbstractCacheStoreConfig, CacheLoaderConfig> {
    CacheLoaderConfigAdapter() {
    }

    public AbstractCacheStoreConfig marshal(CacheLoaderConfig arg0) throws Exception {
        return (AbstractCacheStoreConfig)arg0;
    }

    public CacheLoaderConfig unmarshal(AbstractCacheStoreConfig storeConfig) throws Exception {
        CacheLoaderConfig clc;
        String clClass = storeConfig.getCacheLoaderClassName();
        if (clClass == null || clClass.length() == 0) {
            throw new ConfigurationException("Missing 'class'  attribute for cache loader configuration");
        }
        try {
            clc = this.instantiateCacheLoaderConfig(clClass);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to instantiate cache loader or configuration", e);
        }
        clc.setCacheLoaderClassName(clClass);
        Properties props = storeConfig.getProperties();
        if (props != null) {
            XmlConfigHelper.setValues(clc, props, false, true);
        }
        if (clc instanceof CacheStoreConfig) {
            CacheStoreConfig csc = (CacheStoreConfig)clc;
            csc.setFetchPersistentState(storeConfig.isFetchPersistentState());
            csc.setIgnoreModifications(storeConfig.isIgnoreModifications());
            csc.setPurgeOnStartup(storeConfig.isPurgeOnStartup());
            csc.setPurgeSynchronously(storeConfig.isPurgeSynchronously());
            csc.setSingletonStoreConfig(storeConfig.getSingletonStoreConfig());
            csc.setAsyncStoreConfig(storeConfig.getAsyncStoreConfig());
        }
        return clc;
    }

    private CacheLoaderConfig instantiateCacheLoaderConfig(String cacheLoaderImpl) throws Exception {
        Class<? extends CacheLoaderConfig> cacheLoaderConfigType;
        Class clazz = Util.loadClass(cacheLoaderImpl);
        CacheLoaderMetadata metadata = clazz.getAnnotation(CacheLoaderMetadata.class);
        if (metadata == null) {
            CacheLoader cl = (CacheLoader)Util.getInstance(clazz);
            cacheLoaderConfigType = cl.getConfigurationClass();
        } else {
            cacheLoaderConfigType = metadata.configurationClass();
        }
        return Util.getInstance(cacheLoaderConfigType);
    }
}

