/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.base;

import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.rpc.RpcManager;

public abstract class BaseRpcInterceptor
extends CommandInterceptor {
    protected RpcManager rpcManager;
    protected boolean defaultSynchronous;

    @Inject
    public void init(RpcManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    @Start
    public void init() {
        this.defaultSynchronous = this.configuration.getCacheMode().isSynchronous();
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (ctx.isOriginLocal()) {
            boolean sync = !command.isUnlock();
            command.setFlags(ctx.getFlags());
            this.rpcManager.broadcastRpcCommand(command, sync, false);
        }
        return retVal;
    }

    protected final boolean isSynchronous(InvocationContext ctx) {
        if (ctx.hasFlag(Flag.FORCE_SYNCHRONOUS)) {
            return true;
        }
        if (ctx.hasFlag(Flag.FORCE_ASYNCHRONOUS)) {
            return false;
        }
        return this.defaultSynchronous;
    }

    protected final boolean isLocalModeForced(InvocationContext ctx) {
        if (ctx.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (this.trace) {
                this.log.trace("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return true;
        }
        return false;
    }

    protected final boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        return ctx.isOriginLocal() && (ctx.hasModifications() || !ctx.getLockedKeys().isEmpty());
    }
}

