/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.config.ConfigurationException;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.container.DataContainer;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.util.Util;

@DefaultFactoryFor(classes={DataContainer.class})
public class DataContainerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (this.configuration.getDataContainer() != null) {
            return (T)this.configuration.getDataContainer();
        }
        if (this.configuration.getDataContainerClass() == DefaultDataContainer.class.getName()) {
            EvictionStrategy st = this.configuration.getEvictionStrategy();
            int level = this.configuration.getConcurrencyLevel();
            switch (st) {
                case NONE: {
                    return (T)DefaultDataContainer.unBoundedDataContainer(level);
                }
                case UNORDERED: 
                case LRU: 
                case FIFO: 
                case LIRS: {
                    int maxEntries = this.configuration.getEvictionMaxEntries();
                    if (maxEntries < 0) {
                        return (T)DefaultDataContainer.unBoundedDataContainer(level);
                    }
                    EvictionThreadPolicy policy = this.configuration.getEvictionThreadPolicy();
                    return (T)DefaultDataContainer.boundedDataContainer(level, maxEntries, st, policy);
                }
            }
            throw new ConfigurationException("Unknown eviction strategy " + (Object)((Object)this.configuration.getEvictionStrategy()));
        }
        DataContainer dataContainer = (DataContainer)DataContainer.class.cast(Util.getInstance(this.configuration.getDataContainerClass()));
        XmlConfigHelper.setValues(dataContainer, this.configuration.getDataContainerProperties(), false, true);
        return (T)dataContainer;
    }
}

