/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.ch.AbstractWheelConsistentHash;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.TopologyInfo;
import org.infinispan.distribution.ch.UnionConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.hash.Hash;

public class ConsistentHashHelper {
    public static ConsistentHash removeAddress(ConsistentHash ch, Address toRemove, Configuration c, TopologyInfo topologyInfo) {
        if (ch instanceof UnionConsistentHash) {
            return ConsistentHashHelper.removeAddressFromUnionConsistentHash((UnionConsistentHash)ch, toRemove, c, topologyInfo);
        }
        ConsistentHash newCH = ConsistentHashHelper.constructConsistentHashInstance(c);
        HashSet<Address> caches = new HashSet<Address>(ch.getCaches());
        caches.remove(toRemove);
        newCH.setCaches(caches);
        newCH.setTopologyInfo(topologyInfo);
        return newCH;
    }

    private static ConsistentHash constructConsistentHashInstance(Configuration c) {
        ConsistentHash ch = (ConsistentHash)Util.getInstance(c.getConsistentHashClass());
        if (ch instanceof AbstractWheelConsistentHash) {
            Hash h = (Hash)Util.getInstance(c.getHashFunctionClass());
            ((AbstractWheelConsistentHash)ch).setHashFunction(h);
        }
        return ch;
    }

    private static ConsistentHash constructConsistentHashInstance(Class<? extends ConsistentHash> clazz, Hash hash) {
        ConsistentHash ch = Util.getInstance(clazz);
        if (ch instanceof AbstractWheelConsistentHash) {
            ((AbstractWheelConsistentHash)ch).setHashFunction(hash);
        }
        return ch;
    }

    public static UnionConsistentHash removeAddressFromUnionConsistentHash(UnionConsistentHash uch, Address toRemove, Configuration c, TopologyInfo topologyInfo) {
        ConsistentHash newFirstCH = ConsistentHashHelper.removeAddress(uch.getOldConsistentHash(), toRemove, c, topologyInfo);
        ConsistentHash newSecondCH = ConsistentHashHelper.removeAddress(uch.getNewConsistentHash(), toRemove, c, topologyInfo);
        return new UnionConsistentHash(newFirstCH, newSecondCH);
    }

    public static ConsistentHash createConsistentHash(Configuration c, Collection<Address> addresses, TopologyInfo topologyInfo) {
        ConsistentHash ch = ConsistentHashHelper.constructConsistentHashInstance(c);
        ch.setCaches(ConsistentHashHelper.toSet(addresses));
        ch.setTopologyInfo(topologyInfo);
        return ch;
    }

    public static ConsistentHash createConsistentHash(Configuration c, Collection<Address> addresses, TopologyInfo topologyInfo, Address ... moreAddresses) {
        HashSet<Address> caches = new HashSet<Address>(addresses);
        caches.addAll(Arrays.asList(moreAddresses));
        return ConsistentHashHelper.createConsistentHash(c, caches, topologyInfo);
    }

    public static ConsistentHash createConsistentHash(Configuration c, Collection<Address> addresses, Collection<Address> moreAddresses, TopologyInfo topologyInfo) {
        HashSet<Address> caches = new HashSet<Address>(addresses);
        caches.addAll(moreAddresses);
        return ConsistentHashHelper.createConsistentHash(c, caches, topologyInfo);
    }

    public static ConsistentHash createConsistentHash(ConsistentHash template, Collection<Address> addresses, TopologyInfo topologyInfo) {
        Hash hf = null;
        if (template instanceof AbstractWheelConsistentHash) {
            hf = ((AbstractWheelConsistentHash)template).hashFunction;
        }
        ConsistentHash ch = ConsistentHashHelper.constructConsistentHashInstance(template.getClass(), hf);
        if (addresses != null && !addresses.isEmpty()) {
            ch.setCaches(ConsistentHashHelper.toSet(addresses));
        }
        ch.setTopologyInfo(topologyInfo);
        return ch;
    }

    public static ConsistentHash createConsistentHash(ConsistentHash template, Collection<Address> addresses, TopologyInfo topologyInfo, Address ... moreAddresses) {
        HashSet<Address> caches = new HashSet<Address>(addresses);
        caches.addAll(Arrays.asList(moreAddresses));
        return ConsistentHashHelper.createConsistentHash(template, caches, topologyInfo);
    }

    private static Set<Address> toSet(Collection<Address> c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        return new HashSet<Address>(c);
    }
}

