/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.TopologyInfo;
import org.infinispan.remoting.transport.Address;

public abstract class AbstractConsistentHash
implements ConsistentHash {
    protected volatile Set<Address> caches;

    @Override
    public void setCaches(Set<Address> caches) {
        this.caches = new TreeSet<Address>(new Comparator<Address>(){

            @Override
            public int compare(Address o1, Address o2) {
                return o1.hashCode() - o2.hashCode();
            }
        });
        for (Address a : caches) {
            this.caches.add(a);
        }
    }

    @Override
    public Set<Address> getCaches() {
        return this.caches;
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys, int replCount) {
        HashMap<Object, List<Address>> locations = new HashMap<Object, List<Address>>();
        for (Object k : keys) {
            locations.put(k, this.locate(k, replCount));
        }
        return locations;
    }

    @Override
    public boolean isKeyLocalToAddress(Address a, Object key, int replCount) {
        return this.locate(key, replCount).contains(a);
    }

    @Override
    public void setTopologyInfo(TopologyInfo topologyInfo) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {" + "caches=" + this.caches + '}';
    }
}

