/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.L1Manager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.AggregatingNotifyingFutureImpl;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1ManagerImpl
implements L1Manager {
    private final Log log = LogFactory.getLog(L1ManagerImpl.class);
    private final boolean trace = this.log.isTraceEnabled();
    private RpcManager rpcManager;
    private CommandsFactory commandsFactory;
    private int threshold;
    private final ConcurrentMap<Object, Collection<Address>> requestors = new ConcurrentHashMap<Object, Collection<Address>>();

    @Inject
    public void init(Configuration configuration, RpcManager rpcManager, CommandsFactory commandsFactory) {
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.threshold = configuration.getL1InvalidationThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRequestor(Object key, Address origin) {
        Object object = key;
        synchronized (object) {
            if (!this.requestors.containsKey(key)) {
                this.requestors.put(key, new HashSet());
            }
            if (this.trace) {
                this.log.trace((Object)"Key %s will be L1 cached by requestor %s so storing requestor for later invalidation", key, origin);
            }
            ((Collection)this.requestors.get(key)).add(origin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyingNotifiableFuture<Object> flushCache(Collection<Object> keys, Object retval, Address origin) {
        if (this.trace) {
            this.log.trace((Object)"Invalidating L1 caches for keys %s", keys);
        }
        AggregatingNotifyingFutureImpl future = new AggregatingNotifyingFutureImpl(retval, 2);
        Collection<Address> invalidationAddresses = this.buildInvalidationAddressList(keys, origin);
        int nodes = invalidationAddresses.size();
        boolean multicast = this.isUseMulticast(nodes);
        if (this.trace) {
            this.log.trace((Object)"There are %s nodes involved in invalidation. Threshold is: %s; using multicast: %s", nodes, this.threshold, multicast);
        }
        if (multicast) {
            if (this.trace) {
                this.log.trace((Object)"Invalidating keys %s via multicast", keys);
            }
            InvalidateCommand ic = this.commandsFactory.buildInvalidateFromL1Command(false, keys);
            try {
                this.rpcManager.broadcastRpcCommandInFuture(ic, future);
            }
            finally {
                this.cleanupRequestors(keys);
            }
        } else {
            try {
                InvalidateCommand ic = this.commandsFactory.buildInvalidateFromL1Command(false, keys);
                if (this.trace) {
                    this.log.trace((Object)"Keys %s needs invalidation on %s", keys, invalidationAddresses);
                }
                this.rpcManager.invokeRemotelyInFuture(invalidationAddresses, ic, future);
                AggregatingNotifyingFutureImpl aggregatingNotifyingFutureImpl = future;
                return aggregatingNotifyingFutureImpl;
            }
            finally {
                this.cleanupRequestors(keys);
            }
        }
        return future;
    }

    private void cleanupRequestors(Collection<Object> keys) {
        for (Object key : keys) {
            this.requestors.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Address> buildInvalidationAddressList(Collection<Object> keys, Address origin) {
        HashSet<Address> addresses = new HashSet<Address>();
        Iterator<Object> i$ = keys.iterator();
        while (i$.hasNext()) {
            Object key;
            Object object = key = i$.next();
            synchronized (object) {
                if (this.requestors.containsKey(key)) {
                    addresses.addAll((Collection)this.requestors.get(key));
                }
            }
        }
        if (origin != null) {
            addresses.remove(origin);
        }
        return addresses;
    }

    private boolean isUseMulticast(int nodes) {
        if (this.threshold == -1) {
            return false;
        }
        if (this.threshold == 0) {
            return true;
        }
        if (!this.rpcManager.getTransport().isMulticastCapable()) {
            return false;
        }
        return nodes > this.threshold;
    }
}

