/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.distribution.StateMap;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;

abstract class CommandAggregatingStateMap<T extends ReplicableCommand>
extends StateMap<List<T>> {
    Set<Object> keysHandled = new HashSet<Object>();

    CommandAggregatingStateMap(List<Address> leavers, ConsistentHash oldCH, ConsistentHash newCH, int replCount) {
        super(leavers, oldCH, newCH, replCount);
    }

    abstract Set<Object> getAffectedKeys(T var1);

    void addState(T payload) {
        for (Object key : this.getAffectedKeys(payload)) {
            for (Address leaver : this.leavers) {
                List<Address> owners = this.oldCH.locate(key, this.replCount);
                int leaverIndex = owners.indexOf(leaver);
                if (leaverIndex <= -1) continue;
                List<Address> newOwners = this.newCH.locate(key, this.replCount);
                newOwners.removeAll(owners);
                if (newOwners.isEmpty()) continue;
                for (Address no : newOwners) {
                    LinkedList<T> s = (LinkedList<T>)this.state.get(no);
                    if (s == null) {
                        s = new LinkedList<T>();
                        this.state.put(no, s);
                    }
                    s.add(payload);
                }
            }
        }
    }
}

