/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class TransientMortalCacheEntry
extends AbstractInternalCacheEntry {
    private TransientMortalCacheValue cacheValue;

    TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan) {
        super(key);
        this.cacheValue = new TransientMortalCacheValue(value, System.currentTimeMillis(), lifespan, maxIdle);
        this.touch();
    }

    TransientMortalCacheEntry(Object key, Object value) {
        super(key);
        this.cacheValue = new TransientMortalCacheValue(value, System.currentTimeMillis());
        this.touch();
    }

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long lastUsed, long created) {
        super(key);
        this.cacheValue = new TransientMortalCacheValue(value, created, lifespan, maxIdle, lastUsed);
    }

    @Override
    public void setLifespan(long lifespan) {
        this.cacheValue.lifespan = lifespan;
    }

    @Override
    public void setMaxIdle(long maxIdle) {
        this.cacheValue.maxIdle = maxIdle;
    }

    @Override
    public Object getValue() {
        return this.cacheValue.value;
    }

    @Override
    public long getLifespan() {
        return this.cacheValue.lifespan;
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public long getCreated() {
        return this.cacheValue.created;
    }

    @Override
    public boolean isExpired() {
        return this.cacheValue.isExpired();
    }

    @Override
    public final long getExpiryTime() {
        long muet;
        long lset = this.cacheValue.lifespan > -1L ? this.cacheValue.created + this.cacheValue.lifespan : -1L;
        long l = muet = this.cacheValue.maxIdle > -1L ? this.cacheValue.lastUsed + this.cacheValue.maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    @Override
    public long getLastUsed() {
        return this.cacheValue.lastUsed;
    }

    @Override
    public final void touch() {
        this.cacheValue.lastUsed = System.currentTimeMillis();
    }

    @Override
    public final void reincarnate() {
        this.cacheValue.created = System.currentTimeMillis();
    }

    @Override
    public long getMaxIdle() {
        return this.cacheValue.maxIdle;
    }

    @Override
    public Object setValue(Object value) {
        return this.cacheValue.maxIdle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientMortalCacheEntry that = (TransientMortalCacheEntry)o;
        if (this.cacheValue.created != that.cacheValue.created) {
            return false;
        }
        return this.cacheValue.lifespan == that.cacheValue.lifespan;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.cacheValue.created ^ this.cacheValue.created >>> 32);
        result = 31 * result + (int)(this.cacheValue.lifespan ^ this.cacheValue.lifespan >>> 32);
        return result;
    }

    @Override
    public TransientMortalCacheEntry clone() {
        TransientMortalCacheEntry clone = (TransientMortalCacheEntry)super.clone();
        clone.cacheValue = this.cacheValue.clone();
        return clone;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "cacheValue=" + this.cacheValue + "} " + super.toString();
    }

    public static class Externalizer
    extends AbstractExternalizer<TransientMortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, TransientMortalCacheEntry entry) throws IOException {
            output.writeObject(entry.key);
            output.writeObject(((TransientMortalCacheEntry)entry).cacheValue.value);
            UnsignedNumeric.writeUnsignedLong(output, ((TransientMortalCacheEntry)entry).cacheValue.created);
            output.writeLong(((TransientMortalCacheEntry)entry).cacheValue.lifespan);
            UnsignedNumeric.writeUnsignedLong(output, ((TransientMortalCacheEntry)entry).cacheValue.lastUsed);
            output.writeLong(((TransientMortalCacheEntry)entry).cacheValue.maxIdle);
        }

        @Override
        public TransientMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new TransientMortalCacheEntry(k, v, maxIdle, lifespan, lastUsed, created);
        }

        @Override
        public Integer getId() {
            return 13;
        }

        @Override
        public Set<Class<? extends TransientMortalCacheEntry>> getTypeClasses() {
            return Util.asSet(TransientMortalCacheEntry.class);
        }
    }
}

