/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class ImmortalCacheValue
implements InternalCacheValue,
Cloneable {
    Object value;

    ImmortalCacheValue(Object value) {
        this.value = value;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new ImmortalCacheEntry(key, this.value);
    }

    public final Object setValue(Object value) {
        Object old = this.value;
        this.value = value;
        return old;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public boolean canExpire() {
        return false;
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public long getLastUsed() {
        return -1L;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getMaxIdle() {
        return -1L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmortalCacheValue)) {
            return false;
        }
        ImmortalCacheValue that = (ImmortalCacheValue)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "ImmortalCacheValue{value=" + this.value + '}';
    }

    public ImmortalCacheValue clone() {
        try {
            return (ImmortalCacheValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<ImmortalCacheValue> {
        @Override
        public void writeObject(ObjectOutput output, ImmortalCacheValue icv) throws IOException {
            output.writeObject(icv.value);
        }

        @Override
        public ImmortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            return new ImmortalCacheValue(v);
        }

        @Override
        public Integer getId() {
            return 14;
        }

        @Override
        public Set<Class<? extends ImmortalCacheValue>> getTypeClasses() {
            return Util.asSet(ImmortalCacheValue.class);
        }
    }
}

