/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import org.infinispan.commands.LocalCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class EvictCommand
extends RemoveCommand
implements LocalCommand {
    public EvictCommand(Object key, CacheNotifier notifier) {
        this.key = key;
        this.notifier = notifier;
    }

    public void initialize(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEvictCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.key == null) {
            throw new NullPointerException("Key is null!!");
        }
        super.perform(ctx);
        return null;
    }

    @Override
    public void notify(InvocationContext ctx, Object value, boolean isPre) {
        this.notifier.notifyCacheEntryEvicted(this.key, value, isPre, ctx);
    }

    @Override
    public byte getCommandId() {
        return -1;
    }

    @Override
    public String toString() {
        return "EvictCommand{key=" + this.key + ", value=" + this.value + ", flags=" + this.flags + "}";
    }
}

