/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.util.Arrays;
import java.util.List;
import javax.transaction.xa.Xid;
import org.infinispan.commands.remote.RecoveryCommand;
import org.infinispan.context.InvocationContext;

public class RemoveRecoveryInfoCommand
extends RecoveryCommand {
    public static final int COMMAND_ID = 65;
    private volatile List<Xid> xids;

    public RemoveRecoveryInfoCommand(List<Xid> xids, String cacheName) {
        this.xids = xids;
        this.cacheName = cacheName;
    }

    public RemoveRecoveryInfoCommand() {
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        this.recoveryManager.removeLocalRecoveryInformation(this.xids);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 65;
    }

    @Override
    public Object[] getParameters() {
        Object[] result = new Object[]{this.xids, this.cacheName};
        return result;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 65) {
            throw new IllegalArgumentException("Wrong command id. Received " + commandId + " and expected " + 65);
        }
        this.xids = (List)parameters[0];
        this.cacheName = (String)parameters[1];
    }

    @Override
    public String toString() {
        return "RemoveRecoveryInfoCommand {xids=" + (this.xids == null ? null : Arrays.asList(this.xids)) + "} " + super.toString();
    }
}

