/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.util.Collections;
import java.util.Set;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredGetCommand
extends BaseRpcCommand
implements FlagAffectedCommand {
    public static final byte COMMAND_ID = 16;
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Object key;
    private InvocationContextContainer icc;
    private CommandsFactory commandsFactory;
    private InterceptorChain invoker;
    private Set<Flag> flags;
    private DistributionManager distributionManager;

    public ClusteredGetCommand() {
    }

    public ClusteredGetCommand(Object key, String cacheName, Set<Flag> flags) {
        this.key = key;
        this.cacheName = cacheName;
        this.flags = flags;
    }

    public ClusteredGetCommand(Object key, String cacheName) {
        this(key, cacheName, Collections.emptySet());
    }

    public void initialize(InvocationContextContainer icc, CommandsFactory commandsFactory, InterceptorChain interceptorChain, DistributionManager distributionManager) {
        this.distributionManager = distributionManager;
        this.icc = icc;
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
    }

    @Override
    public InternalCacheValue perform(InvocationContext context) throws Throwable {
        if (this.distributionManager != null && this.distributionManager.isAffectedByRehash(this.key)) {
            return null;
        }
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(this.key, this.flags);
        command.setReturnCacheEntry(true);
        InvocationContext invocationContext = this.icc.createRemoteInvocationContextForCommand(command, this.getOrigin());
        CacheEntry cacheEntry = (CacheEntry)this.invoker.invoke(invocationContext, command);
        if (cacheEntry == null) {
            if (trace) {
                log.trace("Did not find anything, returning null");
            }
            return null;
        }
        if (cacheEntry instanceof MVCCEntry) {
            if (trace) {
                log.trace("Handloing an internal cache entry...");
            }
            MVCCEntry mvccEntry = (MVCCEntry)cacheEntry;
            return InternalEntryFactory.createValue(mvccEntry.getValue(), -1L, mvccEntry.getLifespan(), -1L, mvccEntry.getMaxIdle());
        }
        InternalCacheEntry internalCacheEntry = (InternalCacheEntry)cacheEntry;
        return internalCacheEntry.toInternalCacheValue();
    }

    @Override
    public byte getCommandId() {
        return 16;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.cacheName, this.flags};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.key = args[0];
        this.cacheName = (String)args[1];
        if (args.length > 2) {
            this.flags = (Set)args[2];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        return !(this.key == null ? that.key != null : !this.key.equals(that.key));
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        return result;
    }

    @Override
    public String toString() {
        return "ClusteredGetCommand{key=" + this.key + ", flags=" + this.flags + "}";
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public Set<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(Set<Flag> flags) {
        this.flags = flags;
    }
}

