/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bucket;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public final class Bucket {
    private Map<Object, InternalCacheEntry> entries = new HashMap<Object, InternalCacheEntry>();
    private transient String bucketName;

    public final void addEntry(InternalCacheEntry se) {
        this.entries.put(se.getKey(), se);
    }

    public final boolean removeEntry(Object key) {
        return this.entries.remove(key) != null;
    }

    public final InternalCacheEntry getEntry(Object key) {
        return this.entries.get(key);
    }

    public Map<Object, InternalCacheEntry> getEntries() {
        return this.entries;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean removeExpiredEntries() {
        boolean result = false;
        Iterator<Map.Entry<Object, InternalCacheEntry>> entryIterator = this.entries.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<Object, InternalCacheEntry> entry = entryIterator.next();
            if (!entry.getValue().isExpired()) continue;
            entryIterator.remove();
            result = true;
        }
        return result;
    }

    public Collection<? extends InternalCacheEntry> getStoredEntries() {
        return this.entries.values();
    }

    public long timestampOfFirstEntryToExpire() {
        long result = Long.MAX_VALUE;
        for (InternalCacheEntry se : this.entries.values()) {
            if (se.getExpiryTime() >= result) continue;
            result = se.getExpiryTime();
        }
        return result;
    }

    public String toString() {
        return "Bucket{entries=" + this.entries + ", bucketName='" + this.bucketName + '\'' + '}';
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public void clearEntries() {
        this.entries.clear();
    }

    public static class Externalizer
    extends AbstractExternalizer<Bucket> {
        @Override
        public void writeObject(ObjectOutput output, Bucket b) throws IOException {
            Map entries = b.entries;
            UnsignedNumeric.writeUnsignedInt(output, entries.size());
            for (InternalCacheEntry se : entries.values()) {
                output.writeObject(se);
            }
        }

        @Override
        public Bucket readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Bucket b = new Bucket();
            int numEntries = UnsignedNumeric.readUnsignedInt(input);
            for (int i = 0; i < numEntries; ++i) {
                b.addEntry((InternalCacheEntry)input.readObject());
            }
            return b;
        }

        @Override
        public Integer getId() {
            return 42;
        }

        @Override
        public Set<Class<? extends Bucket>> getTypeClasses() {
            return Util.asSet(Bucket.class);
        }
    }
}

