/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.transaction.TransactionLog;
import org.infinispan.transaction.xa.LocalTransaction;
import org.infinispan.transaction.xa.TransactionTable;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.DisplayType;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Parameter;

@MBean(objectName="Transactions", description="Component that manages the cache's participation in JTA transactions.")
public class TxInterceptor
extends CommandInterceptor {
    private TransactionManager tm;
    private TransactionLog transactionLog;
    private TransactionTable txTable;
    private final AtomicLong prepares = new AtomicLong(0L);
    private final AtomicLong commits = new AtomicLong(0L);
    private final AtomicLong rollbacks = new AtomicLong(0L);
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", writable=true)
    private boolean statisticsEnabled;
    private CommandsFactory commandsFactory;
    private InvocationContextContainer icc;
    private InterceptorChain invoker;

    @Inject
    public void init(TransactionManager tm, TransactionTable txTable, TransactionLog transactionLog, Configuration c, CommandsFactory commandsFactory, InvocationContextContainer icc, InterceptorChain invoker) {
        this.configuration = c;
        this.tm = tm;
        this.transactionLog = transactionLog;
        this.txTable = txTable;
        this.commandsFactory = commandsFactory;
        this.icc = icc;
        this.invoker = invoker;
        this.setStatisticsEnabled(this.configuration.isExposeJmxStatistics());
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            for (WriteCommand modification : command.getModifications()) {
                VisitableCommand toReplay = this.getCommandToReplay(modification);
                if (toReplay == null) continue;
                this.invokeNextInterceptor(ctx, toReplay);
            }
        }
        if (!command.isOnePhaseCommit()) {
            this.transactionLog.logPrepare(command);
        }
        if (this.statisticsEnabled) {
            this.prepares.incrementAndGet();
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit()) {
            this.transactionLog.logOnePhaseCommit(ctx.getGlobalTransaction(), command.getModifications());
        }
        return result;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.commits.incrementAndGet();
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        this.transactionLog.logCommit(command.getGlobalTransaction());
        return result;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.rollbacks.incrementAndGet();
        }
        this.transactionLog.rollback(command.getGlobalTransaction());
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand invalidateCommand) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, invalidateCommand);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    private Object enlistReadAndInvokeNext(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (this.shouldEnlist(ctx)) {
            LocalTransaction localTransaction = this.enlist(ctx);
            LocalTxInvocationContext localTxContext = (LocalTxInvocationContext)ctx;
            localTxContext.setLocalTransaction(localTransaction);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object enlistWriteAndInvokeNext(InvocationContext ctx, WriteCommand command) throws Throwable {
        LocalTransaction localTransaction = null;
        boolean shouldAddMod = false;
        if (this.shouldEnlist(ctx)) {
            localTransaction = this.enlist(ctx);
            LocalTxInvocationContext localTxContext = (LocalTxInvocationContext)ctx;
            if (this.localModeNotForced(ctx)) {
                shouldAddMod = true;
            }
            localTxContext.setLocalTransaction(localTransaction);
        }
        Object rv = this.invokeNextInterceptor(ctx, command);
        if (!ctx.isInTxScope()) {
            this.transactionLog.logNoTxWrite(command);
        }
        if (command.isSuccessful() && shouldAddMod) {
            localTransaction.addModification(command);
        }
        return rv;
    }

    public LocalTransaction enlist(InvocationContext ctx) throws SystemException, RollbackException {
        Transaction transaction = ((TxInvocationContext)ctx).getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("This should only be called in an tx scope");
        }
        int status = transaction.getStatus();
        if (this.isNotValid(status)) {
            throw new IllegalStateException("Transaction " + transaction + " is not in a valid state to be invoking cache operations on.");
        }
        LocalTransaction localTransaction = this.txTable.getOrCreateLocalTransaction(transaction, ctx);
        if (!localTransaction.isEnlisted()) {
            try {
                transaction.enlistResource((XAResource)new TransactionXaAdapter(localTransaction, this.txTable, this.commandsFactory, this.configuration, this.invoker, this.icc));
            }
            catch (Exception e) {
                Xid xid = localTransaction.getXid();
                if (xid != null && !ctx.getLockedKeys().isEmpty()) {
                    this.log.debug("Attempting a rollback to clear stale resources!");
                    try {
                        TransactionXaAdapter.rollbackImpl(xid, this.commandsFactory, this.icc, this.invoker, this.txTable);
                    }
                    catch (XAException xae) {
                        this.log.debug((Object)("Caught exception attempting to clean up " + xid), xae);
                    }
                }
                this.log.error("Failed to enlist TransactionXaAdapter to transaction");
                throw new CacheException(e);
            }
        }
        return localTransaction;
    }

    private boolean isNotValid(int status) {
        return status != 0 && status != 7;
    }

    private boolean shouldEnlist(InvocationContext ctx) {
        return ctx.isInTxScope() && ctx.isOriginLocal();
    }

    private boolean localModeNotForced(InvocationContext icx) {
        if (icx.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (this.trace) {
                this.log.debug("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return false;
        }
        return true;
    }

    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset Statistics")
    public void resetStatistics() {
        this.prepares.set(0L);
        this.commits.set(0L);
        this.rollbacks.set(0L);
    }

    @Operation(displayName="Enable/disable statistics")
    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @Metric(displayName="Statistics enabled", dataType=DataType.TRAIT)
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="Number of transaction prepares performed since last reset")
    @Metric(displayName="Prepares", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getPrepares() {
        return this.prepares.get();
    }

    @ManagedAttribute(description="Number of transaction commits performed since last reset")
    @Metric(displayName="Commits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getCommits() {
        return this.commits.get();
    }

    @ManagedAttribute(description="Number of transaction rollbacks performed since last reset")
    @Metric(displayName="Rollbacks", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRollbacks() {
        return this.rollbacks.get();
    }

    protected VisitableCommand getCommandToReplay(VisitableCommand modification) {
        return modification;
    }
}

