/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PassivationManagerImpl
implements PassivationManager {
    CacheLoaderManager cacheLoaderManager;
    CacheNotifier notifier;
    CacheStore cacheStore;
    Configuration cfg;
    boolean statsEnabled = false;
    boolean enabled = false;
    private static final Log log = LogFactory.getLog(PassivationManagerImpl.class);
    private final AtomicLong passivations = new AtomicLong(0L);
    private DataContainer container;
    private static final boolean trace = log.isTraceEnabled();

    @Inject
    public void inject(CacheLoaderManager cacheLoaderManager, CacheNotifier notifier, Configuration cfg, DataContainer container) {
        this.cacheLoaderManager = cacheLoaderManager;
        this.notifier = notifier;
        this.cfg = cfg;
        this.container = container;
    }

    @Start(priority=11)
    public void start() {
        this.enabled = this.cfg.getCacheLoaderManagerConfig().isPassivation();
        if (this.enabled) {
            CacheStore cacheStore = this.cacheStore = this.cacheLoaderManager == null ? null : this.cacheLoaderManager.getCacheStore();
            if (this.cacheStore == null) {
                throw new ConfigurationException("passivation can only be used with a CacheLoader that implements CacheStore!");
            }
            this.enabled = this.cacheLoaderManager.isEnabled() && this.cacheLoaderManager.isUsingPassivation();
            this.statsEnabled = this.cfg.isExposeJmxStatistics();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void passivate(Object key, InternalCacheEntry entry, InvocationContext ctx) throws CacheLoaderException {
        if (this.enabled) {
            Object value = entry != null ? entry.getValue() : null;
            this.notifier.notifyCacheEntryPassivated(key, value, true, ctx);
            if (trace) {
                log.trace((Object)"Passivating entry %s", key);
            }
            this.cacheStore.store(entry);
            this.notifier.notifyCacheEntryPassivated(key, value, false, ctx);
            if (this.statsEnabled && entry != null) {
                this.passivations.getAndIncrement();
            }
        }
    }

    @Override
    @Stop(priority=9)
    public void passivateAll() throws CacheLoaderException {
        if (this.enabled) {
            long start = System.currentTimeMillis();
            log.info("Passivating all entries to disk");
            for (InternalCacheEntry e : this.container) {
                if (trace) {
                    log.trace((Object)"Passivating %s", e.getKey());
                }
                this.cacheStore.store(e);
            }
            log.info((Object)"Passivated %s entries in %s", this.container.size(), Util.prettyPrintTime(System.currentTimeMillis() - start));
        }
    }

    @Override
    public long getPassivationCount() {
        return this.passivations.get();
    }

    @Override
    public void resetPassivationCount() {
        this.passivations.set(0L);
    }
}

