/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.distribution.ch.AbstractConsistentHash;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.hash.Hash;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractWheelConsistentHash
extends AbstractConsistentHash {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final boolean trace = this.log.isTraceEnabled();
    protected ArrayList<Address> addresses;
    protected SortedMap<Integer, Address> positions;
    protected Map<Address, Integer> addressToHashIds;
    protected Hash hashFunction;
    static final int HASH_SPACE = 10240;

    protected AbstractWheelConsistentHash() {
    }

    public void setHashFunction(Hash h) {
        this.hashFunction = h;
    }

    @Override
    public void setCaches(List<Address> caches) {
        super.setCaches(caches);
        this.addresses = new ArrayList<Address>(caches);
        this.addresses.trimToSize();
        this.positions = new TreeMap<Integer, Address>();
        this.addressToHashIds = new HashMap<Address, Integer>();
        for (Address a : this.addresses) {
            int positionIndex = Math.abs(this.hashFunction.hash(a)) % 10240;
            while (this.positions.containsKey(positionIndex)) {
                ++positionIndex;
            }
            this.positions.put(positionIndex, a);
            if (this.addressToHashIds.containsKey(a)) continue;
            this.addressToHashIds.put(a, positionIndex);
        }
        this.addresses.clear();
        for (Address a : this.positions.values()) {
            this.addresses.add(a);
        }
    }

    @Override
    public List<Address> getBackupsForNode(Address node, int replCount) {
        return this.locate(node, replCount);
    }

    @Override
    public List<Address> getCaches() {
        return this.addresses;
    }

    @Override
    public int getHashSpace() {
        return 10240;
    }

    @Override
    public int getHashId(Address a) {
        Integer hashId = this.addressToHashIds.get(a);
        if (hashId == null) {
            return -1;
        }
        return hashId;
    }

    public int getNormalizedHash(Object key) {
        int keyHashCode = this.hashFunction.hash(key);
        if (keyHashCode == Integer.MIN_VALUE) {
            ++keyHashCode;
        }
        return Math.abs(keyHashCode) % 10240;
    }

    @Override
    public String toString() {
        return "AbstractWheelConsistentHash{addresses=" + this.addresses + ", positions=" + this.positions + ", addressToHashIds=" + this.addressToHashIds + "} " + super.toString();
    }

    public static abstract class Externalizer<T extends AbstractWheelConsistentHash>
    extends AbstractExternalizer<T> {
        protected abstract T instance();

        @Override
        public void writeObject(ObjectOutput output, T abstractWheelConsistentHash) throws IOException {
            output.writeObject(((AbstractWheelConsistentHash)abstractWheelConsistentHash).hashFunction.getClass().getName());
            output.writeObject(((AbstractWheelConsistentHash)abstractWheelConsistentHash).addresses);
            output.writeObject(((AbstractWheelConsistentHash)abstractWheelConsistentHash).positions);
            output.writeObject(((AbstractWheelConsistentHash)abstractWheelConsistentHash).addressToHashIds);
        }

        @Override
        public T readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            T abstractWheelConsistentHash = this.instance();
            String hashFuctionName = (String)unmarshaller.readObject();
            ((AbstractWheelConsistentHash)abstractWheelConsistentHash).setHashFunction((Hash)Util.getInstance(hashFuctionName));
            ((AbstractWheelConsistentHash)abstractWheelConsistentHash).addresses = (ArrayList)unmarshaller.readObject();
            ((AbstractWheelConsistentHash)abstractWheelConsistentHash).positions = (SortedMap)unmarshaller.readObject();
            ((AbstractWheelConsistentHash)abstractWheelConsistentHash).addressToHashIds = (Map)unmarshaller.readObject();
            return abstractWheelConsistentHash;
        }
    }
}

