/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.distribution.RemoteTransactionLogDetails;
import org.infinispan.distribution.RemoteTransactionLogger;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;

public class RemoteTransactionLoggerImpl
implements RemoteTransactionLogger {
    private final CommandsFactory commandsFactory;
    private final Address targetNode;
    private final Address sender;
    private final RpcManager rpcManager;
    private boolean drainWithoutLock = true;
    private Collection<PrepareCommand> pendingPrepares;

    public RemoteTransactionLoggerImpl(CommandsFactory commandsFactory, Address targetNode, RpcManager rpcManager) {
        this.commandsFactory = commandsFactory;
        this.targetNode = targetNode;
        this.rpcManager = rpcManager;
        this.sender = rpcManager.getAddress();
    }

    private RemoteTransactionLogDetails extractRemoteTransactionLogDetails(ReplicableCommand c) {
        Map<Address, Response> lr = this.rpcManager.invokeRemotely(Collections.singleton(this.targetNode), c, true, true);
        if (lr.size() != 1) {
            throw new RpcException("Expected just one response; got " + lr + " instead!");
        }
        Response r = lr.get(this.targetNode);
        if (r != null && r.isSuccessful() && r.isValid()) {
            return (RemoteTransactionLogDetails)((SuccessfulResponse)r).getResponseValue();
        }
        throw new RpcException("Invalid response " + r);
    }

    @Override
    public List<WriteCommand> drain() {
        RehashControlCommand c = this.commandsFactory.buildRehashControlCommand(RehashControlCommand.Type.JOIN_TX_LOG_REQ, this.sender);
        RemoteTransactionLogDetails details = this.extractRemoteTransactionLogDetails(c);
        this.drainWithoutLock = details.isDrainNextCallWithoutLock();
        return details.getModifications();
    }

    @Override
    public List<WriteCommand> drainAndLock(Address notUsed) {
        RehashControlCommand c = this.commandsFactory.buildRehashControlCommand(RehashControlCommand.Type.JOIN_TX_FINAL_LOG_REQ, this.sender);
        RemoteTransactionLogDetails details = this.extractRemoteTransactionLogDetails(c);
        this.pendingPrepares = details.getPendingPreparesMap();
        return details.getModifications();
    }

    @Override
    public boolean shouldDrainWithoutLock() {
        return this.drainWithoutLock;
    }

    @Override
    public Collection<PrepareCommand> getPendingPrepares() {
        return this.pendingPrepares;
    }

    @Override
    public void unlockAndDisable(Address notUsed) {
        RehashControlCommand c = this.commandsFactory.buildRehashControlCommand(RehashControlCommand.Type.JOIN_TX_LOG_CLOSE, this.sender);
        this.rpcManager.invokeRemotely(Collections.singleton(this.targetNode), (ReplicableCommand)c, true, true);
    }
}

