/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Future;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.RehashTask;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.distribution.ch.NodeTopologyInfo;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.concurrent.TimeoutException;

public class JoinTask
extends RehashTask {
    private final InboundInvocationHandler inboundInvocationHandler;

    public JoinTask(RpcManager rpcManager, CommandsFactory commandsFactory, Configuration conf, DataContainer dataContainer, DistributionManagerImpl dmi, InboundInvocationHandler inboundInvocationHandler) {
        super(dmi, rpcManager, conf, commandsFactory, dataContainer);
        this.inboundInvocationHandler = inboundInvocationHandler;
    }

    private List<Address> parseResponses(Collection<Response> resp) {
        for (Response r : resp) {
            if (!(r instanceof SuccessfulResponse)) continue;
            return (List)((SuccessfulResponse)r).getResponseValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRehash() throws Exception {
        long start = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Commencing rehash on node: %s. Before start, distributionManager.joinComplete = %s", this.getMyAddress(), this.distributionManager.isJoinComplete());
        }
        try {
            if (this.distributionManager.isJoinComplete()) {
                throw new IllegalStateException("Join on " + this.getMyAddress() + " cannot be complete without rehash to finishing");
            }
            ConsistentHash chOld = this.retrieveOldConsistentHash();
            ConsistentHash chNew = chOld.getCaches().contains(this.self) ? chOld : ConsistentHashHelper.createConsistentHash(this.configuration, chOld.getCaches(), this.distributionManager.getTopologyInfo(), this.self);
            this.distributionManager.setConsistentHash(chNew);
            try {
                if (this.configuration.isRehashEnabled()) {
                    this.broadcastNewCh();
                    Address myAddress = this.rpcManager.getTransport().getAddress();
                    RehashControlCommand cmd = this.cf.buildRehashControlCommand(RehashControlCommand.Type.PULL_STATE_JOIN, myAddress, null, chOld, chNew, null);
                    List<Address> addressesWhoMaySendStuff = this.getAddressesWhoMaySendStuff(chNew, this.configuration.getNumOwners());
                    HashSet<Future<Void>> stateRetrievalProcesses = new HashSet<Future<Void>>(addressesWhoMaySendStuff.size());
                    for (Address address : addressesWhoMaySendStuff) {
                        stateRetrievalProcesses.add(this.statePullExecutor.submit(new JoinStateGrabber(address, (ReplicableCommand)cmd, chNew)));
                    }
                    for (Future future : stateRetrievalProcesses) {
                        future.get();
                    }
                } else {
                    this.broadcastNewCh();
                    if (this.trace) {
                        this.log.trace("Rehash not enabled, so not pulling state.");
                    }
                }
            }
            finally {
                this.distributionManager.setJoinComplete(true);
                this.distributionManager.setRehashInProgress(false);
                this.inboundInvocationHandler.blockTillNoLongerRetrying(this.cf.getCacheName());
                this.rpcManager.broadcastRpcCommandInFuture(this.cf.buildRehashControlCommand(RehashControlCommand.Type.JOIN_REHASH_END, this.self), true, new NotifyingFutureImpl(null));
                if (this.configuration.isRehashEnabled()) {
                    this.invalidateInvalidHolders(chOld, chNew);
                }
            }
        }
        catch (Exception e) {
            try {
                this.log.error((Object)"Caught exception!", e);
                throw new CacheException("Unexpected exception", e);
            }
            catch (Throwable throwable) {
                this.log.info((Object)"%s completed join rehash in %s!", this.self, Util.prettyPrintTime(System.currentTimeMillis() - start));
                throw throwable;
            }
        }
        this.log.info((Object)"%s completed join rehash in %s!", this.self, Util.prettyPrintTime(System.currentTimeMillis() - start));
    }

    private void broadcastNewCh() {
        RehashControlCommand rehashControlCommand = this.cf.buildRehashControlCommand(RehashControlCommand.Type.JOIN_REHASH_START, this.self);
        rehashControlCommand.setNodeTopologyInfo(this.distributionManager.getTopologyInfo().getNodeTopologyInfo(this.rpcManager.getAddress()));
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(null, (ReplicableCommand)rehashControlCommand, true, true);
        this.updateTopologyInfo(responses.values());
    }

    private void updateTopologyInfo(Collection<Response> responses) {
        for (Response r : responses) {
            if (r instanceof SuccessfulResponse) {
                SuccessfulResponse sr = (SuccessfulResponse)r;
                NodeTopologyInfo nti = (NodeTopologyInfo)sr.getResponseValue();
                if (nti == null) continue;
                this.distributionManager.getTopologyInfo().addNodeTopologyInfo(nti.getAddress(), nti);
                continue;
            }
            if (!this.trace) continue;
            this.log.trace("updateTopologyInfo will ignore unsuccessful response (another node may not be ready), got response with success=" + r.isSuccessful() + ", is a " + r.getClass().getSimpleName());
        }
        if (this.trace) {
            this.log.trace("Topology after after getting cluster info: " + this.distributionManager.getTopologyInfo());
        }
    }

    private ConsistentHash retrieveOldConsistentHash() throws InterruptedException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        ConsistentHash result = null;
        long minSleepTime = 500L;
        long maxSleepTime = 2000L;
        int maxWaitTime = (int)this.configuration.getRehashRpcTimeout() * 10;
        Random rand = new Random();
        long giveupTime = System.currentTimeMillis() + (long)maxWaitTime;
        do {
            List<Address> addresses;
            block8: {
                Map<Address, Response> resp;
                if (this.trace) {
                    this.log.trace("Requesting old consistent hash from coordinator");
                }
                try {
                    resp = this.rpcManager.invokeRemotely(this.coordinator(), this.cf.buildRehashControlCommand(RehashControlCommand.Type.JOIN_REQ, this.self), ResponseMode.SYNCHRONOUS, this.configuration.getRehashRpcTimeout(), true);
                    addresses = this.parseResponses(resp.values());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Retrieved old consistent hash address list %s", addresses);
                    }
                }
                catch (TimeoutException te) {
                    resp = null;
                    addresses = null;
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug("Timed out waiting for responses.");
                }
            }
            if (addresses == null) {
                long time = rand.nextInt((int)(maxSleepTime - minSleepTime) / 10);
                time = time * 10L + minSleepTime;
                if (this.trace) {
                    this.log.trace((Object)"Sleeping for %s", Util.prettyPrintTime(time));
                }
                Thread.sleep(time);
                continue;
            }
            result = ConsistentHashHelper.createConsistentHash(this.configuration, addresses, this.distributionManager.getTopologyInfo());
        } while (result == null && System.currentTimeMillis() < giveupTime);
        if (result == null) {
            throw new CacheException("Unable to retrieve old consistent hash from coordinator even after several attempts at sleeping and retrying!");
        }
        return result;
    }

    List<Address> getAddressesWhoMaySendStuff(ConsistentHash ch, int replCount) {
        return ch.getStateProvidersOnJoin(this.self, replCount);
    }

    public Address getMyAddress() {
        return this.rpcManager != null && this.rpcManager.getTransport() != null ? this.rpcManager.getTransport().getAddress() : null;
    }

    protected final class JoinStateGrabber
    extends RehashTask.StateGrabber {
        public JoinStateGrabber(Address stateProvider, ReplicableCommand command, ConsistentHash newConsistentHash) {
            super(JoinTask.this, stateProvider, command, newConsistentHash);
        }

        @Override
        protected boolean isForLeave() {
            return false;
        }
    }
}

