/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.util.BidirectionalMap;

public class InvocationContextFlagsOverride
implements InvocationContext {
    private final InvocationContext delegate;
    private final Set<Flag> flags;

    public InvocationContextFlagsOverride(InvocationContext delegate, Set<Flag> flags) {
        if (delegate == null || flags == null) {
            throw new IllegalArgumentException("parameters shall not be null");
        }
        this.delegate = delegate;
        this.flags = Flag.copyWithouthRemotableFlags(flags);
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        return this.delegate.lookupEntry(key);
    }

    @Override
    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        return this.delegate.getLookedUpEntries();
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.delegate.putLookedUpEntry(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> lookedUpEntries) {
        this.delegate.putLookedUpEntries(lookedUpEntries);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        this.delegate.removeLookedUpEntry(key);
    }

    @Override
    public void clearLookedUpEntries() {
        this.delegate.clearLookedUpEntries();
    }

    @Override
    public boolean hasLockedKey(Object key) {
        return this.delegate.hasLockedKey(key);
    }

    @Override
    public boolean hasFlag(Flag o) {
        if (this.flags.contains((Object)o)) {
            return true;
        }
        return this.delegate.hasFlag(o);
    }

    @Override
    public Set<Flag> getFlags() {
        Set<Flag> flagsInDelegate = this.delegate.getFlags();
        if (flagsInDelegate == null || flagsInDelegate.isEmpty()) {
            return this.flags;
        }
        EnumSet<Flag> merged = EnumSet.copyOf(flagsInDelegate);
        merged.addAll(this.flags);
        return merged;
    }

    @Override
    public void setFlags(Flag ... newFlags) {
        throw new IllegalStateException("Flags can't be changed after creating an InvocationContextFlagsOverride wrapper");
    }

    @Override
    public void setFlags(Collection<Flag> newFlags) {
        throw new IllegalStateException("Flags can't be changed after creating an InvocationContextFlagsOverride wrapper");
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public boolean isOriginLocal() {
        return this.delegate.isOriginLocal();
    }

    @Override
    public boolean isInTxScope() {
        return this.delegate.isInTxScope();
    }

    @Override
    public Object getLockOwner() {
        return this.delegate.getLockOwner();
    }

    @Override
    public boolean isUseFutureReturnType() {
        return this.delegate.isUseFutureReturnType();
    }

    @Override
    public void setUseFutureReturnType(boolean useFutureReturnType) {
        this.delegate.setUseFutureReturnType(useFutureReturnType);
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.delegate.getLockedKeys();
    }

    @Override
    public InvocationContextFlagsOverride clone() {
        return new InvocationContextFlagsOverride(this.delegate, this.flags);
    }
}

