/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.AbstractConfigurationBeanWithGCR;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationDoc;
import org.infinispan.config.ConfigurationDocRef;
import org.infinispan.config.ConfigurationDocs;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.ExternalizerConfig;
import org.infinispan.executors.DefaultExecutorFactory;
import org.infinispan.executors.DefaultScheduledExecutorFactory;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PlatformMBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.Externalizer;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;

@SurvivesRestarts
@Scope(value=Scopes.GLOBAL)
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={})
@ConfigurationDoc(name="global", desc="Defines global settings shared among all cache instances created by a single CacheManager.")
public class GlobalConfiguration
extends AbstractConfigurationBean {
    private static final long serialVersionUID = 8910865501990177720L;
    public static final short DEFAULT_MARSHALL_VERSION = Version.getVersionShort();
    @XmlElement
    ExecutorFactoryType asyncListenerExecutor = new ExecutorFactoryType();
    @XmlElement
    ExecutorFactoryType asyncTransportExecutor = new ExecutorFactoryType();
    @XmlElement
    ScheduledExecutorFactoryType evictionScheduledExecutor = new ScheduledExecutorFactoryType();
    @XmlElement
    ScheduledExecutorFactoryType replicationQueueScheduledExecutor = new ScheduledExecutorFactoryType();
    @XmlElement
    GlobalJmxStatisticsType globalJmxStatistics = new GlobalJmxStatisticsType();
    @XmlElement
    TransportType transport = new TransportType(null);
    @XmlElement
    SerializationType serialization = new SerializationType();
    @XmlElement
    ShutdownType shutdown = new ShutdownType();
    @XmlTransient
    GlobalComponentRegistry gcr;

    public ExecutorFactoryConfig<ExecutorFactory> configureAsyncListenerExecutor() {
        return this.asyncListenerExecutor;
    }

    public ExecutorFactoryConfig<ExecutorFactory> configureAsyncTransportExecutor() {
        return this.asyncTransportExecutor;
    }

    public ExecutorFactoryConfig<ScheduledExecutorFactory> configureEvictionScheduledExecutor() {
        return this.evictionScheduledExecutor;
    }

    public ExecutorFactoryConfig<ScheduledExecutorFactory> configureReplicationQueueScheduledExecutor() {
        return this.replicationQueueScheduledExecutor;
    }

    public GlobalJmxStatisticsConfig configureGlobalJmxStatistics() {
        return this.globalJmxStatistics;
    }

    public SerializationConfig configureSerialization() {
        return this.serialization;
    }

    public TransportConfig configureTransport() {
        return this.transport;
    }

    public boolean isExposeGlobalJmxStatistics() {
        return this.globalJmxStatistics.enabled;
    }

    @Deprecated
    public void setExposeGlobalJmxStatistics(boolean exposeGlobalJmxStatistics) {
        this.testImmutability("exposeGlobalManagementStatistics");
        this.globalJmxStatistics.enabled(exposeGlobalJmxStatistics);
    }

    @Deprecated
    public void setJmxDomain(String jmxObjectName) {
        this.globalJmxStatistics.setJmxDomain(jmxObjectName);
    }

    public String getJmxDomain() {
        return this.globalJmxStatistics.jmxDomain;
    }

    public String getMBeanServerLookup() {
        return this.globalJmxStatistics.mBeanServerLookup;
    }

    public Properties getMBeanServerProperties() {
        return this.globalJmxStatistics.properties;
    }

    @Deprecated
    public void setMBeanServerProperties(Properties properties) {
        this.globalJmxStatistics.setProperties(this.toTypedProperties(properties));
    }

    @Deprecated
    public void setMBeanServerLookup(String mBeanServerLookupClass) {
        this.globalJmxStatistics.setMBeanServerLookup(mBeanServerLookupClass);
    }

    @XmlTransient
    @Deprecated
    public void setMBeanServerLookup(MBeanServerLookup mBeanServerLookup) {
        this.globalJmxStatistics.setMBeanServerLookupInstance(mBeanServerLookup);
    }

    @XmlTransient
    @Deprecated
    public void setMBeanServerLookupInstance(MBeanServerLookup mBeanServerLookupInstance) {
        this.globalJmxStatistics.setMBeanServerLookupInstance(mBeanServerLookupInstance);
    }

    public MBeanServerLookup getMBeanServerLookupInstance() {
        return this.globalJmxStatistics.getMBeanServerLookupInstance();
    }

    public boolean isAllowDuplicateDomains() {
        return this.globalJmxStatistics.allowDuplicateDomains;
    }

    @Deprecated
    public void setAllowDuplicateDomains(boolean allowDuplicateDomains) {
        this.globalJmxStatistics.setAllowDuplicateDomains(allowDuplicateDomains);
    }

    public String getCacheManagerName() {
        return this.globalJmxStatistics.cacheManagerName;
    }

    @Deprecated
    public void setCacheManagerName(String cacheManagerName) {
        this.globalJmxStatistics.setCacheManagerName(cacheManagerName);
    }

    public boolean isStrictPeerToPeer() {
        return this.transport.strictPeerToPeer;
    }

    @Deprecated
    public void setStrictPeerToPeer(boolean strictPeerToPeer) {
        this.transport.setStrictPeerToPeer(strictPeerToPeer);
    }

    public boolean hasTopologyInfo() {
        return this.getSiteId() != null || this.getRackId() != null || this.getMachineId() != null;
    }

    @Inject
    private void injectDependencies(GlobalComponentRegistry gcr) {
        this.gcr = gcr;
        gcr.registerComponent((Object)this.asyncListenerExecutor, "asyncListenerExecutor");
        gcr.registerComponent((Object)this.asyncTransportExecutor, "asyncTransportExecutor");
        gcr.registerComponent((Object)this.evictionScheduledExecutor, "evictionScheduledExecutor");
        gcr.registerComponent((Object)this.replicationQueueScheduledExecutor, "replicationQueueScheduledExecutor");
        gcr.registerComponent((Object)this.replicationQueueScheduledExecutor, "replicationQueueScheduledExecutor");
        gcr.registerComponent((Object)this.globalJmxStatistics, "globalJmxStatistics");
        gcr.registerComponent((Object)this.transport, "transport");
        gcr.registerComponent((Object)this.serialization, "serialization");
        gcr.registerComponent((Object)this.shutdown, "shutdown");
    }

    @Override
    protected boolean hasComponentStarted() {
        return this.gcr != null && this.gcr.getStatus() != null && this.gcr.getStatus() == ComponentStatus.RUNNING;
    }

    public String getAsyncListenerExecutorFactoryClass() {
        return this.asyncListenerExecutor.factory;
    }

    @Deprecated
    public void setAsyncListenerExecutorFactoryClass(String asyncListenerExecutorFactoryClass) {
        this.asyncListenerExecutor.setFactory(asyncListenerExecutorFactoryClass);
    }

    public String getAsyncTransportExecutorFactoryClass() {
        return this.asyncTransportExecutor.factory;
    }

    @Deprecated
    public void setAsyncTransportExecutorFactoryClass(String asyncTransportExecutorFactoryClass) {
        this.asyncTransportExecutor.setFactory(asyncTransportExecutorFactoryClass);
    }

    public String getEvictionScheduledExecutorFactoryClass() {
        return this.evictionScheduledExecutor.factory;
    }

    @Deprecated
    public void setEvictionScheduledExecutorFactoryClass(String evictionScheduledExecutorFactoryClass) {
        this.evictionScheduledExecutor.setFactory(evictionScheduledExecutorFactoryClass);
    }

    public String getReplicationQueueScheduledExecutorFactoryClass() {
        return this.replicationQueueScheduledExecutor.factory;
    }

    @Deprecated
    public void setReplicationQueueScheduledExecutorFactoryClass(String replicationQueueScheduledExecutorFactoryClass) {
        this.replicationQueueScheduledExecutor.setFactory(replicationQueueScheduledExecutorFactoryClass);
    }

    public String getMarshallerClass() {
        return this.serialization.marshallerClass;
    }

    @Deprecated
    public void setMarshallerClass(String marshallerClass) {
        this.serialization.setMarshallerClass(marshallerClass);
    }

    public String getTransportNodeName() {
        return this.transport.nodeName;
    }

    @Deprecated
    public void setTransportNodeName(String nodeName) {
        this.transport.setNodeName(nodeName);
    }

    public String getTransportClass() {
        return this.transport.transportClass;
    }

    @Deprecated
    public void setTransportClass(String transportClass) {
        this.transport.setTransportClass(transportClass);
    }

    public Properties getTransportProperties() {
        return this.transport.properties;
    }

    @Deprecated
    public void setTransportProperties(Properties transportProperties) {
        this.transport.setProperties(this.toTypedProperties(transportProperties));
    }

    @Deprecated
    public void setTransportProperties(String transportPropertiesString) {
        this.transport.setProperties(this.toTypedProperties(transportPropertiesString));
    }

    public String getClusterName() {
        return this.transport.clusterName;
    }

    @Deprecated
    public void setClusterName(String clusterName) {
        this.transport.setClusterName(clusterName);
    }

    @Deprecated
    public void setMachineId(String machineId) {
        this.transport.setMachineId(machineId);
    }

    public String getMachineId() {
        return this.transport.machineId;
    }

    @Deprecated
    public void setRackId(String rackId) {
        this.transport.setRackId(rackId);
    }

    public String getRackId() {
        return this.transport.rackId;
    }

    @Deprecated
    public void setSiteId(String siteId) {
        this.transport.setSiteId(siteId);
    }

    public String getSiteId() {
        return this.transport.siteId;
    }

    public ShutdownHookBehavior getShutdownHookBehavior() {
        return this.shutdown.hookBehavior;
    }

    public void setShutdownHookBehavior(ShutdownHookBehavior shutdownHookBehavior) {
        this.shutdown.setHookBehavior(shutdownHookBehavior);
    }

    public void setShutdownHookBehavior(String shutdownHookBehavior) {
        if (shutdownHookBehavior == null) {
            throw new ConfigurationException("Shutdown hook behavior cannot be null", "ShutdownHookBehavior");
        }
        ShutdownHookBehavior temp = ShutdownHookBehavior.valueOf(this.uc(shutdownHookBehavior));
        if (temp == null) {
            this.log.warn("Unknown shutdown hook behavior '" + shutdownHookBehavior + "', using defaults.");
            temp = ShutdownHookBehavior.DEFAULT;
        }
        this.setShutdownHookBehavior(temp);
    }

    public Properties getAsyncListenerExecutorProperties() {
        return this.asyncListenerExecutor.properties;
    }

    @Deprecated
    public void setAsyncListenerExecutorProperties(Properties asyncListenerExecutorProperties) {
        this.asyncListenerExecutor.setProperties(this.toTypedProperties(asyncListenerExecutorProperties));
    }

    @Deprecated
    public void setAsyncListenerExecutorProperties(String asyncListenerExecutorPropertiesString) {
        this.asyncListenerExecutor.setProperties(this.toTypedProperties(asyncListenerExecutorPropertiesString));
    }

    public Properties getAsyncTransportExecutorProperties() {
        return this.asyncTransportExecutor.properties;
    }

    @Deprecated
    public void setAsyncTransportExecutorProperties(Properties asyncTransportExecutorProperties) {
        this.asyncTransportExecutor.setProperties(this.toTypedProperties(asyncTransportExecutorProperties));
    }

    @Deprecated
    public void setAsyncTransportExecutorProperties(String asyncSerializationExecutorPropertiesString) {
        this.asyncTransportExecutor.setProperties(this.toTypedProperties(asyncSerializationExecutorPropertiesString));
    }

    public Properties getEvictionScheduledExecutorProperties() {
        return this.evictionScheduledExecutor.properties;
    }

    @Deprecated
    public void setEvictionScheduledExecutorProperties(Properties evictionScheduledExecutorProperties) {
        this.evictionScheduledExecutor.setProperties(this.toTypedProperties(evictionScheduledExecutorProperties));
    }

    @Deprecated
    public void setEvictionScheduledExecutorProperties(String evictionScheduledExecutorPropertiesString) {
        this.evictionScheduledExecutor.setProperties(this.toTypedProperties(evictionScheduledExecutorPropertiesString));
    }

    public Properties getReplicationQueueScheduledExecutorProperties() {
        return this.replicationQueueScheduledExecutor.properties;
    }

    @Deprecated
    public void setReplicationQueueScheduledExecutorProperties(Properties replicationQueueScheduledExecutorProperties) {
        this.replicationQueueScheduledExecutor.setProperties(this.toTypedProperties(replicationQueueScheduledExecutorProperties));
    }

    @Deprecated
    public void setReplicationQueueScheduledExecutorProperties(String replicationQueueScheduledExecutorPropertiesString) {
        this.replicationQueueScheduledExecutor.setProperties(this.toTypedProperties(replicationQueueScheduledExecutorPropertiesString));
    }

    public short getMarshallVersion() {
        return Version.getVersionShort(this.serialization.version);
    }

    public String getMarshallVersionString() {
        return this.serialization.version;
    }

    @Deprecated
    public void setMarshallVersion(short marshallVersion) {
        this.testImmutability("marshallVersion");
        this.serialization.version = Version.decodeVersionForSerialization(marshallVersion);
    }

    @Deprecated
    public void setMarshallVersion(String marshallVersion) {
        this.serialization.setVersion(marshallVersion);
    }

    public void addExternalizer(Externalizer ... externalizers) {
        for (Externalizer ext : externalizers) {
            this.serialization.externalizerTypes.getExternalizerConfigs().add(new ExternalizerConfig().setExternalizer(ext));
        }
    }

    public void addExternalizer(int id, Externalizer externalizer) {
        ExternalizerConfig config = new ExternalizerConfig().setExternalizer(externalizer).setId(id);
        this.serialization.externalizerTypes.getExternalizerConfigs().add(config);
    }

    public void setExternalizersType(ExternalizersType externalizersType) {
        this.serialization.setExternalizerTypes(externalizersType);
    }

    public ExternalizersType getExternalizersType() {
        return this.serialization.externalizerTypes;
    }

    public long getDistributedSyncTimeout() {
        return this.transport.distributedSyncTimeout;
    }

    @Deprecated
    public void setDistributedSyncTimeout(long distributedSyncTimeout) {
        this.transport.distributedSyncTimeout = distributedSyncTimeout;
    }

    public void accept(ConfigurationBeanVisitor v) {
        this.asyncListenerExecutor.accept(v);
        this.asyncTransportExecutor.accept(v);
        this.evictionScheduledExecutor.accept(v);
        this.globalJmxStatistics.accept(v);
        this.replicationQueueScheduledExecutor.accept(v);
        this.serialization.accept(v);
        this.shutdown.accept(v);
        this.transport.accept(v);
        v.visitGlobalConfiguration(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalConfiguration that = (GlobalConfiguration)o;
        if (!this.serialization.version.equals(that.serialization.version)) {
            return false;
        }
        if (this.asyncListenerExecutor.factory != null ? !this.asyncListenerExecutor.factory.equals(that.asyncListenerExecutor.factory) : that.asyncListenerExecutor.factory != null) {
            return false;
        }
        if (this.asyncListenerExecutor.properties != null ? !this.asyncListenerExecutor.properties.equals(that.asyncListenerExecutor.properties) : that.asyncListenerExecutor.properties != null) {
            return false;
        }
        if (this.asyncTransportExecutor.factory != null ? !this.asyncTransportExecutor.factory.equals(that.asyncTransportExecutor.factory) : that.asyncTransportExecutor.factory != null) {
            return false;
        }
        if (this.asyncTransportExecutor.properties != null ? !this.asyncTransportExecutor.properties.equals(that.asyncTransportExecutor.properties) : that.asyncTransportExecutor.properties != null) {
            return false;
        }
        if (this.transport.clusterName != null ? !this.transport.clusterName.equals(that.transport.clusterName) : that.transport.clusterName != null) {
            return false;
        }
        if (this.evictionScheduledExecutor.factory != null ? !this.evictionScheduledExecutor.factory.equals(that.evictionScheduledExecutor.factory) : that.evictionScheduledExecutor.factory != null) {
            return false;
        }
        if (this.evictionScheduledExecutor.properties != null ? !this.evictionScheduledExecutor.properties.equals(that.evictionScheduledExecutor.properties) : that.evictionScheduledExecutor.properties != null) {
            return false;
        }
        if (this.serialization.marshallerClass != null ? !this.serialization.marshallerClass.equals(that.serialization.marshallerClass) : that.serialization.marshallerClass != null) {
            return false;
        }
        if (this.replicationQueueScheduledExecutor.factory != null ? !this.replicationQueueScheduledExecutor.factory.equals(that.replicationQueueScheduledExecutor.factory) : that.replicationQueueScheduledExecutor.factory != null) {
            return false;
        }
        if (this.replicationQueueScheduledExecutor.properties != null ? !this.replicationQueueScheduledExecutor.properties.equals(that.replicationQueueScheduledExecutor.properties) : that.replicationQueueScheduledExecutor.properties != null) {
            return false;
        }
        if (this.shutdown.hookBehavior != null ? !this.shutdown.hookBehavior.equals((Object)that.shutdown.hookBehavior) : that.shutdown.hookBehavior != null) {
            return false;
        }
        if (this.transport.transportClass != null ? !this.transport.transportClass.equals(that.transport.transportClass) : that.transport.transportClass != null) {
            return false;
        }
        if (this.transport.properties != null ? !this.transport.properties.equals(that.transport.properties) : that.transport.properties != null) {
            return false;
        }
        return this.transport.distributedSyncTimeout == null || this.transport.distributedSyncTimeout.equals(that.transport.distributedSyncTimeout);
    }

    public int hashCode() {
        int result = this.asyncListenerExecutor.factory != null ? this.asyncListenerExecutor.factory.hashCode() : 0;
        result = 31 * result + (this.asyncListenerExecutor.properties != null ? this.asyncListenerExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.asyncTransportExecutor.factory != null ? this.asyncTransportExecutor.factory.hashCode() : 0);
        result = 31 * result + (this.asyncTransportExecutor.properties != null ? this.asyncTransportExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.evictionScheduledExecutor.factory != null ? this.evictionScheduledExecutor.factory.hashCode() : 0);
        result = 31 * result + (this.evictionScheduledExecutor.properties != null ? this.evictionScheduledExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.replicationQueueScheduledExecutor.factory != null ? this.replicationQueueScheduledExecutor.factory.hashCode() : 0);
        result = 31 * result + (this.replicationQueueScheduledExecutor.properties != null ? this.replicationQueueScheduledExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.serialization.marshallerClass != null ? this.serialization.marshallerClass.hashCode() : 0);
        result = 31 * result + (this.transport.transportClass != null ? this.transport.transportClass.hashCode() : 0);
        result = 31 * result + (this.transport.properties != null ? this.transport.properties.hashCode() : 0);
        result = 31 * result + (this.transport.clusterName != null ? this.transport.clusterName.hashCode() : 0);
        result = 31 * result + this.shutdown.hookBehavior.hashCode();
        result = 31 * result + this.serialization.version.hashCode();
        result = (int)((long)(31 * result) + this.transport.distributedSyncTimeout);
        return result;
    }

    @Override
    public GlobalConfiguration clone() {
        try {
            GlobalConfiguration dolly = (GlobalConfiguration)super.clone();
            if (this.asyncListenerExecutor != null) {
                dolly.asyncListenerExecutor = this.asyncListenerExecutor.clone();
            }
            if (this.asyncTransportExecutor != null) {
                dolly.asyncTransportExecutor = this.asyncTransportExecutor.clone();
            }
            if (this.evictionScheduledExecutor != null) {
                dolly.evictionScheduledExecutor = this.evictionScheduledExecutor.clone();
            }
            if (this.replicationQueueScheduledExecutor != null) {
                dolly.replicationQueueScheduledExecutor = this.replicationQueueScheduledExecutor.clone();
            }
            if (this.globalJmxStatistics != null) {
                dolly.globalJmxStatistics = (GlobalJmxStatisticsType)this.globalJmxStatistics.clone();
            }
            if (this.transport != null) {
                dolly.transport = this.transport.clone();
            }
            if (this.serialization != null) {
                dolly.serialization = (SerializationType)this.serialization.clone();
            }
            if (this.shutdown != null) {
                dolly.shutdown = (ShutdownType)this.shutdown.clone();
            }
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Problems cloning configuration component!", e);
        }
    }

    public static GlobalConfiguration getClusteredDefault() {
        GlobalConfiguration gc = new GlobalConfiguration();
        gc.setTransportClass(JGroupsTransport.class.getName());
        gc.setTransportProperties((Properties)null);
        Properties p = new Properties();
        p.setProperty("threadNamePrefix", "asyncTransportThread");
        gc.setAsyncTransportExecutorProperties(p);
        return gc;
    }

    public static GlobalConfiguration getNonClusteredDefault() {
        GlobalConfiguration gc = new GlobalConfiguration();
        gc.setTransportClass(null);
        gc.setTransportProperties((Properties)null);
        return gc;
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="shutdown")
    public static class ShutdownType
    extends AbstractConfigurationBeanWithGCR {
        private static final long serialVersionUID = 3427920991221031456L;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setShutdownHookBehavior")
        protected ShutdownHookBehavior hookBehavior = ShutdownHookBehavior.DEFAULT;

        @XmlAttribute
        public void setHookBehavior(ShutdownHookBehavior hookBehavior) {
            this.testImmutability("hookBehavior");
            this.hookBehavior = hookBehavior;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitShutdownType(this);
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="globalJmxStatistics")
    public static class GlobalJmxStatisticsType
    extends AbstractConfigurationBeanWithGCR
    implements GlobalJmxStatisticsConfig {
        private static final long serialVersionUID = 6639689526822921024L;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setExposeGlobalJmxStatistics")
        protected Boolean enabled = false;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setJmxDomain")
        protected String jmxDomain = "org.infinispan";
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setMBeanServerLookup")
        protected String mBeanServerLookup = PlatformMBeanServerLookup.class.getName();
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setAllowDuplicateDomains")
        protected Boolean allowDuplicateDomains = false;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setCacheManagerName")
        protected String cacheManagerName = "DefaultCacheManager";
        @XmlElement(name="properties")
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setMBeanServerProperties")
        protected TypedProperties properties = EMPTY_PROPERTIES;
        private MBeanServerLookup mBeanServerLookupInstance;

        @Override
        public GlobalJmxStatisticsConfig enabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
            return this;
        }

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitGlobalJmxStatisticsType(this);
        }

        @XmlTransient
        public void setProperties(TypedProperties p) {
            this.properties = p;
        }

        @Override
        public GlobalJmxStatisticsConfig jmxDomain(String jmxDomain) {
            this.testImmutability("jmxDomain");
            this.jmxDomain = jmxDomain;
            return this;
        }

        @XmlAttribute
        public void setJmxDomain(String jmxDomain) {
            this.testImmutability("jmxDomain");
            this.jmxDomain = jmxDomain;
        }

        @Override
        public GlobalJmxStatisticsConfig mBeanServerLookup(Class<? extends MBeanServerLookup> beanServerLookupClass) {
            this.testImmutability("mBeanServerLookup");
            this.mBeanServerLookup = beanServerLookupClass.getName();
            return this;
        }

        @XmlAttribute
        public void setMBeanServerLookup(String beanServerLookup) {
            this.testImmutability("mBeanServerLookup");
            this.mBeanServerLookup = beanServerLookup;
        }

        @Override
        public GlobalJmxStatisticsConfig allowDuplicateDomains(Boolean allowDuplicateDomains) {
            this.testImmutability("allowDuplicateDomains");
            this.allowDuplicateDomains = allowDuplicateDomains;
            return this;
        }

        @XmlAttribute
        public void setAllowDuplicateDomains(Boolean allowDuplicateDomains) {
            this.testImmutability("allowDuplicateDomains");
            this.allowDuplicateDomains = allowDuplicateDomains;
        }

        @Override
        public GlobalJmxStatisticsConfig cacheManagerName(String cacheManagerName) {
            this.testImmutability("cacheManagerName");
            this.cacheManagerName = cacheManagerName;
            return this;
        }

        @XmlAttribute
        public void setCacheManagerName(String cacheManagerName) {
            this.testImmutability("cacheManagerName");
            this.cacheManagerName = cacheManagerName;
        }

        public MBeanServerLookup getMBeanServerLookupInstance() {
            if (this.mBeanServerLookupInstance == null) {
                this.mBeanServerLookupInstance = (MBeanServerLookup)Util.getInstance(this.mBeanServerLookup);
            }
            return this.mBeanServerLookupInstance;
        }

        @XmlTransient
        public void setMBeanServerLookupInstance(MBeanServerLookup MBeanServerLookupInstance) {
            this.mBeanServerLookupInstance = MBeanServerLookupInstance;
        }

        @Override
        public GlobalJmxStatisticsConfig setProperties(Properties p) {
            this.properties.putAll((Map<?, ?>)p);
            return this;
        }

        @Override
        public GlobalJmxStatisticsConfig usingMBeanServerLookupInstance(MBeanServerLookup MBeanServerLookupInstance) {
            this.mBeanServerLookupInstance = MBeanServerLookupInstance;
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ConfigurationDoc(name="externalizers")
    public static class ExternalizersType
    extends AbstractConfigurationBeanWithGCR
    implements ExternalizersConfig {
        private static final long serialVersionUID = -496116709223466807L;
        @XmlElement(name="externalizer")
        private List<ExternalizerConfig> externalizers = new ArrayList<ExternalizerConfig>();

        @Override
        public ExternalizersType clone() throws CloneNotSupportedException {
            ExternalizersType dolly = (ExternalizersType)super.clone();
            if (this.externalizers != null) {
                dolly.externalizers = new ArrayList<ExternalizerConfig>();
                for (ExternalizerConfig config : this.externalizers) {
                    ExternalizerConfig clone = (ExternalizerConfig)config.clone();
                    dolly.externalizers.add(clone);
                }
            }
            return dolly;
        }

        public void accept(ConfigurationBeanVisitor v) {
            for (ExternalizerConfig i : this.externalizers) {
                i.accept(v);
            }
            v.visitExternalizersType(this);
        }

        public List<ExternalizerConfig> getExternalizerConfigs() {
            return this.externalizers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExternalizersType)) {
                return false;
            }
            ExternalizersType that = (ExternalizersType)o;
            return !(this.externalizers != null ? !((Object)this.externalizers).equals(that.externalizers) : that.externalizers != null);
        }

        public int hashCode() {
            return this.externalizers != null ? ((Object)this.externalizers).hashCode() : 0;
        }

        @Deprecated
        public void setExternalizerConfigs(List<ExternalizerConfig> externalizers) {
            this.testImmutability("externalizers");
            this.externalizers = externalizers;
        }

        @Override
        public ExternalizersConfig addExtrenalizer(ExternalizerConfig e) {
            this.externalizers.add(e);
            return this;
        }

        @Override
        public <T> ExternalizersConfig addExtrenalizer(Class<? extends Externalizer<T>> clazz, int id) {
            ExternalizerConfig ec = new ExternalizerConfig();
            ec.setExternalizerClass(clazz.getName());
            ec.setId(id);
            this.addExtrenalizer(ec);
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="serialization")
    public static class SerializationType
    extends AbstractConfigurationBeanWithGCR
    implements SerializationConfig {
        private static final long serialVersionUID = -925947118621507282L;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setMarshallerClass")
        protected String marshallerClass = VersionAwareMarshaller.class.getName();
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setMarshallVersion")
        protected String version = "5.0";
        @XmlElement(name="externalizers")
        protected ExternalizersType externalizerTypes = new ExternalizersType();

        public void accept(ConfigurationBeanVisitor v) {
            v.visitSerializationType(this);
        }

        public void setExternalizerTypes(ExternalizersType externalizerTypes) {
            this.externalizerTypes = externalizerTypes;
        }

        @Override
        public SerializationConfig marshallerClass(Class<? extends Marshaller> marshallerClass) {
            this.testImmutability("marshallerClass");
            this.marshallerClass = marshallerClass.getName();
            return this;
        }

        @Override
        public SerializationConfig version(String version) {
            this.testImmutability("version");
            this.version = version;
            return this;
        }

        @XmlAttribute
        public void setMarshallerClass(String marshallerClass) {
            this.testImmutability("marshallerClass");
            this.marshallerClass = marshallerClass;
        }

        @XmlAttribute
        public void setVersion(String version) {
            this.testImmutability("version");
            this.version = version;
        }

        @Override
        public ExternalizersConfig configureExternalizers() {
            return this.externalizerTypes;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="transport")
    public static class TransportType
    extends AbstractConfigurationBeanWithGCR
    implements TransportConfig {
        private static final long serialVersionUID = -4739815717370060368L;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setClusterName")
        protected String clusterName = "Infinispan-Cluster";
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setMachineId")
        protected String machineId;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setRackId")
        protected String rackId;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setSiteId")
        protected String siteId;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setStrictPeerToPeer")
        protected Boolean strictPeerToPeer = true;
        @ConfigurationDoc(name="distributedSyncTimeout", desc="Cluster-wide synchronization timeout for locks.  Used to coordinate changes in cluster membership.")
        protected Long distributedSyncTimeout = 240000L;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setTransportClass")
        protected String transportClass = null;
        @ConfigurationDocRef(bean=GlobalConfiguration.class, targetElement="setTransportNodeName")
        protected String nodeName = null;
        @XmlElement(name="properties")
        protected TypedProperties properties = EMPTY_PROPERTIES;

        public TransportType() {
            this.transportClass = JGroupsTransport.class.getName();
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitTransportType(this);
        }

        public TransportType(String transportClass) {
            this.transportClass = transportClass;
        }

        @Override
        public TransportConfig clusterName(String clusterName) {
            this.testImmutability("clusterName");
            this.clusterName = clusterName;
            return this;
        }

        @Override
        public TransportConfig machineId(String machineId) {
            this.testImmutability("machineId");
            this.machineId = machineId;
            return this;
        }

        @Override
        public TransportConfig rackId(String rackId) {
            this.testImmutability("rackId");
            this.rackId = rackId;
            return this;
        }

        @Override
        public TransportConfig siteId(String siteId) {
            this.testImmutability("siteId");
            this.siteId = siteId;
            return this;
        }

        @XmlAttribute
        public void setClusterName(String clusterName) {
            this.testImmutability("clusterName");
            this.clusterName = clusterName;
        }

        @XmlAttribute
        public void setMachineId(String machineId) {
            this.testImmutability("machineId");
            this.machineId = machineId;
        }

        @XmlAttribute
        public void setRackId(String rackId) {
            this.testImmutability("rackId");
            this.rackId = rackId;
        }

        @XmlAttribute
        public void setSiteId(String siteId) {
            this.testImmutability("siteId");
            this.siteId = siteId;
        }

        @Override
        public TransportConfig distributedSyncTimeout(Long distributedSyncTimeout) {
            this.testImmutability("distributedSyncTimeout");
            this.distributedSyncTimeout = distributedSyncTimeout;
            return this;
        }

        @XmlAttribute
        public void setDistributedSyncTimeout(Long distributedSyncTimeout) {
            this.testImmutability("distributedSyncTimeout");
            this.distributedSyncTimeout = distributedSyncTimeout;
        }

        @XmlAttribute
        public void setTransportClass(String transportClass) {
            this.testImmutability("transportClass");
            this.transportClass = transportClass;
        }

        @Override
        public TransportConfig transportClass(Class<? extends Transport> transportClass) {
            this.testImmutability("transportClass");
            this.transportClass = transportClass.getName();
            return this;
        }

        @Override
        public TransportConfig nodeName(String nodeName) {
            this.testImmutability("nodeName");
            this.nodeName = nodeName;
            return this;
        }

        @XmlAttribute
        public void setNodeName(String nodeName) {
            this.testImmutability("nodeName");
            this.nodeName = nodeName;
        }

        @XmlTransient
        public void setProperties(TypedProperties properties) {
            this.testImmutability("properties");
            this.properties = properties;
        }

        @Override
        public TransportConfig withProperties(Properties properties) {
            this.testImmutability("properties");
            this.properties = this.toTypedProperties(properties);
            return this;
        }

        @Override
        public Object addProperty(String key, String value) {
            return this.properties.put(key, value);
        }

        @Override
        public TransportConfig strictPeerToPeer(Boolean strictPeerToPeer) {
            this.testImmutability("strictPeerToPeer");
            this.strictPeerToPeer = strictPeerToPeer;
            return this;
        }

        @XmlAttribute
        public void setStrictPeerToPeer(Boolean strictPeerToPeer) {
            this.testImmutability("strictPeerToPeer");
            this.strictPeerToPeer = strictPeerToPeer;
        }

        @Override
        public TransportType clone() throws CloneNotSupportedException {
            TransportType dolly = (TransportType)super.clone();
            dolly.properties = (TypedProperties)this.properties.clone();
            return dolly;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDocs(value={@ConfigurationDoc(name="evictionScheduledExecutor", desc="Configuration for the scheduled executor service used to periodically run eviction cleanup tasks."), @ConfigurationDoc(name="replicationQueueScheduledExecutor", desc="Configuration for the scheduled executor service used to periodically flush replication queues, used if asynchronous clustering is enabled along with useReplQueue being set to true.")})
    public static class ScheduledExecutorFactoryType
    extends FactoryClassWithPropertiesType
    implements ExecutorFactoryConfig<ScheduledExecutorFactory> {
        private static final long serialVersionUID = 7806391452092647488L;
        @ConfigurationDoc(name="factory", desc="Fully qualified class name of the ScheduledExecutorFactory to use.  Must implement org.infinispan.executors.ScheduledExecutorFactory")
        protected String factory = DefaultScheduledExecutorFactory.class.getName();

        public ScheduledExecutorFactoryType(String factory) {
            this.factory = factory;
        }

        public ScheduledExecutorFactoryType() {
        }

        @XmlAttribute
        public void setFactory(String factory) {
            this.testImmutability("factory");
            this.factory = factory;
        }

        @Override
        public ScheduledExecutorFactoryType clone() throws CloneNotSupportedException {
            return (ScheduledExecutorFactoryType)super.clone();
        }

        @Override
        public ExecutorFactoryConfig<ScheduledExecutorFactory> factory(Class<? extends ScheduledExecutorFactory> clazz) {
            this.testImmutability("factory");
            this.factory = clazz.getName();
            return this;
        }

        @Override
        public Object addProperty(String key, String value) {
            return this.getProperties().put(key, value);
        }

        @Override
        public ExecutorFactoryConfig<ScheduledExecutorFactory> withProperties(Properties props) {
            this.getProperties().putAll((Map<?, ?>)props);
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDocs(value={@ConfigurationDoc(name="asyncListenerExecutor", desc="Configuration for the executor service used to emit notifications to asynchronous listeners"), @ConfigurationDoc(name="asyncTransportExecutor", desc="Configuration for the executor service used for asynchronous work on the Transport, including asynchronous marshalling and Cache 'async operations' such as Cache.putAsync().")})
    public static class ExecutorFactoryType
    extends FactoryClassWithPropertiesType
    implements ExecutorFactoryConfig<ExecutorFactory> {
        private static final long serialVersionUID = 6895901500645539386L;
        @ConfigurationDoc(name="factory", desc="Fully qualified class name of the ExecutorFactory to use.  Must implement org.infinispan.executors.ExecutorFactory")
        protected String factory = DefaultExecutorFactory.class.getName();

        public ExecutorFactoryType(String factory) {
            this.factory = factory;
        }

        public ExecutorFactoryType() {
        }

        @XmlAttribute
        public void setFactory(String factory) {
            this.testImmutability("factory");
            this.factory = factory;
        }

        @Override
        public ExecutorFactoryType clone() throws CloneNotSupportedException {
            return (ExecutorFactoryType)super.clone();
        }

        @Override
        public ExecutorFactoryConfig<ExecutorFactory> factory(Class<? extends ExecutorFactory> clazz) {
            this.factory = clazz.getName();
            return this;
        }

        @Override
        public Object addProperty(String key, String value) {
            return this.getProperties().put(key, value);
        }

        @Override
        public ExecutorFactoryConfig<ExecutorFactory> withProperties(Properties props) {
            this.getProperties().putAll((Map<?, ?>)props);
            return this;
        }
    }

    public static abstract class FactoryClassWithPropertiesType
    extends AbstractConfigurationBeanWithGCR {
        private static final long serialVersionUID = 7625606997888180254L;
        @ConfigurationDocs(value={@ConfigurationDoc(name="maxThreads", desc="Maximum number of threads for this executor. Default values can be found <a href=&quot;http://community.jboss.org/docs/DOC-15540&quot;>here</a>"), @ConfigurationDoc(name="threadNamePrefix", desc="Thread name prefix for threads created by this executor. Default values can be found <a href=&quot;http://community.jboss.org/docs/DOC-15540&quot;>here</a>")})
        protected TypedProperties properties = EMPTY_PROPERTIES;

        public void accept(ConfigurationBeanVisitor v) {
            v.visitFactoryClassWithPropertiesType(this);
        }

        public void setProperties(TypedProperties properties) {
            this.testImmutability("properties");
            this.properties = properties;
        }

        @XmlElement(name="properties")
        public TypedProperties getProperties() {
            return this.properties;
        }

        @Override
        public FactoryClassWithPropertiesType clone() throws CloneNotSupportedException {
            FactoryClassWithPropertiesType dolly = (FactoryClassWithPropertiesType)super.clone();
            dolly.properties = (TypedProperties)this.properties.clone();
            return dolly;
        }
    }

    public static enum ShutdownHookBehavior {
        DEFAULT,
        REGISTER,
        DONT_REGISTER;

    }

    public static interface ExternalizersConfig {
        public ExternalizersConfig addExtrenalizer(ExternalizerConfig var1);

        public <T> ExternalizersConfig addExtrenalizer(Class<? extends Externalizer<T>> var1, int var2);
    }

    public static interface SerializationConfig {
        public SerializationConfig marshallerClass(Class<? extends Marshaller> var1);

        public SerializationConfig version(String var1);

        public ExternalizersConfig configureExternalizers();
    }

    public static interface TransportConfig {
        public TransportConfig clusterName(String var1);

        public TransportConfig machineId(String var1);

        public TransportConfig rackId(String var1);

        public TransportConfig siteId(String var1);

        public TransportConfig distributedSyncTimeout(Long var1);

        public TransportConfig transportClass(Class<? extends Transport> var1);

        public TransportConfig nodeName(String var1);

        public TransportConfig withProperties(Properties var1);

        public TransportConfig strictPeerToPeer(Boolean var1);

        public Object addProperty(String var1, String var2);
    }

    public static interface GlobalJmxStatisticsConfig {
        public GlobalJmxStatisticsConfig enabled(Boolean var1);

        public GlobalJmxStatisticsConfig setProperties(Properties var1);

        public GlobalJmxStatisticsConfig jmxDomain(String var1);

        public GlobalJmxStatisticsConfig mBeanServerLookup(Class<? extends MBeanServerLookup> var1);

        public GlobalJmxStatisticsConfig allowDuplicateDomains(Boolean var1);

        public GlobalJmxStatisticsConfig cacheManagerName(String var1);

        public GlobalJmxStatisticsConfig usingMBeanServerLookupInstance(MBeanServerLookup var1);
    }

    public static interface ExecutorFactoryConfig<T> {
        public ExecutorFactoryConfig<T> factory(Class<? extends T> var1);

        public Object addProperty(String var1, String var2);

        public ExecutorFactoryConfig<T> withProperties(Properties var1);
    }
}

