/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.infinispan.CacheException;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationDoc;
import org.infinispan.config.ConfigurationDocRef;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.Dynamic;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.OverrideConfigurationVisitor;
import org.infinispan.container.DataContainer;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.TopologyAwareConsistentHash;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.remoting.ReplicationQueueImpl;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.hash.MurmurHash3;

@SurvivesRestarts
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={})
@ConfigurationDoc(name="default")
public class Configuration
extends AbstractNamedCacheConfigurationBean {
    private static final long serialVersionUID = 5553791890144997466L;
    @XmlTransient
    private GlobalConfiguration globalConfiguration;
    @XmlAttribute
    @ConfigurationDoc(desc="Only used with the namedCache element, this attribute specifies the name of the cache.  Can be any String, but must be unique in a given configuration.")
    protected String name;
    @XmlElement
    private LockingType locking = new LockingType();
    @XmlElement
    private CacheLoaderManagerConfig loaders = new CacheLoaderManagerConfig();
    @XmlElement
    private TransactionType transaction = new TransactionType(null);
    @XmlElement
    private CustomInterceptorsType customInterceptors = new CustomInterceptorsType();
    @XmlElement
    private DataContainerType dataContainer = new DataContainerType();
    @XmlElement
    private EvictionType eviction = new EvictionType();
    @XmlElement
    private ExpirationType expiration = new ExpirationType();
    @XmlElement
    private UnsafeType unsafe = new UnsafeType();
    @XmlElement
    private ClusteringType clustering = new ClusteringType(CacheMode.LOCAL);
    @XmlElement
    private JmxStatistics jmxStatistics = new JmxStatistics();
    @XmlElement
    private LazyDeserialization lazyDeserialization = new LazyDeserialization();
    @XmlElement
    private InvocationBatching invocationBatching = new InvocationBatching();
    @XmlElement
    private DeadlockDetectionType deadlockDetection = new DeadlockDetectionType();
    @XmlElement
    private QueryConfigurationBean indexing = new QueryConfigurationBean();

    public LockingConfig configureLocking() {
        return this.locking;
    }

    public LoadersConfig configureLoaders() {
        return this.loaders;
    }

    public TransactionConfig configureTransaction() {
        return this.transaction;
    }

    public CustomInterceptorsConfig configureInterceptors() {
        return this.customInterceptors;
    }

    public EvictionConfig configureEviction() {
        return this.eviction;
    }

    public ExpirationConfig configureExpiration() {
        return this.expiration;
    }

    public ClusteringConfig configureClustering() {
        return this.clustering;
    }

    public DeadlockDetectionConfig configureDeadlockDetection() {
        return this.deadlockDetection;
    }

    public IndexingConfig configureIndexing() {
        return this.indexing;
    }

    @Start(priority=1)
    private void correctIsolationLevels() {
        switch (this.locking.isolationLevel) {
            case NONE: 
            case READ_UNCOMMITTED: {
                this.locking.isolationLevel = IsolationLevel.READ_COMMITTED;
                break;
            }
            case SERIALIZABLE: {
                this.locking.isolationLevel = IsolationLevel.REPEATABLE_READ;
            }
        }
    }

    public void applyOverrides(Configuration overrides) {
        OverrideConfigurationVisitor v1 = new OverrideConfigurationVisitor();
        this.accept(v1);
        OverrideConfigurationVisitor v2 = new OverrideConfigurationVisitor();
        overrides.accept(v2);
        v1.override(v2);
    }

    @Override
    public void inject(ComponentRegistry cr) {
        this.accept(new AbstractNamedCacheConfigurationBean.InjectComponentRegistryVisitor(cr));
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void setGlobalConfiguration(GlobalConfiguration gc) {
        this.globalConfiguration = gc;
    }

    public String getName() {
        return this.name;
    }

    @Inject
    private void injectGlobalConfiguration(GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public boolean isStateTransferEnabled() {
        return this.clustering.stateRetrieval.fetchInMemoryState != false || this.loaders != null && this.loaders.isFetchPersistentState() != false;
    }

    public long getDeadlockDetectionSpinDuration() {
        return this.deadlockDetection.spinDuration;
    }

    @Deprecated
    public void setDeadlockDetectionSpinDuration(long eagerDeadlockSpinDuration) {
        this.deadlockDetection.setSpinDuration(eagerDeadlockSpinDuration);
    }

    public boolean isEnableDeadlockDetection() {
        return this.deadlockDetection.enabled;
    }

    @Deprecated
    public void setEnableDeadlockDetection(boolean useEagerDeadlockDetection) {
        this.deadlockDetection.setEnabled(useEagerDeadlockDetection);
    }

    @Deprecated
    public void setUseLockStriping(boolean useLockStriping) {
        this.locking.setUseLockStriping(useLockStriping);
    }

    public boolean isUseLockStriping() {
        return this.locking.useLockStriping;
    }

    public boolean isUnsafeUnreliableReturnValues() {
        return this.unsafe.unreliableReturnValues;
    }

    public void setUnsafeUnreliableReturnValues(boolean unsafeUnreliableReturnValues) {
        this.unsafe.setUnreliableReturnValues(unsafeUnreliableReturnValues);
    }

    @Deprecated
    public void setRehashRpcTimeout(long rehashRpcTimeout) {
        this.clustering.hash.setRehashRpcTimeout(rehashRpcTimeout);
    }

    public long getRehashRpcTimeout() {
        return this.clustering.hash.rehashRpcTimeout;
    }

    public boolean isWriteSkewCheck() {
        return this.locking.writeSkewCheck;
    }

    @Deprecated
    public void setWriteSkewCheck(boolean writeSkewCheck) {
        this.locking.setWriteSkewCheck(writeSkewCheck);
    }

    public int getConcurrencyLevel() {
        return this.locking.concurrencyLevel;
    }

    @Deprecated
    public void setConcurrencyLevel(int concurrencyLevel) {
        this.locking.setConcurrencyLevel(concurrencyLevel);
    }

    @Deprecated
    public void setReplQueueMaxElements(int replQueueMaxElements) {
        this.clustering.async.setReplQueueMaxElements(replQueueMaxElements);
    }

    @Deprecated
    public void setReplQueueInterval(long replQueueInterval) {
        this.clustering.async.setReplQueueInterval(replQueueInterval);
    }

    @Deprecated
    public void setReplQueueInterval(long replQueueInterval, TimeUnit timeUnit) {
        this.setReplQueueInterval(timeUnit.toMillis(replQueueInterval));
    }

    @Deprecated
    public void setReplQueueClass(String classname) {
        this.clustering.async.setReplQueueClass(classname);
    }

    @Deprecated
    public void setExposeJmxStatistics(boolean useMbean) {
        this.jmxStatistics.setEnabled(useMbean);
    }

    public void setInvocationBatchingEnabled(boolean enabled) {
        this.invocationBatching.setEnabled(enabled);
    }

    @Deprecated
    public void setFetchInMemoryState(boolean fetchInMemoryState) {
        this.clustering.stateRetrieval.setFetchInMemoryState(fetchInMemoryState);
    }

    @Deprecated
    public void setAlwaysProvideInMemoryState(boolean alwaysProvideInMemoryState) {
        this.clustering.stateRetrieval.setAlwaysProvideInMemoryState(alwaysProvideInMemoryState);
    }

    @Deprecated
    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout) {
        this.locking.setLockAcquisitionTimeout(lockAcquisitionTimeout);
    }

    @Deprecated
    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout, TimeUnit timeUnit) {
        this.setLockAcquisitionTimeout(timeUnit.toMillis(lockAcquisitionTimeout));
    }

    @Deprecated
    public void setSyncReplTimeout(long syncReplTimeout) {
        this.clustering.sync.setReplTimeout(syncReplTimeout);
    }

    @Deprecated
    public void setSyncReplTimeout(long syncReplTimeout, TimeUnit timeUnit) {
        this.setSyncReplTimeout(timeUnit.toMillis(syncReplTimeout));
    }

    @Deprecated
    public void setCacheMode(CacheMode cacheModeInt) {
        this.clustering.setMode(cacheModeInt);
    }

    @Deprecated
    public void setCacheMode(String cacheMode) {
        if (cacheMode == null) {
            throw new ConfigurationException("Cache mode cannot be null", "CacheMode");
        }
        this.clustering.setMode(CacheMode.valueOf(this.uc(cacheMode)));
        if (this.clustering.mode == null) {
            this.log.warn("Unknown cache mode '" + cacheMode + "', using defaults.");
            this.clustering.setMode(CacheMode.LOCAL);
        }
    }

    public String getCacheModeString() {
        return this.clustering.mode == null ? null : this.clustering.mode.toString();
    }

    @Deprecated
    public void setCacheModeString(String cacheMode) {
        this.setCacheMode(cacheMode);
    }

    @Deprecated
    public void setDataContainerClass(Class<? extends DataContainer> dataContainerClass) {
        this.dataContainer.setClass(dataContainerClass.getName());
    }

    @Deprecated
    public void setDataContainerClass(String dataContainerClass) {
        this.dataContainer.setClass(dataContainerClass);
    }

    public String getDataContainerClass() {
        return this.dataContainer.dataContainerClass;
    }

    @Deprecated
    public void setDataContainer(DataContainer dataContainer) {
        this.dataContainer.setDataContainer(dataContainer);
    }

    public DataContainer getDataContainer() {
        return this.dataContainer.dataContainer;
    }

    @Deprecated
    public void setDataContainerProperties(TypedProperties properties) {
        this.dataContainer.setProperties(properties);
    }

    public TypedProperties getDataContainerProperties() {
        return this.dataContainer.properties;
    }

    public long getEvictionWakeUpInterval() {
        return this.eviction.wakeUpInterval;
    }

    @Deprecated
    public void setEvictionWakeUpInterval(long evictionWakeUpInterval) {
        this.eviction.setWakeUpInterval(evictionWakeUpInterval);
    }

    public EvictionStrategy getEvictionStrategy() {
        return this.eviction.strategy;
    }

    @Deprecated
    public void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.eviction.setStrategy(evictionStrategy);
    }

    @Deprecated
    public void setEvictionStrategy(String eStrategy) {
        this.eviction.strategy = EvictionStrategy.valueOf(this.uc(eStrategy));
        if (this.eviction.strategy == null) {
            this.log.warn("Unknown evictionStrategy  '" + eStrategy + "'!  Using EvictionStrategy.NONE.");
            this.eviction.setStrategy(EvictionStrategy.NONE);
        }
    }

    public EvictionThreadPolicy getEvictionThreadPolicy() {
        return this.eviction.threadPolicy;
    }

    @Deprecated
    public void setEvictionThreadPolicy(EvictionThreadPolicy policy) {
        this.eviction.setThreadPolicy(policy);
    }

    @Deprecated
    public void setEvictionThreadPolicy(String policy) {
        this.eviction.threadPolicy = EvictionThreadPolicy.valueOf(this.uc(policy));
        if (this.eviction.threadPolicy == null) {
            this.log.warn("Unknown thread eviction policy  '" + policy + "'!  Using EvictionThreadPolicy.DEFAULT");
            this.eviction.setThreadPolicy(EvictionThreadPolicy.DEFAULT);
        }
    }

    public int getEvictionMaxEntries() {
        return this.eviction.maxEntries;
    }

    @Deprecated
    public void setEvictionMaxEntries(int evictionMaxEntries) {
        this.eviction.setMaxEntries(evictionMaxEntries);
    }

    public long getExpirationLifespan() {
        return this.expiration.lifespan;
    }

    @Deprecated
    public void setExpirationLifespan(long expirationLifespan) {
        this.expiration.setLifespan(expirationLifespan);
    }

    public long getExpirationMaxIdle() {
        return this.expiration.maxIdle;
    }

    @Deprecated
    public void setExpirationMaxIdle(long expirationMaxIdle) {
        this.expiration.setMaxIdle(expirationMaxIdle);
    }

    @Deprecated
    public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
        this.transaction.setTransactionManagerLookupClass(transactionManagerLookupClass);
    }

    @Deprecated
    public void setTransactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.transaction.usingTransactionManagerLookup(transactionManagerLookup);
    }

    public void setCacheLoaderManagerConfig(CacheLoaderManagerConfig cacheLoaderManagerConfig) {
        this.loaders = cacheLoaderManagerConfig;
    }

    @Deprecated
    public void setSyncCommitPhase(boolean syncCommitPhase) {
        this.transaction.setSyncCommitPhase(syncCommitPhase);
    }

    @Deprecated
    public void setSyncRollbackPhase(boolean syncRollbackPhase) {
        this.transaction.setSyncRollbackPhase(syncRollbackPhase);
    }

    @Deprecated
    public void setUseEagerLocking(boolean useEagerLocking) {
        this.transaction.setUseEagerLocking(useEagerLocking);
    }

    @Deprecated
    public void setEagerLockSingleNode(boolean eagerLockSingleNode) {
        this.transaction.setEagerLockSingleNode(eagerLockSingleNode);
    }

    @Deprecated
    public Configuration setCacheStopTimeout(int cacheStopTimeout) {
        this.transaction.setCacheStopTimeout(cacheStopTimeout);
        return this;
    }

    @Deprecated
    public void setUseReplQueue(boolean useReplQueue) {
        this.clustering.async.setUseReplQueue(useReplQueue);
    }

    @Deprecated
    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.locking.setIsolationLevel(isolationLevel);
    }

    @Deprecated
    public void setStateRetrievalTimeout(long stateRetrievalTimeout) {
        this.clustering.stateRetrieval.setTimeout(stateRetrievalTimeout);
    }

    @Deprecated
    public void setStateRetrievalTimeout(long stateRetrievalTimeout, TimeUnit timeUnit) {
        this.setStateRetrievalTimeout(timeUnit.toMillis(stateRetrievalTimeout));
    }

    @Deprecated
    public void setStateRetrievalLogFlushTimeout(long logFlushTimeout) {
        this.clustering.stateRetrieval.setLogFlushTimeout(logFlushTimeout);
    }

    @Deprecated
    public void setStateRetrievalLogFlushTimeout(long logFlushTimeout, TimeUnit timeUnit) {
        this.clustering.stateRetrieval.setLogFlushTimeout(timeUnit.toMillis(logFlushTimeout));
    }

    @Deprecated
    public void setStateRetrievalMaxNonProgressingLogWrites(int maxNonProgressingLogWrites) {
        this.clustering.stateRetrieval.setMaxNonProgressingLogWrites(maxNonProgressingLogWrites);
    }

    @Deprecated
    public void setStateRetrievalInitialRetryWaitTime(long initialRetryWaitTime) {
        this.clustering.stateRetrieval.setInitialRetryWaitTime(initialRetryWaitTime);
    }

    @Deprecated
    public void setStateRetrievalInitialRetryWaitTime(long initialRetryWaitTime, TimeUnit timeUnit) {
        this.setStateRetrievalInitialRetryWaitTime(timeUnit.toMillis(initialRetryWaitTime));
    }

    @Deprecated
    public void setStateRetrievalRetryWaitTimeIncreaseFactor(int retryWaitTimeIncreaseFactor) {
        this.clustering.stateRetrieval.setRetryWaitTimeIncreaseFactor(retryWaitTimeIncreaseFactor);
    }

    @Deprecated
    public void setStateRetrievalNumRetries(int numRetries) {
        this.clustering.stateRetrieval.setNumRetries(numRetries);
    }

    @Deprecated
    public void setIsolationLevel(String isolationLevel) {
        if (isolationLevel == null) {
            throw new ConfigurationException("Isolation level cannot be null", "IsolationLevel");
        }
        this.locking.setIsolationLevel(IsolationLevel.valueOf(this.uc(isolationLevel)));
        if (this.locking.isolationLevel == null) {
            this.log.warn("Unknown isolation level '" + isolationLevel + "', using defaults.");
            this.locking.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        }
    }

    public void setUseLazyDeserialization(boolean useLazyDeserialization) {
        this.lazyDeserialization.setEnabled(useLazyDeserialization);
    }

    @Deprecated
    public void setL1CacheEnabled(boolean l1CacheEnabled) {
        this.clustering.l1.setEnabled(l1CacheEnabled);
    }

    @Deprecated
    public void setL1Lifespan(long l1Lifespan) {
        this.clustering.l1.setLifespan(l1Lifespan);
    }

    @Deprecated
    public void setL1OnRehash(boolean l1OnRehash) {
        this.clustering.l1.setOnRehash(l1OnRehash);
    }

    @Deprecated
    public void setConsistentHashClass(String consistentHashClass) {
        this.clustering.hash.setConsistentHashClass(consistentHashClass);
    }

    @Deprecated
    public void setHashFunctionClass(String hashFunctionClass) {
        this.clustering.hash.hashFunctionClass = hashFunctionClass;
    }

    @Deprecated
    public void setNumOwners(int numOwners) {
        this.clustering.hash.setNumOwners(numOwners);
    }

    @Deprecated
    public void setRehashEnabled(boolean rehashEnabled) {
        this.clustering.hash.setRehashEnabled(rehashEnabled);
    }

    @Deprecated
    public void setRehashWaitTime(long rehashWaitTime) {
        this.clustering.hash.setRehashWait(rehashWaitTime);
    }

    @Deprecated
    public void setUseAsyncMarshalling(boolean useAsyncMarshalling) {
        this.clustering.async.setAsyncMarshalling(useAsyncMarshalling);
    }

    @Deprecated
    public void setIndexingEnabled(boolean enabled) {
        this.indexing.setEnabled(enabled);
    }

    @Deprecated
    public void setIndexLocalOnly(boolean indexLocalOnly) {
        this.indexing.setIndexLocalOnly(indexLocalOnly);
    }

    public boolean isUseAsyncMarshalling() {
        return this.clustering.async.asyncMarshalling;
    }

    public boolean isUseReplQueue() {
        return this.clustering.async.useReplQueue;
    }

    public int getReplQueueMaxElements() {
        return this.clustering.async.replQueueMaxElements;
    }

    public long getReplQueueInterval() {
        return this.clustering.async.replQueueInterval;
    }

    public String getReplQueueClass() {
        return this.clustering.async.replQueueClass;
    }

    public boolean isExposeJmxStatistics() {
        return this.jmxStatistics.enabled;
    }

    public boolean isInvocationBatchingEnabled() {
        return this.invocationBatching.enabled;
    }

    public boolean isIndexingEnabled() {
        return this.indexing.isEnabled();
    }

    public boolean isIndexLocalOnly() {
        return this.indexing.isIndexLocalOnly();
    }

    public boolean isFetchInMemoryState() {
        return this.clustering.stateRetrieval.fetchInMemoryState;
    }

    public boolean isAlwaysProvideInMemoryState() {
        return this.clustering.stateRetrieval.alwaysProvideInMemoryState;
    }

    public long getLockAcquisitionTimeout() {
        return this.locking.lockAcquisitionTimeout;
    }

    public long getSyncReplTimeout() {
        return this.clustering.sync.replTimeout;
    }

    public CacheMode getCacheMode() {
        return this.clustering.mode;
    }

    public IsolationLevel getIsolationLevel() {
        return this.locking.isolationLevel;
    }

    public String getTransactionManagerLookupClass() {
        return this.transaction.transactionManagerLookupClass;
    }

    public TransactionManagerLookup getTransactionManagerLookup() {
        return this.transaction.transactionManagerLookup;
    }

    public CacheLoaderManagerConfig getCacheLoaderManagerConfig() {
        return this.loaders;
    }

    public boolean isSyncCommitPhase() {
        return this.transaction.syncCommitPhase;
    }

    public boolean isSyncRollbackPhase() {
        return this.transaction.syncRollbackPhase;
    }

    public boolean isUseEagerLocking() {
        return this.transaction.useEagerLocking;
    }

    public boolean isEagerLockSingleNode() {
        return this.transaction.eagerLockSingleNode;
    }

    public int getCacheStopTimeout() {
        return this.transaction.cacheStopTimeout;
    }

    public long getStateRetrievalTimeout() {
        return this.clustering.stateRetrieval.timeout;
    }

    public long getStateRetrievalInitialRetryWaitTime() {
        return this.clustering.stateRetrieval.initialRetryWaitTime;
    }

    public int getStateRetrievalRetryWaitTimeIncreaseFactor() {
        return this.clustering.stateRetrieval.retryWaitTimeIncreaseFactor;
    }

    public int getStateRetrievalNumRetries() {
        return this.clustering.stateRetrieval.numRetries;
    }

    public int getStateRetrievalMaxNonProgressingLogWrites() {
        return this.clustering.stateRetrieval.maxNonProgressingLogWrites;
    }

    public long getStateRetrievalLogFlushTimeout() {
        return this.clustering.stateRetrieval.logFlushTimeout;
    }

    public boolean isUseLazyDeserialization() {
        return this.lazyDeserialization.enabled;
    }

    public boolean isL1CacheEnabled() {
        return this.clustering.l1.enabled;
    }

    public long getL1Lifespan() {
        return this.clustering.l1.lifespan;
    }

    public boolean isL1OnRehash() {
        return this.clustering.l1.onRehash;
    }

    public String getConsistentHashClass() {
        if (this.clustering.hash.consistentHashClass == null) {
            this.clustering.hash.consistentHashClass = this.globalConfiguration == null || this.globalConfiguration.hasTopologyInfo() ? TopologyAwareConsistentHash.class.getName() : DefaultConsistentHash.class.getName();
        }
        return this.clustering.hash.consistentHashClass;
    }

    public String getHashFunctionClass() {
        return this.clustering.hash.hashFunctionClass;
    }

    public int getNumOwners() {
        return this.clustering.hash.numOwners;
    }

    public boolean isRehashEnabled() {
        return this.clustering.hash.rehashEnabled;
    }

    public long getRehashWaitTime() {
        return this.clustering.hash.rehashWait;
    }

    public void accept(ConfigurationBeanVisitor v) {
        this.clustering.accept(v);
        this.customInterceptors.accept(v);
        this.dataContainer.accept(v);
        this.deadlockDetection.accept(v);
        this.eviction.accept(v);
        this.expiration.accept(v);
        this.invocationBatching.accept(v);
        this.jmxStatistics.accept(v);
        this.lazyDeserialization.accept(v);
        this.loaders.accept(v);
        this.locking.accept(v);
        this.transaction.accept(v);
        this.unsafe.accept(v);
        this.indexing.accept(v);
        v.visitConfiguration(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)o;
        if (this.clustering != null ? !this.clustering.equals(that.clustering) : that.clustering != null) {
            return false;
        }
        if (this.customInterceptors != null ? !this.customInterceptors.equals(that.customInterceptors) : that.customInterceptors != null) {
            return false;
        }
        if (this.dataContainer != null ? !this.dataContainer.equals(that.dataContainer) : that.dataContainer != null) {
            return false;
        }
        if (this.deadlockDetection != null ? !this.deadlockDetection.equals(that.deadlockDetection) : that.deadlockDetection != null) {
            return false;
        }
        if (this.eviction != null ? !this.eviction.equals(that.eviction) : that.eviction != null) {
            return false;
        }
        if (this.expiration != null ? !this.expiration.equals(that.expiration) : that.expiration != null) {
            return false;
        }
        if (this.globalConfiguration != null ? !this.globalConfiguration.equals(that.globalConfiguration) : that.globalConfiguration != null) {
            return false;
        }
        if (this.invocationBatching != null ? !this.invocationBatching.equals(that.invocationBatching) : that.invocationBatching != null) {
            return false;
        }
        if (this.jmxStatistics != null ? !this.jmxStatistics.equals(that.jmxStatistics) : that.jmxStatistics != null) {
            return false;
        }
        if (this.lazyDeserialization != null ? !this.lazyDeserialization.equals(that.lazyDeserialization) : that.lazyDeserialization != null) {
            return false;
        }
        if (this.loaders != null ? !this.loaders.equals(that.loaders) : that.loaders != null) {
            return false;
        }
        if (this.locking != null ? !this.locking.equals(that.locking) : that.locking != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.transaction != null ? !this.transaction.equals(that.transaction) : that.transaction != null) {
            return false;
        }
        return !(this.unsafe != null ? !this.unsafe.equals(that.unsafe) : that.unsafe != null);
    }

    public int hashCode() {
        int result = this.globalConfiguration != null ? this.globalConfiguration.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.locking != null ? this.locking.hashCode() : 0);
        result = 31 * result + (this.loaders != null ? this.loaders.hashCode() : 0);
        result = 31 * result + (this.transaction != null ? this.transaction.hashCode() : 0);
        result = 31 * result + (this.customInterceptors != null ? this.customInterceptors.hashCode() : 0);
        result = 31 * result + (this.dataContainer != null ? this.dataContainer.hashCode() : 0);
        result = 31 * result + (this.eviction != null ? this.eviction.hashCode() : 0);
        result = 31 * result + (this.expiration != null ? this.expiration.hashCode() : 0);
        result = 31 * result + (this.unsafe != null ? this.unsafe.hashCode() : 0);
        result = 31 * result + (this.clustering != null ? this.clustering.hashCode() : 0);
        result = 31 * result + (this.jmxStatistics != null ? this.jmxStatistics.hashCode() : 0);
        result = 31 * result + (this.lazyDeserialization != null ? this.lazyDeserialization.hashCode() : 0);
        result = 31 * result + (this.invocationBatching != null ? this.invocationBatching.hashCode() : 0);
        result = 31 * result + (this.deadlockDetection != null ? this.deadlockDetection.hashCode() : 0);
        return result;
    }

    @Override
    public Configuration clone() {
        try {
            Configuration dolly = (Configuration)super.clone();
            if (this.clustering != null) {
                dolly.clustering = this.clustering.clone();
            }
            if (this.globalConfiguration != null) {
                dolly.globalConfiguration = this.globalConfiguration.clone();
            }
            if (this.locking != null) {
                dolly.locking = (LockingType)this.locking.clone();
            }
            if (this.loaders != null) {
                dolly.loaders = this.loaders.clone();
            }
            if (this.transaction != null) {
                dolly.transaction = (TransactionType)this.transaction.clone();
            }
            if (this.customInterceptors != null) {
                dolly.customInterceptors = this.customInterceptors.clone();
            }
            if (this.dataContainer != null) {
                dolly.dataContainer = (DataContainerType)this.dataContainer.clone();
            }
            if (this.eviction != null) {
                dolly.eviction = (EvictionType)this.eviction.clone();
            }
            if (this.expiration != null) {
                dolly.expiration = (ExpirationType)this.expiration.clone();
            }
            if (this.unsafe != null) {
                dolly.unsafe = (UnsafeType)this.unsafe.clone();
            }
            if (this.clustering != null) {
                dolly.clustering = this.clustering.clone();
            }
            if (this.jmxStatistics != null) {
                dolly.jmxStatistics = (JmxStatistics)this.jmxStatistics.clone();
            }
            if (this.lazyDeserialization != null) {
                dolly.lazyDeserialization = (LazyDeserialization)this.lazyDeserialization.clone();
            }
            if (this.invocationBatching != null) {
                dolly.invocationBatching = (InvocationBatching)this.invocationBatching.clone();
            }
            if (this.deadlockDetection != null) {
                dolly.deadlockDetection = (DeadlockDetectionType)this.deadlockDetection.clone();
            }
            if (this.indexing != null) {
                dolly.indexing = this.indexing.clone();
            }
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Unexpected!", e);
        }
    }

    public boolean isUsingCacheLoaders() {
        return this.getCacheLoaderManagerConfig() != null && !this.getCacheLoaderManagerConfig().getCacheLoaderConfigs().isEmpty();
    }

    public List<CustomInterceptorConfig> getCustomInterceptors() {
        return this.customInterceptors.customInterceptors == null ? Collections.emptyList() : this.customInterceptors.customInterceptors;
    }

    @Deprecated
    public void setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
        this.customInterceptors.setCustomInterceptors(customInterceptors);
    }

    public void assertValid() throws ConfigurationException {
        if (this.clustering.mode.isDistributed() && this.clustering.stateRetrieval.fetchInMemoryState.booleanValue()) {
            throw new ConfigurationException("Cache cannot use DISTRIBUTION mode and have fetchInMemoryState set to true.  Perhaps you meant to enable rehashing?");
        }
        if (this.clustering.mode.isClustered() && this.globalConfiguration != null && (this.globalConfiguration.getTransportClass() == null || this.globalConfiguration.getTransportClass().length() == 0)) {
            throw new ConfigurationException("Cache cannot use a clustered mode (" + (Object)((Object)this.clustering.mode) + ") mode and not define a transport!");
        }
    }

    public boolean isOnePhaseCommit() {
        return !this.getCacheMode().isSynchronous();
    }

    public static enum CacheMode {
        LOCAL,
        REPL_SYNC,
        REPL_ASYNC,
        INVALIDATION_SYNC,
        INVALIDATION_ASYNC,
        DIST_SYNC,
        DIST_ASYNC;


        public boolean isInvalidation() {
            return this == INVALIDATION_SYNC || this == INVALIDATION_ASYNC;
        }

        public boolean isSynchronous() {
            return this == REPL_SYNC || this == DIST_SYNC || this == INVALIDATION_SYNC || this == LOCAL;
        }

        public boolean isClustered() {
            return this != LOCAL;
        }

        public boolean isDistributed() {
            return this == DIST_SYNC || this == DIST_ASYNC;
        }

        public boolean isReplicated() {
            return this == REPL_SYNC || this == REPL_ASYNC;
        }

        public CacheMode toSync() {
            switch (this) {
                case REPL_ASYNC: {
                    return REPL_SYNC;
                }
                case INVALIDATION_ASYNC: {
                    return INVALIDATION_SYNC;
                }
                case DIST_ASYNC: {
                    return DIST_SYNC;
                }
            }
            return this;
        }

        public CacheMode toAsync() {
            switch (this) {
                case REPL_SYNC: {
                    return REPL_ASYNC;
                }
                case INVALIDATION_SYNC: {
                    return INVALIDATION_ASYNC;
                }
                case DIST_SYNC: {
                    return DIST_ASYNC;
                }
            }
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="indexing")
    public static class QueryConfigurationBean
    extends AbstractConfigurationBean
    implements IndexingConfig {
        private static final long serialVersionUID = 2891683014353342549L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setIndexingEnabled")
        protected Boolean enabled = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setIndexLocalOnly")
        protected Boolean indexLocalOnly = false;

        public Boolean isEnabled() {
            return this.enabled;
        }

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        @Override
        public IndexingConfig enabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
            return this;
        }

        public Boolean isIndexLocalOnly() {
            return this.indexLocalOnly;
        }

        @XmlAttribute
        public void setIndexLocalOnly(Boolean indexLocalOnly) {
            this.testImmutability("indexLocalOnly");
            this.indexLocalOnly = indexLocalOnly;
        }

        @Override
        public IndexingConfig indexLocalOnly(Boolean indexLocalOnly) {
            this.testImmutability("indexLocalOnly");
            this.indexLocalOnly = indexLocalOnly;
            return this;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitQueryConfigurationBean(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QueryConfigurationBean)) {
                return false;
            }
            QueryConfigurationBean that = (QueryConfigurationBean)o;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
                return false;
            }
            return !(this.indexLocalOnly != null ? !this.indexLocalOnly.equals(that.indexLocalOnly) : that.indexLocalOnly != null);
        }

        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.indexLocalOnly != null ? this.indexLocalOnly.hashCode() : 0);
            return result;
        }

        @Override
        protected boolean hasComponentStarted() {
            return false;
        }

        @Override
        public QueryConfigurationBean clone() {
            try {
                QueryConfigurationBean dolly = (QueryConfigurationBean)super.clone();
                dolly.enabled = this.enabled;
                dolly.indexLocalOnly = this.indexLocalOnly;
                return dolly;
            }
            catch (CloneNotSupportedException shouldNotHappen) {
                throw new RuntimeException("Should not happen!", shouldNotHappen);
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ConfigurationDoc(name="customInterceptors")
    public static class CustomInterceptorsType
    extends AbstractNamedCacheConfigurationBean
    implements CustomInterceptorsConfig {
        private static final long serialVersionUID = 7187545782011884661L;
        @XmlElement(name="interceptor")
        private List<CustomInterceptorConfig> customInterceptors = new ArrayList<CustomInterceptorConfig>();

        @Override
        public CustomInterceptorsType clone() throws CloneNotSupportedException {
            CustomInterceptorsType dolly = (CustomInterceptorsType)super.clone();
            if (this.customInterceptors != null) {
                dolly.customInterceptors = new ArrayList<CustomInterceptorConfig>();
                for (CustomInterceptorConfig config : this.customInterceptors) {
                    CustomInterceptorConfig clone = config.clone();
                    dolly.customInterceptors.add(clone);
                }
            }
            return dolly;
        }

        public void accept(ConfigurationBeanVisitor v) {
            for (CustomInterceptorConfig i : this.customInterceptors) {
                i.accept(v);
            }
            v.visitCustomInterceptorsType(this);
        }

        public List<CustomInterceptorConfig> getCustomInterceptors() {
            return this.customInterceptors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CustomInterceptorsType)) {
                return false;
            }
            CustomInterceptorsType that = (CustomInterceptorsType)o;
            return !(this.customInterceptors != null ? !((Object)this.customInterceptors).equals(that.customInterceptors) : that.customInterceptors != null);
        }

        public int hashCode() {
            return this.customInterceptors != null ? ((Object)this.customInterceptors).hashCode() : 0;
        }

        @Override
        public CustomInterceptorsConfig setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
            this.testImmutability("customInterceptors");
            this.customInterceptors = customInterceptors;
            return this;
        }

        @Override
        public CustomInterceptorsConfig addCustomInterceptor(CustomInterceptorConfig config) {
            this.getCustomInterceptors().add(config);
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="unsafe")
    public static class UnsafeType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -9200921443651234163L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setUnsafeUnreliableReturnValues")
        protected Boolean unreliableReturnValues = false;

        @XmlAttribute
        public void setUnreliableReturnValues(Boolean unreliableReturnValues) {
            this.testImmutability("unreliableReturnValues");
            this.unreliableReturnValues = unreliableReturnValues;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitUnsafeType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnsafeType)) {
                return false;
            }
            UnsafeType that = (UnsafeType)o;
            return !(this.unreliableReturnValues != null ? !this.unreliableReturnValues.equals(that.unreliableReturnValues) : that.unreliableReturnValues != null);
        }

        public int hashCode() {
            return this.unreliableReturnValues != null ? this.unreliableReturnValues.hashCode() : 0;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="deadlockDetection")
    public static class DeadlockDetectionType
    extends AbstractNamedCacheConfigurationBean
    implements DeadlockDetectionConfig {
        private static final long serialVersionUID = -7178286048602531152L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEnableDeadlockDetection")
        protected Boolean enabled = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setDeadlockDetectionSpinDuration")
        protected Long spinDuration = 100L;

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        @Override
        public DeadlockDetectionConfig enabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
            return this;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitDeadlockDetectionType(this);
        }

        @XmlAttribute
        public void setSpinDuration(Long spinDuration) {
            this.testImmutability("spinDuration");
            this.spinDuration = spinDuration;
        }

        @Override
        public DeadlockDetectionConfig spinDuration(Long spinDuration) {
            this.testImmutability("spinDuration");
            this.spinDuration = spinDuration;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeadlockDetectionType)) {
                return false;
            }
            DeadlockDetectionType that = (DeadlockDetectionType)o;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
                return false;
            }
            return !(this.spinDuration != null ? !this.spinDuration.equals(that.spinDuration) : that.spinDuration != null);
        }

        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.spinDuration != null ? this.spinDuration.hashCode() : 0);
            return result;
        }
    }

    @ConfigurationDoc(name="invocationBatching")
    public static class InvocationBatching
    extends BooleanAttributeType {
        private static final long serialVersionUID = 5854115656815587815L;

        public InvocationBatching() {
            super("invocationBatching");
        }
    }

    @ConfigurationDoc(name="jmxStatistics")
    public static class JmxStatistics
    extends BooleanAttributeType {
        private static final long serialVersionUID = 8716456707015486673L;

        public JmxStatistics() {
            super("jmxStatistics");
        }
    }

    @ConfigurationDoc(name="lazyDeserialization")
    public static class LazyDeserialization
    extends BooleanAttributeType {
        private static final long serialVersionUID = 7404820498857564962L;

        public LazyDeserialization() {
            super("lazyDeserialization");
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class BooleanAttributeType
    extends AbstractNamedCacheConfigurationBean {
        @XmlTransient
        protected final String fieldName;
        private static final long serialVersionUID = 2296863404153834686L;
        @ConfigurationDoc(desc="Toggle switch")
        protected Boolean enabled = false;

        public BooleanAttributeType() {
            this.fieldName = "undefined";
        }

        public BooleanAttributeType(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitBooleanAttributeType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BooleanAttributeType)) {
                return false;
            }
            BooleanAttributeType that = (BooleanAttributeType)o;
            return !(this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null);
        }

        public int hashCode() {
            return this.enabled != null ? this.enabled.hashCode() : 0;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="l1")
    public static class L1Type
    extends AbstractNamedCacheConfigurationBean
    implements L1Config {
        private static final long serialVersionUID = -4703587764861110638L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setL1CacheEnabled")
        protected Boolean enabled = true;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setL1Lifespan")
        protected Long lifespan = 600000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setL1OnRehash")
        protected Boolean onRehash = true;

        @XmlAttribute
        public L1Config setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
            return this;
        }

        @Override
        public L1Config enabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
            return this;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitL1Type(this);
        }

        @XmlAttribute
        public L1Config setLifespan(Long lifespan) {
            this.testImmutability("lifespan");
            this.lifespan = lifespan;
            return this;
        }

        @XmlAttribute
        public L1Config setOnRehash(Boolean onRehash) {
            this.testImmutability("onRehash");
            this.onRehash = onRehash;
            return this;
        }

        @Override
        public L1Config lifespan(Long lifespan) {
            this.testImmutability("lifespan");
            this.lifespan = lifespan;
            return this;
        }

        @Override
        public L1Config onRehash(Boolean onRehash) {
            this.testImmutability("onRehash");
            this.onRehash = onRehash;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof L1Type)) {
                return false;
            }
            L1Type l1Type = (L1Type)o;
            if (this.enabled != null ? !this.enabled.equals(l1Type.enabled) : l1Type.enabled != null) {
                return false;
            }
            if (this.lifespan != null ? !this.lifespan.equals(l1Type.lifespan) : l1Type.lifespan != null) {
                return false;
            }
            return !(this.onRehash != null ? !this.onRehash.equals(l1Type.onRehash) : l1Type.onRehash != null);
        }

        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.lifespan != null ? this.lifespan.hashCode() : 0);
            result = 31 * result + (this.onRehash != null ? this.onRehash.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="hash")
    public static class HashType
    extends AbstractNamedCacheConfigurationBean
    implements HashConfig {
        private static final long serialVersionUID = 752218766840948822L;
        @ConfigurationDocRef(name="class", bean=Configuration.class, targetElement="setConsistentHashClass")
        protected String consistentHashClass;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setHashFunctionClass")
        protected String hashFunctionClass = MurmurHash3.class.getName();
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setNumOwners")
        protected Integer numOwners = 2;
        @ConfigurationDoc(desc="Future flag. Currenly unused.")
        protected Long rehashWait = TimeUnit.MINUTES.toMillis(1L);
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setRehashRpcTimeout")
        protected Long rehashRpcTimeout = TimeUnit.MINUTES.toMillis(10L);
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setRehashEnabled")
        protected Boolean rehashEnabled = true;

        @XmlAttribute(name="class")
        public void setConsistentHashClass(String consistentHashClass) {
            this.testImmutability("consistentHashClass");
            this.consistentHashClass = consistentHashClass;
        }

        @XmlAttribute
        public void setHashFunctionClass(String hashFunctionClass) {
            this.testImmutability("hashFunctionClass");
            this.hashFunctionClass = hashFunctionClass;
        }

        @Override
        public HashConfig consistentHashClass(String consistentHashClass) {
            this.testImmutability("consistentHashClass");
            this.consistentHashClass = consistentHashClass;
            return this;
        }

        @Override
        public HashConfig hashFunctionClass(String hashFunctionClass) {
            this.testImmutability("hashFunctionClass");
            this.hashFunctionClass = hashFunctionClass;
            return this;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitHashType(this);
        }

        @XmlAttribute
        public void setNumOwners(Integer numOwners) {
            this.testImmutability("numOwners");
            this.numOwners = numOwners;
        }

        @XmlAttribute
        public void setRehashWait(Long rehashWaitTime) {
            this.testImmutability("rehashWait");
            this.rehashWait = rehashWaitTime;
        }

        @XmlAttribute
        public void setRehashRpcTimeout(Long rehashRpcTimeout) {
            this.testImmutability("rehashRpcTimeout");
            this.rehashRpcTimeout = rehashRpcTimeout;
        }

        @XmlAttribute
        public void setRehashEnabled(Boolean rehashEnabled) {
            this.testImmutability("rehashEnabled");
            this.rehashEnabled = rehashEnabled;
        }

        @Override
        public HashConfig numOwners(Integer numOwners) {
            this.testImmutability("numOwners");
            this.numOwners = numOwners;
            return this;
        }

        @Override
        public HashConfig rehashWait(Long rehashWaitTime) {
            this.testImmutability("rehashWait");
            this.rehashWait = rehashWaitTime;
            return this;
        }

        @Override
        public HashConfig rehashRpcTimeout(Long rehashRpcTimeout) {
            this.testImmutability("rehashRpcTimeout");
            this.rehashRpcTimeout = rehashRpcTimeout;
            return this;
        }

        @Override
        public HashConfig rehashEnabled(Boolean rehashEnabled) {
            this.testImmutability("rehashEnabled");
            this.rehashEnabled = rehashEnabled;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HashType)) {
                return false;
            }
            HashType hashType = (HashType)o;
            if (this.consistentHashClass != null ? !this.consistentHashClass.equals(hashType.consistentHashClass) : hashType.consistentHashClass != null) {
                return false;
            }
            if (this.hashFunctionClass != null ? !this.hashFunctionClass.equals(hashType.hashFunctionClass) : hashType.hashFunctionClass != null) {
                return false;
            }
            if (this.numOwners != null ? !this.numOwners.equals(hashType.numOwners) : hashType.numOwners != null) {
                return false;
            }
            if (this.rehashRpcTimeout != null ? !this.rehashRpcTimeout.equals(hashType.rehashRpcTimeout) : hashType.rehashRpcTimeout != null) {
                return false;
            }
            if (this.rehashWait != null ? !this.rehashWait.equals(hashType.rehashWait) : hashType.rehashWait != null) {
                return false;
            }
            return this.rehashEnabled == hashType.rehashEnabled;
        }

        public int hashCode() {
            int result = this.consistentHashClass != null ? this.consistentHashClass.hashCode() : 0;
            result = 31 * result + (this.hashFunctionClass != null ? this.hashFunctionClass.hashCode() : 0);
            result = 31 * result + (this.numOwners != null ? this.numOwners.hashCode() : 0);
            result = 31 * result + (this.rehashWait != null ? this.rehashWait.hashCode() : 0);
            result = 31 * result + (this.rehashRpcTimeout != null ? this.rehashRpcTimeout.hashCode() : 0);
            result = 31 * result + (this.rehashEnabled != false ? 0 : 1);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="sync")
    public static class SyncType
    extends AbstractNamedCacheConfigurationBean
    implements SyncConfig {
        private static final long serialVersionUID = 8419216253674289524L;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setSyncReplTimeout")
        protected Long replTimeout = 15000L;
        @XmlTransient
        private boolean unmarshalledFromXml = false;

        @XmlAttribute
        public void setReplTimeout(Long replTimeout) {
            this.testImmutability("replTimeout");
            this.replTimeout = replTimeout;
        }

        @Override
        public SyncConfig replTimeout(Long replTimeout) {
            this.testImmutability("replTimeout");
            this.replTimeout = replTimeout;
            return this;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitSyncType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SyncType)) {
                return false;
            }
            SyncType syncType = (SyncType)o;
            return !(this.replTimeout != null ? !this.replTimeout.equals(syncType.replTimeout) : syncType.replTimeout != null);
        }

        public int hashCode() {
            return this.replTimeout != null ? this.replTimeout.hashCode() : 0;
        }

        @Override
        public void willUnmarshall(Object parent) {
            ClusteringType clustering = (ClusteringType)parent;
            if (clustering.async.unmarshalledFromXml) {
                throw new ConfigurationException("Cannot have both <sync /> and <async /> tags in a <clustering /> tag!");
            }
            this.unmarshalledFromXml = true;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="stateRetrieval")
    public static class StateRetrievalType
    extends AbstractNamedCacheConfigurationBean
    implements StateRetrievalConfig {
        private static final long serialVersionUID = 3709234918426217096L;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setFetchInMemoryState")
        protected Boolean fetchInMemoryState = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setAlwaysProvideInMemoryState")
        protected Boolean alwaysProvideInMemoryState = false;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalTimeout")
        protected Long timeout = 10000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalInitialRetryWaitTime")
        protected Long initialRetryWaitTime = 500L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalRetryWaitTimeIncreaseFactor")
        protected Integer retryWaitTimeIncreaseFactor = 2;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalNumRetries")
        protected Integer numRetries = 5;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalLogFlushTimeout")
        protected Long logFlushTimeout = 60000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setStateRetrievalMaxNonProgressingLogWrites")
        protected Integer maxNonProgressingLogWrites = 100;

        @XmlAttribute
        public void setFetchInMemoryState(Boolean fetchInMemoryState) {
            this.testImmutability("fetchInMemoryState");
            this.fetchInMemoryState = fetchInMemoryState;
        }

        @XmlAttribute
        public void setAlwaysProvideInMemoryState(Boolean alwaysProvideInMemoryState) {
            this.testImmutability("alwaysProvideInMemoryState");
            this.alwaysProvideInMemoryState = alwaysProvideInMemoryState;
        }

        @XmlAttribute
        public void setInitialRetryWaitTime(Long initialRetryWaitTime) {
            this.testImmutability("initialWaitTime");
            this.initialRetryWaitTime = initialRetryWaitTime;
        }

        @XmlAttribute
        public void setRetryWaitTimeIncreaseFactor(Integer retryWaitTimeIncreaseFactor) {
            this.testImmutability("retryWaitTimeIncreaseFactor");
            this.retryWaitTimeIncreaseFactor = retryWaitTimeIncreaseFactor;
        }

        @XmlAttribute
        public void setNumRetries(Integer numRetries) {
            this.testImmutability("numRetries");
            this.numRetries = numRetries;
        }

        @XmlAttribute
        public void setTimeout(Long timeout) {
            this.testImmutability("timeout");
            this.timeout = timeout;
        }

        @XmlAttribute
        public void setLogFlushTimeout(Long logFlushTimeout) {
            this.testImmutability("logFlushTimeout");
            this.logFlushTimeout = logFlushTimeout;
        }

        @XmlAttribute
        public void setMaxNonProgressingLogWrites(Integer maxNonProgressingLogWrites) {
            this.testImmutability("maxNonProgressingLogWrites");
            this.maxNonProgressingLogWrites = maxNonProgressingLogWrites;
        }

        @Override
        public StateRetrievalConfig fetchInMemoryState(Boolean fetchInMemoryState) {
            this.testImmutability("fetchInMemoryState");
            this.fetchInMemoryState = fetchInMemoryState;
            return this;
        }

        @Override
        public StateRetrievalConfig alwaysProvideInMemoryState(Boolean alwaysProvideInMemoryState) {
            this.testImmutability("alwaysProvideInMemoryState");
            this.alwaysProvideInMemoryState = alwaysProvideInMemoryState;
            return this;
        }

        @Override
        public StateRetrievalConfig initialRetryWaitTime(Long initialRetryWaitTime) {
            this.testImmutability("initialWaitTime");
            this.initialRetryWaitTime = initialRetryWaitTime;
            return this;
        }

        @Override
        public StateRetrievalConfig retryWaitTimeIncreaseFactor(Integer retryWaitTimeIncreaseFactor) {
            this.testImmutability("retryWaitTimeIncreaseFactor");
            this.retryWaitTimeIncreaseFactor = retryWaitTimeIncreaseFactor;
            return this;
        }

        @Override
        public StateRetrievalConfig numRetries(Integer numRetries) {
            this.testImmutability("numRetries");
            this.numRetries = numRetries;
            return this;
        }

        @Override
        public StateRetrievalConfig timeout(Long timeout) {
            this.testImmutability("timeout");
            this.timeout = timeout;
            return this;
        }

        @Override
        public StateRetrievalConfig logFlushTimeout(Long logFlushTimeout) {
            this.testImmutability("logFlushTimeout");
            this.logFlushTimeout = logFlushTimeout;
            return this;
        }

        @Override
        public StateRetrievalConfig maxNonProgressingLogWrites(Integer maxNonProgressingLogWrites) {
            this.testImmutability("maxNonProgressingLogWrites");
            this.maxNonProgressingLogWrites = maxNonProgressingLogWrites;
            return this;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitStateRetrievalType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateRetrievalType)) {
                return false;
            }
            StateRetrievalType that = (StateRetrievalType)o;
            if (this.fetchInMemoryState != null ? !this.fetchInMemoryState.equals(that.fetchInMemoryState) : that.fetchInMemoryState != null) {
                return false;
            }
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) {
                return false;
            }
            if (this.initialRetryWaitTime != null ? !this.initialRetryWaitTime.equals(that.initialRetryWaitTime) : that.initialRetryWaitTime != null) {
                return false;
            }
            if (this.retryWaitTimeIncreaseFactor != null ? !this.retryWaitTimeIncreaseFactor.equals(that.retryWaitTimeIncreaseFactor) : that.retryWaitTimeIncreaseFactor != null) {
                return false;
            }
            return !(this.numRetries != null ? !this.numRetries.equals(that.numRetries) : that.numRetries != null);
        }

        public int hashCode() {
            int result = this.fetchInMemoryState != null ? this.fetchInMemoryState.hashCode() : 0;
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.initialRetryWaitTime != null ? this.initialRetryWaitTime.hashCode() : 0);
            result = 31 * result + (this.retryWaitTimeIncreaseFactor != null ? this.retryWaitTimeIncreaseFactor.hashCode() : 0);
            result = 31 * result + (this.numRetries != null ? this.numRetries.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="dataContainer")
    public static class DataContainerType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -959027510815676570L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setDataContainerClass")
        protected String dataContainerClass = DefaultDataContainer.class.getName();
        @XmlElement(name="properties")
        protected TypedProperties properties = EMPTY_PROPERTIES;
        protected DataContainer dataContainer;

        @XmlAttribute
        public void setClass(String dataContainerClass) {
            this.testImmutability("dataContainerClass");
            this.dataContainerClass = dataContainerClass;
        }

        public void setDataContainer(DataContainer dataContainer) {
            this.dataContainer = dataContainer;
        }

        public void setProperties(TypedProperties properties) {
            this.testImmutability("properties");
            this.properties = properties;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitDataContainerType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataContainerType)) {
                return false;
            }
            DataContainerType that = (DataContainerType)o;
            if (this.dataContainerClass != null ? !this.dataContainerClass.equals(that.dataContainerClass) : that.dataContainerClass != null) {
                return false;
            }
            return !(this.dataContainer != null ? !this.dataContainer.equals(that.dataContainer) : that.dataContainer != null);
        }

        public int hashCode() {
            int result = this.dataContainerClass != null ? this.dataContainerClass.hashCode() : 0;
            result = 31 * result + (this.dataContainer != null ? this.dataContainer.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="eviction")
    public static class EvictionType
    extends AbstractNamedCacheConfigurationBean
    implements EvictionConfig {
        private static final long serialVersionUID = -1248563712058858791L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEvictionWakeUpInterval")
        protected Long wakeUpInterval = 5000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEvictionStrategy")
        protected EvictionStrategy strategy = EvictionStrategy.NONE;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEvictionMaxEntries")
        protected Integer maxEntries = -1;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEvictionThreadPolicy")
        protected EvictionThreadPolicy threadPolicy = EvictionThreadPolicy.DEFAULT;

        @Override
        public EvictionConfig wakeUpInterval(Long wakeUpInterval) {
            this.testImmutability("wakeUpInterval");
            this.wakeUpInterval = wakeUpInterval;
            return this;
        }

        @XmlAttribute
        public void setWakeUpInterval(Long wakeUpInterval) {
            this.testImmutability("wakeUpInterval");
            this.wakeUpInterval = wakeUpInterval;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitEvictionType(this);
        }

        @Override
        public EvictionConfig strategy(EvictionStrategy strategy) {
            this.testImmutability("strategy");
            this.strategy = strategy;
            return this;
        }

        @XmlAttribute
        public void setStrategy(EvictionStrategy strategy) {
            this.testImmutability("strategy");
            this.strategy = strategy;
        }

        @Override
        public EvictionConfig threadPolicy(EvictionThreadPolicy threadPolicy) {
            this.testImmutability("threadPolicy");
            this.threadPolicy = threadPolicy;
            return this;
        }

        @XmlAttribute
        public void setThreadPolicy(EvictionThreadPolicy threadPolicy) {
            this.testImmutability("threadPolicy");
            this.threadPolicy = threadPolicy;
        }

        @Override
        public EvictionConfig maxEntries(Integer maxEntries) {
            this.testImmutability("maxEntries");
            this.maxEntries = maxEntries;
            return this;
        }

        @XmlAttribute
        public void setMaxEntries(Integer maxEntries) {
            this.testImmutability("maxEntries");
            this.maxEntries = maxEntries;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EvictionType)) {
                return false;
            }
            EvictionType that = (EvictionType)o;
            if (this.maxEntries != null ? !this.maxEntries.equals(that.maxEntries) : that.maxEntries != null) {
                return false;
            }
            if (this.strategy != that.strategy) {
                return false;
            }
            if (this.threadPolicy != that.threadPolicy) {
                return false;
            }
            return !(this.wakeUpInterval != null ? !this.wakeUpInterval.equals(that.wakeUpInterval) : that.wakeUpInterval != null);
        }

        public int hashCode() {
            int result = this.wakeUpInterval != null ? this.wakeUpInterval.hashCode() : 0;
            result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
            result = 31 * result + (this.threadPolicy != null ? this.threadPolicy.hashCode() : 0);
            result = 31 * result + (this.maxEntries != null ? this.maxEntries.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="expiration")
    public static class ExpirationType
    extends AbstractNamedCacheConfigurationBean
    implements ExpirationConfig {
        private static final long serialVersionUID = 5757161438110848530L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setExpirationLifespan")
        protected Long lifespan = -1L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setExpirationMaxIdle")
        protected Long maxIdle = -1L;

        @Override
        public ExpirationConfig lifespan(Long lifespan) {
            this.testImmutability("lifespan");
            this.lifespan = lifespan;
            return this;
        }

        @XmlAttribute
        public void setLifespan(Long lifespan) {
            this.testImmutability("lifespan");
            this.lifespan = lifespan;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitExpirationType(this);
        }

        @XmlAttribute
        public void setMaxIdle(Long maxIdle) {
            this.testImmutability("maxIdle");
            this.maxIdle = maxIdle;
        }

        @Override
        public ExpirationConfig maxIdle(Long maxIdle) {
            this.testImmutability("maxIdle");
            this.maxIdle = maxIdle;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExpirationType)) {
                return false;
            }
            ExpirationType that = (ExpirationType)o;
            if (this.lifespan != null ? !this.lifespan.equals(that.lifespan) : that.lifespan != null) {
                return false;
            }
            return !(this.maxIdle != null ? !this.maxIdle.equals(that.maxIdle) : that.maxIdle != null);
        }

        public int hashCode() {
            int result = this.lifespan != null ? this.lifespan.hashCode() : 0;
            result = 31 * result + (this.maxIdle != null ? this.maxIdle.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="async", parentName="clustering")
    public static class AsyncType
    extends AbstractNamedCacheConfigurationBean
    implements AsyncConfig {
        @XmlTransient
        private boolean readFromXml = false;
        private static final long serialVersionUID = -7726319188826197399L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setUseReplQueue")
        protected Boolean useReplQueue = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setReplQueueMaxElements")
        protected Integer replQueueMaxElements = 1000;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setReplQueueInterval")
        protected Long replQueueInterval = 5000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setUseAsyncMarshalling")
        protected Boolean asyncMarshalling = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setReplQueueClass")
        protected String replQueueClass = ReplicationQueueImpl.class.getName();
        @XmlTransient
        private boolean unmarshalledFromXml = false;

        private AsyncType(boolean readFromXml) {
            this.readFromXml = readFromXml;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitAsyncType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AsyncType)) {
                return false;
            }
            AsyncType asyncType = (AsyncType)o;
            if (this.readFromXml != asyncType.readFromXml) {
                return false;
            }
            if (this.asyncMarshalling != null ? !this.asyncMarshalling.equals(asyncType.asyncMarshalling) : asyncType.asyncMarshalling != null) {
                return false;
            }
            if (this.replQueueInterval != null ? !this.replQueueInterval.equals(asyncType.replQueueInterval) : asyncType.replQueueInterval != null) {
                return false;
            }
            if (this.replQueueMaxElements != null ? !this.replQueueMaxElements.equals(asyncType.replQueueMaxElements) : asyncType.replQueueMaxElements != null) {
                return false;
            }
            if (this.useReplQueue != null ? !this.useReplQueue.equals(asyncType.useReplQueue) : asyncType.useReplQueue != null) {
                return false;
            }
            return Util.safeEquals(this.replQueueClass, asyncType.replQueueClass);
        }

        public int hashCode() {
            int result = this.readFromXml ? 1 : 0;
            result = 31 * result + (this.useReplQueue != null ? this.useReplQueue.hashCode() : 0);
            result = 31 * result + (this.replQueueMaxElements != null ? this.replQueueMaxElements.hashCode() : 0);
            result = 31 * result + (this.replQueueInterval != null ? this.replQueueInterval.hashCode() : 0);
            result = 31 * result + (this.asyncMarshalling != null ? this.asyncMarshalling.hashCode() : 0);
            result = 31 * result + (this.replQueueClass != null ? this.replQueueClass.hashCode() : 0);
            return result;
        }

        private AsyncType() {
            this(true);
        }

        @Override
        public AsyncConfig useReplQueue(Boolean useReplQueue) {
            this.testImmutability("useReplQueue");
            this.useReplQueue = useReplQueue;
            return this;
        }

        @Override
        public AsyncConfig replQueueMaxElements(Integer replQueueMaxElements) {
            this.testImmutability("replQueueMaxElements");
            this.replQueueMaxElements = replQueueMaxElements;
            return this;
        }

        @Override
        public AsyncConfig replQueueInterval(Long replQueueInterval) {
            this.testImmutability("replQueueInterval");
            this.replQueueInterval = replQueueInterval;
            return this;
        }

        @Override
        public AsyncConfig asyncMarshalling(Boolean asyncMarshalling) {
            this.testImmutability("asyncMarshalling");
            this.asyncMarshalling = asyncMarshalling;
            return this;
        }

        @Override
        public AsyncConfig replQueueClass(String replQueueClass) {
            this.testImmutability("replQueueClass");
            this.replQueueClass = replQueueClass;
            return this;
        }

        @XmlAttribute
        public void setUseReplQueue(Boolean useReplQueue) {
            this.testImmutability("useReplQueue");
            this.useReplQueue = useReplQueue;
        }

        @XmlAttribute
        public void setReplQueueMaxElements(Integer replQueueMaxElements) {
            this.testImmutability("replQueueMaxElements");
            this.replQueueMaxElements = replQueueMaxElements;
        }

        @XmlAttribute
        public void setReplQueueInterval(Long replQueueInterval) {
            this.testImmutability("replQueueInterval");
            this.replQueueInterval = replQueueInterval;
        }

        @XmlAttribute
        public void setAsyncMarshalling(Boolean asyncMarshalling) {
            this.testImmutability("asyncMarshalling");
            this.asyncMarshalling = asyncMarshalling;
        }

        @XmlAttribute
        public void setReplQueueClass(String replQueueClass) {
            this.testImmutability("replQueueClass");
            this.replQueueClass = replQueueClass;
        }

        @Override
        public void willUnmarshall(Object parent) {
            ClusteringType clustering = (ClusteringType)parent;
            if (clustering.sync.unmarshalledFromXml) {
                throw new ConfigurationException("Cannot have both <sync /> and <async /> tags in a <clustering /> tag!");
            }
            this.unmarshalledFromXml = true;
        }
    }

    public static class ClusteringTypeAdapter
    extends XmlAdapter<ClusteringType, ClusteringType> {
        public ClusteringType marshal(ClusteringType ct) throws Exception {
            return ct;
        }

        public ClusteringType unmarshal(ClusteringType ct) throws Exception {
            if (ct.stringMode != null) {
                String mode = ct.stringMode.toLowerCase();
                if (mode.startsWith("r")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.REPL_SYNC);
                    } else {
                        ct.setMode(CacheMode.REPL_ASYNC);
                    }
                } else if (mode.startsWith("i")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.INVALIDATION_SYNC);
                    } else {
                        ct.setMode(CacheMode.INVALIDATION_ASYNC);
                    }
                } else if (mode.startsWith("d")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.DIST_SYNC);
                    } else {
                        ct.setMode(CacheMode.DIST_ASYNC);
                    }
                } else if (mode.startsWith("l")) {
                    ct.setMode(CacheMode.LOCAL);
                } else {
                    throw new ConfigurationException("Invalid clustering mode " + ct.stringMode);
                }
            }
            return ct;
        }
    }

    @XmlJavaTypeAdapter(value=ClusteringTypeAdapter.class)
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlType(propOrder={})
    @ConfigurationDoc(name="clustering")
    public static class ClusteringType
    extends AbstractNamedCacheConfigurationBean
    implements ClusteringConfig {
        private static final long serialVersionUID = 4048135465543498430L;
        @XmlAttribute(name="mode")
        protected String stringMode;
        @XmlTransient
        protected boolean configuredAsync = false;
        @XmlTransient
        protected boolean configuredSync = false;
        @XmlTransient
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setCacheMode")
        protected CacheMode mode;
        @XmlElement
        protected SyncType sync = new SyncType();
        @XmlElement
        protected StateRetrievalType stateRetrieval = new StateRetrievalType();
        @XmlElement
        protected L1Type l1 = new L1Type();
        @XmlElement
        protected AsyncType async = new AsyncType(false);
        @XmlElement
        protected HashType hash = new HashType();

        public ClusteringType(CacheMode mode) {
            this.mode = mode;
        }

        public ClusteringType() {
            this.mode = CacheMode.DIST_SYNC;
        }

        @Override
        public AsyncConfig configureAsync() {
            if (this.configuredSync) {
                throw new ConfigurationException("Already configured as sync");
            }
            this.configuredAsync = true;
            return this.async;
        }

        @Override
        public SyncConfig configureSync() {
            if (this.configuredAsync) {
                throw new ConfigurationException("Already configured as async");
            }
            this.configuredSync = true;
            return this.sync;
        }

        @Override
        public StateRetrievalConfig configureStateRetrieval() {
            return this.stateRetrieval;
        }

        @Override
        public L1Config configureL1() {
            return this.l1;
        }

        @Override
        public HashConfig configureHash() {
            return this.hash;
        }

        public void setMode(CacheMode mode) {
            this.testImmutability("mode");
            this.mode = mode;
        }

        @Override
        public ClusteringConfig mode(CacheMode mode) {
            this.testImmutability("mode");
            this.mode = mode;
            return this;
        }

        public boolean isSynchronous() {
            return !this.async.readFromXml;
        }

        @Override
        public ClusteringType clone() throws CloneNotSupportedException {
            ClusteringType dolly = (ClusteringType)super.clone();
            dolly.sync = (SyncType)this.sync.clone();
            dolly.stateRetrieval = (StateRetrievalType)this.stateRetrieval.clone();
            dolly.l1 = (L1Type)this.l1.clone();
            dolly.async = (AsyncType)this.async.clone();
            dolly.hash = (HashType)this.hash.clone();
            return dolly;
        }

        public void accept(ConfigurationBeanVisitor v) {
            this.async.accept(v);
            this.hash.accept(v);
            this.l1.accept(v);
            this.stateRetrieval.accept(v);
            this.sync.accept(v);
            v.visitClusteringType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClusteringType)) {
                return false;
            }
            ClusteringType that = (ClusteringType)o;
            if (this.async != null ? !this.async.equals(that.async) : that.async != null) {
                return false;
            }
            if (this.hash != null ? !this.hash.equals(that.hash) : that.hash != null) {
                return false;
            }
            if (this.l1 != null ? !this.l1.equals(that.l1) : that.l1 != null) {
                return false;
            }
            if (this.mode != that.mode) {
                return false;
            }
            if (this.stateRetrieval != null ? !this.stateRetrieval.equals(that.stateRetrieval) : that.stateRetrieval != null) {
                return false;
            }
            return !(this.sync != null ? !this.sync.equals(that.sync) : that.sync != null);
        }

        public int hashCode() {
            int result = this.stringMode != null ? this.stringMode.hashCode() : 0;
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.sync != null ? this.sync.hashCode() : 0);
            result = 31 * result + (this.stateRetrieval != null ? this.stateRetrieval.hashCode() : 0);
            result = 31 * result + (this.l1 != null ? this.l1.hashCode() : 0);
            result = 31 * result + (this.async != null ? this.async.hashCode() : 0);
            result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
            return result;
        }

        @Override
        public void willUnmarshall(Object parent) {
            this.setMode(CacheMode.DIST_SYNC);
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="locking")
    public static class LockingType
    extends AbstractNamedCacheConfigurationBean
    implements LockingConfig {
        private static final long serialVersionUID = 8142143187082119506L;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setLockAcquisitionTimeout")
        protected Long lockAcquisitionTimeout = 10000L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setIsolationLevel")
        protected IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setWriteSkewCheck")
        protected Boolean writeSkewCheck = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setUseLockStriping")
        protected Boolean useLockStriping = true;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setConcurrencyLevel")
        protected Integer concurrencyLevel = 32;

        @Override
        public LockingConfig lockAcquisitionTimeout(Long lockAcquisitionTimeout) {
            this.testImmutability("lockAcquisitionTimeout");
            this.lockAcquisitionTimeout = lockAcquisitionTimeout;
            return this;
        }

        @XmlAttribute
        public void setLockAcquisitionTimeout(Long lockAcquisitionTimeout) {
            this.testImmutability("lockAcquisitionTimeout");
            this.lockAcquisitionTimeout = lockAcquisitionTimeout;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitLockingType(this);
        }

        @Override
        public LockingConfig isolationLevel(IsolationLevel isolationLevel) {
            this.testImmutability("isolationLevel");
            this.isolationLevel = isolationLevel;
            return this;
        }

        @XmlAttribute
        public void setIsolationLevel(IsolationLevel isolationLevel) {
            this.testImmutability("isolationLevel");
            this.isolationLevel = isolationLevel;
        }

        @Override
        public LockingConfig writeSkewCheck(Boolean writeSkewCheck) {
            this.testImmutability("writeSkewCheck");
            this.writeSkewCheck = writeSkewCheck;
            return this;
        }

        @XmlAttribute
        public void setWriteSkewCheck(Boolean writeSkewCheck) {
            this.testImmutability("writeSkewCheck");
            this.writeSkewCheck = writeSkewCheck;
        }

        @Override
        public LockingConfig useLockStriping(Boolean useLockStriping) {
            this.testImmutability("useLockStriping");
            this.useLockStriping = useLockStriping;
            return this;
        }

        @XmlAttribute
        public void setUseLockStriping(Boolean useLockStriping) {
            this.testImmutability("useLockStriping");
            this.useLockStriping = useLockStriping;
        }

        @Override
        public LockingConfig concurrencyLevel(Integer concurrencyLevel) {
            this.testImmutability("concurrencyLevel");
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        @XmlAttribute
        public void setConcurrencyLevel(Integer concurrencyLevel) {
            this.testImmutability("concurrencyLevel");
            this.concurrencyLevel = concurrencyLevel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LockingType)) {
                return false;
            }
            LockingType that = (LockingType)o;
            if (this.concurrencyLevel != null ? !this.concurrencyLevel.equals(that.concurrencyLevel) : that.concurrencyLevel != null) {
                return false;
            }
            if (this.isolationLevel != that.isolationLevel) {
                return false;
            }
            if (this.lockAcquisitionTimeout != null ? !this.lockAcquisitionTimeout.equals(that.lockAcquisitionTimeout) : that.lockAcquisitionTimeout != null) {
                return false;
            }
            if (this.useLockStriping != null ? !this.useLockStriping.equals(that.useLockStriping) : that.useLockStriping != null) {
                return false;
            }
            return !(this.writeSkewCheck != null ? !this.writeSkewCheck.equals(that.writeSkewCheck) : that.writeSkewCheck != null);
        }

        public int hashCode() {
            int result = this.lockAcquisitionTimeout != null ? this.lockAcquisitionTimeout.hashCode() : 0;
            result = 31 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
            result = 31 * result + (this.writeSkewCheck != null ? this.writeSkewCheck.hashCode() : 0);
            result = 31 * result + (this.useLockStriping != null ? this.useLockStriping.hashCode() : 0);
            result = 31 * result + (this.concurrencyLevel != null ? this.concurrencyLevel.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @ConfigurationDoc(name="transaction")
    public static class TransactionType
    extends AbstractNamedCacheConfigurationBean
    implements TransactionConfig {
        private static final long serialVersionUID = -3867090839830874603L;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setTransactionManagerLookupClass")
        protected String transactionManagerLookupClass;
        @XmlTransient
        protected TransactionManagerLookup transactionManagerLookup;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setSyncCommitPhase")
        protected Boolean syncCommitPhase = false;
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setSyncRollbackPhase")
        @Dynamic
        protected Boolean syncRollbackPhase = false;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setUseEagerLocking")
        protected Boolean useEagerLocking = false;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setEagerLockSingleNode")
        protected Boolean eagerLockSingleNode = false;
        @Dynamic
        @ConfigurationDocRef(bean=Configuration.class, targetElement="setCacheStopTimeout")
        protected Integer cacheStopTimeout = 30000;

        public TransactionType(String transactionManagerLookupClass) {
            this.transactionManagerLookupClass = transactionManagerLookupClass;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitTransactionType(this);
        }

        public TransactionType() {
            this.transactionManagerLookupClass = GenericTransactionManagerLookup.class.getName();
        }

        @XmlAttribute
        public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
            this.testImmutability("transactionManagerLookupClass");
            this.transactionManagerLookupClass = transactionManagerLookupClass;
        }

        @Override
        public TransactionConfig transactionManagerLookupClass(Class<? extends TransactionManagerLookup> transactionManagerLookupClass) {
            this.testImmutability("transactionManagerLookupClass");
            this.transactionManagerLookupClass = transactionManagerLookupClass.getName();
            return this;
        }

        @XmlAttribute
        public void setSyncCommitPhase(Boolean syncCommitPhase) {
            this.testImmutability("syncCommitPhase");
            this.syncCommitPhase = syncCommitPhase;
        }

        @Override
        public TransactionConfig syncCommitPhase(Boolean syncCommitPhase) {
            this.testImmutability("syncCommitPhase");
            this.syncCommitPhase = syncCommitPhase;
            return this;
        }

        @XmlAttribute
        public void setSyncRollbackPhase(Boolean syncRollbackPhase) {
            this.testImmutability("syncRollbackPhase");
            this.syncRollbackPhase = syncRollbackPhase;
        }

        @Override
        public TransactionConfig syncRollbackPhase(Boolean syncRollbackPhase) {
            this.testImmutability("syncRollbackPhase");
            this.syncRollbackPhase = syncRollbackPhase;
            return this;
        }

        @XmlAttribute
        public void setUseEagerLocking(Boolean useEagerLocking) {
            this.testImmutability("useEagerLocking");
            this.useEagerLocking = useEagerLocking;
        }

        @Override
        public TransactionConfig useEagerLocking(Boolean useEagerLocking) {
            this.testImmutability("useEagerLocking");
            this.useEagerLocking = useEagerLocking;
            return this;
        }

        @Override
        public TransactionConfig usingTransactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
            this.testImmutability("transactionManagerLookup");
            this.transactionManagerLookup = transactionManagerLookup;
            return this;
        }

        @XmlAttribute
        public TransactionConfig setEagerLockSingleNode(Boolean eagerLockSingleNode) {
            this.testImmutability("eagerLockSingleNode");
            this.eagerLockSingleNode = eagerLockSingleNode;
            return this;
        }

        @Override
        public TransactionConfig eagerLockSingleNode(Boolean eagerLockSingleNode) {
            this.testImmutability("eagerLockSingleNode");
            this.eagerLockSingleNode = eagerLockSingleNode;
            return this;
        }

        @XmlAttribute
        public void setCacheStopTimeout(Integer cacheStopTimeout) {
            this.testImmutability("cacheStopTimeout");
            this.cacheStopTimeout = cacheStopTimeout;
        }

        @Override
        public TransactionConfig cacheStopTimeout(Integer cacheStopTimeout) {
            this.testImmutability("cacheStopTimeout");
            this.cacheStopTimeout = cacheStopTimeout;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionType)) {
                return false;
            }
            TransactionType that = (TransactionType)o;
            if (this.syncCommitPhase != null ? !this.syncCommitPhase.equals(that.syncCommitPhase) : that.syncCommitPhase != null) {
                return false;
            }
            if (this.syncRollbackPhase != null ? !this.syncRollbackPhase.equals(that.syncRollbackPhase) : that.syncRollbackPhase != null) {
                return false;
            }
            if (this.transactionManagerLookup != null ? !this.transactionManagerLookup.equals(that.transactionManagerLookup) : that.transactionManagerLookup != null) {
                return false;
            }
            if (this.transactionManagerLookupClass != null ? !this.transactionManagerLookupClass.equals(that.transactionManagerLookupClass) : that.transactionManagerLookupClass != null) {
                return false;
            }
            if (this.useEagerLocking != null ? !this.useEagerLocking.equals(that.useEagerLocking) : that.useEagerLocking != null) {
                return false;
            }
            return !(this.cacheStopTimeout != null ? !this.cacheStopTimeout.equals(that.cacheStopTimeout) : that.cacheStopTimeout != null);
        }

        public int hashCode() {
            int result = this.transactionManagerLookupClass != null ? this.transactionManagerLookupClass.hashCode() : 0;
            result = 31 * result + (this.transactionManagerLookup != null ? this.transactionManagerLookup.hashCode() : 0);
            result = 31 * result + (this.syncCommitPhase != null ? this.syncCommitPhase.hashCode() : 0);
            result = 31 * result + (this.syncRollbackPhase != null ? this.syncRollbackPhase.hashCode() : 0);
            result = 31 * result + (this.useEagerLocking != null ? this.useEagerLocking.hashCode() : 0);
            result = 31 * result + (this.cacheStopTimeout != null ? this.cacheStopTimeout.hashCode() : 0);
            return result;
        }

        @Override
        public void willUnmarshall(Object parent) {
            this.setTransactionManagerLookupClass(GenericTransactionManagerLookup.class.getName());
        }
    }

    public static interface IndexingConfig {
        public IndexingConfig enabled(Boolean var1);

        public IndexingConfig indexLocalOnly(Boolean var1);
    }

    public static interface HashConfig {
        public HashConfig consistentHashClass(String var1);

        public HashConfig hashFunctionClass(String var1);

        public HashConfig numOwners(Integer var1);

        public HashConfig rehashWait(Long var1);

        public HashConfig rehashRpcTimeout(Long var1);

        public HashConfig rehashEnabled(Boolean var1);
    }

    public static interface L1Config {
        public L1Config enabled(Boolean var1);

        public L1Config lifespan(Long var1);

        public L1Config onRehash(Boolean var1);
    }

    public static interface StateRetrievalConfig {
        public StateRetrievalConfig fetchInMemoryState(Boolean var1);

        public StateRetrievalConfig alwaysProvideInMemoryState(Boolean var1);

        public StateRetrievalConfig initialRetryWaitTime(Long var1);

        public StateRetrievalConfig retryWaitTimeIncreaseFactor(Integer var1);

        public StateRetrievalConfig numRetries(Integer var1);

        public StateRetrievalConfig timeout(Long var1);

        public StateRetrievalConfig logFlushTimeout(Long var1);

        public StateRetrievalConfig maxNonProgressingLogWrites(Integer var1);
    }

    public static interface AsyncConfig {
        public AsyncConfig useReplQueue(Boolean var1);

        public AsyncConfig replQueueMaxElements(Integer var1);

        public AsyncConfig replQueueInterval(Long var1);

        public AsyncConfig asyncMarshalling(Boolean var1);

        public AsyncConfig replQueueClass(String var1);
    }

    public static interface SyncConfig {
        public SyncConfig replTimeout(Long var1);
    }

    public static interface ClusteringConfig {
        public ClusteringConfig mode(CacheMode var1);

        public AsyncConfig configureAsync();

        public SyncConfig configureSync();

        public StateRetrievalConfig configureStateRetrieval();

        public L1Config configureL1();

        public HashConfig configureHash();
    }

    public static interface ExpirationConfig {
        public ExpirationConfig lifespan(Long var1);

        public ExpirationConfig maxIdle(Long var1);
    }

    public static interface EvictionConfig {
        public EvictionConfig wakeUpInterval(Long var1);

        public EvictionConfig strategy(EvictionStrategy var1);

        public EvictionConfig threadPolicy(EvictionThreadPolicy var1);

        public EvictionConfig maxEntries(Integer var1);
    }

    public static interface CustomInterceptorsConfig {
        public CustomInterceptorsConfig setCustomInterceptors(List<CustomInterceptorConfig> var1);

        public CustomInterceptorsConfig addCustomInterceptor(CustomInterceptorConfig var1);
    }

    public static interface DeadlockDetectionConfig {
        public DeadlockDetectionConfig enabled(Boolean var1);

        public DeadlockDetectionConfig spinDuration(Long var1);
    }

    public static interface TransactionConfig {
        public TransactionConfig transactionManagerLookupClass(Class<? extends TransactionManagerLookup> var1);

        public TransactionConfig syncCommitPhase(Boolean var1);

        public TransactionConfig syncRollbackPhase(Boolean var1);

        public TransactionConfig useEagerLocking(Boolean var1);

        public TransactionConfig usingTransactionManagerLookup(TransactionManagerLookup var1);

        public TransactionConfig eagerLockSingleNode(Boolean var1);

        public TransactionConfig cacheStopTimeout(Integer var1);
    }

    public static interface LoadersConfig {
        public LoadersConfig preload(Boolean var1);

        public LoadersConfig passivation(Boolean var1);

        public LoadersConfig shared(Boolean var1);

        public LoadersConfig addCacheLoaderConfig(CacheLoaderConfig var1);

        public LoadersConfig setCacheLoaderConfigs(List<CacheLoaderConfig> var1);
    }

    public static interface LockingConfig {
        public LockingConfig lockAcquisitionTimeout(Long var1);

        public LockingConfig isolationLevel(IsolationLevel var1);

        public LockingConfig writeSkewCheck(Boolean var1);

        public LockingConfig useLockStriping(Boolean var1);

        public LockingConfig concurrencyLevel(Integer var1);
    }
}

