/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Collections;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.util.Immutables;

public class AtomicMapLookup {
    public static <MK, K, V> AtomicMap<K, V> getAtomicMap(Cache<MK, ?> cache, MK key) {
        return AtomicMapLookup.getAtomicMap(cache, key, true);
    }

    public static <MK, K, V> AtomicMap<K, V> getAtomicMap(Cache<MK, ?> cache, MK key, boolean createIfAbsent) {
        Object value = cache.get(key);
        if (value == null) {
            if (createIfAbsent) {
                value = AtomicHashMap.newInstance(cache, key);
            } else {
                return null;
            }
        }
        AtomicHashMap castValue = (AtomicHashMap)value;
        return castValue.getProxy(cache, key, cache.getAdvancedCache().getBatchContainer(), cache.getAdvancedCache().getInvocationContextContainer());
    }

    public static <MK, K, V> Map<K, V> getReadOnlyAtomicMap(Cache<MK, ?> cache, MK key) {
        AtomicMap<K, V> am = AtomicMapLookup.getAtomicMap(cache, key, false);
        if (am == null) {
            return Collections.emptyMap();
        }
        return Immutables.immutableMapWrap(am);
    }

    public static <MK> void removeAtomicMap(Cache<MK, ?> cache, MK key) {
        cache.remove(key);
    }
}

