/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.infinispan.CacheException;
import org.infinispan.config.ConfigurationException;

public final class Util {
    private static final boolean isArraysDebug = Boolean.getBoolean("infinispan.arrays.debug");
    private static String INDENT = "    ";

    public static Class loadClass(String classname) {
        try {
            return Util.loadClassStrict(classname);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to instantiate class " + classname, e);
        }
    }

    public static Class loadClassStrict(String classname) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl.loadClass(classname);
    }

    private static Method getFactoryMethod(Class c) {
        for (Method m : c.getMethods()) {
            if (!m.getName().equals("getInstance") || m.getParameterTypes().length != 0 || !Modifier.isStatic(m.getModifiers())) continue;
            return m;
        }
        return null;
    }

    public static <T> T getInstance(Class<T> clazz) {
        try {
            return Util.getInstanceStrict(clazz);
        }
        catch (IllegalAccessException iae) {
            throw new ConfigurationException("Unable to instantiate class " + clazz.getName(), iae);
        }
        catch (InstantiationException ie) {
            throw new ConfigurationException("Unable to instantiate class " + clazz.getName(), ie);
        }
    }

    public static <T> T getInstanceStrict(Class<T> clazz) throws IllegalAccessException, InstantiationException {
        Object instance = null;
        try {
            Method factoryMethod = Util.getFactoryMethod(clazz);
            if (factoryMethod != null) {
                instance = factoryMethod.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            instance = null;
        }
        if (instance == null) {
            instance = clazz.newInstance();
        }
        return (T)(instance == null ? null : instance);
    }

    public static Object getInstance(String classname) {
        if (classname == null) {
            throw new IllegalArgumentException("Cannot load null class!");
        }
        Class clazz = Util.loadClass(classname);
        return Util.getInstance(clazz);
    }

    public static Object getInstanceStrict(String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (classname == null) {
            throw new IllegalArgumentException("Cannot load null class!");
        }
        Class clazz = Util.loadClassStrict(classname);
        return Util.getInstanceStrict(clazz);
    }

    private Util() {
    }

    public static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static InputStream loadResourceAsStream(String resource) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream s = cl.getResourceAsStream(resource);
        if (s == null) {
            cl = Util.class.getClassLoader();
            s = cl.getResourceAsStream(resource);
        }
        return s;
    }

    public static String prettyPrintTime(long time, TimeUnit unit) {
        return Util.prettyPrintTime(unit.toMillis(time));
    }

    public static String prettyPrintTime(long millis) {
        if (millis < 1000L) {
            return millis + " milliseconds";
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        double toPrint = (double)millis / 1000.0;
        if (toPrint < 300.0) {
            return nf.format(toPrint) + " seconds";
        }
        if ((toPrint /= 60.0) < 120.0) {
            return nf.format(toPrint) + " minutes";
        }
        return nf.format(toPrint /= 60.0) + " hours";
    }

    public static void close(Closeable cl) {
        if (cl == null) {
            return;
        }
        try {
            cl.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndCloseStream(OutputStream o) {
        if (o == null) {
            return;
        }
        try {
            o.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndCloseOutput(ObjectOutput o) {
        if (o == null) {
            return;
        }
        try {
            o.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String formatString(Object message, Object ... params) {
        if (params.length == 0) {
            return message == null ? "null" : message.toString();
        }
        StringBuilder value = new StringBuilder(String.valueOf(message));
        for (int i = 0; i < params.length; ++i) {
            String placeholder = "{" + i + "}";
            int phIndex = value.indexOf(placeholder);
            if (phIndex <= -1) continue;
            value = value.replace(phIndex, phIndex + placeholder.length(), String.valueOf(params[i]));
        }
        return value.toString();
    }

    public static String printArray(byte[] array, boolean withHash) {
        if (array == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ByteArray{size=").append(array.length);
        if (withHash) {
            sb.append(", hashCode=").append(Integer.toHexString(array.hashCode()));
        }
        sb.append(", array=");
        if (isArraysDebug) {
            sb.append(Arrays.toString(array));
        } else {
            sb.append("[");
            int length = array.length < 10 ? array.length : 10;
            for (int i = 0; i < length; ++i) {
                sb.append(array[i]).append(", ");
            }
            sb.append("..]");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String padString(String s, int minWidth) {
        if (s.length() < minWidth) {
            StringBuilder sb = new StringBuilder(s);
            while (sb.length() < minWidth) {
                sb.append(" ");
            }
            return sb.toString();
        }
        return s;
    }

    public static final void safeRelease(Lock toRelease) {
        if (toRelease != null) {
            try {
                toRelease.unlock();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    public static String threadDump() {
        StringBuilder threadDump = new StringBuilder();
        ThreadMXBean threadMx = ManagementFactory.getThreadMXBean();
        if (threadMx.isObjectMonitorUsageSupported() && threadMx.isSynchronizerUsageSupported()) {
            Util.dumpThreadInfo(threadDump, true, threadMx);
        } else {
            Util.dumpThreadInfo(threadDump, false, threadMx);
        }
        return threadDump.toString();
    }

    private static void dumpThreadInfo(StringBuilder threadDump, boolean withLocks, ThreadMXBean threadMx) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date());
        threadDump.append(timestamp);
        threadDump.append("\nFull thread dump ");
        threadDump.append("\n");
        if (withLocks) {
            ThreadInfo[] threadInfos;
            for (ThreadInfo threadInfo : threadInfos = threadMx.dumpAllThreads(true, true)) {
                Util.printThreadInfo(threadInfo, threadDump);
                LockInfo[] syncs = threadInfo.getLockedSynchronizers();
                Util.printLockInfo(syncs, threadDump);
            }
            threadDump.append("\n");
        } else {
            ThreadInfo[] threadInfos;
            long[] threadIds = threadMx.getAllThreadIds();
            for (ThreadInfo threadInfo : threadInfos = threadMx.getThreadInfo(threadIds, Integer.MAX_VALUE)) {
                Util.printThreadInfo(threadInfo, threadDump);
            }
        }
    }

    private static void printThreadInfo(ThreadInfo threadInfo, StringBuilder threadDump) {
        Util.printThread(threadInfo, threadDump);
        StackTraceElement[] stacktrace = threadInfo.getStackTrace();
        MonitorInfo[] monitors = threadInfo.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            threadDump.append(INDENT + "at " + ste.toString());
            threadDump.append("\n");
            for (int j = 1; j < monitors.length; ++j) {
                MonitorInfo mi = monitors[j];
                if (mi.getLockedStackDepth() != i) continue;
                threadDump.append(INDENT + "  - locked " + mi);
                threadDump.append("\n");
            }
        }
        threadDump.append("\n");
    }

    private static void printLockInfo(LockInfo[] locks, StringBuilder threadDump) {
        threadDump.append(INDENT + "Locked synchronizers: count = " + locks.length);
        threadDump.append("\n");
        for (int i = 0; i < locks.length; ++i) {
            LockInfo li = locks[i];
            threadDump.append(INDENT + "  - " + li);
            threadDump.append("\n");
        }
        threadDump.append("\n");
    }

    private static void printThread(ThreadInfo threadInfo, StringBuilder threadDump) {
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\"" + " nid=" + threadInfo.getThreadId() + " state=" + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null && threadInfo.getThreadState() != Thread.State.BLOCKED) {
            String[] lockInfo = threadInfo.getLockName().split("@");
            sb.append("\n" + INDENT + "- waiting on <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
            sb.append("\n" + INDENT + "- locked <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
        } else if (threadInfo.getLockName() != null && threadInfo.getThreadState() == Thread.State.BLOCKED) {
            String[] lockInfo = threadInfo.getLockName().split("@");
            sb.append("\n" + INDENT + "- waiting to lock <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (running in native)");
        }
        threadDump.append(sb.toString());
        threadDump.append("\n");
        if (threadInfo.getLockOwnerName() != null) {
            threadDump.append(INDENT + " owned by " + threadInfo.getLockOwnerName() + " id=" + threadInfo.getLockOwnerId());
            threadDump.append("\n");
        }
    }

    public static CacheException rewrapAsCacheException(Throwable t) {
        if (t instanceof CacheException) {
            return (CacheException)t;
        }
        return new CacheException(t);
    }

    public static <T> Set<T> asSet(T ... a) {
        if (a.length > 1) {
            return new HashSet<T>(Arrays.asList(a));
        }
        return Collections.singleton(a[0]);
    }

    public static class MapModifications {
        public final Map<Object, Object> addedEntries = new HashMap<Object, Object>();
        public final Map<Object, Object> removedEntries = new HashMap<Object, Object>();
        public final Map<Object, Object> modifiedEntries = new HashMap<Object, Object>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapModifications that = (MapModifications)o;
            if (this.addedEntries != null ? !((Object)this.addedEntries).equals(that.addedEntries) : that.addedEntries != null) {
                return false;
            }
            if (this.modifiedEntries != null ? !((Object)this.modifiedEntries).equals(that.modifiedEntries) : that.modifiedEntries != null) {
                return false;
            }
            return !(this.removedEntries != null ? !((Object)this.removedEntries).equals(that.removedEntries) : that.removedEntries != null);
        }

        public int hashCode() {
            int result = this.addedEntries != null ? ((Object)this.addedEntries).hashCode() : 0;
            result = 31 * result + (this.removedEntries != null ? ((Object)this.removedEntries).hashCode() : 0);
            result = 31 * result + (this.modifiedEntries != null ? ((Object)this.modifiedEntries).hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Added Entries " + this.addedEntries + " Removed Entries " + this.removedEntries + " Modified Entries " + this.modifiedEntries;
        }
    }
}

