/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionLog {
    private final Map<GlobalTransaction, PrepareCommand> pendingPrepares = new ConcurrentHashMap<GlobalTransaction, PrepareCommand>();
    private final BlockingQueue<LogEntry> entries = new LinkedBlockingQueue<LogEntry>();
    private AtomicBoolean active = new AtomicBoolean();
    private static final Log log = LogFactory.getLog(TransactionLog.class);

    public void logPrepare(PrepareCommand command) {
        this.pendingPrepares.put(command.getGlobalTransaction(), command);
    }

    public void logCommit(GlobalTransaction gtx) {
        PrepareCommand command = this.pendingPrepares.remove(gtx);
        if (command != null && this.isActive()) {
            this.addEntry(gtx, command.getModifications());
        }
    }

    private void addEntry(GlobalTransaction gtx, WriteCommand ... commands) {
        LogEntry entry = new LogEntry(gtx, commands);
        boolean success = false;
        while (!success) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Added commit entry to tx log {0}", entry);
                }
                this.entries.put(entry);
                success = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public final void logOnePhaseCommit(GlobalTransaction gtx, WriteCommand[] modifications) {
        if (gtx != null) {
            this.pendingPrepares.remove(gtx);
        }
        if (this.isActive() && modifications != null && modifications.length > 0) {
            this.addEntry(gtx, modifications);
        }
    }

    public final void logNoTxWrite(WriteCommand write) {
        if (this.isActive()) {
            this.addEntry(null, write);
        }
    }

    public void rollback(GlobalTransaction gtx) {
        this.pendingPrepares.remove(gtx);
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public final boolean activate() {
        return this.active.compareAndSet(false, true);
    }

    public final void deactivate() {
        this.active.set(false);
        if (!this.entries.isEmpty()) {
            log.error((Object)"Unprocessed Transaction Log Entries! = {0}", this.entries.size());
        }
        this.entries.clear();
    }

    public final int size() {
        return this.entries.size();
    }

    public void writeCommitLog(StreamingMarshaller marshaller, ObjectOutput out) throws Exception {
        ArrayList buffer = new ArrayList(10);
        while (this.entries.drainTo(buffer, 10) > 0) {
            for (LogEntry entry : buffer) {
                marshaller.objectToObjectStream(entry, out);
            }
            buffer.clear();
        }
    }

    public void writePendingPrepares(StreamingMarshaller marshaller, ObjectOutput out) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Writing {0} pending prepares to the stream", this.pendingPrepares.size());
        }
        for (PrepareCommand entry : this.pendingPrepares.values()) {
            marshaller.objectToObjectStream(entry, out);
        }
    }

    public boolean hasPendingPrepare(PrepareCommand command) {
        return this.pendingPrepares.containsKey(command.getGlobalTransaction());
    }

    public static class LogEntry {
        private final GlobalTransaction transaction;
        private final WriteCommand[] modifications;

        public LogEntry(GlobalTransaction transaction, WriteCommand ... modifications) {
            this.transaction = transaction;
            this.modifications = modifications;
        }

        public GlobalTransaction getTransaction() {
            return this.transaction;
        }

        public WriteCommand[] getModifications() {
            return this.modifications;
        }

        public static class Externalizer
        extends AbstractExternalizer<LogEntry> {
            @Override
            public void writeObject(ObjectOutput output, LogEntry le) throws IOException {
                output.writeObject(le.transaction);
                WriteCommand[] cmds = le.modifications;
                UnsignedNumeric.writeUnsignedInt(output, cmds.length);
                for (WriteCommand c : cmds) {
                    output.writeObject(c);
                }
            }

            @Override
            public LogEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                GlobalTransaction gtx = (GlobalTransaction)input.readObject();
                int numCommands = UnsignedNumeric.readUnsignedInt(input);
                WriteCommand[] cmds = new WriteCommand[numCommands];
                for (int i = 0; i < numCommands; ++i) {
                    cmds[i] = (WriteCommand)input.readObject();
                }
                return new LogEntry(gtx, cmds);
            }

            @Override
            public Integer getId() {
                return 41;
            }

            @Override
            public Set<Class<? extends LogEntry>> getTypeClasses() {
                return Util.asSet(LogEntry.class);
            }
        }
    }
}

