/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class ImmortalCacheEntry
extends AbstractInternalCacheEntry {
    private ImmortalCacheValue cacheValue;

    ImmortalCacheEntry(Object key, Object value) {
        super(key);
        this.cacheValue = new ImmortalCacheValue(value);
    }

    @Override
    public final boolean isExpired() {
        return false;
    }

    @Override
    public final boolean canExpire() {
        return false;
    }

    @Override
    public final long getCreated() {
        return -1L;
    }

    @Override
    public final long getLastUsed() {
        return -1L;
    }

    @Override
    public final long getLifespan() {
        return -1L;
    }

    @Override
    public final long getMaxIdle() {
        return -1L;
    }

    @Override
    public final long getExpiryTime() {
        return -1L;
    }

    @Override
    public final void touch() {
    }

    @Override
    public final void reincarnate() {
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    @Override
    public Object getValue() {
        return this.cacheValue.value;
    }

    @Override
    public Object setValue(Object value) {
        return this.cacheValue.setValue(value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmortalCacheEntry that = (ImmortalCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.cacheValue != null ? !this.cacheValue.equals(that.cacheValue) : that.cacheValue != null);
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.cacheValue != null ? this.cacheValue.hashCode() : 0);
        return result;
    }

    @Override
    public ImmortalCacheEntry clone() {
        ImmortalCacheEntry clone = (ImmortalCacheEntry)super.clone();
        clone.cacheValue = this.cacheValue.clone();
        return clone;
    }

    @Override
    public String toString() {
        return "ImmortalCacheEntry{cacheValue=" + this.cacheValue + "} " + super.toString();
    }

    public static class Externalizer
    extends AbstractExternalizer<ImmortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, ImmortalCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(((ImmortalCacheEntry)ice).cacheValue.value);
        }

        @Override
        public ImmortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            return new ImmortalCacheEntry(k, v);
        }

        @Override
        public Integer getId() {
            return 10;
        }

        @Override
        public Set<Class<? extends ImmortalCacheEntry>> getTypeClasses() {
            return Util.asSet(ImmortalCacheEntry.class);
        }
    }
}

