/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.util.concurrent.locks.DeadlockDetectedException;
import org.infinispan.util.concurrent.locks.LockManagerImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;

@MBean(objectName="DeadlockDetectingLockManager", description="Information about the number of deadlocks that were detected")
public class DeadlockDetectingLockManager
extends LockManagerImpl {
    private static final Log log = LogFactory.getLog(DeadlockDetectingLockManager.class);
    protected volatile long spinDuration;
    protected volatile boolean exposeJmxStats;
    private AtomicLong localTxStopped = new AtomicLong(0L);
    private AtomicLong remoteTxStopped = new AtomicLong(0L);
    private AtomicLong cannotRunDld = new AtomicLong(0L);

    @Start
    public void init() {
        this.spinDuration = this.configuration.getDeadlockDetectionSpinDuration();
        this.exposeJmxStats = this.configuration.isExposeJmxStatistics();
    }

    @Override
    public boolean lockAndRecord(Object key, InvocationContext ctx) throws InterruptedException {
        long lockTimeout = this.getLockAcquisitionTimeout(ctx);
        if (trace) {
            log.trace((Object)"Attempting to lock %s with acquisition timeout of %s millis", key, lockTimeout);
        }
        if (ctx.isInTxScope()) {
            if (trace) {
                log.trace("Using early dead lock detection");
            }
            long start = System.currentTimeMillis();
            DldGlobalTransaction thisTx = (DldGlobalTransaction)ctx.getLockOwner();
            thisTx.setLockIntention(key);
            if (trace) {
                log.trace("Setting lock intention to: " + key);
            }
            while (System.currentTimeMillis() < start + lockTimeout) {
                if (this.lockContainer.acquireLock(key, this.spinDuration, TimeUnit.MILLISECONDS) != null) {
                    thisTx.setLockIntention(null);
                    if (trace) {
                        log.trace("successfully acquired lock on " + key + ", returning ...");
                    }
                    return true;
                }
                Object owner = this.getOwner(key);
                if (!(owner instanceof DldGlobalTransaction)) {
                    if (trace) {
                        log.trace("Not running DLD as lock owner( " + owner + ") is not a transaction");
                    }
                    this.cannotRunDld.incrementAndGet();
                    continue;
                }
                DldGlobalTransaction lockOwnerTx = (DldGlobalTransaction)owner;
                if (!this.isDeadlockAndIAmLoosing(lockOwnerTx, thisTx, key)) continue;
                this.updateStats(thisTx);
                String message = "Deadlock found and we " + thisTx + " shall not continue. Other tx is " + lockOwnerTx;
                if (trace) {
                    log.trace(message);
                }
                throw new DeadlockDetectedException(message);
            }
        } else if (this.lockContainer.acquireLock(key, lockTimeout, TimeUnit.MILLISECONDS) != null) {
            return true;
        }
        return false;
    }

    private boolean isDeadlockAndIAmLoosing(DldGlobalTransaction lockOwnerTx, DldGlobalTransaction thisTx, Object key) {
        boolean wouldWeLoose = thisTx.wouldLose(lockOwnerTx);
        if (!wouldWeLoose) {
            if (trace) {
                log.trace("We (" + thisTx + ") wouldn't lose against the other(" + lockOwnerTx + ") transaction, so no point running rest of DLD");
            }
            return false;
        }
        return this.ownsLocalIntention(thisTx, lockOwnerTx.getLockIntention()) || this.ownsRemoteIntention(lockOwnerTx, thisTx, key) || this.isSameKeyDeadlock(key, thisTx, lockOwnerTx);
    }

    private boolean isSameKeyDeadlock(Object key, DldGlobalTransaction thisTx, DldGlobalTransaction lockOwnerTx) {
        boolean iHaveRemoteLock = !thisTx.isRemote();
        boolean otherHasLocalLock = lockOwnerTx.isRemote();
        if (iHaveRemoteLock && otherHasLocalLock) {
            if (trace) {
                log.trace((Object)"Same key deadlock between %s and %s on key %s.", thisTx, lockOwnerTx, key);
            }
            return true;
        }
        return false;
    }

    private boolean ownsRemoteIntention(DldGlobalTransaction lockOwnerTx, DldGlobalTransaction thisTx, Object key) {
        boolean localLockOwner;
        boolean bl = localLockOwner = !lockOwnerTx.isRemote();
        if (localLockOwner) {
            if (thisTx.hasLockAtOrigin(lockOwnerTx.getRemoteLockIntention())) {
                if (trace) {
                    log.trace("Same key deadlock detected: lock owner tries to acquire lock remotely on " + key + " but we have it!");
                }
                return true;
            }
        } else if (trace) {
            log.trace("Lock owner is remote: " + lockOwnerTx);
        }
        return false;
    }

    private boolean ownsLocalIntention(DldGlobalTransaction thisTx, Object lockOwnerTxIntention) {
        boolean result;
        boolean bl = result = lockOwnerTxIntention != null && this.ownsLock(lockOwnerTxIntention, thisTx);
        if (trace) {
            log.trace("Local intention is '" + lockOwnerTxIntention + "'. Do we own lock for it? " + result + " We == " + thisTx);
        }
        return result;
    }

    public void setExposeJmxStats(boolean exposeJmxStats) {
        this.exposeJmxStats = exposeJmxStats;
    }

    @ManagedAttribute(description="Total number of local detected deadlocks")
    @Metric(displayName="Number of total detected deadlocks", measurementType=MeasurementType.TRENDSUP)
    public long getTotalNumberOfDetectedDeadlocks() {
        return this.localTxStopped.get() + this.remoteTxStopped.get();
    }

    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset statistics")
    public void resetStatistics() {
        this.localTxStopped.set(0L);
        this.remoteTxStopped.set(0L);
        this.cannotRunDld.set(0L);
    }

    @ManagedAttribute(description="Number of remote transaction that were roll backed due to deadlocks")
    @Metric(displayName="Number of remote transaction that were roll backed due to deadlocks", measurementType=MeasurementType.TRENDSUP)
    public long getDetectedRemoteDeadlocks() {
        return this.remoteTxStopped.get();
    }

    @ManagedAttribute(description="Number of local transaction that were roll backed due to deadlocks")
    @Metric(displayName="Number of local transaction that were roll backed due to deadlocks", measurementType=MeasurementType.TRENDSUP)
    public long getDetectedLocalDeadlocks() {
        return this.localTxStopped.get();
    }

    @ManagedAttribute(description="Number of situations when we try to determine a deadlock and the other lock owner is NOT a transaction. In this scenario we cannot run the deadlock detection mechanism")
    @Metric(displayName="Number of unsolvable deadlock situations", measurementType=MeasurementType.TRENDSUP)
    public long getOverlapWithNotDeadlockAwareLockOwners() {
        return this.cannotRunDld.get();
    }

    private void updateStats(DldGlobalTransaction tx) {
        if (this.exposeJmxStats) {
            if (tx.isRemote()) {
                this.remoteTxStopped.incrementAndGet();
            } else {
                this.localTxStopped.incrementAndGet();
            }
        }
    }

    @ManagedAttribute(description="Number of locally originated transactions that were interrupted as a deadlock situation was detected")
    @Metric(displayName="Number of interrupted local transactions", measurementType=MeasurementType.TRENDSUP)
    @Deprecated
    public long getLocallyInterruptedTransactions() {
        return -1L;
    }
}

