/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.MembershipArithmetic;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransactionFactory;
import org.infinispan.transaction.xa.LocalTransaction;
import org.infinispan.transaction.xa.RemoteTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionTable {
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    private static boolean trace = log.isTraceEnabled();
    private final Map<Transaction, LocalTransaction> localTransactions = new ConcurrentHashMap<Transaction, LocalTransaction>();
    private final Map<GlobalTransaction, RemoteTransaction> remoteTransactions = new ConcurrentHashMap<GlobalTransaction, RemoteTransaction>();
    private final Map<Xid, LocalTransaction> xid2LocalTx = new ConcurrentHashMap<Xid, LocalTransaction>();
    private final Object listener = new StaleTransactionCleanup();
    private Configuration configuration;
    private InvocationContextContainer icc;
    private InterceptorChain invoker;
    private CacheNotifier notifier;
    private RpcManager rpcManager;
    private GlobalTransactionFactory gtf;
    private ExecutorService lockBreakingService;
    private EmbeddedCacheManager cm;

    @Inject
    public void initialize(RpcManager rpcManager, Configuration configuration, InvocationContextContainer icc, InterceptorChain invoker, CacheNotifier notifier, GlobalTransactionFactory gtf, EmbeddedCacheManager cm) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.icc = icc;
        this.invoker = invoker;
        this.notifier = notifier;
        this.gtf = gtf;
        this.cm = cm;
    }

    @Start
    private void start() {
        this.lockBreakingService = Executors.newFixedThreadPool(1);
        this.cm.addListener(this.listener);
    }

    @Stop
    private void stop() {
        this.cm.removeListener(this.listener);
        this.lockBreakingService.shutdownNow();
        if (trace) {
            log.trace((Object)"Wait for on-going transactions to finish for %d seconds.", TimeUnit.MILLISECONDS.toSeconds(this.configuration.getCacheStopTimeout()));
        }
        long failTime = System.currentTimeMillis() + (long)this.configuration.getCacheStopTimeout();
        boolean txsOnGoing = this.areTxsOnGoing();
        while (txsOnGoing && System.currentTimeMillis() < failTime) {
            try {
                Thread.sleep(100L);
                txsOnGoing = this.areTxsOnGoing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (!trace) continue;
                log.trace((Object)"Interrupted waiting for on-going transactions to finish. localTransactions=%s, remoteTransactions%s", this.localTransactions, this.remoteTransactions);
            }
        }
        if (txsOnGoing) {
            log.warn((Object)"Stopping but there're transactions that did not finish in time: localTransactions=%s, remoteTransactions%s", this.localTransactions, this.remoteTransactions);
        } else if (trace) {
            log.trace("All transactions terminated");
        }
    }

    private boolean areTxsOnGoing() {
        return !this.localTransactions.isEmpty() || !this.remoteTransactions.isEmpty();
    }

    public Set<Object> getLockedKeysForRemoteTransaction(GlobalTransaction gtx) {
        RemoteTransaction transaction = this.remoteTransactions.get(gtx);
        if (transaction == null) {
            return Collections.emptySet();
        }
        return transaction.getLockedKeys();
    }

    public LocalTransaction getLocalTransaction(Xid xid) {
        return this.xid2LocalTx.get(xid);
    }

    public void addLocalTransactionMapping(LocalTransaction localTransaction) {
        if (localTransaction.getXid() == null) {
            throw new IllegalStateException("Initialize xid first!");
        }
        this.xid2LocalTx.put(localTransaction.getXid(), localTransaction);
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return this.remoteTransactions.get(txId);
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications) {
        RemoteTransaction remoteTransaction = new RemoteTransaction(modifications, globalTx);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx) {
        RemoteTransaction remoteTransaction = new RemoteTransaction(globalTx);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    private void registerRemoteTransaction(GlobalTransaction gtx, RemoteTransaction rtx) {
        RemoteTransaction transaction = this.remoteTransactions.put(gtx, rtx);
        if (transaction != null) {
            String message = "A remote transaction with the given id was already registered!!!";
            log.error(message);
            throw new IllegalStateException(message);
        }
        if (trace) {
            log.trace("Created and registered remote transaction " + rtx);
        }
    }

    public LocalTransaction getOrCreateLocalTransaction(Transaction transaction, InvocationContext ctx) {
        LocalTransaction current = this.localTransactions.get(transaction);
        if (current == null) {
            Address localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
            GlobalTransaction tx = this.gtf.newGlobalTransaction(localAddress, false);
            if (trace) {
                log.trace((Object)"Created a new GlobalTransaction %s", tx);
            }
            current = new LocalTransaction(transaction, tx);
            this.localTransactions.put(transaction, current);
            this.notifier.notifyTransactionRegistered(tx, ctx);
        }
        return current;
    }

    public boolean removeLocalTransaction(LocalTransaction localTransaction) {
        this.xid2LocalTx.remove(localTransaction.getXid());
        return this.localTransactions.remove(localTransaction.getTransaction()) != null;
    }

    public boolean removeRemoteTransaction(GlobalTransaction txId) {
        boolean existed;
        boolean bl = existed = this.remoteTransactions.remove(txId) != null;
        if (trace) {
            log.trace("Removed " + txId + " from transaction table. Transaction existed? " + existed);
        }
        return existed;
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public LocalTransaction getLocalTransaction(Transaction tx) {
        return this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }

    @Listener
    public class StaleTransactionCleanup {
        @ViewChanged
        public void onViewChange(ViewChangedEvent vce) {
            List<Address> leavers = MembershipArithmetic.getMembersLeft(vce.getOldMembers(), vce.getNewMembers());
            if (!leavers.isEmpty()) {
                if (trace) {
                    log.trace((Object)"Saw %s leavers - kicking off a lock breaking task", leavers.size());
                }
                this.cleanTxForWhichTheOwnerLeft(leavers);
                if (TransactionTable.this.configuration.isUseEagerLocking() && TransactionTable.this.configuration.isEagerLockSingleNode() && TransactionTable.this.configuration.getCacheMode().isDistributed()) {
                    for (LocalTransaction localTx : TransactionTable.this.localTransactions.values()) {
                        if (!localTx.hasRemoteLocksAcquired(leavers)) continue;
                        localTx.markForRollback();
                    }
                }
            }
        }

        private void cleanTxForWhichTheOwnerLeft(final List<Address> leavers) {
            try {
                TransactionTable.this.lockBreakingService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HashSet<GlobalTransaction> toKill = new HashSet<GlobalTransaction>();
                        for (GlobalTransaction gt : TransactionTable.this.remoteTransactions.keySet()) {
                            if (!leavers.contains(gt.getAddress())) continue;
                            toKill.add(gt);
                        }
                        if (trace) {
                            if (toKill.isEmpty()) {
                                log.trace((Object)"No global transactions pertain to originator(s) %s who have left the cluster.", leavers);
                            } else {
                                log.trace((Object)"%s global transactions pertain to leavers list %s and need to be killed", toKill.size(), leavers);
                            }
                        }
                        for (GlobalTransaction gtx : toKill) {
                            if (trace) {
                                log.trace((Object)"Killing %s", gtx);
                            }
                            RollbackCommand rc = new RollbackCommand(gtx);
                            rc.init(TransactionTable.this.invoker, TransactionTable.this.icc, TransactionTable.this);
                            try {
                                rc.perform(null);
                                if (!trace) continue;
                                log.trace((Object)"Rollback of %s complete.", gtx);
                            }
                            catch (Throwable e) {
                                log.warn((Object)("Unable to roll back gtx " + gtx), e);
                            }
                            finally {
                                TransactionTable.this.removeRemoteTransaction(gtx);
                            }
                        }
                        if (trace) {
                            log.trace("Completed cleaning stale locks.");
                        }
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                log.debug((Object)"Unable to submit task to executor", ree);
            }
        }
    }
}

